/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.ColumnHeaderRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableCellRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class TableListener
extends MouseAdapter
implements ActionListener {
    JTable table = null;
    MyTableCellRenderer rowHeaderRenderer;
    ColumnHeaderRenderer colHeaderRenderer;
    Point m_point = null;
    TableFrame tableFrame = null;
    static final String DELETEROW = "Delete";
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jMenuItemDeleteColumn = new JMenuItem("Delete");

    TableListener(JTable table, MyTableCellRenderer rowHeaderRenderer, ColumnHeaderRenderer colHeaderRenderer, TableFrame tFrame) {
        this.colHeaderRenderer = colHeaderRenderer;
        this.rowHeaderRenderer = rowHeaderRenderer;
        this.table = table;
        this.tableFrame = tFrame;
        this.jPopupMenu.add(this.jMenuItemDeleteColumn);
        this.jMenuItemDeleteColumn.addActionListener(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.jPopupMenu;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            int col = this.table.columnAtPoint(e.getPoint());
            int row = this.table.rowAtPoint(e.getPoint());
            if (col == 0) {
                if (this.table.getColumnSelectionAllowed()) {
                    this.table.setRowSelectionInterval(row, row);
                }
                this.colHeaderRenderer.clearPressedColumn();
                this.table.setColumnSelectionAllowed(false);
                this.table.setRowSelectionAllowed(true);
            }
            if (this.table.getColumnSelectionAllowed()) {
                int[] selected = this.table.getSelectedColumns();
                this.colHeaderRenderer.clearPressedColumn();
                int i = 0;
                while (i < selected.length) {
                    this.colHeaderRenderer.addPressedColumn(selected[i]);
                    ++i;
                }
            }
            this.table.getTableHeader().repaint();
            this.table.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!(!e.isPopupTrigger() && (e.getModifiers() & 4) == 0 || this.table.getSelectedRowCount() <= 0 && this.table.getSelectedRowCount() <= 0)) {
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private boolean isSelected(int row, int[] selected) {
        int i = 0;
        while (i < selected.length) {
            if (row == selected[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void deleteColumn() {
        int[] selected = this.table.getSelectedColumns();
        if (this.table != null) {
            if (this.table.getColumnCount() - selected.length == 1) {
                this.tableFrame.this_internalFrameClosed();
                this.tableFrame.dispose();
            }
            if (selected.length > 0) {
                MyTableModel dm = (MyTableModel)this.table.getModel();
                int rows = dm.m_data.length;
                int cols = dm.m_data[0].length;
                Object[][] data = new Object[rows][cols - selected.length];
                String[] cl = new String[dm.m_cLabel.length - selected.length];
                int k = 0;
                int i = 0;
                while (i < cols) {
                    if (!this.isSelected(i + 1, selected)) {
                        cl[k] = "C" + (k + 1);
                        int j = 0;
                        while (j < rows) {
                            data[j][k] = dm.m_data[j][i];
                            ++j;
                        }
                        ++k;
                    }
                    ++i;
                }
                this.tableFrame.m_dm = new MyTableModel(data, dm.m_rLabel, cl);
                this.table.setModel(this.tableFrame.m_dm);
                this.colHeaderRenderer.clearPressedColumn();
                TableColumnModel model = this.table.getColumnModel();
                int n = this.table.getColumnCount();
                int i2 = 1;
                while (i2 < n) {
                    model.getColumn(i2).setHeaderRenderer(this.colHeaderRenderer);
                    ++i2;
                }
                this.table.revalidate();
            }
        }
    }

    public void deleteRow() {
        int[] selected = this.table.getSelectedRows();
        if (this.table.getRowCount() - selected.length == 0) {
            this.tableFrame.this_internalFrameClosed();
            this.tableFrame.dispose();
        }
        if (selected.length > 0) {
            MyTableModel dm = (MyTableModel)this.table.getModel();
            int rows = dm.m_data.length;
            int cols = dm.m_data[0].length;
            Object[][] data = new Object[rows - selected.length][cols];
            String[] rl = new String[dm.m_rLabel.length - selected.length];
            int k = 0;
            int i = 0;
            while (i < rows) {
                if (!this.isSelected(i, selected)) {
                    rl[k] = "R" + (k + 1);
                    int j = 0;
                    while (j < cols) {
                        data[k][j] = dm.m_data[i][j];
                        ++j;
                    }
                    ++k;
                }
                ++i;
            }
            this.tableFrame.m_dm = new MyTableModel(data, rl, dm.m_cLabel);
            this.table.setModel(this.tableFrame.m_dm);
            TableColumnModel model = this.table.getColumnModel();
            int n = this.table.getColumnCount();
            int i2 = 1;
            while (i2 < n) {
                model.getColumn(i2).setHeaderRenderer(this.colHeaderRenderer);
                ++i2;
            }
            JTableHeader header = this.table.getTableHeader();
            this.table.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.table.getRowSelectionAllowed()) {
            if (this.table.getSelectedRowCount() > 0) {
                this.deleteRow();
            }
        } else if (this.table.getColumnSelectionAllowed() && this.table.getSelectedColumnCount() > 0) {
            this.deleteColumn();
        }
    }
}

