/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.RecentSwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setRequestFocusEnabled(false);
        this.setInheritsPopupMenu(true);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    protected void initValues() {
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int row = 0;
        while (row < this.numSwatches.height) {
            int y = row * (this.swatchSize.height + this.gap.height);
            int column = 0;
            while (column < this.numSwatches.width) {
                g.setColor(this.getColorForCell(column, row));
                int x = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? (this.numSwatches.width - column - 1) * (this.swatchSize.width + this.gap.width) : column * (this.swatchSize.width + this.gap.width);
                g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                g.setColor(Color.black);
                g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                ++column;
            }
            ++row;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(x, y);
    }

    protected void initColors() {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.getColorForLocation(e.getX(), e.getY());
        return String.valueOf(color.getRed()) + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int x, int y) {
        int column = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : x / (this.swatchSize.width + this.gap.width);
        int row = y / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(column, row);
    }

    private Color getColorForCell(int column, int row) {
        return this.colors[row * this.numSwatches.width + column];
    }
}

