/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class PreferenceDlg
extends JDialog
implements ActionListener {
    static PreferenceDlg m_dlg = null;
    static final String MANHATTAN = "Manhattan";
    static final String EUCLIDEAN = "Euclidean";
    JPanel jPCAPreference = new JPanel();
    JPanel jHCAPreference = new JPanel();
    JPanel jKmeansPreference = new JPanel(new GridBagLayout());
    JRadioButton jRadioButton_HartiganWong = new JRadioButton("Hartigan-Wong");
    JRadioButton jRadioButton_Floyd = new JRadioButton("Lloyd");
    JRadioButton jRadioButton_Forgy = new JRadioButton("Forgy");
    JRadioButton jRadioButton_MacQueen = new JRadioButton("MacQueen");
    ButtonGroup KmeansMethodGroup = new ButtonGroup();
    JTextField jTextField_NumCenters;
    JTextField jTextField_Item;
    JTextField jTextField_NumSets;
    JTabbedPane jTabPanel = new JTabbedPane();
    JButton ok = new JButton("Ok");
    JPanel buttonContainer = new JPanel();
    JCheckBox jHCAAutoScale = new JCheckBox();
    JCheckBox jSorted = new JCheckBox();
    JCheckBox jCheckboxUseFlag = new JCheckBox();
    JPanel jHcaPanel = new JPanel(new BorderLayout());
    JPanel jPanel1 = new JPanel(new BorderLayout());
    JPanel jMethodPanel = new JPanel();
    JPanel jotherOption = new JPanel();
    JPanel jPanel = new JPanel();
    JPanel jDistancePanel = new JPanel();
    JPanel jLinkagePanel = new JPanel();
    JRadioButton jSingleCluster = new JRadioButton("Single cluster");
    JRadioButton jDualCluster = new JRadioButton("Dual cluster");
    JRadioButton jColorImage = new JRadioButton("Heat map");
    ButtonGroup bgMethod = new ButtonGroup();
    JRadioButton jMahattan = new JRadioButton("Manhattan");
    JRadioButton jEuclidian = new JRadioButton("Euclidean");
    JRadioButton jr = new JRadioButton("1-r");
    ButtonGroup bgDistance = new ButtonGroup();
    JRadioButton jSingle = new JRadioButton("Single");
    JRadioButton jComplete = new JRadioButton("Complete");
    JRadioButton jAverage = new JRadioButton("Average");
    JRadioButton jCentroid = new JRadioButton("Centroid");
    JRadioButton jMedian = new JRadioButton("Median");
    JRadioButton jWards = new JRadioButton("Ward's");
    ButtonGroup bgLinkage = new ButtonGroup();
    JRadioButton jPCACovariance = new JRadioButton("Centered");
    JRadioButton jPCACorrelation = new JRadioButton("Auto scaled");
    ButtonGroup pcaMethod = new ButtonGroup();

    public PreferenceDlg() throws HeadlessException {
        super((Frame)null, "Preferences");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(490, 270);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)((screenSize.getWidth() - (double)this.getWidth()) / 2.0), (int)((screenSize.getHeight() - (double)this.getHeight()) / 2.0));
        this.setVisible(true);
        this.jHCAAutoScale.setText("Auto scale data");
        this.jHCAAutoScale.setActionCommand("HCA auto scale data");
        this.jHCAAutoScale.addActionListener(this);
        this.jHCAAutoScale.setSelected(AppFrame.m_bNormalize);
        this.jSorted.setText("Cluster sorted by value");
        this.jSorted.setSelected(AppFrame.m_bSortValue);
        this.jSorted.setActionCommand("Cluster sorted by value");
        this.jSorted.addActionListener(this);
        this.ok.addActionListener(this);
        this.getContentPane().add((Component)this.jTabPanel, "Center");
        this.getContentPane().add((Component)this.buttonContainer, "South");
        this.buttonContainer.setLayout(new FlowLayout());
        this.buttonContainer.add(this.ok);
        this.jTabPanel.add("HCA", this.jHCAPreference);
        this.jTabPanel.add("PCA", this.jPCAPreference);
        this.jTabPanel.add("K-Means", this.jKmeansPreference);
        this.jHCAPreference.add(this.jHcaPanel);
        this.jHcaPanel.add((Component)this.jotherOption, "North");
        this.jHcaPanel.add((Component)this.jPanel1, "South");
        this.jotherOption.add(this.jHCAAutoScale);
        this.jotherOption.add(this.jSorted);
        this.jMethodPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Method Selection"));
        this.jDistancePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Distance"));
        this.jLinkagePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "LinkageType"));
        this.jPanel1.add((Component)this.jDistancePanel, "Center");
        this.jPanel1.add((Component)this.jLinkagePanel, "South");
        this.bgMethod.add(this.jSingleCluster);
        this.bgMethod.add(this.jDualCluster);
        this.bgMethod.add(this.jColorImage);
        this.bgDistance.add(this.jMahattan);
        this.bgDistance.add(this.jEuclidian);
        this.bgDistance.add(this.jr);
        this.bgLinkage.add(this.jSingle);
        this.bgLinkage.add(this.jComplete);
        this.bgLinkage.add(this.jAverage);
        this.bgLinkage.add(this.jCentroid);
        this.bgLinkage.add(this.jMedian);
        this.bgLinkage.add(this.jWards);
        this.jMethodPanel.add(this.jDualCluster);
        this.jMethodPanel.add(this.jColorImage);
        this.jSingleCluster.setActionCommand("Single cluster");
        this.jSingleCluster.setMnemonic(83);
        this.jSingleCluster.addActionListener(this);
        this.jSingleCluster.setSelected(AppFrame.m_method == 0);
        this.jDualCluster.setActionCommand("Dual cluster");
        this.jDualCluster.setMnemonic(68);
        this.jDualCluster.setSelected(AppFrame.m_method == 1);
        this.jDualCluster.addActionListener(this);
        this.jColorImage.setActionCommand("Heat map");
        this.jColorImage.setMnemonic(73);
        this.jColorImage.addActionListener(this);
        this.jColorImage.setSelected(AppFrame.m_method == 2);
        this.jDistancePanel.add(this.jMahattan);
        this.jDistancePanel.add(this.jEuclidian);
        this.jDistancePanel.add(this.jr);
        this.jMahattan.setActionCommand(MANHATTAN);
        this.jMahattan.setMnemonic(72);
        this.jMahattan.addActionListener(this);
        this.jMahattan.setSelected(AppFrame.m_metric == 0);
        this.jEuclidian.setActionCommand(EUCLIDEAN);
        this.jEuclidian.setMnemonic(69);
        this.jEuclidian.addActionListener(this);
        this.jEuclidian.setSelected(AppFrame.m_metric == 1);
        this.jr.setActionCommand("1-r");
        this.jr.setMnemonic(82);
        this.jr.addActionListener(this);
        this.jr.setSelected(AppFrame.m_metric == 2);
        this.jLinkagePanel.add(this.jSingle);
        this.jLinkagePanel.add(this.jComplete);
        this.jLinkagePanel.add(this.jAverage);
        this.jLinkagePanel.add(this.jCentroid);
        this.jLinkagePanel.add(this.jMedian);
        this.jLinkagePanel.add(this.jWards);
        this.jSingle.setActionCommand("Single");
        this.jSingle.setMnemonic(71);
        this.jSingle.addActionListener(this);
        this.jSingle.setSelected(AppFrame.m_Dissimilarity == 0);
        this.jComplete.setActionCommand("Complete");
        this.jComplete.setMnemonic(80);
        this.jComplete.addActionListener(this);
        this.jComplete.setSelected(AppFrame.m_Dissimilarity == 1);
        this.jAverage.setActionCommand("Average");
        this.jAverage.setMnemonic(65);
        this.jAverage.addActionListener(this);
        this.jCentroid.setActionCommand("Centroid");
        this.jCentroid.setMnemonic(67);
        this.jCentroid.addActionListener(this);
        this.jCentroid.setSelected(AppFrame.m_Dissimilarity == 3);
        this.jMedian.setActionCommand("Median");
        this.jMedian.setMnemonic(77);
        this.jMedian.addActionListener(this);
        this.jMedian.setSelected(AppFrame.m_Dissimilarity == 4);
        this.jWards.setActionCommand("Ward's");
        this.jWards.setMnemonic(87);
        this.jWards.addActionListener(this);
        this.jWards.setSelected(AppFrame.m_Dissimilarity == 5);
        this.setDistanceState(AppFrame.m_Dissimilarity != 5);
        this.pcaMethod.add(this.jPCACovariance);
        this.pcaMethod.add(this.jPCACorrelation);
        this.jPCACorrelation.addActionListener(this);
        this.jPCACovariance.addActionListener(this);
        this.jPCACorrelation.setSelected(AppFrame.m_bAutoscale);
        this.jPCACovariance.setSelected(!AppFrame.m_bAutoscale);
        this.jPCAPreference.add(this.jPCACovariance);
        this.jPCAPreference.add(this.jPCACorrelation);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        this.jKmeansPreference.add((Component)new JLabel("Number of clusters:"), c);
        c.gridy = 1;
        this.jKmeansPreference.add((Component)new JLabel("Maximum iterations:"), c);
        c.gridy = 2;
        this.jKmeansPreference.add((Component)new JLabel("Number of random sets:"), c);
        this.jTextField_NumCenters = new JTextField(String.valueOf(AppFrame.m_Kmeans_numCenters));
        this.jTextField_Item = new JTextField(String.valueOf(AppFrame.m_Kmeans_IterMax));
        this.jTextField_NumSets = new JTextField(String.valueOf(AppFrame.m_Kmeans_nStart));
        c.gridx = 1;
        c.gridy = 0;
        this.jKmeansPreference.add((Component)this.jTextField_NumCenters, c);
        c.gridy = 1;
        this.jKmeansPreference.add((Component)this.jTextField_Item, c);
        c.gridy = 2;
        this.jKmeansPreference.add((Component)this.jTextField_NumSets, c);
        JPanel jPanelTmp = new JPanel();
        jPanelTmp.add(this.jRadioButton_HartiganWong);
        jPanelTmp.add(this.jRadioButton_Floyd);
        jPanelTmp.add(this.jRadioButton_Forgy);
        jPanelTmp.add(this.jRadioButton_MacQueen);
        this.KmeansMethodGroup.add(this.jRadioButton_HartiganWong);
        this.KmeansMethodGroup.add(this.jRadioButton_Floyd);
        this.KmeansMethodGroup.add(this.jRadioButton_Forgy);
        this.KmeansMethodGroup.add(this.jRadioButton_MacQueen);
        this.jRadioButton_HartiganWong.setSelected(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 3;
        this.jKmeansPreference.add((Component)jPanelTmp, c);
        Dimension size = this.jTextField_NumCenters.getPreferredSize();
        size.width = 50;
        this.jTextField_NumCenters.setPreferredSize(size);
        this.jTextField_Item.setPreferredSize(size);
        this.jTextField_NumSets.setPreferredSize(size);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            System.out.println("Ok clicked!");
            String method = this.jRadioButton_HartiganWong.getText();
            if (this.jRadioButton_Floyd.isSelected()) {
                method = this.jRadioButton_Floyd.getText();
            } else if (this.jRadioButton_Forgy.isSelected()) {
                method = this.jRadioButton_Forgy.getText();
            } else if (this.jRadioButton_MacQueen.isSelected()) {
                method = this.jRadioButton_MacQueen.getText();
            }
            AppFrame.m_Kmeans_Method = method;
            try {
                AppFrame.m_Kmeans_IterMax = Integer.parseInt(this.jTextField_Item.getText());
                AppFrame.m_Kmeans_nStart = Integer.parseInt(this.jTextField_NumSets.getText());
                AppFrame.m_Kmeans_numCenters = Integer.parseInt(this.jTextField_NumCenters.getText());
            }
            catch (Exception er) {
                ClUtils.ErrorMessage(er.getMessage());
                return;
            }
            this.dispose();
        } else if (cmd.equals(MANHATTAN)) {
            AppFrame.m_metric = 0;
            System.out.println(MANHATTAN);
        } else if (cmd.equals(EUCLIDEAN)) {
            AppFrame.m_metric = 1;
            System.out.println(EUCLIDEAN);
        } else if (cmd.equals("1-r")) {
            AppFrame.m_metric = 2;
            System.out.println("1-r");
        } else if (cmd.equals("Single")) {
            this.setDistanceState(true);
            AppFrame.m_Dissimilarity = 0;
            System.out.println("Single");
        } else if (cmd.equals("Complete")) {
            this.setDistanceState(true);
            AppFrame.m_Dissimilarity = 1;
            System.out.println("Complete");
        } else if (cmd.equals("Average")) {
            this.setDistanceState(true);
            AppFrame.m_Dissimilarity = 2;
            System.out.println("Average");
        } else if (cmd.equals("Centroid")) {
            this.setDistanceState(true);
            AppFrame.m_Dissimilarity = 3;
            System.out.println("Centroid");
        } else if (cmd.equals("Median")) {
            this.setDistanceState(true);
            AppFrame.m_Dissimilarity = 4;
            System.out.println("Median");
        } else if (cmd.equals("Ward's")) {
            this.jEuclidian.setSelected(true);
            AppFrame.m_metric = 1;
            AppFrame.m_Dissimilarity = 5;
            this.setDistanceState(false);
            System.out.println("Ward's");
        } else if (cmd.equals("Centered") || cmd.equals("Auto scaled")) {
            AppFrame.m_bAutoscale = this.jPCACorrelation.isSelected();
            System.out.println(AppFrame.m_bAutoscale);
        } else if (cmd.equals("HCA auto scale data")) {
            AppFrame.m_bNormalize = this.jHCAAutoScale.isSelected();
        } else if (cmd.equals("Cluster sorted by value")) {
            AppFrame.m_bSortValue = this.jSorted.isSelected();
        } else {
            System.out.println("null command");
        }
    }

    private void setDistanceState(boolean state) {
        this.jMahattan.setEnabled(state);
        this.jEuclidian.setEnabled(state);
        this.jr.setEnabled(state);
    }
}

