/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.MatrixTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAResults;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_DlgSymbol;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_jTable_S_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_jTable_U_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_jTable_U_mouseMotionAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_jTable_V_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_this_componentAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx_this_windowAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.RowLabelCellRenderer;
import NCTR.graph.SciGraph.SciGraph;
import NCTR.graph.SciGraph.SgGraphItem;
import NCTR.graph.SciGraph.SgGrid;
import NCTR.graph.SciGraph.SgSphere;
import NCTR.util.math.la.Matrix;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;

public class PcaFrameEx
extends PcaFrame
implements ActionListener,
ItemListener {
    static final String COMPONENTX = "Change Component X";
    static final String COMPONENTY = "Change Component Y";
    static final String COMPONENTZ = "Change Component Z";
    static final String SAVEIMAGE = "Save to File...";
    static final String RESETVIEWPOINT = "Reset Viewpoint";
    static final int SCORE = 1;
    boolean m_b3D = false;
    PCAResults pcaResults;
    AppFrame m_appFrame = null;
    PcaFrameEx m_pcaFrame = this;
    boolean m_bHeaderInFirstRow = true;
    JPanel contentPane;
    PcaPanel2D jPanel_2D = new PcaPanel2D();
    PCAPanel3D jPanel_3D = null;
    SciGraph<Integer, String> graph3D = new SciGraph();
    JSplitPane jSplitPane1 = new JSplitPane();
    JSplitPane jSplitPane2 = new JSplitPane();
    JTabbedPane jTabPanel = new JTabbedPane();
    JScrollPane jScorePane = new JScrollPane();
    JScrollPane jEigenValue = new JScrollPane();
    JScrollPane jLoadingPane;
    JTable jTable_U = null;
    JTable jTable_V = null;
    JTable jTable_S = null;
    JPanelRelativeVariance jRelativeVariance;
    JPanel jPanelFor2D = new JPanel(new GridLayout(3, 1, 0, 1));
    JPanel jPanelX = new JPanel();
    JPanel jPanelY = new JPanel();
    JPanel jPanel3DV = new JPanel();
    JComboBox jComboBox_X = new JComboBox();
    JComboBox jComboBox_Y = new JComboBox();
    JPanel jPanelFor3D = new JPanel(new BorderLayout());
    JPanel jPanelgrid = new JPanel(new GridLayout(6, 1, 0, 1));
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JButton jButton_2D3DView = new JButton("3D view");
    Color selectionColor2D = Color.MAGENTA;
    Color defaultColor = new Color(0.1f, 0.5f, 1.0f);
    JLabel selObsNameLabel;
    JLabel selObsScoresLabel;
    JSlider shapesize_slider = null;
    JSlider dataTransparency_slider = null;
    JComboBox jComboBox_X3 = new JComboBox();
    JComboBox jComboBox_Y3 = new JComboBox();
    JComboBox jComboBox_Z3 = new JComboBox();
    JButton jButton_ResetView = new JButton("Reset Viewpoint");
    JCheckBox jCheckBox_ShowNames = new JCheckBox("Show Dataset Names", false);
    JCheckBox jCheckBox_ColorGrid = new JCheckBox("Color Grid", true);
    JCheckBox jCheckBox_UseTicks = new JCheckBox("Use Axis Ticks", true);
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jChangeColor = new JMenuItem("Color...");
    JMenuItem jUTSave = new JMenuItem("Save");
    JMenuItem jMenuSave = new JMenuItem("Save");
    JPopupMenu jUTablePopupMenu = new JPopupMenu();
    JMenuItem jDoSearch = new JMenuItem("Search...");
    JMenuItem jDoCopy = new JMenuItem("Copy selected rows");
    Color selectedColor = null;
    final JColorChooser colorChooser = new JColorChooser();
    int m_xIndex;
    int m_yIndex;
    int m_zIndex;
    int m_saveIndex = -1;
    List<String>[] grpColNames;
    static final String LOADINGMATRIX = "Loadings";
    static final String SCOREMATRIX = "Scores";
    static final String SINGULARMATRIX = "Eigenvalues";
    static final String RELATIVEVARIANCE = "Relative Variances";
    public static final String TOGGLE_REVERSE_PC1_CMD = "Reverse PC1";
    public static final String TOGGLE_REVERSE_PC2_CMD = "Reverse PC2";
    public static final String TOGGLE_REVERSE_PC3_CMD = "Reverse PC3";
    public static final String REAR_GRID_CMD = "Rear Grid";
    public static final String CENTRAL_GRID_CMD = "Central Grid";
    public static final String NO_GRID_CMD = "No Grid";
    public static final String TOGGLE_CENTRAL_AXES_LINES_CMD = "Toggle Axes Lines";
    public static final String SAVE_3D_IMG_CMD = "save 3d img";
    public static final String PC2_VS_PC1_VIEWPOINT_CMD = "Y vs X";
    public static final String PC3_VS_PC1_VIEWPOINT_CMD = "Z vs X";
    public static final String PC3_VS_PC2_VIEWPOINT_CMD = "Z vs Y";
    public static final String CHOOSE_OBS_COLOR_CMD = "Choose obs Color";
    public static final String CHOOSE_OBS_SHAPE_CMD = "Choose obs Shape";
    public static final String CLEAR_SELECTIONS_CMD = "Clear Sels";
    public static final String SELECT_ALL_CMD = "Select All";
    static final boolean DEFAULT_SHOULD_SHOW_CENTRAL_AXES = true;
    static final GridStyle DEFAULT_GRID_STYLE = GridStyle.REAR_GRID;

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        try {
            e.getSource().equals(this.jCheckBox_ShowNames);
            if (e.getSource().equals(this.jCheckBox_ColorGrid)) {
                this.graph3D.useGridColor(selected);
                this.graph3D.refresh();
            }
            if (e.getSource().equals(this.jCheckBox_UseTicks)) {
                this.graph3D.setUseAxisTicks(selected);
                this.graph3D.refresh();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private float[][] initColorComponents(int numColors, int numColorComp) {
        float[][] ret = new float[numColorComp][numColors];
        Color[] cT = new Color[]{Color.blue, Color.red, Color.green, Color.pink, Color.cyan, Color.lightGray, Color.orange, Color.black, new Color(0.0f, 0.5f, 0.5f), new Color(0.5f, 0.0f, 0.5f), new Color(1.0f, 0.0f, 0.5f), new Color(0.0f, 0.75f, 1.0f), new Color(0.0f, 0.75f, 0.25f), Color.gray, Color.yellow};
        float[] colorComp = null;
        int end = numColors > 15 ? 15 : numColors;
        int i = 0;
        while (i < end) {
            colorComp = cT[i].getRGBColorComponents(null);
            ret[0][i] = colorComp[0];
            ret[1][i] = colorComp[1];
            ret[2][i] = colorComp[2];
            ++i;
        }
        Random rand = new Random(10L);
        int i2 = 10;
        while (i2 < numColors) {
            ret[0][i2] = rand.nextFloat();
            ret[1][i2] = rand.nextFloat();
            ret[2][i2] = rand.nextFloat();
            ++i2;
        }
        return ret;
    }

    public PcaFrameEx(Frame frame, PCAResults pca_results, List<String>[] grp_col_names) {
        super("PCA 2D Viewer");
        this.m_appFrame = (AppFrame)frame;
        this.setIconImage(this.m_appFrame.imgPCA.getImage());
        this.pcaResults = pca_results;
        if (grp_col_names != null && grp_col_names.length > 1) {
            this.grpColNames = grp_col_names;
        }
        this.setAlwaysOnTop(true);
        this.jbInit();
        if (this.grpColNames != null) {
            int numColors = this.grpColNames.length;
            float[][] rgb = this.initColorComponents(numColors, 3);
            ArrayList<HashSet<String>> member_names_for_grps = new ArrayList<HashSet<String>>();
            List<String>[] listArray = this.grpColNames;
            int n = this.grpColNames.length;
            int n2 = 0;
            while (n2 < n) {
                List<String> mbr_names = listArray[n2];
                member_names_for_grps.add(new HashSet<String>(mbr_names));
                ++n2;
            }
            int obs_ix = 0;
            while (obs_ix < this.jPanel_2D.m_point.length) {
                String obs_name = this.pcaResults.getObservationLabels()[obs_ix];
                int grp_ix = 0;
                while (grp_ix < numColors) {
                    if (((Set)member_names_for_grps.get(grp_ix)).contains(obs_name)) {
                        this.jPanel_2D.m_color[obs_ix] = new Color(rgb[0][grp_ix], rgb[1][grp_ix], rgb[2][grp_ix]);
                        break;
                    }
                    ++grp_ix;
                }
                ++obs_ix;
            }
        }
    }

    public PcaFrameEx(Frame frame, PCAResults pca_results) {
        this(frame, pca_results, null);
    }

    @Override
    public PCAResults getPCAResults() {
        return this.pcaResults;
    }

    @Override
    public String[] getSelectedGenes() {
        return null;
    }

    private void saveTable(JTable table) {
        JFileChooser file_dlg = new JFileChooser(AppFrame.last_user_path);
        file_dlg.setDialogTitle("Export to File");
        if (file_dlg.showSaveDialog(this) == 0) {
            File sel_file = file_dlg.getSelectedFile();
            AppFrame.last_user_path = file_dlg.getSelectedFile().getParentFile();
            if (sel_file != null) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(sel_file));
                    int rows = table.getRowCount();
                    int cols = table.getColumnCount();
                    NumberFormat nFmt = NumberFormat.getInstance(Locale.US);
                    nFmt.setMaximumFractionDigits(3);
                    int i = 0;
                    while (i < rows) {
                        int j = 0;
                        while (j < cols) {
                            if (j > 0) {
                                bw.write(nFmt.format(table.getValueAt(i, j)));
                            } else {
                                bw.write((String)table.getValueAt(i, j));
                            }
                            if (j < cols - 1) {
                                bw.write("\t");
                            } else {
                                bw.write("\n");
                            }
                            ++j;
                        }
                        ++i;
                    }
                    bw.close();
                }
                catch (IOException ex) {
                    ClUtils.ErrorMessage(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Save")) {
            if (this.m_saveIndex == 0) {
                this.saveTable(this.jTable_U);
            } else if (this.m_saveIndex == 1) {
                if (this.jTable_V != null) {
                    this.saveTable(this.jTable_V);
                }
            } else {
                this.saveTable(this.jTable_S);
            }
        } else if (cmd.equals("Color...")) {
            JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, this.colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PcaFrameEx.this.selectedColor = PcaFrameEx.this.colorChooser.getColor();
                }
            }, null);
            dialog.setVisible(true);
            if (this.selectedColor != null) {
                int[] selected = this.jTable_U.getSelectedRows();
                ArrayList<Integer> sel = new ArrayList<Integer>();
                int[] nArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    int ixs = nArray[n2];
                    sel.add(ixs);
                    ++n2;
                }
                this.jPanel_2D.setObsColor(sel, this.selectedColor);
                if (this.m_pcaFrame.jPanel_3D != null) {
                    this.jPanel_3D.clearSelection();
                    this.jPanel_3D.setObsColor(sel, this.selectedColor);
                }
            }
        } else if (cmd.equals("Copy selected rows")) {
            int[] rows = this.jTable_U.getSelectedRows();
            int cols = this.jTable_U.getColumnCount();
            StringBuffer sbf = new StringBuffer();
            int r = 0;
            while (r < rows.length) {
                int c = 0;
                while (c < cols) {
                    sbf.append(this.jTable_U.getValueAt(rows[r], c));
                    if (c < cols - 1) {
                        sbf.append("\t");
                    }
                    ++c;
                }
                sbf.append("\n");
                ++r;
            }
            StringSelection stsel = new StringSelection(sbf.toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(stsel, stsel);
        } else if (cmd.equals("Search...")) {
            String inputValue = JOptionPane.showInputDialog(null, "Search:", "Search String...", 3);
            if (inputValue != null && inputValue != "") {
                StringTokenizer st = new StringTokenizer(inputValue, " \t;,");
                Vector<String> f = new Vector<String>();
                while (st.hasMoreElements()) {
                    f.add(st.nextToken());
                }
                int rows = this.jTable_U.getRowCount();
                this.jTable_U.clearSelection();
                int i = 0;
                while (i < rows) {
                    String v = (String)this.jTable_U.getValueAt(i, 0);
                    boolean add = true;
                    int j = 0;
                    while (j < f.size()) {
                        if (v.indexOf((String)f.get(j)) < 0) {
                            add = false;
                            break;
                        }
                        ++j;
                    }
                    if (add) {
                        this.jTable_U.addRowSelectionInterval(i, i);
                    }
                    ++i;
                }
                int[] sel = this.jTable_U.getSelectedRows();
                this.jPanel_2D.setSelected(sel);
                if (this.jPanel_3D != null) {
                    this.jPanel_3D.setSelected(sel);
                }
            }
        } else if (cmd.equals(COMPONENTX) || cmd.equals(COMPONENTY) || cmd.equals(COMPONENTZ)) {
            if (cmd.equals(COMPONENTX)) {
                this.m_xIndex = ((JComboBox)e.getSource()).getSelectedIndex();
                this.jComboBox_X.setSelectedIndex(this.m_xIndex);
                this.jComboBox_X3.setSelectedIndex(this.m_xIndex);
            } else if (cmd.equals(COMPONENTY)) {
                this.m_yIndex = ((JComboBox)e.getSource()).getSelectedIndex();
                this.jComboBox_Y.setSelectedIndex(this.m_yIndex);
                this.jComboBox_Y3.setSelectedIndex(this.m_yIndex);
            } else {
                this.m_zIndex = ((JComboBox)e.getSource()).getSelectedIndex();
            }
            if (this.jPanel_3D != null) {
                try {
                    this.jPanel_3D.initSamples(this.m_xIndex, this.m_yIndex, this.m_zIndex);
                    this.jPanel_3D.setSelected(this.jTable_U.getSelectedRows());
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
            this.refreshImage();
        } else if (cmd.equals("Plot Details...")) {
            this.jPanel_2D.actionPerformed(e);
        } else if (cmd.equals(RESETVIEWPOINT)) {
            try {
                this.graph3D.resetView();
                this.graph3D.refresh();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    private void jbInit() {
        this.jLoadingPane = this.pcaResults.getLoadingMatrix() != null ? new JScrollPane() : null;
        this.jSplitPane1.setOrientation(0);
        this.addWindowListener(new PcaFrameEx_this_windowAdapter(this));
        this.addComponentListener(new PcaFrameEx_this_componentAdapter(this));
        this.jSplitPane1.add((Component)this.jSplitPane2, "top");
        this.jSplitPane1.add((Component)this.jTabPanel, "bottom");
        this.jSplitPane2.add((Component)this.jPanelFor2D, "right");
        this.jSplitPane2.add((Component)this.jPanel_2D, "left");
        this.jPanelFor2D.add((Component)this.jPanelX, null);
        this.jPanelX.add((Component)this.jComboBox_X, null);
        this.jPanelFor2D.add((Component)this.jPanelY, null);
        this.jPanelY.add((Component)this.jComboBox_Y, null);
        this.jPanelFor2D.add((Component)this.jPanel3DV, null);
        this.shapesize_slider = new JSlider(0, 0, 50, 20);
        this.shapesize_slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                try {
                    float scale_factor = (float)PcaFrameEx.this.shapesize_slider.getValue() / 10.0f;
                    PcaFrameEx.this.graph3D.setShapeSize(scale_factor);
                    PcaFrameEx.this.graph3D.refresh();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    System.out.println("Couldn't set shape scale: " + ex);
                }
            }
        });
        this.shapesize_slider.setBorder(new TitledBorder("Symbol/Text Size"));
        this.dataTransparency_slider = new JSlider(0, 0, 100, 80);
        this.dataTransparency_slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                try {
                    float scale_factor = (float)PcaFrameEx.this.shapesize_slider.getValue() / 100.0f;
                    PcaFrameEx.this.graph3D.setDataTransparency(scale_factor);
                    PcaFrameEx.this.graph3D.refresh();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    System.out.println("Couldn't set transparency scale: " + ex);
                }
            }
        });
        this.dataTransparency_slider.setBorder(new TitledBorder("Symbol Transparency"));
        this.jPanelFor3D.add((Component)this.jPanelgrid, "Center");
        this.jPanelFor3D.add((Component)this.jPanel3, "North");
        this.selObsNameLabel = new JLabel(" ");
        this.jPanel3.add((Component)this.selObsNameLabel, null);
        this.selObsScoresLabel = new JLabel(" ");
        this.jPanel3.add((Component)this.selObsScoresLabel, null);
        this.jPanelgrid.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jComboBox_X3, null);
        this.jPanel4.add((Component)this.jComboBox_Y3, null);
        this.jPanel4.add((Component)this.jComboBox_Z3, null);
        this.jPanelgrid.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jCheckBox_ShowNames, null);
        this.jPanel5.add((Component)this.jCheckBox_ColorGrid, null);
        this.jPanel5.add((Component)this.jCheckBox_UseTicks, null);
        this.jCheckBox_ShowNames.addItemListener(this);
        this.jPanelgrid.add((Component)this.jPanel6, null);
        this.jPanelgrid.add(this.dataTransparency_slider);
        this.jPanelgrid.add(this.shapesize_slider);
        this.jCheckBox_ShowNames.addItemListener(this);
        this.jCheckBox_ColorGrid.addItemListener(this);
        this.jCheckBox_UseTicks.addItemListener(this);
        this.jPanelgrid.add((Component)this.jPanel8, null);
        this.jPanel3DV.add((Component)this.jButton_2D3DView, null);
        this.jPanel8.add((Component)this.jButton_ResetView, null);
        this.jButton_ResetView.addActionListener(this);
        this.jButton_2D3DView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PcaFrameEx.this.jButton_2D3DView.getText().equals("2D view")) {
                    PcaFrameEx.this.jButton_2D3DView.setText("3D view");
                    PcaFrameEx.this.jPanel8.remove(PcaFrameEx.this.jButton_2D3DView);
                    PcaFrameEx.this.jPanel3DV.add(PcaFrameEx.this.jButton_2D3DView);
                    int loc = PcaFrameEx.this.jSplitPane2.getDividerLocation();
                    int[] selected = PcaFrameEx.this.jTable_U.getSelectedRows();
                    if (selected != null) {
                        PcaFrameEx.this.jPanel_2D.setSelected(selected);
                    }
                    PcaFrameEx.this.jSplitPane2.setLeftComponent(PcaFrameEx.this.jPanel_2D);
                    PcaFrameEx.this.jSplitPane2.setRightComponent(PcaFrameEx.this.jPanelFor2D);
                    PcaFrameEx.this.jSplitPane2.setDividerLocation(loc);
                    PcaFrameEx.this.m_b3D = false;
                    PcaFrameEx.this.m_pcaFrame.setTitle("PCA 2D View");
                } else {
                    PcaFrameEx.this.jButton_2D3DView.setText("2D view");
                    PcaFrameEx.this.jPanel3DV.remove(PcaFrameEx.this.jButton_2D3DView);
                    PcaFrameEx.this.jPanel8.add((Component)PcaFrameEx.this.jButton_2D3DView, 0);
                    if (PcaFrameEx.this.jPanel_3D == null) {
                        try {
                            PcaFrameEx.this.jPanel_3D = new PCAPanel3D();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.out);
                        }
                    }
                    int[] selected = PcaFrameEx.this.jTable_U.getSelectedRows();
                    if (PcaFrameEx.this.jPanel_3D != null) {
                        ArrayList<Integer> sel = new ArrayList<Integer>();
                        if (selected.length > 0) {
                            int[] nArray = selected;
                            int n = selected.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int i = nArray[n2];
                                sel.add(new Integer(i));
                                ++n2;
                            }
                            try {
                                PcaFrameEx.this.jPanel_3D.setSelectedObservations(sel);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace(System.out);
                            }
                        } else {
                            PcaFrameEx.this.jPanel_3D.clearSelection();
                        }
                    }
                    int loc = PcaFrameEx.this.jSplitPane2.getDividerLocation();
                    PcaFrameEx.this.jSplitPane2.setLeftComponent(PcaFrameEx.this.jPanel_3D);
                    PcaFrameEx.this.jSplitPane2.setRightComponent(PcaFrameEx.this.jPanelFor3D);
                    PcaFrameEx.this.jSplitPane2.setDividerLocation(loc);
                    PcaFrameEx.this.m_b3D = true;
                    PcaFrameEx.this.m_pcaFrame.setTitle("PCA 3D Viewer");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("jPanel_3D repaint......");
                            (this).PcaFrameEx.this.jPanel_3D.revalidate();
                            (this).PcaFrameEx.this.jPanel_3D.repaint();
                        }
                    });
                }
            }
        });
        this.createTables();
        this.jRelativeVariance = new JPanelRelativeVariance();
        if (this.jTable_V != null) {
            this.jLoadingPane.getViewport().add((Component)this.jTable_V, null);
        }
        this.jScorePane.getViewport().add((Component)this.jTable_U, null);
        this.jEigenValue.getViewport().add((Component)this.jTable_S, null);
        this.m_xIndex = 0;
        this.m_yIndex = 1;
        this.m_zIndex = 2;
        int comps = this.pcaResults.getEigenValues().length;
        if (comps == 0) {
            ClUtils.ErrorMessage("No components exception");
        }
        if (this.m_xIndex > comps - 1) {
            this.m_xIndex = comps - 1;
        }
        if (this.m_yIndex > comps - 1) {
            this.m_yIndex = comps - 1;
        }
        if (this.m_zIndex > comps - 1) {
            this.m_zIndex = comps - 1;
        }
        int i = 0;
        while (i < comps) {
            this.jComboBox_X.addItem("PC " + (i + 1));
            this.jComboBox_Y.addItem("PC " + (i + 1));
            this.jComboBox_X3.addItem("PC " + (i + 1));
            this.jComboBox_Y3.addItem("PC " + (i + 1));
            this.jComboBox_Z3.addItem("PC " + (i + 1));
            ++i;
        }
        this.jComboBox_X.setSelectedIndex(this.m_xIndex);
        this.jComboBox_X.setActionCommand(COMPONENTX);
        this.jComboBox_X.addActionListener(this);
        this.jComboBox_Y.setActionCommand(COMPONENTY);
        this.jComboBox_Y.addActionListener(this);
        this.jComboBox_Y.setSelectedIndex(this.m_yIndex);
        this.jComboBox_X3.setSelectedIndex(this.m_xIndex);
        this.jComboBox_X3.setActionCommand(COMPONENTX);
        this.jComboBox_X3.addActionListener(this);
        this.jComboBox_Y3.setActionCommand(COMPONENTY);
        this.jComboBox_Y3.addActionListener(this);
        this.jComboBox_Y3.setSelectedIndex(this.m_yIndex);
        this.jComboBox_Z3.setActionCommand(COMPONENTZ);
        this.jComboBox_Z3.addActionListener(this);
        this.jComboBox_Z3.setSelectedIndex(this.m_zIndex);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.setSizeLocation();
        this.jSplitPane1.setDividerLocation(0.618);
        this.jSplitPane2.setDividerLocation(0.5);
        this.jPopupMenu.add(this.jMenuSave);
        this.jUTablePopupMenu.add(this.jDoSearch);
        this.jUTablePopupMenu.add(this.jDoCopy);
        this.jUTablePopupMenu.add(this.jUTSave);
        this.jUTablePopupMenu.add(this.jChangeColor);
        this.jTabPanel.add(RELATIVEVARIANCE, this.jRelativeVariance);
        this.jTabPanel.add(SCOREMATRIX, this.jScorePane);
        this.jTabPanel.add(SINGULARMATRIX, this.jEigenValue);
        if (this.jLoadingPane != null) {
            this.jTabPanel.add(LOADINGMATRIX, this.jLoadingPane);
        }
        this.jMenuSave.addActionListener(this);
        this.jUTSave.addActionListener(this);
        this.jChangeColor.addActionListener(this);
        this.jDoSearch.addActionListener(this);
        this.jDoCopy.addActionListener(this);
    }

    private void createTables() {
        this.jTable_U = new JTable(new MatrixTableModel(this.pcaResults.getScoresMatrix(), this.pcaResults.getObservationLabels(), "PC"));
        this.jTable_U.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
        this.jTable_U.setAutoResizeMode(0);
        this.jTable_U.addMouseListener(new PcaFrameEx_jTable_U_mouseAdapter(this));
        this.jTable_U.addMouseMotionListener(new PcaFrameEx_jTable_U_mouseMotionAdapter(this));
        Matrix loading_matrix = this.pcaResults.getLoadingMatrix();
        if (loading_matrix != null) {
            String[] numbered_orig_coords = null;
            String[] orig_coords = this.pcaResults.getOriginalCoordinateNames();
            if (orig_coords != null) {
                numbered_orig_coords = new String[orig_coords.length];
                int i = orig_coords.length - 1;
                while (i >= 0) {
                    numbered_orig_coords[i] = String.valueOf(orig_coords[i]) + " [" + (i + 1) + "]";
                    --i;
                }
            }
            this.jTable_V = new JTable(new MatrixTableModel(loading_matrix, numbered_orig_coords, "PC"));
            this.jTable_V.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
            this.jTable_V.setAutoResizeMode(0);
            this.jTable_V.addMouseListener(new PcaFrameEx_jTable_V_mouseAdapter(this));
        }
        int num_evals = this.pcaResults.getEigenValues().length;
        double[] pcts_var = new double[num_evals];
        float sum_evals = 0.0f;
        int i = 0;
        while (i < num_evals) {
            sum_evals = (float)((double)sum_evals + this.pcaResults.getEigenValues()[i]);
            ++i;
        }
        i = 0;
        while (i < num_evals) {
            pcts_var[i] = this.pcaResults.getEigenValues()[i] / (double)sum_evals * 100.0;
            ++i;
        }
        Matrix svals_1xn = new Matrix(new double[][]{this.pcaResults.getEigenValues(), pcts_var});
        this.jTable_S = new JTable(new MatrixTableModel(svals_1xn, new String[]{"Eigenvalue", "% Var"}, "PC"));
        this.jTable_S.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
        this.jTable_S.setAutoResizeMode(0);
        this.jTable_S.addMouseListener(new PcaFrameEx_jTable_S_mouseAdapter(this));
    }

    private void setSizeLocation() {
        this.setExtendedState(6);
        Dimension size = this.m_appFrame.desktop.getSize();
        int width = (int)((double)size.width * 0.75);
        int height = (int)((double)width * 0.6);
        Point pt = new Point(0, 0);
        pt.x = AppFrame.m_xOffset * this.m_appFrame.m_wOffset;
        pt.y = AppFrame.m_yOffset * this.m_appFrame.m_wOffset++;
        if (pt.x + width > size.width || pt.y + height > size.height) {
            this.m_appFrame.m_wOffset = 0;
            pt.x = 0;
            pt.y = 0;
        }
        SwingUtilities.convertPointToScreen(pt, this.m_appFrame.desktop);
        this.setSize(width, height);
        this.setLocation(pt);
        this.setVisible(true);
        Dimension ss = this.getMinimumSize();
        if (ss.height != AppFrame.m_yOffset) {
            AppFrame.m_xOffset = AppFrame.m_yOffset = this.getMinimumSize().height;
        }
    }

    private void refreshImage() {
        int num_scores_rows = this.pcaResults.getScoresMatrix().getRowDimension();
        float[] x = new float[num_scores_rows];
        float[] y = new float[num_scores_rows];
        int i = num_scores_rows - 1;
        while (i >= 0) {
            x[i] = (float)this.pcaResults.getScoresMatrix().get(i, this.m_xIndex);
            y[i] = (float)this.pcaResults.getScoresMatrix().get(i, this.m_yIndex);
            --i;
        }
        this.jPanel_2D.resetCoord(x, y, this.pcaResults.getObservationLabels(), this.m_xIndex + 1, this.m_yIndex + 1);
    }

    void jTable_U_mouseDragged(MouseEvent e) {
        int[] sel;
        if ((e.getModifiers() & 0x10) != 0 && (sel = this.jTable_U.getSelectedRows()) != null) {
            if (this.m_b3D) {
                if (this.jPanel_3D != null) {
                    this.jPanel_3D.setSelected(sel);
                }
            } else {
                this.jPanel_2D.setSelected(sel);
            }
        }
    }

    void jTable_U_mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 0;
            this.jChangeColor.setEnabled(this.jTable_U.getSelectedRowCount() > 0);
            this.jDoCopy.setEnabled(this.jTable_U.getSelectedRowCount() > 0);
            this.jUTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        } else {
            int[] selected = this.jTable_U.getSelectedRows();
            if (selected != null) {
                if (this.m_b3D) {
                    if (this.jPanel_3D != null) {
                        this.jPanel_3D.setSelected(selected);
                    }
                } else {
                    this.jPanel_2D.setSelected(selected);
                }
            }
        }
    }

    @Override
    void jTable_V_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 1;
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    void jTable_S_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 2;
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    void this_internalFrameActivated(InternalFrameEvent e) {
        this.m_appFrame.jButton_PCA.setEnabled(false);
        this.m_appFrame.jMenuItem_PCA.setEnabled(false);
        this.m_appFrame.jButton_TransposeTable.setEnabled(false);
    }

    @Override
    public void this_windowActivated(WindowEvent e) {
        this.setAlwaysOnTop(false);
    }

    @Override
    public void this_componentResized(ComponentEvent e) {
        float goldenLine = 0.618f;
        this.jSplitPane1.setDividerLocation(goldenLine);
        Dimension size = this.getSize();
        int h = (int)((float)size.height * goldenLine);
        int w = (int)((float)size.width * goldenLine);
        if (h < w) {
            this.jSplitPane2.setDividerLocation(h);
        } else {
            this.jSplitPane2.setDividerLocation(w);
        }
    }

    static enum GridStyle {
        NO_GRID,
        CENTRAL_GRID,
        REAR_GRID;

    }

    class JPanelRelativeVariance
    extends JPanel {
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension size = this.getSize();
            g2.setColor(Color.black);
            FontRenderContext frc = g2.getFontRenderContext();
            String xLabel = "PC";
            Font font = g2.getFont();
            TextLayout layout1 = new TextLayout(xLabel, font, frc);
            Rectangle2D rcX = layout1.getBounds();
            String yLabel = "Relative Variance";
            TextLayout layout2 = new TextLayout(xLabel, font, frc);
            Rectangle2D rcY = layout2.getBounds();
            int limitY = (int)(2.0 * rcX.getHeight());
            int limitX = 4 * (int)rcY.getHeight();
            if (size.width < 2 * limitX || size.height < 2 * limitY) {
                return;
            }
            g2.drawLine(limitX, limitY, limitX, size.height - limitY);
            g2.drawLine(limitX, size.height - limitY, size.width - limitX, size.height - limitY);
            g2.drawString(xLabel, (int)((size.getWidth() - rcX.getWidth()) / 2.0), size.height - 5);
            int cols = PcaFrameEx.this.pcaResults.getEigenValues().length;
            float[] ev = new float[cols];
            float sum = 0.0f;
            int i = 0;
            while (i < cols) {
                ev[i] = (float)PcaFrameEx.this.pcaResults.getEigenValues()[i];
                sum += ev[i];
                ++i;
            }
            this.setBackground(Color.white);
            float upLimit = 0.0f;
            int i2 = 0;
            while (i2 < cols) {
                if ((upLimit += ev[i2] / sum) >= 0.99f) {
                    cols = i2 + 1;
                    break;
                }
                ++i2;
            }
            int band = (size.width - 2 * limitX) / cols;
            if (band > 2) {
                int h = 0;
                int i3 = 0;
                while (i3 < cols) {
                    h = (int)(ev[i3] * (float)(size.height - 2 * limitY) / ev[0]);
                    float r = ev[i3] / ev[0];
                    Color color = new Color(r, 1.0f - r, 0.0f);
                    g2.setColor(color);
                    g2.fillRect(limitX + i3 * band + band / 2, size.height - limitY - h, band / 2, h);
                    ++i3;
                }
            }
            int x = (int)rcY.getHeight();
            int y = (int)((double)(size.height / 2) + rcY.getWidth() / 2.0);
            g2.setColor(Color.black);
            g2.translate(x, y);
            g2.rotate(-1.5707963267948966);
            g2.drawString(yLabel, 0, 0);
            g2.rotate(1.5707963267948966);
            g2.translate(-x, -y);
            g2.drawLine(limitX, limitY, limitX + 4, limitY);
            int delt = (size.height - 2 * limitY) / 3;
            g2.drawLine(limitX, limitY + delt, limitX + 4, limitY + delt);
            g2.drawLine(limitX, limitY + delt * 2, limitX + 4, limitY + delt * 2);
            String[] bs = new String[4];
            DecimalFormat format = new DecimalFormat("0.##");
            float initV = ev[0] / sum;
            int i4 = 0;
            while (i4 < bs.length) {
                bs[i4] = format.format(initV - initV / 3.0f * (float)i4);
                bs[3] = "0";
                TextLayout layout = new TextLayout(bs[i4], font, frc);
                Rectangle2D rc = layout.getBounds();
                g2.drawString(bs[i4], (int)((double)limitX - rc.getWidth() - 1.0), (int)((double)(limitY + i4 * delt) + rc.getHeight() / 2.0));
                ++i4;
            }
        }
    }

    static enum ObsDisplayStyle {
        SYMBOL,
        TEXT;

    }

    class PCAPanel3D
    extends JPanel
    implements ActionListener {
        List<Set<String>> obsGrpsMbrNames;
        List<Integer> selectedObsIxs;
        Map<Integer, Color> userColorsByObsIx;
        final int numPCs = 3;
        int numObs = 0;
        ObsDisplayStyle obsDisplayStyle;
        JPopupMenu popupMenu;
        private JMenuItem spotColorChooserMenuItem;
        private JMenuItem spotShapeMenuItem;
        private JMenuItem clearSpotSelectionsMenuItem;
        Color selectionColor = Color.BLACK;

        public PCAPanel3D() throws RemoteException {
            this.setToolTipText("");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            super.setLayout(new BorderLayout());
            this.selectedObsIxs = new ArrayList<Integer>();
            this.userColorsByObsIx = new HashMap<Integer, Color>();
            List<String> obs_names = Arrays.asList(PcaFrameEx.this.pcaResults.getObservationLabels());
            this.numObs = obs_names.size();
            this.initSamples(PcaFrameEx.this.m_xIndex, PcaFrameEx.this.m_yIndex, PcaFrameEx.this.m_zIndex);
            if (PcaFrameEx.this.grpColNames != null) {
                ArrayList<Set<String>> member_names_for_grps = new ArrayList<Set<String>>();
                List<String>[] listArray = PcaFrameEx.this.grpColNames;
                int n = PcaFrameEx.this.grpColNames.length;
                int n2 = 0;
                while (n2 < n) {
                    List<String> mbr_names = listArray[n2];
                    member_names_for_grps.add(new HashSet<String>(mbr_names));
                    ++n2;
                }
                this.setObservationGroupMemberships(member_names_for_grps);
            }
            this.obsDisplayStyle = ObsDisplayStyle.SYMBOL;
            this.add(PcaFrameEx.this.graph3D, "Center");
            this.popupMenu = this.createPopupMenu();
            this.enableDisableMenuItems();
        }

        private void initSamples(int pcX, int pcY, int pcZ) throws RemoteException {
            if (PcaFrameEx.this.graph3D == null) {
                System.out.println("initSamples called before graph object created.");
                return;
            }
            PcaFrameEx.this.graph3D.clearGraph();
            PcaFrameEx.this.graph3D.add(new SgGrid(0));
            PcaFrameEx.this.graph3D.add(new SgGrid(1));
            PcaFrameEx.this.graph3D.add(new SgGrid(2));
            int obs_ix = 0;
            while (obs_ix < this.numObs) {
                double x = PcaFrameEx.this.pcaResults.getScoresMatrix().get(obs_ix, pcX);
                double y = PcaFrameEx.this.pcaResults.getScoresMatrix().get(obs_ix, pcY);
                double z = PcaFrameEx.this.pcaResults.getScoresMatrix().get(obs_ix, pcZ);
                int grp = this.getGroupIdx(obs_ix);
                PcaFrameEx.this.graph3D.add(new SgSphere(x, y, z, obs_ix, this.getGroupColor(grp)));
                ++obs_ix;
            }
            PcaFrameEx.this.graph3D.setAxesLabels("PC" + (pcX + 1), "PC" + (pcY + 1), "PC" + (pcZ + 1));
            PcaFrameEx.this.graph3D.autoScaleData();
            PcaFrameEx.this.graph3D.refresh();
        }

        private Color getGroupColor(int grp) {
            Color darkGreen = new Color(0, 153, 0);
            Color[] clist = new Color[]{darkGreen, Color.blue, Color.red, Color.magenta, Color.orange, Color.cyan};
            if (grp < 0) {
                grp = 0;
            }
            if (grp >= clist.length) {
                grp = clist.length - 1;
            }
            Color c = clist[grp];
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), 204);
        }

        private int getGroupIdx(int obs_ix) {
            List<Set<String>> obs_grps_mbr_names = this.obsGrpsMbrNames;
            int num_grps = obs_grps_mbr_names != null ? obs_grps_mbr_names.size() : 0;
            String obs_name = PcaFrameEx.this.pcaResults.getObservationLabels()[obs_ix];
            int grp_ix = 0;
            while (grp_ix < num_grps) {
                if (obs_grps_mbr_names.get(grp_ix).contains(obs_name)) {
                    return grp_ix;
                }
                ++grp_ix;
            }
            System.out.println("Obs Index " + obs_ix + "(" + obs_name + ") was not found in any groups.");
            return 0;
        }

        public void setColorMap(List<Set<String>> obsGrpsMbrNames, Map<Integer, Color> userColorsByObsIx) {
            int obs_ix = 0;
            while (obs_ix < this.numObs) {
                int grp = this.getGroupIdx(obs_ix);
                SgGraphItem<Integer, String> item = PcaFrameEx.this.graph3D.findByID(obs_ix);
                item.setSurfaceColor(this.getGroupColor(grp));
                ++obs_ix;
            }
            PcaFrameEx.this.graph3D.refresh();
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            JPopupMenu popup = new JPopupMenu();
            popup.setDoubleBuffered(false);
            this.spotColorChooserMenuItem = new JMenuItem("Choose New Color");
            this.spotColorChooserMenuItem.setActionCommand(PcaFrameEx.CHOOSE_OBS_COLOR_CMD);
            this.spotColorChooserMenuItem.addActionListener(this);
            popup.add(this.spotColorChooserMenuItem);
            this.spotShapeMenuItem = new JMenuItem("Choose New Shape");
            this.spotShapeMenuItem.setActionCommand(PcaFrameEx.CHOOSE_OBS_SHAPE_CMD);
            this.spotShapeMenuItem.addActionListener(this);
            popup.add(this.spotShapeMenuItem);
            this.clearSpotSelectionsMenuItem = new JMenuItem("Clear Selections");
            this.clearSpotSelectionsMenuItem.setActionCommand(PcaFrameEx.CLEAR_SELECTIONS_CMD);
            this.clearSpotSelectionsMenuItem.addActionListener(this);
            popup.add(this.clearSpotSelectionsMenuItem);
            JMenuItem sel_all_mi = new JMenuItem(PcaFrameEx.SELECT_ALL_CMD);
            sel_all_mi.setActionCommand(PcaFrameEx.SELECT_ALL_CMD);
            sel_all_mi.addActionListener(this);
            popup.add(sel_all_mi);
            JMenu viewpoint_menu = new JMenu("Viewpoint");
            popup.add(viewpoint_menu);
            JMenuItem pc1_vs_pc2_mi = new JMenuItem(PcaFrameEx.PC2_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc2_mi.setActionCommand(PcaFrameEx.PC2_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc2_mi.addActionListener(this);
            viewpoint_menu.add(pc1_vs_pc2_mi);
            JMenuItem pc2_vs_pc3_mi = new JMenuItem(PcaFrameEx.PC3_VS_PC2_VIEWPOINT_CMD);
            pc2_vs_pc3_mi.setActionCommand(PcaFrameEx.PC3_VS_PC2_VIEWPOINT_CMD);
            pc2_vs_pc3_mi.addActionListener(this);
            viewpoint_menu.add(pc2_vs_pc3_mi);
            JMenuItem pc1_vs_pc3_mi = new JMenuItem(PcaFrameEx.PC3_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc3_mi.setActionCommand(PcaFrameEx.PC3_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc3_mi.addActionListener(this);
            viewpoint_menu.add(pc1_vs_pc3_mi);
            JMenu axes_menu = new JMenu("Axes");
            popup.add(axes_menu);
            popup.addSeparator();
            JCheckBoxMenuItem reverse_pc1_check = new JCheckBoxMenuItem("Reverse X");
            reverse_pc1_check.setActionCommand(PcaFrameEx.TOGGLE_REVERSE_PC1_CMD);
            reverse_pc1_check.addActionListener(this);
            axes_menu.add(reverse_pc1_check);
            JCheckBoxMenuItem reverse_pc2_check = new JCheckBoxMenuItem("Reverse Y");
            reverse_pc2_check.setActionCommand(PcaFrameEx.TOGGLE_REVERSE_PC2_CMD);
            reverse_pc2_check.addActionListener(this);
            axes_menu.add(reverse_pc2_check);
            JCheckBoxMenuItem reverse_pc3_check = new JCheckBoxMenuItem("Reverse Z");
            reverse_pc3_check.setActionCommand(PcaFrameEx.TOGGLE_REVERSE_PC3_CMD);
            reverse_pc3_check.addActionListener(this);
            axes_menu.add(reverse_pc3_check);
            axes_menu.addSeparator();
            JCheckBoxMenuItem axes_lines_check = new JCheckBoxMenuItem("Show Central Axes Lines (blue)");
            axes_lines_check.setSelected(true);
            axes_lines_check.setActionCommand(PcaFrameEx.TOGGLE_CENTRAL_AXES_LINES_CMD);
            axes_lines_check.addActionListener(this);
            axes_menu.add(axes_lines_check);
            axes_menu.addSeparator();
            JRadioButtonMenuItem rear_grid_btn = new JRadioButtonMenuItem(PcaFrameEx.REAR_GRID_CMD);
            rear_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.REAR_GRID);
            rear_grid_btn.setActionCommand(PcaFrameEx.REAR_GRID_CMD);
            rear_grid_btn.addActionListener(this);
            axes_menu.add(rear_grid_btn);
            JRadioButtonMenuItem central_grid_btn = new JRadioButtonMenuItem(PcaFrameEx.CENTRAL_GRID_CMD);
            central_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.CENTRAL_GRID);
            central_grid_btn.setActionCommand(PcaFrameEx.CENTRAL_GRID_CMD);
            central_grid_btn.addActionListener(this);
            axes_menu.add(central_grid_btn);
            JRadioButtonMenuItem no_grid_btn = new JRadioButtonMenuItem(PcaFrameEx.NO_GRID_CMD);
            no_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.NO_GRID);
            no_grid_btn.setActionCommand(PcaFrameEx.NO_GRID_CMD);
            no_grid_btn.addActionListener(this);
            axes_menu.add(no_grid_btn);
            axes_menu.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            bg.add(rear_grid_btn);
            bg.add(central_grid_btn);
            bg.add(no_grid_btn);
            return popup;
        }

        public void setObservationGroupMemberships(List<Set<String>> grps_mbr_names) throws RemoteException {
            this.obsGrpsMbrNames = grps_mbr_names;
            this.setColorMap(this.obsGrpsMbrNames, this.userColorsByObsIx);
        }

        public void setSelected(int[] selected) {
            if (selected.length < 1) {
                return;
            }
            ArrayList<Integer> sel = new ArrayList<Integer>();
            int[] nArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                sel.add(new Integer(i));
                ++n2;
            }
            try {
                this.setSelectedObservations(sel);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }

        private void synchronizeUTable(List<Integer> sel_obs_ixs) {
            PcaFrameEx.this.jTabPanel.setSelectedIndex(1);
            PcaFrameEx.this.jTable_U.clearSelection();
            if (sel_obs_ixs != null) {
                for (Integer i : sel_obs_ixs) {
                    PcaFrameEx.this.jTable_U.addRowSelectionInterval(i, i);
                }
                if (sel_obs_ixs.size() > 0) {
                    Rectangle rc = PcaFrameEx.this.jTable_U.getCellRect(sel_obs_ixs.get(0), 0, true);
                    PcaFrameEx.this.jTable_U.scrollRectToVisible(rc);
                }
                PcaFrameEx.this.jTable_U.repaint();
            }
        }

        public void setSelectedObservations(List<Integer> sel_obs_ixs) throws RemoteException {
            PcaFrameEx.this.graph3D.setSelectedObservations(sel_obs_ixs);
            PcaFrameEx.this.graph3D.refresh();
            this.enableDisableMenuItems();
        }

        protected void enableDisableMenuItems() {
            this.spotColorChooserMenuItem.setEnabled(this.selectedObsIxs.size() > 0);
            this.spotShapeMenuItem.setEnabled(this.selectedObsIxs.size() > 0);
            this.clearSpotSelectionsMenuItem.setEnabled(this.selectedObsIxs.size() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            try {
                if (cmd != PcaFrameEx.PC2_VS_PC1_VIEWPOINT_CMD && cmd != PcaFrameEx.PC3_VS_PC1_VIEWPOINT_CMD && cmd != PcaFrameEx.PC3_VS_PC2_VIEWPOINT_CMD) {
                    if (cmd == PcaFrameEx.TOGGLE_CENTRAL_AXES_LINES_CMD) {
                        boolean bl = ((AbstractButton)ae.getSource()).isSelected();
                    } else if (cmd != PcaFrameEx.REAR_GRID_CMD && cmd != PcaFrameEx.CENTRAL_GRID_CMD && cmd != PcaFrameEx.NO_GRID_CMD && cmd != PcaFrameEx.TOGGLE_REVERSE_PC1_CMD && cmd != PcaFrameEx.TOGGLE_REVERSE_PC2_CMD && cmd != PcaFrameEx.TOGGLE_REVERSE_PC3_CMD) {
                        if (cmd == PcaFrameEx.CHOOSE_OBS_COLOR_CMD) {
                            if (this.selectedObsIxs.size() > 0) {
                                JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, PcaFrameEx.this.colorChooser, new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ((PCAPanel3D)PCAPanel3D.this).PcaFrameEx.this.selectedColor = ((PCAPanel3D)PCAPanel3D.this).PcaFrameEx.this.colorChooser.getColor();
                                    }
                                }, null);
                                dialog.setVisible(true);
                                if (PcaFrameEx.this.selectedColor != null) {
                                    this.setObsColor(this.selectedObsIxs, PcaFrameEx.this.selectedColor);
                                    PcaFrameEx.this.jPanel_2D.setObsColor(this.selectedObsIxs, PcaFrameEx.this.selectedColor);
                                }
                            }
                        } else if (cmd != PcaFrameEx.CHOOSE_OBS_SHAPE_CMD) {
                            if (cmd == PcaFrameEx.CLEAR_SELECTIONS_CMD) {
                                this.clearSelection();
                            } else if (cmd == PcaFrameEx.SELECT_ALL_CMD) {
                                int num_obs = PcaFrameEx.this.jTable_U.getRowCount();
                                ArrayList<Integer> all_obs_ixs = new ArrayList<Integer>(num_obs);
                                int obs_ix = 0;
                                while (obs_ix < num_obs) {
                                    all_obs_ixs.add(obs_ix);
                                    ++obs_ix;
                                }
                                this.setSelectedObservations(all_obs_ixs);
                                this.synchronizeUTable(all_obs_ixs);
                            } else if (cmd == PcaFrameEx.SAVE_3D_IMG_CMD && PcaFrameEx.this.graph3D != null) {
                                new Thread(){

                                    @Override
                                    public void run() {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                ((PCAPanel3D)(this).PCAPanel3D.this).PcaFrameEx.this.graph3D.SaveAsImage();
                                            }
                                        });
                                    }
                                }.start();
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }

        public void setObsColor(List<Integer> selObsIxs, Color new_color) {
            try {
                PcaFrameEx.this.graph3D.setObsColor(selObsIxs, new_color);
                PcaFrameEx.this.graph3D.refresh();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }

        public void clearSelection() {
            try {
                PcaFrameEx.this.graph3D.clearSelection();
                PcaFrameEx.this.graph3D.refresh();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }

        protected double[] rangeFromMinMax(double[] scores_min_max) {
            double[] range = new double[]{scores_min_max[0] - 0.05 * Math.abs(scores_min_max[0]), scores_min_max[1] + 0.05 * Math.abs(scores_min_max[1])};
            return range;
        }
    }

    class PcaPanel2D
    extends JPanel
    implements ActionListener {
        static final String BACKGROUNDCOLOR = "Backgroud Color...";
        static final String SAVEIMAGE = "Save to File...";
        static final String SYMBOL = "Plot Details...";
        Color m_bgColor = null;
        Color[] m_color = null;
        boolean[] m_bLabel = null;
        int[] m_symbol = null;
        int[] m_size = null;
        Font m_font = null;
        DataPoint[] m_point = null;
        float[] m_x = new float[2];
        float[] m_y = new float[2];
        boolean m_bOK = false;
        int m_xComponent = 1;
        int m_yComponent = 2;
        Vector<Point> m_mousePoint = new Vector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItemSymbol = new JMenuItem("Plot Details...");
        JMenuItem jMenuItemBgColor = new JMenuItem("Backgroud Color...");
        JMenuItem jSave = new JMenuItem("Save as image...");

        private void hexagonPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x[3] = x0;
            y[0] = y0 - size;
            y[3] = y0 + size;
            int deltx = (int)((double)size * Math.sin(1.0471975511965976));
            int delty = (int)((double)size * Math.cos(1.0471975511965976));
            x[1] = x[2] = x0 + deltx;
            x[4] = x[5] = x0 - deltx;
            y[1] = y[5] = y0 - delty;
            y[2] = y[4] = y0 + delty;
        }

        private void pentagonPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x0;
            y[0] = y0 - size;
            int deltx = (int)((double)size * Math.sin(0.6283185307179586));
            int delty = (int)((double)size * Math.cos(0.6283185307179586));
            x[2] = x0 + deltx;
            x[3] = x0 - deltx;
            y[2] = y[3] = y0 + delty;
            deltx = (int)((double)size * Math.cos(0.3141592653589793));
            delty = (int)((double)size * Math.sin(0.3141592653589793));
            x[1] = x0 + deltx;
            x[4] = x0 - deltx;
            y[1] = y[4] = y0 - delty;
        }

        private void starPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x0;
            y[0] = y0 - size;
            x[5] = x0;
            y[5] = y0 + size / 2;
            int deltX = (int)((double)size * Math.sin(0.6283185307179586) / 2.0);
            int deltY = (int)((double)size * Math.cos(0.6283185307179586) / 2.0);
            x[1] = x0 + deltX;
            y[1] = y0 - deltY;
            x[9] = x0 - deltX;
            y[9] = y[1];
            deltX = (int)((double)size * Math.cos(0.3141592653589793));
            deltY = (int)((double)size * Math.sin(0.3141592653589793));
            x[2] = x0 + deltX;
            y[2] = y0 - deltY;
            x[8] = x0 - deltX;
            y[8] = y0 - deltY;
            deltX = (int)((double)size * Math.sin(0.6283185307179586));
            deltY = (int)((double)size * Math.cos(0.6283185307179586));
            x[4] = x0 + deltX;
            y[4] = y0 + deltY;
            x[6] = x0 - deltX;
            y[6] = y0 + deltY;
            deltX = (int)((double)size * Math.sin(1.2566370614359172) / 2.0);
            deltY = (int)((double)size * Math.cos(1.2566370614359172) / 2.0);
            x[3] = x0 + deltX;
            y[3] = y0 + deltY;
            x[7] = x0 - deltX;
            y[7] = y0 + deltY;
        }

        public PcaPanel2D() {
            this.setBackground(Color.white);
            this.jbInit();
            this.setToolTipText("");
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }

        public void clearSelection() {
            int i = 0;
            while (i < this.m_point.length) {
                this.m_point[i].setSelectState(false);
                ++i;
            }
            PcaFrameEx.this.jPanel_2D.updateUI();
            PcaFrameEx.this.jTable_U.clearSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(BACKGROUNDCOLOR)) {
                JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, PcaFrameEx.this.colorChooser, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((PcaPanel2D)PcaPanel2D.this).PcaFrameEx.this.selectedColor = ((PcaPanel2D)PcaPanel2D.this).PcaFrameEx.this.colorChooser.getColor();
                    }
                }, null);
                dialog.setVisible(true);
                if (PcaFrameEx.this.selectedColor != null) {
                    this.m_bgColor = PcaFrameEx.this.selectedColor;
                    this.repaint();
                }
            } else if (cmd.equals(SYMBOL)) {
                PcaFrameEx_DlgSymbol dlg = new PcaFrameEx_DlgSymbol(PcaFrameEx.this.m_pcaFrame);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = PcaFrameEx.this.m_appFrame.getSize();
                Point loc = PcaFrameEx.this.m_appFrame.getLocation();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
            } else if (cmd.equals("Save to File...")) {
                JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
                FileFilter filter = FileFilters.getImageFileFilter();
                chooser.addChoosableFileFilter(filter);
                chooser.setAcceptAllFileFilterUsed(false);
                int returnVal = chooser.showSaveDialog(this);
                if (returnVal == 0) {
                    AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
                    String fileName = chooser.getSelectedFile().getPath();
                    try {
                        String ext = ClUtils.getExtension(fileName);
                        if (ext == null) {
                            fileName = String.valueOf(fileName) + ".png";
                        }
                        File file = new File(fileName);
                        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                        this.paintComponent(img.createGraphics());
                        ext = ClUtils.getExtension(file);
                        ImageIO.write((RenderedImage)img, ext, file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }

        public int[] getSelectedIndex() {
            int[] ret = null;
            int count = 0;
            int i = 0;
            while (i < this.m_point.length) {
                if (this.m_point[i].isSelected()) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return null;
            }
            ret = new int[count];
            count = 0;
            i = 0;
            while (i < this.m_point.length) {
                if (this.m_point[i].isSelected()) {
                    ret[count++] = i;
                }
                ++i;
            }
            return ret;
        }

        public void resetCoord(float[] x, float[] y, String[] label, int x_comp, int y_comp) {
            int i;
            this.m_bOK = false;
            this.m_xComponent = x_comp;
            this.m_yComponent = y_comp;
            this.m_x = this.translateData(x);
            this.m_y = this.translateData(y);
            this.scaleData(x, this.m_x[1] - this.m_x[0]);
            this.scaleData(y, this.m_y[1] - this.m_y[0]);
            if (this.m_point == null) {
                this.m_point = new DataPoint[x.length];
            }
            int i2 = 0;
            while (i2 < x.length) {
                this.m_point[i2] = new DataPoint(x[i2], y[i2], i2);
                ++i2;
            }
            int[] selected = PcaFrameEx.this.jTable_U.getSelectedRows();
            if (selected != null) {
                i = 0;
                while (i < selected.length) {
                    this.m_point[selected[i]].setSelectState(true);
                    ++i;
                }
            }
            if (this.m_color == null) {
                this.m_color = new Color[x.length];
            }
            if (this.m_bLabel == null) {
                this.m_bLabel = new boolean[x.length];
            }
            if (this.m_size == null) {
                this.m_size = new int[x.length];
                i = 0;
                while (i < x.length) {
                    this.m_size[i] = PcaFrameEx_DlgSymbol.DEFAULTSIZE;
                    ++i;
                }
            }
            if (this.m_symbol == null) {
                this.m_symbol = new int[x.length];
                i = 0;
                while (i < x.length) {
                    this.m_symbol[i] = 0;
                    ++i;
                }
            }
            this.m_bOK = true;
            this.repaint();
        }

        private void scaleData(float[] data, float dis) {
            int i = 0;
            while (i < data.length) {
                data[i] = data[i] / dis + 0.5f;
                ++i;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_bOK) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.0f));
                if (this.m_font != null) {
                    g2.setFont(this.m_font);
                }
                if (this.m_bgColor != null) {
                    this.setBackground(this.m_bgColor);
                }
                this.drawPoint(g2);
            }
        }

        private void drawPoint(Graphics2D g2) {
            if (this.m_point.length > 2000) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setStroke(new BasicStroke(2.0f));
            int i = 0;
            while (i < this.m_point.length) {
                this.m_point[i].draw(w, h, g2);
                ++i;
            }
            g2.setStroke(new BasicStroke(1.0f));
            if (this.m_point.length > 0) {
                int x = (int)((float)w * 0.1f);
                int y = (int)((float)h * 0.1f);
                g2.setColor(Color.black);
                String str = new String("Score Plot");
                FontRenderContext frc = g2.getFontRenderContext();
                Font oldFont = g2.getFont();
                g2.setFont(new Font(oldFont.getName(), 1, (int)((double)oldFont.getSize() * 1.4)));
                TextLayout layout = new TextLayout(str, g2.getFont(), frc);
                Rectangle2D rect = layout.getBounds();
                g2.drawString(str, (int)((double)w - rect.getWidth()) / 2, y - y / 10);
                g2.setFont(oldFont);
                g2.drawRect(x, y, (int)((float)w * 0.8f), (int)((float)h * 0.8f));
                int delt = (int)((float)w * 0.8f / 3.0f);
                g2.drawLine(x + delt, h - y - 1, x + delt, h - y - 5);
                g2.drawLine(x + 2 * delt, h - y - 1, x + 2 * delt, h - y - 5);
                delt = (int)((float)h * 0.8f / 3.0f);
                g2.drawLine(x, y + delt, x + 4, y + delt);
                g2.drawLine(x, y + 2 * delt, x + 4, y + 2 * delt);
                str = "PC " + this.m_xComponent;
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)w * 0.5f) - rect.getWidth() / 2.0), (int)((double)(h - y) + rect.getHeight()) + 1);
                DecimalFormat format = new DecimalFormat("0.###");
                str = format.format(this.m_x[1]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)w * 0.9f) - rect.getWidth()), (int)((double)(h - y) + rect.getHeight()) + 2);
                str = format.format(this.m_x[0]);
                g2.drawString(str, x, (int)((double)(h - y) + rect.getHeight()) + 2);
                str = "PC " + this.m_yComponent;
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                y = (int)((double)(0.5f * (float)h) + rect.getWidth() / 2.0);
                g2.translate(--x, y);
                g2.rotate(-1.5707963267948966);
                g2.drawString(str, 0, -2);
                str = format.format(this.m_y[0]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)(-y) + 0.1f * (float)h) + rect.getWidth() - 6.0), -2);
                str = format.format(this.m_y[1]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)y - 0.1f * (float)h) - rect.getWidth()), -2);
                g2.rotate(1.5707963267948966);
                g2.translate(-x, -y);
                if (this.m_point.length > 2000) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                }
            }
        }

        private float[] translateData(float[] data) {
            float[] ret = new float[2];
            ret[1] = -3.4028235E38f;
            ret[0] = Float.MAX_VALUE;
            int i = 0;
            while (i < data.length) {
                if (data[i] > ret[1]) {
                    ret[1] = data[i];
                }
                if (data[i] < ret[0]) {
                    ret[0] = data[i];
                }
                ++i;
            }
            float tmp = (ret[1] + ret[0]) / 2.0f;
            int i2 = 0;
            while (i2 < data.length) {
                int n = i2++;
                data[n] = data[n] - tmp;
            }
            return ret;
        }

        public void setObsColor(List<Integer> selObsIxs, Color new_color) {
            for (Integer obsIxs : selObsIxs) {
                this.m_point[obsIxs].setColor(new_color);
            }
            this.clearSelection();
            this.repaint();
        }

        private void jbInit() {
            this.addMouseListener(new PcaPanel2D_this_mouseAdapter(this));
            this.addMouseMotionListener(new PcaPanel2D_this_mouseMotionAdapter(this));
            this.jPopupMenu.add(this.jMenuItemSymbol);
            this.jMenuItemSymbol.addActionListener(this);
            this.jPopupMenu.add(this.jMenuItemBgColor);
            this.jMenuItemBgColor.addActionListener(this);
            this.jPopupMenu.add(this.jSave);
            this.jSave.setActionCommand("Save to File...");
            this.jSave.addActionListener(this);
        }

        void this_mousePressed(MouseEvent e) {
            this.m_mousePoint.clear();
            if (e.getButton() == 1) {
                int i = 0;
                while (i < this.m_point.length) {
                    this.m_point[i].setSelectState(false);
                    ++i;
                }
                PcaFrameEx.this.jTable_U.clearSelection();
                this.m_mousePoint.add(e.getPoint());
            }
            this.setCursor(new Cursor(1));
            this.revalidate();
        }

        void this_mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
                this.jMenuItemSymbol.setVisible(PcaFrameEx.this.jPanel_2D.getSelectedIndex() != null);
                this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_mousePoint.size() > 1) {
                GeneralPath path = new GeneralPath();
                int nNum = this.m_mousePoint.size();
                path.moveTo(this.m_mousePoint.get((int)0).x, this.m_mousePoint.get((int)0).y);
                int i = 1;
                while (i < nNum) {
                    path.lineTo(this.m_mousePoint.get((int)i).x, this.m_mousePoint.get((int)i).y);
                    ++i;
                }
                path.closePath();
                int w = this.getWidth();
                int h = this.getHeight();
                int i2 = 0;
                while (i2 < this.m_point.length) {
                    int x1 = (int)(this.m_point[i2].getX() * (float)w * 0.8f + (float)w * 0.1f);
                    int y1 = (int)((float)h - (this.m_point[i2].getY() * (float)h * 0.8f + (float)h * 0.1f));
                    boolean bInner = path.contains(x1, y1);
                    this.m_point[i2].setSelectState(bInner);
                    if (bInner) {
                        PcaFrameEx.this.jTable_U.addRowSelectionInterval(i2, i2);
                    }
                    ++i2;
                }
                PcaFrameEx.this.jTabPanel.setSelectedIndex(1);
                int row = PcaFrameEx.this.jTable_U.getSelectedRow();
                if (row > -1) {
                    PcaFrameEx.this.jTable_U.scrollRectToVisible(PcaFrameEx.this.jTable_U.getCellRect(row, 0, false));
                }
            }
            this.m_mousePoint.clear();
            this.repaint();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void this_mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                this.m_mousePoint.add(e.getPoint());
                int nNum = this.m_mousePoint.size();
                if (nNum > 1) {
                    Graphics2D g2 = (Graphics2D)this.getGraphics();
                    if (g2 == null) {
                        return;
                    }
                    Point p1 = this.m_mousePoint.get(nNum - 2);
                    g2.drawLine(p1.x, p1.y, e.getX(), e.getY());
                }
            }
        }

        public void setSelected(int[] selected) {
            int i = 0;
            while (i < this.m_point.length) {
                this.m_point[i].setSelectState(false);
                ++i;
            }
            i = 0;
            while (i < selected.length) {
                this.m_point[selected[i]].setSelectState(true);
                ++i;
            }
            this.repaint();
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int w = this.getWidth();
            int h = this.getHeight();
            int i = this.m_point.length - 1;
            while (i >= 0) {
                int x1 = (int)(this.m_point[i].m_x * (float)w * 0.8f + (float)w * 0.1f);
                int y1 = (int)((float)h - (this.m_point[i].m_y * (float)h * 0.8f + (float)h * 0.1f));
                if (e.getX() > x1 - this.m_point[i].getSize() / 2 && e.getX() < x1 + this.m_point[i].getSize() / 2 && e.getY() > y1 - this.m_point[i].getSize() / 2 && e.getY() < y1 + this.m_point[i].getSize() / 2) {
                    String ret = "<html>" + PcaFrameEx.this.getPCAResults().getObservationLabels()[i] + "<br>";
                    ret = String.valueOf(ret) + "X-Score = " + PcaFrameEx.this.getPCAResults().getScoresMatrix().get(i, this.m_xComponent - 1) + "<br>";
                    ret = String.valueOf(ret) + "Y-Score = " + PcaFrameEx.this.getPCAResults().getScoresMatrix().get(i, this.m_yComponent - 1) + "</html>";
                    return ret;
                }
                --i;
            }
            return null;
        }

        class DataPoint {
            static final float coef1 = 0.57735f;
            static final float coef2 = 0.28867513f;
            static final int HOLLOWOVAL = 0;
            static final int FILLEDOVAL = 1;
            static final int HOLLOWRECT = 2;
            static final int FILLEDRECT = 3;
            static final int HOLLOWTRIANGLE = 4;
            static final int FILLEDTRIANGLE = 5;
            static final int INVERSEHOLLOWTRIANGLE = 6;
            static final int INVERSEFILLEDTRIANGLE = 7;
            static final int LEFTHOLLOWTRIANGLE = 8;
            static final int LEFTFILLEDTRIANGLE = 9;
            static final int RIGHTHOLLOWTRIANGLE = 10;
            static final int RIGHTFILLEDTRIANGLE = 11;
            static final int CHECK = 12;
            static final int RICE = 13;
            static final int STAR = 14;
            static final int FILLEDSTAR = 15;
            static final int TIAN = 16;
            static final int PENTAGON = 17;
            static final int FILLEDPENTAGON = 18;
            static final int HEXAGON = 19;
            static final int FILLEDHEXAGON = 20;
            static final int TIANX = 21;
            static final int DIAMOND = 22;
            static final int FILLEDDIAMOND = 23;
            static final int CROSS = 24;
            float m_x;
            float m_y;
            boolean m_bSelected;
            int m_rowNumber = -1;

            public DataPoint(float x, float y, int rowNum) {
                this.m_x = x;
                this.m_y = y;
                this.m_rowNumber = rowNum;
                this.m_bSelected = false;
            }

            public void setColor(Color color) {
                PcaPanel2D.this.m_color[this.m_rowNumber] = color;
            }

            public Color getColor() {
                return PcaPanel2D.this.m_color[this.m_rowNumber];
            }

            public void setSelectState(boolean state) {
                this.m_bSelected = state;
            }

            public boolean isSelected() {
                return this.m_bSelected;
            }

            public void setLabelState(boolean state) {
                PcaPanel2D.this.m_bLabel[this.m_rowNumber] = state;
            }

            public boolean isLabeled() {
                return PcaPanel2D.this.m_bLabel[this.m_rowNumber];
            }

            public void setSymbol(int symbol) {
                PcaPanel2D.this.m_symbol[this.m_rowNumber] = symbol;
            }

            public int getSymbol() {
                return PcaPanel2D.this.m_symbol[this.m_rowNumber];
            }

            public void setSize(int size) {
                PcaPanel2D.this.m_size[this.m_rowNumber] = size;
            }

            public int getSize() {
                return PcaPanel2D.this.m_size[this.m_rowNumber];
            }

            public float getX() {
                return this.m_x;
            }

            public float getY() {
                return this.m_y;
            }

            private int getRowNum() {
                return this.m_rowNumber;
            }

            public void draw(int w, int h, Graphics2D g2) {
                int x1 = (int)(this.m_x * (float)w * 0.8f + (float)w * 0.1f);
                int y1 = (int)((float)h - (this.m_y * (float)h * 0.8f + (float)h * 0.1f));
                if (this.m_bSelected) {
                    g2.setColor(((PcaPanel2D)PcaPanel2D.this).PcaFrameEx.this.selectionColor2D);
                } else if (PcaPanel2D.this.m_color[this.m_rowNumber] != null) {
                    g2.setColor(PcaPanel2D.this.m_color[this.m_rowNumber]);
                } else {
                    g2.setColor(((PcaPanel2D)PcaPanel2D.this).PcaFrameEx.this.defaultColor);
                }
                switch (this.getSymbol()) {
                    case 0: {
                        int shift = this.getSize() / 2;
                        g2.drawOval(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 1: {
                        int shift = this.getSize() / 2;
                        g2.fillOval(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 2: {
                        int shift = this.getSize() / 2;
                        g2.drawRect(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 3: {
                        int shift = this.getSize() / 2;
                        g2.fillRect(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 4: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 - (float)this.getSize() * 0.57735f), (int)((float)y1 + (float)this.getSize() * 0.28867513f), (int)((float)y1 + (float)this.getSize() * 0.28867513f)};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 5: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 - (float)this.getSize() * 0.57735f), (int)((float)y1 + (float)this.getSize() * 0.28867513f), (int)((float)y1 + (float)this.getSize() * 0.28867513f)};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 6: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 + (float)this.getSize() * 0.57735f), (int)((float)y1 - (float)this.getSize() * 0.28867513f), (int)((float)y1 - (float)this.getSize() * 0.28867513f)};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 7: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 + (float)this.getSize() * 0.57735f), (int)((float)y1 - (float)this.getSize() * 0.28867513f), (int)((float)y1 - (float)this.getSize() * 0.28867513f)};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 8: {
                        int[] x = new int[]{(int)((float)x1 - (float)this.getSize() * 0.57735f), (int)((float)x1 + (float)this.getSize() * 0.28867513f), (int)((float)x1 + (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 9: {
                        int[] x = new int[]{(int)((float)x1 - (float)this.getSize() * 0.57735f), (int)((float)x1 + (float)this.getSize() * 0.28867513f), (int)((float)x1 + (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 10: {
                        int[] x = new int[]{(int)((float)x1 + (float)this.getSize() * 0.57735f), (int)((float)x1 - (float)this.getSize() * 0.28867513f), (int)((float)x1 - (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 11: {
                        int[] x = new int[]{(int)((float)x1 + (float)this.getSize() * 0.57735f), (int)((float)x1 - (float)this.getSize() * 0.28867513f), (int)((float)x1 - (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 12: {
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 13: {
                        g2.drawLine(x1 - this.getSize() / 2, y1, x1 + this.getSize() / 2, y1);
                        g2.drawLine(x1, y1 - this.getSize() / 2, x1, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 14: {
                        int[] x = new int[10];
                        int[] y = new int[10];
                        PcaPanel2D.this.starPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, x.length);
                        break;
                    }
                    case 15: {
                        int[] x = new int[10];
                        int[] y = new int[10];
                        PcaPanel2D.this.starPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, x.length);
                        break;
                    }
                    case 16: {
                        g2.drawRect(x1 - this.getSize() / 2, y1 - this.getSize() / 2, this.getSize(), this.getSize());
                        g2.drawLine(x1 - this.getSize() / 2, y1, x1 + this.getSize() / 2, y1);
                        g2.drawLine(x1, y1 + this.getSize() / 2, x1, y1 - this.getSize() / 2);
                        break;
                    }
                    case 17: {
                        int[] x = new int[5];
                        int[] y = new int[5];
                        PcaPanel2D.this.pentagonPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, 5);
                        break;
                    }
                    case 18: {
                        int[] x = new int[5];
                        int[] y = new int[5];
                        PcaPanel2D.this.pentagonPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, 5);
                        break;
                    }
                    case 19: {
                        int[] x = new int[6];
                        int[] y = new int[6];
                        PcaPanel2D.this.hexagonPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, 6);
                        break;
                    }
                    case 20: {
                        int[] x = new int[6];
                        int[] y = new int[6];
                        PcaPanel2D.this.hexagonPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, 6);
                        break;
                    }
                    case 21: {
                        g2.drawRect(x1 - this.getSize() / 2, y1 - this.getSize() / 2, this.getSize(), this.getSize());
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 22: {
                        int[] x = new int[]{x1, x1 + this.getSize(), x1, x1 - this.getSize()};
                        int[] y = new int[]{y1 - this.getSize(), y1, y1 + this.getSize(), y1};
                        g2.drawPolygon(x, y, 4);
                        break;
                    }
                    case 23: {
                        int[] x = new int[]{x1, x1 + this.getSize(), x1, x1 - this.getSize()};
                        int[] y = new int[]{y1 - this.getSize(), y1, y1 + this.getSize(), y1};
                        g2.fillPolygon(x, y, 4);
                        break;
                    }
                    case 24: {
                        int shift = this.getSize() / 2;
                        g2.drawLine(x1 - shift, y1, x1 + shift, y1);
                        g2.drawLine(x1, y1 - shift, x1, y1 + shift);
                    }
                }
                if (PcaPanel2D.this.m_bLabel[this.m_rowNumber]) {
                    String tmp = PcaFrameEx.this.getPCAResults().getObservationLabels()[this.getRowNum()];
                    if (tmp.length() > 12) {
                        tmp = tmp.substring(0, 12);
                    }
                    g2.drawString(tmp, x1 + 1, y1 - 1);
                }
            }
        }

        class PcaPanel2D_this_mouseAdapter
        extends MouseAdapter {
            PcaPanel2D adaptee;

            PcaPanel2D_this_mouseAdapter(PcaPanel2D adaptee) {
                this.adaptee = adaptee;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.adaptee.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.adaptee.this_mouseReleased(e);
            }
        }

        class PcaPanel2D_this_mouseMotionAdapter
        extends MouseMotionAdapter {
            PcaPanel2D adaptee;

            PcaPanel2D_this_mouseMotionAdapter(PcaPanel2D adaptee) {
                this.adaptee = adaptee;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.adaptee.this_mouseDragged(e);
            }
        }
    }
}

