/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.IDataSetGroupsSelectionPanel;
import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.DlgSymbol;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.FontSelectDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.HighResImage;
import NCTR.app.arraytrack.vs2.analysis.clustering.MatrixTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAResults;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_jTable_S_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_jTable_SampleInfo_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_jTable_U_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_jTable_V_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_this_componentAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame_this_windowAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.RowLabelCellRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.ShapeChoice;
import NCTR.util.math.la.Matrix;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.TriangleStripArray;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import visad.ColorControl;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ShapeControl;
import visad.SimpleSet;
import visad.TextControl;
import visad.ThingReference;
import visad.Tuple;
import visad.UnionSet;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADQuadArray;
import visad.VisADRay;
import visad.VisADTriangleStripArray;
import visad.bom.PickManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ProjectionControlJ3D;

public class PcaFrame
extends JFrame
implements ActionListener,
ItemListener {
    static final String COMPONENTX = "Change Component X";
    static final String COMPONENTY = "Change Component Y";
    static final String COMPONENTZ = "Change Component Z";
    static final String SAVEIMAGE = "Save to File...";
    static final String RESETVIEWPOINT = "Reset Viewpoint";
    static final int SCORE = 1;
    boolean m_b3D = false;
    int columForSearch = -1;
    PCAResults pcaResults;
    AppFrame m_appFrame = null;
    PcaFrame m_pcaFrame = this;
    boolean m_bHeaderInFirstRow = true;
    JPanel contentPane;
    PcaPanel2D jPanel_2D = new PcaPanel2D();
    PCAPanel3D jPanel_3D = null;
    JSplitPane jSplitPane1 = new JSplitPane();
    JSplitPane jSplitPane2 = new JSplitPane();
    JSplitPane jSplitPane3 = new JSplitPane();
    JTabbedPane jTabPane_2D3D = new JTabbedPane();
    JTabbedPane jTabPanel = new JTabbedPane();
    JScrollPane jScorePane = new JScrollPane();
    JScrollPane jEigenValue = new JScrollPane();
    JScrollPane jLoadingPane;
    JScrollPane jSampleInfoPane;
    JTable jTable_U = null;
    JTable jTable_V = null;
    JTable jTable_S = null;
    JTable jTable_SampleInfo = null;
    List<Integer> selectedObsIxs = new ArrayList<Integer>();
    RowSorter<TableModel> sorter_sampleInfo = null;
    RowSorter<TableModel> sorter_U = null;
    JPanelRelativeVariance jRelativeVariance;
    JPanel jPanelFor2D = new JPanel(new GridLayout(3, 1, 0, 1));
    JPanel jPanelX = new JPanel();
    JPanel jPanelY = new JPanel();
    JPanel jPanel3DV = new JPanel();
    JComboBox jComboBox_X = new JComboBox();
    JComboBox jComboBox_Y = new JComboBox();
    JPanel jPanelFor3D = new JPanel(new BorderLayout());
    JPanel jPanelgrid = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JButton jButton_2D3DView = new JButton("3D view");
    JButton jButton_3D2DView = new JButton("2D view");
    Color selectionColor2D = Color.MAGENTA;
    Color defaultColor = new Color(0.1f, 0.5f, 1.0f);
    JLabel selObsNameLabel;
    JLabel selObsScoresLabel;
    JSlider shapesize_slider = null;
    JComboBox jComboBox_X3 = new JComboBox();
    JComboBox jComboBox_Y3 = new JComboBox();
    JComboBox jComboBox_Z3 = new JComboBox();
    JButton jButton_ResetView = new JButton("Reset Viewpoint");
    JButton j_rotXup = new JButton("");
    JTextField jtf_Angle = new JTextField("5");
    JButton j_rotXdown = new JButton("");
    JButton j_rotYleft = new JButton("");
    JButton j_rotYright = new JButton("");
    JCheckBox jCheckBox_Project = new JCheckBox("Perspective Projection");
    JCheckBox jCheckBox_ShowNames = new JCheckBox("Show Dataset Names");
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jChangeColor = new JMenuItem("Color...");
    JMenuItem jUTSave = new JMenuItem("Save");
    JMenuItem jMenuSave = new JMenuItem("Save");
    JPopupMenu jUTablePopupMenu = new JPopupMenu();
    JPopupMenu jSampleInfoPopupMenu = new JPopupMenu();
    JMenuItem jDoSearch = new JMenuItem("Search...");
    JMenuItem jColorByLabelGroup = new JMenuItem("Color samples by label groups");
    JMenuItem jSearchInColum = new JMenuItem("Search...");
    JMenuItem jSaveSampleInfo = new JMenuItem("Save");
    JMenuItem jChangeColorSampleInfo = new JMenuItem("Color...");
    JMenuItem jCopySampleInfo = new JMenuItem("Copy selected rows");
    int columnForSearch = -1;
    JMenuItem jDoCopy = new JMenuItem("Copy selected rows");
    Color selectedColor = null;
    final JColorChooser colorChooser = ClUtils.createColorChooser();
    int m_xIndex;
    int m_yIndex;
    int m_zIndex;
    int m_saveIndex = -1;
    List<String>[] grpColNames;
    static final String LOADINGMATRIX = "Loadings";
    static final String SCOREMATRIX = "Scores";
    static final String SINGULARMATRIX = "Eigenvalues";
    static final String RELATIVEVARIANCE = "Relative Variances";
    static final String SAMPLEINFO = "Sample Info";
    public static final String TOGGLE_REVERSE_PC1_CMD = "Reverse PC1";
    public static final String TOGGLE_REVERSE_PC2_CMD = "Reverse PC2";
    public static final String TOGGLE_REVERSE_PC3_CMD = "Reverse PC3";
    public static final String REAR_GRID_CMD = "Rear Grid";
    public static final String CENTRAL_GRID_CMD = "Central Grid";
    public static final String NO_GRID_CMD = "No Grid";
    public static final String TOGGLE_CENTRAL_AXES_LINES_CMD = "Toggle Axes Lines";
    public static final String SAVE_3D_IMG_CMD = "save 3d img";
    public static final String PC2_VS_PC1_VIEWPOINT_CMD = "Y vs X";
    public static final String PC3_VS_PC1_VIEWPOINT_CMD = "Z vs X";
    public static final String PC3_VS_PC2_VIEWPOINT_CMD = "Z vs Y";
    public static final String CHOOSE_OBS_COLOR_CMD = "Choose obs Color";
    public static final String CHOOSE_OBS_SHAPE_CMD = "Choose obs Shape";
    public static final String CLEAR_SELECTIONS_CMD = "Clear Sels";
    public static final String SHOW_SPOT_LABEL_CMD = "Show Label";
    public static final String SELECT_ALL_CMD = "Select All";
    static final int DEFAULT_PROJECTION_MODE = 1;
    static final boolean DEFAULT_SHOULD_SHOW_CENTRAL_AXES = true;
    static final GridStyle DEFAULT_GRID_STYLE = GridStyle.REAR_GRID;
    float scale_factor = 0.5f;

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean persp_proj = ((AbstractButton)e.getSource()).isSelected();
        try {
            if (e.getSource().equals(this.jCheckBox_ShowNames)) {
                this.jPanel_2D.setShowLabel(this.jCheckBox_ShowNames.isSelected());
                this.jPanel_3D.setShapeMap(this.jPanel_3D.userShapesByObsIx);
            } else {
                this.jPanel_3D.display3D.getGraphicsModeControl().setProjectionPolicy(persp_proj ? 1 : 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelection() {
        if (this.selectedObsIxs.size() < 1) {
            return;
        }
        int i = 0;
        while (i < this.jPanel_2D.m_point.length) {
            this.jPanel_2D.m_point[i].setSelectState(false);
            ++i;
        }
        i = 0;
        while (i < this.selectedObsIxs.size()) {
            this.jPanel_2D.m_point[this.selectedObsIxs.get(i)].setSelectState(true);
            ++i;
        }
        this.jPanel_2D.repaint();
        if (this.jPanel_3D != null) {
            try {
                this.jPanel_3D.setSelectedObservations();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        this.jTable_U.clearSelection();
        if (this.jTable_SampleInfo != null) {
            this.jTable_SampleInfo.clearSelection();
        }
        for (int mix : this.selectedObsIxs) {
            int vix = this.sorter_U.convertRowIndexToView(mix);
            this.jTable_U.addRowSelectionInterval(vix, vix);
            if (this.jTable_SampleInfo == null) continue;
            vix = this.sorter_sampleInfo.convertRowIndexToView(mix);
            this.jTable_SampleInfo.addRowSelectionInterval(vix, vix);
        }
    }

    public void clearSelection() {
        this.selectedObsIxs.clear();
        int i = 0;
        while (i < this.jPanel_2D.m_point.length) {
            this.jPanel_2D.m_point[i].setSelectState(false);
            ++i;
        }
        this.jPanel_2D.updateUI();
        this.jTable_U.clearSelection();
        if (this.jTable_SampleInfo != null) {
            this.jTable_SampleInfo.clearSelection();
            this.jTable_SampleInfo.updateUI();
        }
        try {
            if (this.jPanel_3D != null) {
                this.jPanel_3D.display3D.removeReference((ThingReference)this.jPanel_3D.selectionHilightsDataRef);
                this.jPanel_3D.setSelectedObservations();
                this.jPanel_3D.selectionHilightsDataRef = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float[][] initColorComponents(int numColors, int numColorComp) {
        float[][] ret = new float[numColorComp][numColors];
        Color[] cT = new Color[]{Color.red, Color.blue, Color.green, Color.pink, Color.cyan, Color.lightGray, Color.orange, Color.black, new Color(0.0f, 0.5f, 0.5f), new Color(0.5f, 0.0f, 0.5f), new Color(1.0f, 0.0f, 0.5f), new Color(0.0f, 0.75f, 1.0f), new Color(0.0f, 0.75f, 0.25f), Color.gray, Color.yellow};
        float[] colorComp = null;
        int end = numColors > 15 ? 15 : numColors;
        int i = 0;
        while (i < end) {
            colorComp = cT[i].getRGBColorComponents(null);
            ret[0][i] = colorComp[0];
            ret[1][i] = colorComp[1];
            ret[2][i] = colorComp[2];
            ++i;
        }
        Random rand = new Random(10L);
        int i2 = 10;
        while (i2 < numColors) {
            ret[0][i2] = rand.nextFloat();
            ret[1][i2] = rand.nextFloat();
            ret[2][i2] = rand.nextFloat();
            ++i2;
        }
        return ret;
    }

    public PcaFrame(Frame frame, PCAResults pca_results, List<String>[] grp_col_names) {
        super("PCA 2D/3D Viewer");
        this.m_appFrame = (AppFrame)frame;
        this.setIconImage(this.m_appFrame.imgPCA.getImage());
        this.pcaResults = pca_results;
        if (grp_col_names != null && grp_col_names.length > 1) {
            this.grpColNames = grp_col_names;
        }
        this.setAlwaysOnTop(true);
        this.jbInit();
        if (this.grpColNames != null) {
            int numColors = this.grpColNames.length;
            float[][] rgb = this.initColorComponents(numColors, 3);
            ArrayList<HashSet<String>> member_names_for_grps = new ArrayList<HashSet<String>>();
            List<String>[] listArray = this.grpColNames;
            int n = this.grpColNames.length;
            int n2 = 0;
            while (n2 < n) {
                List<String> mbr_names = listArray[n2];
                member_names_for_grps.add(new HashSet<String>(mbr_names));
                ++n2;
            }
            int obs_ix = 0;
            while (obs_ix < this.jPanel_2D.m_point.length) {
                String obs_name = this.pcaResults.getObservationLabels()[obs_ix];
                int grp_ix = 0;
                while (grp_ix < numColors) {
                    if (((java.util.Set)member_names_for_grps.get(grp_ix)).contains(obs_name)) {
                        this.jPanel_2D.m_color[obs_ix] = new Color(rgb[0][grp_ix], rgb[1][grp_ix], rgb[2][grp_ix]);
                        break;
                    }
                    ++grp_ix;
                }
                ++obs_ix;
            }
        }
        this.setDefaultCloseOperation(2);
    }

    public PcaFrame(String title) {
        super(title);
        this.setDefaultCloseOperation(2);
    }

    public PcaFrame(Frame frame, PCAResults pca_results) {
        this(frame, pca_results, null);
    }

    public PCAResults getPCAResults() {
        return this.pcaResults;
    }

    public String[] getSelectedGenes() {
        return null;
    }

    protected double[] getPercentEigen() {
        int num_evals = this.getPCAResults().getEigenValues().length;
        double[] pcts_var = new double[num_evals];
        double sum_evals = 0.0;
        int i = 0;
        while (i < num_evals) {
            sum_evals += this.getPCAResults().getEigenValues()[i];
            ++i;
        }
        i = 0;
        while (i < num_evals) {
            pcts_var[i] = this.getPCAResults().getEigenValues()[i] / sum_evals * 100.0;
            ++i;
        }
        return pcts_var;
    }

    private void saveTable(JTable table) {
        JFileChooser file_dlg = new JFileChooser(AppFrame.last_user_path);
        file_dlg.setDialogTitle("Export to File");
        if (file_dlg.showSaveDialog(this) == 0) {
            File sel_file = file_dlg.getSelectedFile();
            AppFrame.last_user_path = file_dlg.getSelectedFile().getParentFile();
            if (sel_file != null) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(sel_file));
                    int rows = table.getRowCount();
                    int cols = table.getColumnCount();
                    MatrixTableModel mod = (MatrixTableModel)table.getModel();
                    NumberFormat nFmt = mod.nFmt;
                    bw.write("\t");
                    int j = 1;
                    while (j < cols) {
                        bw.write(mod.getColumnName(j));
                        if (j < cols - 1) {
                            bw.write("\t");
                        } else {
                            bw.write("\n");
                        }
                        ++j;
                    }
                    int i = 0;
                    while (i < rows) {
                        int j2 = 0;
                        while (j2 < cols) {
                            if (j2 > 0) {
                                bw.write(nFmt.format(table.getValueAt(i, j2)));
                            } else {
                                bw.write((String)table.getValueAt(i, j2));
                            }
                            if (j2 < cols - 1) {
                                bw.write("\t");
                            } else {
                                bw.write("\n");
                            }
                            ++j2;
                        }
                        ++i;
                    }
                    bw.close();
                }
                catch (IOException ex) {
                    ClUtils.ErrorMessage(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Save")) {
            if (this.m_saveIndex == 0) {
                this.saveTable(this.jTable_U);
            } else if (this.m_saveIndex == 1) {
                if (this.jTable_V != null) {
                    this.saveTable(this.jTable_V);
                }
            } else if (this.m_saveIndex == 2) {
                this.saveTable(this.jTable_S);
            } else if (this.m_saveIndex == 3) {
                this.saveTable(this.jTable_SampleInfo);
            }
        } else if (cmd.equals("Color...")) {
            JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, this.colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PcaFrame.this.selectedColor = PcaFrame.this.colorChooser.getColor();
                }
            }, null);
            dialog.setVisible(true);
            if (this.selectedColor != null) {
                int[] selected = null;
                selected = this.jTable_U.getSelectedRows();
                ArrayList<Integer> sel = new ArrayList<Integer>();
                int[] nArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    int ixs = nArray[n2];
                    sel.add(ixs);
                    ++n2;
                }
                this.jPanel_2D.setObsColor(sel, this.selectedColor);
                if (this.m_pcaFrame.jPanel_3D != null) {
                    this.jPanel_3D.setObsColor(sel, this.selectedColor);
                }
                this.clearSelection();
            }
        } else if (cmd.equals("Copy selected rows")) {
            JTable tb = null;
            if (this.m_saveIndex == 0) {
                tb = this.jTable_U;
            } else if (this.m_saveIndex == 3) {
                tb = this.jTable_SampleInfo;
            } else {
                System.out.println("Do nothing");
                return;
            }
            int[] rows = tb.getSelectedRows();
            int cols = tb.getColumnCount();
            StringBuffer sbf = new StringBuffer();
            sbf.append("\t");
            int c = 1;
            while (c < cols) {
                sbf.append(tb.getColumnName(c));
                if (c < cols - 1) {
                    sbf.append("\t");
                }
                ++c;
            }
            sbf.append("\n");
            int r = 0;
            while (r < rows.length) {
                int c2 = 0;
                while (c2 < cols) {
                    sbf.append(tb.getValueAt(rows[r], c2));
                    if (c2 < cols - 1) {
                        sbf.append("\t");
                    }
                    ++c2;
                }
                sbf.append("\n");
                ++r;
            }
            StringSelection stsel = new StringSelection(sbf.toString());
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(stsel, stsel);
        } else if (cmd.equals("Search...")) {
            String inputValue = JOptionPane.showInputDialog(null, "Search:", "Search String...", 3);
            JTable tb = null;
            int col = -1;
            if (this.m_saveIndex == 0) {
                tb = this.jTable_U;
                col = 0;
            } else if (this.m_saveIndex == 3) {
                tb = this.jTable_SampleInfo;
                col = this.columForSearch;
            } else {
                System.out.println("Do nothing");
                return;
            }
            if (inputValue != null && inputValue != "") {
                StringTokenizer st = new StringTokenizer(inputValue, " \t;,");
                Vector<String> f = new Vector<String>();
                while (st.hasMoreElements()) {
                    f.add(st.nextToken());
                }
                this.clearSelection();
                int rows = this.jTable_U.getRowCount();
                int i = 0;
                while (i < rows) {
                    String v = (String)tb.getValueAt(i, col);
                    if (v != null) {
                        int j = 0;
                        while (j < f.size()) {
                            if (v.indexOf((String)f.get(j)) >= 0) {
                                int mix = -1;
                                mix = tb.equals(this.jTable_U) ? this.sorter_U.convertRowIndexToModel(i) : this.sorter_sampleInfo.convertRowIndexToModel(i);
                                this.selectedObsIxs.add(mix);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.setSelection();
            }
        } else if (cmd.equals("Color samples by label groups")) {
            int rows = this.jTable_SampleInfo.getRowCount();
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < rows) {
                Object obj = this.jTable_SampleInfo.getValueAt(i, this.columForSearch);
                if (obj != null) {
                    set.add(obj.toString());
                } else {
                    set.add("");
                }
                ++i;
            }
            Color[] colorpool = new Color[]{Color.blue, Color.red, Color.green, Color.black, Color.cyan, Color.gray, Color.orange, Color.darkGray, Color.lightGray, Color.pink, Color.yellow, Color.magenta};
            ArrayList<Integer> sel = new ArrayList<Integer>();
            int nC = 0;
            for (String str : set) {
                sel.clear();
                int i2 = 0;
                while (i2 < rows) {
                    Object obj = this.jTable_SampleInfo.getValueAt(i2, this.columForSearch);
                    String v = "";
                    if (obj != null) {
                        v = obj.toString();
                    }
                    if (str.equals(v)) {
                        sel.add(this.sorter_sampleInfo.convertRowIndexToModel(i2));
                    }
                    ++i2;
                }
                this.jPanel_2D.setObsColor(sel, colorpool[nC]);
                if (this.m_pcaFrame.jPanel_3D != null) {
                    this.jPanel_3D.setObsColor(sel, colorpool[nC]);
                }
                if (++nC != colorpool.length) continue;
                nC = 0;
            }
        } else if (cmd.equals(COMPONENTX) || cmd.equals(COMPONENTY) || cmd.equals(COMPONENTZ)) {
            if (cmd.equals(COMPONENTX)) {
                this.m_xIndex = ((JComboBox)e.getSource()).getSelectedIndex();
                this.jComboBox_X.setSelectedIndex(this.m_xIndex);
                this.jComboBox_X3.setSelectedIndex(this.m_xIndex);
            } else if (cmd.equals(COMPONENTY)) {
                this.m_yIndex = ((JComboBox)e.getSource()).getSelectedIndex();
                this.jComboBox_Y.setSelectedIndex(this.m_yIndex);
                this.jComboBox_Y3.setSelectedIndex(this.m_yIndex);
            } else {
                this.m_zIndex = ((JComboBox)e.getSource()).getSelectedIndex();
            }
            int[] vix = this.jTable_U.getSelectedRows();
            this.selectedObsIxs.clear();
            int[] nArray = vix;
            int n = vix.length;
            int n3 = 0;
            while (n3 < n) {
                int ix = nArray[n3];
                this.selectedObsIxs.add(this.sorter_U.convertRowIndexToModel(ix));
                ++n3;
            }
            if (this.jPanel_3D != null) {
                try {
                    this.jPanel_3D.initSamples(this.m_xIndex, this.m_yIndex, this.m_zIndex);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            this.setSelection();
            this.refreshImage();
        } else if (cmd.equals("Plot Details...")) {
            this.jPanel_2D.actionPerformed(e);
        } else if (cmd.equals(RESETVIEWPOINT)) {
            try {
                ProjectionControlJ3D pct = (ProjectionControlJ3D)this.jPanel_3D.display3D.getProjectionControl();
                pct.setOrthoView(4);
            }
            catch (Exception pct) {}
        } else if (cmd.equals("roll+")) {
            String str = this.jtf_Angle.getText();
            int angleX = Integer.parseInt(str);
            if (angleX >= 360) {
                angleX %= 360;
            }
            this.rotate3DObjects(angleX, 0.0);
        } else if (cmd.equals("roll-")) {
            String str = this.jtf_Angle.getText();
            int angleX = Integer.parseInt(str);
            if (angleX >= 360) {
                angleX %= 360;
            }
            this.rotate3DObjects(-angleX, 0.0);
        } else if (cmd.equals("pitch+")) {
            String str = this.jtf_Angle.getText();
            int angleY = Integer.parseInt(str);
            if (angleY >= 360) {
                angleY %= 360;
            }
            this.rotate3DObjects(0.0, angleY);
        } else if (cmd.equals("pitch-")) {
            String str = this.jtf_Angle.getText();
            int angleY = Integer.parseInt(str);
            if (angleY >= 360) {
                angleY %= 360;
            }
            this.rotate3DObjects(0.0, -angleY);
        }
    }

    private void rotate3DObjects(double angleX, double angleY) {
        try {
            ProjectionControlJ3D pct = (ProjectionControlJ3D)this.jPanel_3D.display3D.getProjectionControl();
            double[] mx = pct.getMatrix();
            double[] t1 = this.jPanel_3D.display3D.getMouseBehavior().make_matrix(angleX, angleY, 0.0, 1.0, 0.0, 0.0, 0.0);
            t1 = this.jPanel_3D.display3D.getMouseBehavior().multiply_matrix(t1, mx);
            pct.setMatrix(t1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() {
        this.jLoadingPane = this.pcaResults.getLoadingMatrix() != null ? new JScrollPane() : null;
        this.jSplitPane1.setOrientation(0);
        this.addWindowListener(new PcaFrame_this_windowAdapter(this));
        this.addComponentListener(new PcaFrame_this_componentAdapter(this));
        this.jSplitPane1.add((Component)this.jTabPane_2D3D, "top");
        this.jSplitPane1.add((Component)this.jTabPanel, "bottom");
        this.jTabPane_2D3D.add("2D View", this.jSplitPane2);
        this.jSplitPane2.add((Component)this.jPanelFor2D, "right");
        this.jSplitPane2.add((Component)this.jPanel_2D, "left");
        this.jPanelFor2D.add((Component)this.jPanelX, null);
        this.jPanelX.add((Component)this.jComboBox_X, null);
        this.jPanelFor2D.add((Component)this.jPanelY, null);
        this.jPanelY.add((Component)this.jComboBox_Y, null);
        this.jPanelgrid.setLayout(new BoxLayout(this.jPanelgrid, 1));
        if (this.isJ3DInstalled()) {
            this.jPanelFor2D.add((Component)this.jPanel3DV, null);
            this.jTabPane_2D3D.add("3D View", this.jSplitPane3);
            this.shapesize_slider = new JSlider(0, 0, 30, (int)(this.scale_factor * 10.0f));
            this.shapesize_slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    try {
                        PcaFrame.this.scale_factor = (float)PcaFrame.this.shapesize_slider.getValue() / 10.0f;
                        ((ShapeControl)PcaFrame.this.jPanel_3D.shapeMap.getControl()).setScale(PcaFrame.this.scale_factor);
                        ((ShapeControl)PcaFrame.this.jPanel_3D.labelShapeMap.getControl()).setScale(PcaFrame.this.scale_factor);
                        if (PcaFrame.this.jPanel_3D.selectionHilightsDataRef != null) {
                            PcaFrame.this.jPanel_3D.selectionHilightsDataRef.setData((Data)PcaFrame.this.jPanel_3D.createSelectionHilights());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Couldn't set shape scale: " + e);
                    }
                }
            });
            this.shapesize_slider.setBorder(new TitledBorder("Symbol/Text Size"));
            this.jPanelFor3D.add((Component)this.jPanelgrid, "Center");
            this.jPanelFor3D.add((Component)this.jPanel3, "North");
            this.selObsNameLabel = new JLabel(" ");
            this.jPanel3.add((Component)this.selObsNameLabel, null);
            this.selObsScoresLabel = new JLabel(" ");
            this.jPanel3.add((Component)this.selObsScoresLabel, null);
            this.jPanelgrid.add(this.jPanel4);
            this.jPanel4.add((Component)this.jComboBox_X3, null);
            this.jPanel4.add((Component)this.jComboBox_Y3, null);
            this.jPanel4.add((Component)this.jComboBox_Z3, null);
            this.j_rotXup.setActionCommand("roll+");
            this.j_rotXup.addActionListener(this);
            this.j_rotXdown.setActionCommand("roll-");
            this.j_rotXdown.addActionListener(this);
            this.j_rotYleft.setActionCommand("pitch+");
            this.j_rotYleft.addActionListener(this);
            this.j_rotYright.setActionCommand("pitch-");
            this.j_rotYright.addActionListener(this);
            Dimension size = new Dimension(16, 16);
            this.j_rotXup.setPreferredSize(size);
            ClassLoader cl = PcaFrame.class.getClassLoader();
            this.j_rotXup.setIcon(new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/rollXup.gif")));
            this.j_rotXdown.setIcon(new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/rollXdown.gif")));
            this.j_rotYleft.setIcon(new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/pitchYleft.gif")));
            this.j_rotYright.setIcon(new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/pitchYright.gif")));
            this.j_rotXdown.setPreferredSize(size);
            this.j_rotYleft.setPreferredSize(size);
            this.j_rotYright.setPreferredSize(size);
            this.jtf_Angle.setPreferredSize(new Dimension(50, this.j_rotXup.getPreferredSize().height));
            this.jtf_Angle.setHorizontalAlignment(0);
            JPanel jp_tmp = new JPanel(new BorderLayout());
            JPanel jp_tmp3 = new JPanel();
            jp_tmp3.add(this.j_rotXup);
            jp_tmp3.setAlignmentX(0.5f);
            jp_tmp.add((Component)jp_tmp3, "North");
            jp_tmp3 = new JPanel();
            jp_tmp3.add(this.j_rotXdown);
            jp_tmp3.setAlignmentX(0.5f);
            jp_tmp.add((Component)jp_tmp3, "South");
            jp_tmp3 = new JPanel();
            jp_tmp3.add(this.j_rotYleft);
            jp_tmp3.add(this.jtf_Angle);
            jp_tmp3.add(this.j_rotYright);
            jp_tmp.add((Component)jp_tmp3, "Center");
            JPanel jp_tmp1 = new JPanel();
            jp_tmp1.add(jp_tmp);
            this.jPanelgrid.add(jp_tmp1);
            this.jPanelgrid.add(this.jPanel5);
            this.jPanel5.add((Component)this.jCheckBox_ShowNames, null);
            this.jCheckBox_ShowNames.addItemListener(this);
            this.jPanelgrid.add(this.jPanel6);
            this.jPanel6.add((Component)this.jCheckBox_Project, null);
            this.jCheckBox_Project.setSelected(true);
            this.jCheckBox_Project.addItemListener(this);
            this.jPanelgrid.add(this.jPanel8);
            this.jPanel3DV.add((Component)this.jButton_2D3DView, null);
            this.jPanel8.add((Component)this.jButton_3D2DView, null);
            this.jPanel8.add((Component)this.jButton_ResetView, null);
            this.jButton_ResetView.addActionListener(this);
            this.jPanelFor3D.add((Component)this.shapesize_slider, "South");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PcaFrame.this.createNew3DPanel();
                    PcaFrame.this.jSplitPane3.add((Component)PcaFrame.this.jPanel_3D, "left");
                    PcaFrame.this.jSplitPane3.add((Component)PcaFrame.this.jPanelFor3D, "right");
                    PcaFrame.this.jSplitPane3.setDividerLocation(0.5);
                }
            });
            this.jTabPane_2D3D.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    JTabbedPane pane = (JTabbedPane)evt.getSource();
                    int sel = pane.getSelectedIndex();
                    PcaFrame.this.m_b3D = sel == 1;
                }
            });
            this.jButton_2D3DView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PcaFrame.this.jTabPane_2D3D.setSelectedIndex(1);
                }
            });
            this.jButton_3D2DView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PcaFrame.this.jTabPane_2D3D.setSelectedIndex(0);
                }
            });
        }
        this.createTables();
        this.jRelativeVariance = new JPanelRelativeVariance();
        if (this.jTable_V != null) {
            this.jLoadingPane.getViewport().add((Component)this.jTable_V, null);
        }
        this.jScorePane.getViewport().add((Component)this.jTable_U, null);
        this.jEigenValue.getViewport().add((Component)this.jTable_S, null);
        this.m_xIndex = 0;
        this.m_yIndex = 1;
        this.m_zIndex = 2;
        int comps = this.pcaResults.getEigenValues().length;
        if (comps == 0) {
            ClUtils.ErrorMessage("No components exception");
        }
        if (this.m_xIndex > comps - 1) {
            this.m_xIndex = comps - 1;
        }
        if (this.m_yIndex > comps - 1) {
            this.m_yIndex = comps - 1;
        }
        if (this.m_zIndex > comps - 1) {
            this.m_zIndex = comps - 1;
        }
        int i = 0;
        while (i < comps) {
            this.jComboBox_X.addItem("PC " + (i + 1));
            this.jComboBox_Y.addItem("PC " + (i + 1));
            this.jComboBox_X3.addItem("PC " + (i + 1));
            this.jComboBox_Y3.addItem("PC " + (i + 1));
            this.jComboBox_Z3.addItem("PC " + (i + 1));
            ++i;
        }
        this.jComboBox_X.setSelectedIndex(this.m_xIndex);
        this.jComboBox_X.setActionCommand(COMPONENTX);
        this.jComboBox_X.addActionListener(this);
        this.jComboBox_Y.setActionCommand(COMPONENTY);
        this.jComboBox_Y.addActionListener(this);
        this.jComboBox_Y.setSelectedIndex(this.m_yIndex);
        this.jComboBox_X3.setSelectedIndex(this.m_xIndex);
        this.jComboBox_X3.setActionCommand(COMPONENTX);
        this.jComboBox_X3.addActionListener(this);
        this.jComboBox_Y3.setActionCommand(COMPONENTY);
        this.jComboBox_Y3.addActionListener(this);
        this.jComboBox_Y3.setSelectedIndex(this.m_yIndex);
        this.jComboBox_Z3.setActionCommand(COMPONENTZ);
        this.jComboBox_Z3.addActionListener(this);
        this.jComboBox_Z3.setSelectedIndex(this.m_zIndex);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.setSizeLocation();
        this.jSplitPane1.setDividerLocation(0.618);
        this.jSplitPane2.setDividerLocation(0.5);
        this.jPopupMenu.add(this.jMenuSave);
        this.jUTablePopupMenu.add(this.jDoSearch);
        this.jUTablePopupMenu.add(this.jDoCopy);
        this.jUTablePopupMenu.add(this.jUTSave);
        this.jUTablePopupMenu.add(this.jChangeColor);
        this.jTabPanel.add(RELATIVEVARIANCE, this.jRelativeVariance);
        this.jTabPanel.add(SCOREMATRIX, this.jScorePane);
        this.jTabPanel.add(SINGULARMATRIX, this.jEigenValue);
        this.jSampleInfoPopupMenu.add(this.jSearchInColum);
        this.jSampleInfoPopupMenu.add(this.jColorByLabelGroup);
        this.jSampleInfoPopupMenu.add(this.jChangeColorSampleInfo);
        this.jSampleInfoPopupMenu.add(this.jSaveSampleInfo);
        this.jSampleInfoPopupMenu.add(this.jCopySampleInfo);
        this.jSearchInColum.addActionListener(this);
        this.jColorByLabelGroup.addActionListener(this);
        this.jChangeColorSampleInfo.addActionListener(this);
        this.jSaveSampleInfo.addActionListener(this);
        this.jCopySampleInfo.addActionListener(this);
        if (this.jLoadingPane != null) {
            this.jTabPanel.add(LOADINGMATRIX, this.jLoadingPane);
        }
        this.jMenuSave.addActionListener(this);
        this.jUTSave.addActionListener(this);
        this.jChangeColor.addActionListener(this);
        this.jDoSearch.addActionListener(this);
        this.jDoCopy.addActionListener(this);
    }

    public void createNew3DPanel() {
        try {
            if (this.jPanel_3D == null) {
                this.jPanel_3D = new PCAPanel3D();
            }
            if (this.jPanel_3D != null) {
                this.jPanel_3D.setSelectedObservations();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean isJ3DInstalled() {
        try {
            new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        }
        catch (Throwable t) {
            System.err.println("Canvas3D creation caused error: " + t + ", disabled 3D");
            return false;
        }
        return true;
    }

    private void createTables() {
        this.jTable_U = new JTable(new MatrixTableModel(this.pcaResults.getScoresMatrix(), this.pcaResults.getObservationLabels(), "PC"));
        this.jTable_U.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
        this.jTable_U.setAutoResizeMode(0);
        this.jTable_U.addMouseListener(new PcaFrame_jTable_U_mouseAdapter(this));
        this.sorter_U = new TableRowSorter<TableModel>(this.jTable_U.getModel());
        this.sorter_U.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORTED) {
                    PcaFrame.this.jTable_U.clearSelection();
                    for (Integer sel : PcaFrame.this.selectedObsIxs) {
                        int vix = PcaFrame.this.sorter_U.convertRowIndexToView(sel);
                        PcaFrame.this.jTable_U.addRowSelectionInterval(vix, vix);
                    }
                }
            }
        });
        this.jTable_U.setRowSorter(this.sorter_U);
        Matrix loading_matrix = this.pcaResults.getLoadingMatrix();
        if (loading_matrix != null) {
            String[] numbered_orig_coords = null;
            String[] orig_coords = this.pcaResults.getOriginalCoordinateNames();
            if (orig_coords != null) {
                numbered_orig_coords = new String[orig_coords.length];
                int i = orig_coords.length - 1;
                while (i >= 0) {
                    numbered_orig_coords[i] = String.valueOf(orig_coords[i]) + " [" + (i + 1) + "]";
                    --i;
                }
            }
            this.jTable_V = new JTable(new MatrixTableModel(loading_matrix, numbered_orig_coords, "PC"));
            this.jTable_V.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
            this.jTable_V.setAutoResizeMode(0);
            this.jTable_V.addMouseListener(new PcaFrame_jTable_V_mouseAdapter(this));
        }
        int num_evals = this.pcaResults.getEigenValues().length;
        double[] pcts_var = new double[num_evals];
        float sum_evals = 0.0f;
        int i = 0;
        while (i < num_evals) {
            sum_evals = (float)((double)sum_evals + this.pcaResults.getEigenValues()[i]);
            ++i;
        }
        i = 0;
        while (i < num_evals) {
            pcts_var[i] = this.pcaResults.getEigenValues()[i] / (double)sum_evals * 100.0;
            ++i;
        }
        Matrix svals_1xn = new Matrix(new double[][]{this.pcaResults.getEigenValues(), pcts_var});
        this.jTable_S = new JTable(new MatrixTableModel(svals_1xn, new String[]{"Eigenvalue", "% Var"}, "PC"));
        this.jTable_S.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
        this.jTable_S.setAutoResizeMode(0);
        this.jTable_S.addMouseListener(new PcaFrame_jTable_S_mouseAdapter(this));
    }

    public void updateSampleInfoTable(IDataSetGroupsSelectionPanel dsetGrpsSelPnl) {
        TableModel model = dsetGrpsSelPnl.getSampleInfo();
        int cols = model.getColumnCount();
        int rows = model.getRowCount();
        if (cols == 0 || rows == 0) {
            return;
        }
        boolean[] remove = new boolean[cols];
        int i = 0;
        while (i < cols) {
            remove[i] = true;
            int j = 0;
            while (j < rows) {
                if (model.getValueAt(j, i) != null && model.getValueAt(j, i) != "") {
                    remove[i] = false;
                    break;
                }
                ++j;
            }
            ++i;
        }
        int cc = cols;
        int i2 = 0;
        while (i2 < cols) {
            if (remove[i2]) {
                --cc;
            }
            ++i2;
        }
        int kk = 0;
        Object[] cl = new String[cc];
        final ArrayList col_classes = new ArrayList(cols);
        int j = 0;
        while (j < cols) {
            if (!remove[j]) {
                cl[kk++] = model.getColumnName(j);
                col_classes.add(model.getColumnClass(j));
            }
            ++j;
        }
        if (cl.length != cols) {
            Object[][] objs = new Object[rows][cc];
            int i3 = 0;
            while (i3 < rows) {
                kk = 0;
                int j2 = 0;
                while (j2 < cols) {
                    if (!remove[j2]) {
                        objs[i3][kk++] = model.getValueAt(i3, j2);
                    }
                    ++j2;
                }
                ++i3;
            }
            model = new DefaultTableModel(objs, cl){

                @Override
                public Class<?> getColumnClass(int cix) {
                    return (Class)col_classes.get(cix);
                }
            };
        }
        this.jSampleInfoPane = new JScrollPane();
        this.jTabPanel.add(SAMPLEINFO, this.jSampleInfoPane);
        this.jTabPanel.setSelectedComponent(this.jSampleInfoPane);
        this.jTable_SampleInfo = new JTable(model);
        this.jTable_SampleInfo.setAutoResizeMode(0);
        this.sorter_sampleInfo = new TableRowSorter<TableModel>(model);
        this.sorter_sampleInfo.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORTED && PcaFrame.this.jTable_SampleInfo != null) {
                    PcaFrame.this.jTable_SampleInfo.clearSelection();
                    for (Integer sel : PcaFrame.this.selectedObsIxs) {
                        int vix = PcaFrame.this.sorter_sampleInfo.convertRowIndexToView(sel);
                        PcaFrame.this.jTable_SampleInfo.addRowSelectionInterval(vix, vix);
                    }
                }
            }
        });
        this.jTable_SampleInfo.setRowSorter(this.sorter_sampleInfo);
        this.jSampleInfoPane.getViewport().add((Component)this.jTable_SampleInfo, null);
        this.jTable_SampleInfo.getColumnModel().getColumn(0).setCellRenderer(new RowLabelCellRenderer());
        this.jTable_SampleInfo.addMouseListener(new PcaFrame_jTable_SampleInfo_mouseAdapter(this));
    }

    private void setSizeLocation() {
        this.setExtendedState(6);
        Dimension size = this.m_appFrame.desktop.getSize();
        int width = (int)((double)size.width * 0.75);
        int height = (int)((double)width * 0.6);
        Point pt = new Point(0, 0);
        pt.x = AppFrame.m_xOffset * this.m_appFrame.m_wOffset;
        pt.y = AppFrame.m_yOffset * this.m_appFrame.m_wOffset++;
        if (pt.x + width > size.width || pt.y + height > size.height) {
            this.m_appFrame.m_wOffset = 0;
            pt.x = 0;
            pt.y = 0;
        }
        SwingUtilities.convertPointToScreen(pt, this.m_appFrame.desktop);
        this.setSize(width, height);
        this.setLocation(pt);
        this.setVisible(true);
        Dimension ss = this.getMinimumSize();
        if (ss.height != AppFrame.m_yOffset) {
            AppFrame.m_xOffset = AppFrame.m_yOffset = this.getMinimumSize().height;
        }
    }

    private void refreshImage() {
        int num_scores_rows = this.pcaResults.getScoresMatrix().getRowDimension();
        float[] x = new float[num_scores_rows];
        float[] y = new float[num_scores_rows];
        int i = num_scores_rows - 1;
        while (i >= 0) {
            x[i] = (float)this.pcaResults.getScoresMatrix().get(i, this.m_xIndex);
            y[i] = (float)this.pcaResults.getScoresMatrix().get(i, this.m_yIndex);
            --i;
        }
        this.jPanel_2D.resetCoord(x, y, this.pcaResults.getObservationLabels(), this.m_xIndex + 1, this.m_yIndex + 1);
    }

    private void jButtonFont_actionPerformed() {
        FontSelectDlg dlg = new FontSelectDlg("Arial", 0, 12);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.m_fontFamily != null) {
            this.jPanel_2D.m_font = new Font(dlg.m_fontFamily, dlg.m_fontStyle, dlg.m_fontSize);
            this.jPanel_2D.repaint();
        }
    }

    void jTable_U_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 0;
            this.jChangeColor.setEnabled(this.jTable_U.getSelectedRowCount() > 0);
            this.jDoCopy.setEnabled(this.jTable_U.getSelectedRowCount() > 0);
            this.jUTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        } else {
            int[] vix = this.jTable_U.getSelectedRows();
            this.selectedObsIxs.clear();
            int[] nArray = vix;
            int n = vix.length;
            int n2 = 0;
            while (n2 < n) {
                int ix = nArray[n2];
                this.selectedObsIxs.add(this.sorter_U.convertRowIndexToModel(ix));
                ++n2;
            }
            this.setSelection();
        }
    }

    void jTable_SampleInfo_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 3;
            this.jChangeColorSampleInfo.setEnabled(this.jTable_SampleInfo.getSelectedRowCount() > 0);
            this.jCopySampleInfo.setEnabled(this.jTable_SampleInfo.getSelectedRowCount() > 0);
            this.jSampleInfoPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            this.columForSearch = this.jTable_SampleInfo.columnAtPoint(e.getPoint());
        } else {
            int[] vix = this.jTable_SampleInfo.getSelectedRows();
            this.selectedObsIxs.clear();
            int[] nArray = vix;
            int n = vix.length;
            int n2 = 0;
            while (n2 < n) {
                int ix = nArray[n2];
                this.selectedObsIxs.add(this.sorter_sampleInfo.convertRowIndexToModel(ix));
                ++n2;
            }
            this.setSelection();
        }
    }

    void jTable_V_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 1;
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    void jTable_S_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.m_saveIndex = 2;
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        this.m_appFrame.jButton_PCA.setEnabled(false);
        this.m_appFrame.jMenuItem_PCA.setEnabled(false);
        this.m_appFrame.jButton_TransposeTable.setEnabled(false);
    }

    public void this_windowActivated(WindowEvent e) {
        this.setAlwaysOnTop(false);
    }

    public void this_componentResized(ComponentEvent e) {
        float goldenLine = 0.618f;
        this.jSplitPane1.setDividerLocation(goldenLine);
        Dimension size = this.getSize();
        int h = (int)((float)size.height * goldenLine);
        int w = (int)((float)size.width * goldenLine);
        if (h < w) {
            this.jSplitPane2.setDividerLocation(h);
            this.jSplitPane3.setDividerLocation(h);
        } else {
            this.jSplitPane2.setDividerLocation(w);
            this.jSplitPane3.setDividerLocation(w);
        }
    }

    static enum GridStyle {
        NO_GRID,
        CENTRAL_GRID,
        REAR_GRID;

    }

    class JPanelRelativeVariance
    extends JPanel {
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension size = this.getSize();
            g2.setColor(Color.black);
            FontRenderContext frc = g2.getFontRenderContext();
            String xLabel = "PC";
            Font font = g2.getFont();
            TextLayout layout1 = new TextLayout(xLabel, font, frc);
            Rectangle2D rcX = layout1.getBounds();
            String yLabel = "Relative Variance";
            TextLayout layout2 = new TextLayout(xLabel, font, frc);
            Rectangle2D rcY = layout2.getBounds();
            int limitY = (int)(2.0 * rcX.getHeight());
            int limitX = 4 * (int)rcY.getHeight();
            if (size.width < 2 * limitX || size.height < 2 * limitY) {
                return;
            }
            g2.drawLine(limitX, limitY, limitX, size.height - limitY);
            g2.drawLine(limitX, size.height - limitY, size.width - limitX, size.height - limitY);
            g2.drawString(xLabel, (int)((size.getWidth() - rcX.getWidth()) / 2.0), size.height - 5);
            int cols = PcaFrame.this.pcaResults.getEigenValues().length;
            float[] ev = new float[cols];
            float sum = 0.0f;
            int i = 0;
            while (i < cols) {
                ev[i] = (float)PcaFrame.this.pcaResults.getEigenValues()[i];
                sum += ev[i];
                ++i;
            }
            this.setBackground(Color.white);
            float upLimit = 0.0f;
            int i2 = 0;
            while (i2 < cols) {
                if ((upLimit += ev[i2] / sum) >= 0.99f) {
                    cols = i2 + 1;
                    break;
                }
                ++i2;
            }
            int band = (size.width - 2 * limitX) / cols;
            if (band > 2) {
                int h = 0;
                int i3 = 0;
                while (i3 < cols) {
                    h = (int)(ev[i3] * (float)(size.height - 2 * limitY) / ev[0]);
                    float r = ev[i3] / ev[0];
                    Color color = new Color(r, 1.0f - r, 0.0f);
                    g2.setColor(color);
                    g2.fillRect(limitX + i3 * band + band / 2, size.height - limitY - h, band / 2, h);
                    ++i3;
                }
            }
            int x = (int)rcY.getHeight();
            int y = (int)((double)(size.height / 2) + rcY.getWidth() / 2.0);
            g2.setColor(Color.black);
            g2.translate(x, y);
            g2.rotate(-1.5707963267948966);
            g2.drawString(yLabel, 0, 0);
            g2.rotate(1.5707963267948966);
            g2.translate(-x, -y);
            g2.drawLine(limitX, limitY, limitX + 4, limitY);
            int delt = (size.height - 2 * limitY) / 3;
            g2.drawLine(limitX, limitY + delt, limitX + 4, limitY + delt);
            g2.drawLine(limitX, limitY + delt * 2, limitX + 4, limitY + delt * 2);
            String[] bs = new String[4];
            DecimalFormat format = new DecimalFormat("0.##");
            float initV = ev[0] / sum;
            int i4 = 0;
            while (i4 < bs.length) {
                bs[i4] = format.format(initV - initV / 3.0f * (float)i4);
                bs[3] = "0";
                TextLayout layout = new TextLayout(bs[i4], font, frc);
                Rectangle2D rc = layout.getBounds();
                g2.drawString(bs[i4], (int)((double)limitX - rc.getWidth() - 1.0), (int)((double)(limitY + i4 * delt) + rc.getHeight() / 2.0));
                ++i4;
            }
        }
    }

    static enum ObsDisplayStyle {
        SYMBOL,
        TEXT;

    }

    class PCAPanel3D
    extends JPanel
    implements ActionListener {
        FlatField obsIxToScores;
        List<java.util.Set<String>> obsGrpsMbrNames;
        Map<Integer, Color> userColorsByObsIx;
        Map<Integer, VisADGeometryArray> userShapesByObsIx;
        final int numPCs = 3;
        int numObs = 0;
        DisplayImpl display3D;
        PickManipulationRendererJ3D pickManipRen;
        RealType obsIxType;
        RealTupleType obsScoresType;
        RealType pcXType;
        RealType pcYType;
        RealType pcZType;
        List<ScalarMap> pcScalarMaps;
        ScalarMap shapeMap;
        ScalarMap labelShapeMap;
        ScalarMap colorMap;
        ConstantMap[] gridLinesConstantMaps;
        ConstantMap[] axesLinesConstantMaps;
        DataReference mainDataRef;
        DataReference gridLinesDataRef;
        DataReference axesLinesDataRef;
        DataReference selectionHilightsDataRef;
        ObsDisplayStyle obsDisplayStyle;
        List<ShapeChoice> availableShapes;
        JPopupMenu popupMenu;
        private JMenuItem spotColorChooserMenuItem;
        private JMenuItem spotShapeMenuItem;
        private JMenuItem clearSpotSelectionsMenuItem;
        private JMenuItem showSpotLabelMenuItem;
        Color selectionColor = Color.BLACK;

        public PCAPanel3D() throws VisADException, RemoteException {
            this.setToolTipText("");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            super.setLayout(new BorderLayout());
            GraphicsDevice[] screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsConfiguration gcfg = null;
            int i = 0;
            while (i < screens.length) {
                if (screens[i].getDefaultConfiguration().getBounds().contains(PcaFrame.this.m_pcaFrame.getBounds().getCenterX(), PcaFrame.this.m_pcaFrame.getBounds().getCenterY())) {
                    gcfg = screens[i].getBestConfiguration((GraphicsConfigTemplate)new GraphicsConfigTemplate3D());
                    break;
                }
                ++i;
            }
            this.display3D = new DisplayImplJ3D("PCA_3D", gcfg);
            this.userColorsByObsIx = new HashMap<Integer, Color>();
            this.userShapesByObsIx = new HashMap<Integer, VisADGeometryArray>();
            if (PcaFrame.this.jPanel_2D.m_color != null) {
                i = 0;
                while (i < PcaFrame.this.jPanel_2D.m_color.length) {
                    if (PcaFrame.this.jPanel_2D.m_color[i] != null) {
                        this.userColorsByObsIx.put(new Integer(i), PcaFrame.this.jPanel_2D.m_color[i]);
                    }
                    ++i;
                }
            }
            List<String> obs_names = Arrays.asList(PcaFrame.this.pcaResults.getObservationLabels());
            this.numObs = obs_names.size();
            this.obsIxType = RealType.getRealType((String)"obsIndex");
            this.pcXType = RealType.getRealType((String)"X");
            this.pcYType = RealType.getRealType((String)"Y");
            this.pcZType = RealType.getRealType((String)"Z");
            this.obsScoresType = new RealTupleType(this.pcXType, this.pcYType, this.pcZType);
            this.obsIxToScores = new FlatField(new FunctionType((MathType)this.obsIxType, (MathType)this.obsScoresType), (Set)new Integer1DSet((MathType)this.obsIxType, this.numObs));
            this.pcScalarMaps = new ArrayList<ScalarMap>(3);
            this.pcScalarMaps.add(new ScalarMap((ScalarType)this.pcXType, Display.XAxis));
            this.pcScalarMaps.add(new ScalarMap((ScalarType)this.pcYType, Display.YAxis));
            this.pcScalarMaps.add(new ScalarMap((ScalarType)this.pcZType, Display.ZAxis));
            for (ScalarMap pc_smap : this.pcScalarMaps) {
                this.display3D.addMap(pc_smap);
                pc_smap.getAxisScale().setSnapToBox(true);
                pc_smap.getAxisScale().setLabelAllTicks(true);
                pc_smap.getAxisScale().setLabelSize(14);
            }
            this.gridLinesDataRef = new DataReferenceImpl("grid_lines_data_ref");
            double grid = 0.55;
            this.gridLinesConstantMaps = new ConstantMap[]{new ConstantMap(grid, Display.Red), new ConstantMap(grid, Display.Green), new ConstantMap(grid, Display.Blue)};
            this.display3D.addReference(this.gridLinesDataRef, this.gridLinesConstantMaps);
            this.axesLinesDataRef = new DataReferenceImpl("axes_lines_data_ref");
            this.axesLinesConstantMaps = new ConstantMap[]{new ConstantMap(0.5, Display.Red), new ConstantMap(0.5, Display.Green), new ConstantMap(1.0, Display.Blue)};
            this.display3D.addReference(this.axesLinesDataRef, this.axesLinesConstantMaps);
            this.initSamples(PcaFrame.this.m_xIndex, PcaFrame.this.m_yIndex, PcaFrame.this.m_zIndex);
            if (PcaFrame.this.grpColNames != null) {
                ArrayList<java.util.Set<String>> member_names_for_grps = new ArrayList<java.util.Set<String>>();
                List<String>[] listArray = PcaFrame.this.grpColNames;
                int n = PcaFrame.this.grpColNames.length;
                int n2 = 0;
                while (n2 < n) {
                    List<String> mbr_names = listArray[n2];
                    member_names_for_grps.add(new HashSet<String>(mbr_names));
                    ++n2;
                }
                this.setObservationGroupMemberships(member_names_for_grps);
            }
            this.availableShapes = this.createShapes();
            this.obsDisplayStyle = ObsDisplayStyle.SYMBOL;
            this.shapeMap = new ScalarMap((ScalarType)this.obsIxType, Display.Shape);
            this.labelShapeMap = new ScalarMap((ScalarType)this.obsIxType, Display.Shape);
            this.display3D.addMap(this.shapeMap);
            this.display3D.addMap(this.labelShapeMap);
            this.setShapeMap(this.userShapesByObsIx);
            this.setColorMap(this.obsGrpsMbrNames, this.userColorsByObsIx);
            this.mainDataRef = new DataReferenceImpl("main_data_ref");
            this.mainDataRef.setData((Data)this.obsIxToScores);
            this.pickManipRen = new PickManipulationRendererJ3D();
            this.display3D.addReferences((DataRenderer)this.pickManipRen, this.mainDataRef);
            this.pickManipRen.suppressExceptions(true);
            this.display3D.getGraphicsModeControl().setScaleEnable(true);
            this.display3D.getGraphicsModeControl().setProjectionPolicy(1);
            this.display3D.getDisplayRenderer().setBackgroundColor(Color.WHITE);
            this.display3D.getDisplayRenderer().setForegroundColor(Color.BLACK);
            this.display3D.getDisplayRenderer().setBoxColor(Color.black);
            this.display3D.addDisplayListener(this.createSpotSelectionDisplayListener());
            this.add(this.display3D.getComponent(), "Center");
            this.popupMenu = this.createPopupMenu();
            this.enableDisableMenuItems();
        }

        private void initSamples(int pcX, int pcY, int pcZ) throws VisADException, RemoteException {
            double first_score;
            double[][] scores_min_max = new double[3][2];
            double d = first_score = this.numObs > 0 ? PcaFrame.this.pcaResults.getScoresMatrix().get(0, pcX) : Double.NaN;
            scores_min_max[0][1] = d;
            scores_min_max[0][0] = d;
            double d2 = first_score = this.numObs > 0 ? PcaFrame.this.pcaResults.getScoresMatrix().get(0, pcY) : Double.NaN;
            scores_min_max[1][1] = d2;
            scores_min_max[1][0] = d2;
            double d3 = first_score = this.numObs > 0 ? PcaFrame.this.pcaResults.getScoresMatrix().get(0, pcZ) : Double.NaN;
            scores_min_max[2][1] = d3;
            scores_min_max[2][0] = d3;
            double[][] scores = new double[3][this.numObs];
            int obs_ix = 0;
            while (obs_ix < this.numObs) {
                scores[0][obs_ix] = PcaFrame.this.pcaResults.getScoresMatrix().get(obs_ix, pcX);
                scores[1][obs_ix] = PcaFrame.this.pcaResults.getScoresMatrix().get(obs_ix, pcY);
                scores[2][obs_ix] = PcaFrame.this.pcaResults.getScoresMatrix().get(obs_ix, pcZ);
                int pc_ix = 2;
                while (pc_ix >= 0) {
                    if (scores[pc_ix][obs_ix] < scores_min_max[pc_ix][0]) {
                        scores_min_max[pc_ix][0] = scores[pc_ix][obs_ix];
                    } else if (scores[pc_ix][obs_ix] > scores_min_max[pc_ix][1]) {
                        scores_min_max[pc_ix][1] = scores[pc_ix][obs_ix];
                    }
                    --pc_ix;
                }
                ++obs_ix;
            }
            this.obsIxToScores.setSamples(scores);
            int pc_ix = 2;
            while (pc_ix >= 0) {
                double[] range = this.rangeFromMinMax(scores_min_max[pc_ix]);
                this.pcScalarMaps.get(pc_ix).setRange(range[0], range[1]);
                --pc_ix;
            }
            DecimalFormat format = new DecimalFormat("0.###");
            double[] percent_eigen = PcaFrame.this.getPercentEigen();
            this.pcScalarMaps.get(0).setScalarName("PC" + (pcX + 1) + "(" + format.format(percent_eigen[pcX]) + ")");
            this.pcScalarMaps.get(1).setScalarName("PC" + (pcY + 1) + "(" + format.format(percent_eigen[pcY]) + ")");
            this.pcScalarMaps.get(2).setScalarName("PC" + (pcZ + 1) + "(" + format.format(percent_eigen[pcZ]) + ")");
            this.gridLinesDataRef.setData((Data)this.createGridLines(DEFAULT_GRID_STYLE));
            this.axesLinesDataRef.setData((Data)this.createAxesLines());
        }

        public List<ShapeChoice> createShapes() {
            VisADQuadArray cube = new VisADQuadArray();
            cube.coordinates = new float[]{0.1f, 0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, -0.1f, 0.1f, 0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, -0.1f, 0.1f, -0.1f, -0.1f, 0.1f, 0.1f, -0.1f, 0.1f};
            cube.vertexCount = cube.coordinates.length / 3;
            cube.normals = new float[144];
            int i = 0;
            while (i < 24) {
                cube.normals[i] = 0.0f;
                cube.normals[i + 1] = 0.0f;
                cube.normals[i + 2] = -1.0f;
                cube.normals[i + 24] = 0.0f;
                cube.normals[i + 25] = 0.0f;
                cube.normals[i + 26] = 1.0f;
                cube.normals[i + 48] = 1.0f;
                cube.normals[i + 49] = 0.0f;
                cube.normals[i + 50] = 0.0f;
                cube.normals[i + 72] = -1.0f;
                cube.normals[i + 73] = 0.0f;
                cube.normals[i + 74] = 0.0f;
                cube.normals[i + 96] = 0.0f;
                cube.normals[i + 97] = 1.0f;
                cube.normals[i + 98] = 0.0f;
                cube.normals[i + 120] = 0.0f;
                cube.normals[i + 121] = -1.0f;
                cube.normals[i + 122] = 0.0f;
                i += 3;
            }
            VisADTriangleStripArray sphere_visad = new VisADTriangleStripArray();
            Sphere sphere_j3d = new Sphere(0.1f, new Appearance());
            TriangleStripArray geom_j3d = (TriangleStripArray)sphere_j3d.getShape().getGeometry();
            sphere_visad.vertexCount = geom_j3d.getVertexCount();
            sphere_visad.coordinates = new float[3 * geom_j3d.getVertexCount()];
            geom_j3d.getCoordinates(0, sphere_visad.coordinates);
            sphere_visad.normals = new float[3 * geom_j3d.getVertexCount()];
            geom_j3d.getNormals(0, sphere_visad.normals);
            sphere_visad.vertexFormat = geom_j3d.getVertexFormat();
            sphere_visad.stripVertexCounts = new int[geom_j3d.getNumStrips()];
            geom_j3d.getStripVertexCounts(sphere_visad.stripVertexCounts);
            ArrayList<ShapeChoice> shapes = new ArrayList<ShapeChoice>();
            shapes.add(new ShapeChoice("Sphere", (VisADGeometryArray)sphere_visad));
            shapes.add(new ShapeChoice("Cube", (VisADGeometryArray)cube));
            return shapes;
        }

        protected void lebalStateChange() {
            try {
                this.setShapeMap(this.userShapesByObsIx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void resetShapeMap(ShapeControl shape_control, ObsDisplayStyle obs_display_style, Map<Integer, VisADGeometryArray> user_shapes_by_obs_ix) throws VisADException, RemoteException {
            int num_obs = this.obsIxToScores.getDomainSet().getLength();
            float[][] obs_ixs = new float[1][num_obs];
            int i = 0;
            while (i < num_obs) {
                obs_ixs[0][i] = i;
                ++i;
            }
            shape_control.setShapeSet((SimpleSet)new Gridded1DSet((MathType)this.obsIxType, obs_ixs, num_obs));
            int obs_ix = 0;
            while (obs_ix < num_obs) {
                if (obs_display_style == ObsDisplayStyle.SYMBOL) {
                    VisADGeometryArray user_shape = user_shapes_by_obs_ix != null ? user_shapes_by_obs_ix.get(obs_ix) : null;
                    VisADGeometryArray shape = user_shape != null ? user_shape : this.availableShapes.get(0).getGeometryArray();
                    shape_control.setShape(obs_ix, shape);
                } else if (PcaFrame.this.jPanel_2D.m_point[obs_ix].isLabeled()) {
                    String obs_name = PcaFrame.this.pcaResults.getObservationLabels()[obs_ix];
                    double[] start = new double[]{0.0, 0.0, 0.0};
                    double[] base = new double[]{0.1, 0.0, 0.0};
                    double[] up = new double[]{0.0, 0.1, 0.0};
                    VisADLineArray obs_txt = PlotText.render_label((String)("<-" + obs_name), (double[])start, (double[])base, (double[])up, (TextControl.Justification)TextControl.Justification.LEFT, (TextControl.Justification)TextControl.Justification.CENTER);
                    shape_control.setShape(obs_ix, (VisADGeometryArray)obs_txt);
                } else {
                    shape_control.setShape(obs_ix, null);
                }
                ++obs_ix;
            }
            shape_control.setScale(PcaFrame.this.scale_factor);
        }

        protected void setShapeMap(Map<Integer, VisADGeometryArray> user_shapes_by_obs_ix) throws VisADException, RemoteException {
            this.resetShapeMap((ShapeControl)this.labelShapeMap.getControl(), ObsDisplayStyle.TEXT, user_shapes_by_obs_ix);
            this.resetShapeMap((ShapeControl)this.shapeMap.getControl(), ObsDisplayStyle.SYMBOL, user_shapes_by_obs_ix);
        }

        protected void setColorMap(List<java.util.Set<String>> obs_grps_mbr_names, Map<Integer, Color> user_colors_by_obs_ix) throws VisADException, RemoteException {
            if (this.colorMap != null) {
                this.display3D.removeMap(this.colorMap);
            }
            this.colorMap = new ScalarMap((ScalarType)this.obsIxType, Display.RGB);
            this.display3D.addMap(this.colorMap);
            ColorControl cctl = (ColorControl)this.colorMap.getControl();
            int num_grps = obs_grps_mbr_names != null ? obs_grps_mbr_names.size() : 0;
            int num_obs = this.obsIxToScores.getDomainSet().getLength();
            int num_color_comps = 3;
            float[][] grp_colors = obs_grps_mbr_names != null ? PcaFrame.this.initColorComponents(num_grps, num_color_comps) : null;
            float[][] obs_colors = new float[num_color_comps][num_obs];
            float[] default_color_comps = PcaFrame.this.defaultColor.getRGBColorComponents(null);
            int obs_ix = 0;
            while (obs_ix < num_obs) {
                int obs_ix_ = new Integer(obs_ix);
                Color user_color = user_colors_by_obs_ix.get(obs_ix_);
                if (user_color != null) {
                    float[] color_comps = user_color.getRGBColorComponents(null);
                    int comp_ix = 0;
                    while (comp_ix < num_color_comps) {
                        obs_colors[comp_ix][obs_ix] = color_comps[comp_ix];
                        ++comp_ix;
                    }
                } else {
                    int comp_ix = 0;
                    while (comp_ix < num_color_comps) {
                        obs_colors[comp_ix][obs_ix] = default_color_comps[comp_ix];
                        ++comp_ix;
                    }
                    if (obs_grps_mbr_names != null) {
                        String obs_name = PcaFrame.this.pcaResults.getObservationLabels()[obs_ix];
                        int grp_ix = 0;
                        while (grp_ix < num_grps) {
                            if (obs_grps_mbr_names.get(grp_ix).contains(obs_name)) {
                                int comp_ix2 = 0;
                                while (comp_ix2 < num_color_comps) {
                                    obs_colors[comp_ix2][obs_ix] = grp_colors[comp_ix2][grp_ix];
                                    ++comp_ix2;
                                }
                                break;
                            }
                            ++grp_ix;
                        }
                    }
                }
                ++obs_ix;
            }
            cctl.setTable(obs_colors);
        }

        protected Set createGridLines(GridStyle grid_style) throws VisADException {
            if (grid_style == GridStyle.NO_GRID) {
                return null;
            }
            ArrayList<Gridded3DSet> line_sets = new ArrayList<Gridded3DSet>();
            int axis1_ix = 0;
            while (axis1_ix < 3) {
                int axis2_ix = 0;
                while (axis2_ix < 3) {
                    if (axis1_ix != axis2_ix) {
                        for (Object d : this.pcScalarMaps.get(axis1_ix).getAxisScale().getLabelTable().keySet()) {
                            float[][] end_points = new float[3][2];
                            end_points[axis1_ix][0] = ((Double)d).floatValue();
                            end_points[axis1_ix][1] = ((Double)d).floatValue();
                            end_points[axis2_ix][0] = (float)this.pcScalarMaps.get(axis2_ix).getRange()[0];
                            end_points[axis2_ix][1] = (float)this.pcScalarMaps.get(axis2_ix).getRange()[1];
                            int other_axis_ix = 0;
                            while (other_axis_ix < 3) {
                                if (other_axis_ix != axis1_ix && other_axis_ix != axis2_ix) {
                                    if (grid_style == GridStyle.REAR_GRID) {
                                        end_points[other_axis_ix][0] = (float)this.pcScalarMaps.get(other_axis_ix).getRange()[0];
                                        end_points[other_axis_ix][1] = (float)this.pcScalarMaps.get(other_axis_ix).getRange()[0];
                                        break;
                                    }
                                    end_points[other_axis_ix][0] = 0.0f;
                                    end_points[other_axis_ix][1] = 0.0f;
                                    break;
                                }
                                ++other_axis_ix;
                            }
                            line_sets.add(new Gridded3DSet((MathType)this.obsScoresType, end_points, 2));
                        }
                    }
                    ++axis2_ix;
                }
                ++axis1_ix;
            }
            return new UnionSet((MathType)this.obsScoresType, (SampledSet[])line_sets.toArray(new Gridded3DSet[line_sets.size()]));
        }

        protected Set createAxesLines() throws VisADException {
            ArrayList<Gridded3DSet> line_sets = new ArrayList<Gridded3DSet>();
            int axis_ix = 0;
            while (axis_ix < 3) {
                float[][] end_points = new float[3][2];
                int i = 0;
                while (i < 3) {
                    if (i == axis_ix) {
                        end_points[i][0] = 0.0f;
                        end_points[i][1] = (float)this.pcScalarMaps.get(axis_ix).getRange()[1];
                    } else {
                        end_points[i][0] = 0.0f;
                        end_points[i][1] = 0.0f;
                    }
                    ++i;
                }
                line_sets.add(new Gridded3DSet((MathType)this.obsScoresType, end_points, 2));
                ++axis_ix;
            }
            return new UnionSet((MathType)this.obsScoresType, (SampledSet[])line_sets.toArray(new Gridded3DSet[line_sets.size()]));
        }

        protected Set createSelectionHilights() throws VisADException, RemoteException {
            ArrayList<Gridded3DSet> line_sets = new ArrayList<Gridded3DSet>();
            for (int obs_ix : PcaFrame.this.selectedObsIxs) {
                double[] line_len = new double[3];
                int axis_ix = 0;
                while (axis_ix < 3) {
                    double[] axis_min_max = this.pcScalarMaps.get(axis_ix).getRange();
                    line_len[axis_ix] = (double)PcaFrame.this.scale_factor * 0.08 * (axis_min_max[1] - axis_min_max[0]);
                    ++axis_ix;
                }
                float[][] end_points = new float[3][2];
                Real[] tup_comps = ((Tuple)this.obsIxToScores.getSample(obs_ix)).getRealComponents();
                int steps = 2;
                int axis1_ix = 0;
                while (axis1_ix < 3) {
                    int axis2_ix = 0;
                    while (axis2_ix < 3) {
                        if (axis1_ix != axis2_ix) {
                            int i = 0;
                            while (i < steps) {
                                double angle = (double)i * (Math.PI / (double)steps);
                                double cos = Math.cos(angle);
                                double sin = Math.sin(angle);
                                end_points[axis1_ix][0] = (float)(tup_comps[axis1_ix].getValue() - line_len[axis1_ix] * cos);
                                end_points[axis1_ix][1] = (float)(tup_comps[axis1_ix].getValue() + line_len[axis1_ix] * cos);
                                end_points[axis2_ix][0] = (float)(tup_comps[axis2_ix].getValue() - line_len[axis2_ix] * sin);
                                end_points[axis2_ix][1] = (float)(tup_comps[axis2_ix].getValue() + line_len[axis2_ix] * sin);
                                int other_ix = 0;
                                while (other_ix < 3) {
                                    if (other_ix != axis1_ix && other_ix != axis2_ix) {
                                        float f = (float)tup_comps[other_ix].getValue();
                                        end_points[other_ix][1] = f;
                                        end_points[other_ix][0] = f;
                                    }
                                    ++other_ix;
                                }
                                line_sets.add(new Gridded3DSet((MathType)this.obsScoresType, end_points, 2));
                                ++i;
                            }
                        }
                        ++axis2_ix;
                    }
                    ++axis1_ix;
                }
            }
            return line_sets.size() > 0 ? new UnionSet((MathType)this.obsScoresType, (SampledSet[])line_sets.toArray(new Gridded3DSet[line_sets.size()])) : null;
        }

        protected DisplayListener createSpotSelectionDisplayListener() {
            return new DisplayListener(){

                public void displayChanged(DisplayEvent de) {
                    if (de.getId() == 5) {
                        VisADRay direct_ray = PCAPanel3D.this.display3D.getDisplayRenderer().getMouseBehavior().findRay(de.getX(), de.getY());
                        float dist = PCAPanel3D.this.pickManipRen.checkClose(direct_ray.position, direct_ray.vector);
                        if (dist < PCAPanel3D.this.display3D.getDisplayRenderer().getPickThreshhold()) {
                            Integer close_obs_ix = new Integer(PCAPanel3D.this.pickManipRen.getCloseIndex());
                            if ((de.getModifiers() & 2) == 0) {
                                ((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.selectedObsIxs.clear();
                            }
                            if (close_obs_ix != -1) {
                                if (((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.selectedObsIxs.contains(close_obs_ix)) {
                                    ((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.selectedObsIxs.remove(close_obs_ix);
                                } else {
                                    ((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.selectedObsIxs.add(close_obs_ix);
                                }
                            }
                            PcaFrame.this.setSelection();
                        }
                    }
                    if (de.getId() == 6) {
                        PCAPanel3D.this.popupMenu.show(PCAPanel3D.this.display3D.getComponent(), de.getX(), de.getY());
                    }
                }
            };
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            JPopupMenu popup = new JPopupMenu();
            popup.setDoubleBuffered(false);
            this.spotColorChooserMenuItem = new JMenuItem("Choose New Color");
            this.spotColorChooserMenuItem.setActionCommand(PcaFrame.CHOOSE_OBS_COLOR_CMD);
            this.spotColorChooserMenuItem.addActionListener(this);
            popup.add(this.spotColorChooserMenuItem);
            this.spotShapeMenuItem = new JMenuItem("Choose New Shape");
            this.spotShapeMenuItem.setActionCommand(PcaFrame.CHOOSE_OBS_SHAPE_CMD);
            this.spotShapeMenuItem.addActionListener(this);
            popup.add(this.spotShapeMenuItem);
            this.showSpotLabelMenuItem = new JMenuItem(PcaFrame.SHOW_SPOT_LABEL_CMD);
            this.showSpotLabelMenuItem.setActionCommand(PcaFrame.SHOW_SPOT_LABEL_CMD);
            this.showSpotLabelMenuItem.addActionListener(this);
            popup.add(this.showSpotLabelMenuItem);
            this.clearSpotSelectionsMenuItem = new JMenuItem("Clear Selections");
            this.clearSpotSelectionsMenuItem.setActionCommand(PcaFrame.CLEAR_SELECTIONS_CMD);
            this.clearSpotSelectionsMenuItem.addActionListener(this);
            popup.add(this.clearSpotSelectionsMenuItem);
            JMenuItem sel_all_mi = new JMenuItem(PcaFrame.SELECT_ALL_CMD);
            sel_all_mi.setActionCommand(PcaFrame.SELECT_ALL_CMD);
            sel_all_mi.addActionListener(this);
            popup.add(sel_all_mi);
            JMenu viewpoint_menu = new JMenu("Viewpoint");
            popup.add(viewpoint_menu);
            JMenuItem pc1_vs_pc2_mi = new JMenuItem(PcaFrame.PC2_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc2_mi.setActionCommand(PcaFrame.PC2_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc2_mi.addActionListener(this);
            viewpoint_menu.add(pc1_vs_pc2_mi);
            JMenuItem pc2_vs_pc3_mi = new JMenuItem(PcaFrame.PC3_VS_PC2_VIEWPOINT_CMD);
            pc2_vs_pc3_mi.setActionCommand(PcaFrame.PC3_VS_PC2_VIEWPOINT_CMD);
            pc2_vs_pc3_mi.addActionListener(this);
            viewpoint_menu.add(pc2_vs_pc3_mi);
            JMenuItem pc1_vs_pc3_mi = new JMenuItem(PcaFrame.PC3_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc3_mi.setActionCommand(PcaFrame.PC3_VS_PC1_VIEWPOINT_CMD);
            pc1_vs_pc3_mi.addActionListener(this);
            viewpoint_menu.add(pc1_vs_pc3_mi);
            JMenu axes_menu = new JMenu("Axes");
            popup.add(axes_menu);
            popup.addSeparator();
            JCheckBoxMenuItem reverse_pc1_check = new JCheckBoxMenuItem("Reverse X");
            reverse_pc1_check.setActionCommand(PcaFrame.TOGGLE_REVERSE_PC1_CMD);
            reverse_pc1_check.addActionListener(this);
            axes_menu.add(reverse_pc1_check);
            JCheckBoxMenuItem reverse_pc2_check = new JCheckBoxMenuItem("Reverse Y");
            reverse_pc2_check.setActionCommand(PcaFrame.TOGGLE_REVERSE_PC2_CMD);
            reverse_pc2_check.addActionListener(this);
            axes_menu.add(reverse_pc2_check);
            JCheckBoxMenuItem reverse_pc3_check = new JCheckBoxMenuItem("Reverse Z");
            reverse_pc3_check.setActionCommand(PcaFrame.TOGGLE_REVERSE_PC3_CMD);
            reverse_pc3_check.addActionListener(this);
            axes_menu.add(reverse_pc3_check);
            axes_menu.addSeparator();
            JCheckBoxMenuItem axes_lines_check = new JCheckBoxMenuItem("Show Central Axes Lines (blue)");
            axes_lines_check.setSelected(true);
            axes_lines_check.setActionCommand(PcaFrame.TOGGLE_CENTRAL_AXES_LINES_CMD);
            axes_lines_check.addActionListener(this);
            axes_menu.add(axes_lines_check);
            axes_menu.addSeparator();
            JRadioButtonMenuItem rear_grid_btn = new JRadioButtonMenuItem(PcaFrame.REAR_GRID_CMD);
            rear_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.REAR_GRID);
            rear_grid_btn.setActionCommand(PcaFrame.REAR_GRID_CMD);
            rear_grid_btn.addActionListener(this);
            axes_menu.add(rear_grid_btn);
            JRadioButtonMenuItem central_grid_btn = new JRadioButtonMenuItem(PcaFrame.CENTRAL_GRID_CMD);
            central_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.CENTRAL_GRID);
            central_grid_btn.setActionCommand(PcaFrame.CENTRAL_GRID_CMD);
            central_grid_btn.addActionListener(this);
            axes_menu.add(central_grid_btn);
            JRadioButtonMenuItem no_grid_btn = new JRadioButtonMenuItem(PcaFrame.NO_GRID_CMD);
            no_grid_btn.setSelected(DEFAULT_GRID_STYLE == GridStyle.NO_GRID);
            no_grid_btn.setActionCommand(PcaFrame.NO_GRID_CMD);
            no_grid_btn.addActionListener(this);
            axes_menu.add(no_grid_btn);
            axes_menu.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            bg.add(rear_grid_btn);
            bg.add(central_grid_btn);
            bg.add(no_grid_btn);
            JMenuItem save_img_mi = new JMenuItem("Save as Image");
            save_img_mi.setActionCommand(PcaFrame.SAVE_3D_IMG_CMD);
            save_img_mi.addActionListener(this);
            popup.add(save_img_mi);
            JMenuItem save_img_high = new JMenuItem("Save As High Resolution Image (tiff)");
            save_img_high.addActionListener(this);
            popup.add(save_img_high);
            return popup;
        }

        public void setObservationGroupMemberships(List<java.util.Set<String>> grps_mbr_names) throws VisADException, RemoteException {
            this.obsGrpsMbrNames = grps_mbr_names;
            this.setColorMap(this.obsGrpsMbrNames, this.userColorsByObsIx);
        }

        public void setSelectedObservations() throws VisADException, RemoteException {
            if (this.selectionHilightsDataRef == null) {
                this.selectionHilightsDataRef = new DataReferenceImpl("sel_hilights_data_ref");
                float[] selection_color_comps = this.selectionColor.getRGBColorComponents(null);
                this.display3D.addReference(this.selectionHilightsDataRef, new ConstantMap[]{new ConstantMap((double)selection_color_comps[0], Display.Red), new ConstantMap((double)selection_color_comps[1], Display.Green), new ConstantMap((double)selection_color_comps[2], Display.Blue), new ConstantMap(2.0, Display.LineWidth)});
            }
            this.selectionHilightsDataRef.setData((Data)this.createSelectionHilights());
            if (PcaFrame.this.selectedObsIxs.size() == 1) {
                int obs_ix = PcaFrame.this.selectedObsIxs.get(0);
                NumberFormat nfmt = NumberFormat.getInstance();
                nfmt.setMaximumFractionDigits(1);
                PcaFrame.this.selObsNameLabel.setText(PcaFrame.this.pcaResults.getObservationLabels()[obs_ix]);
                StringBuilder scores_buf = new StringBuilder("(");
                int pc_ix = 0;
                while (pc_ix < 3) {
                    if (pc_ix != 0) {
                        scores_buf.append(", ");
                    }
                    double score = PcaFrame.this.pcaResults.getScoresMatrix().get(obs_ix, pc_ix);
                    scores_buf.append(nfmt.format(score));
                    ++pc_ix;
                }
                scores_buf.append(")");
                PcaFrame.this.selObsScoresLabel.setText(scores_buf.toString());
            } else {
                PcaFrame.this.selObsNameLabel.setText(" ");
                PcaFrame.this.selObsScoresLabel.setText(" ");
            }
            this.enableDisableMenuItems();
        }

        protected void enableDisableMenuItems() {
            this.spotColorChooserMenuItem.setEnabled(PcaFrame.this.selectedObsIxs.size() > 0);
            this.spotShapeMenuItem.setEnabled(PcaFrame.this.selectedObsIxs.size() > 0);
            this.clearSpotSelectionsMenuItem.setEnabled(PcaFrame.this.selectedObsIxs.size() > 0);
            this.showSpotLabelMenuItem.setEnabled(PcaFrame.this.selectedObsIxs.size() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            try {
                if (cmd == PcaFrame.PC2_VS_PC1_VIEWPOINT_CMD) {
                    ProjectionControlJ3D pctl = (ProjectionControlJ3D)this.display3D.getProjectionControl();
                    pctl.setOrthoView(4);
                } else if (cmd == PcaFrame.PC3_VS_PC1_VIEWPOINT_CMD) {
                    ProjectionControlJ3D pctl = (ProjectionControlJ3D)this.display3D.getProjectionControl();
                    pctl.setOrthoView(3);
                } else if (cmd == PcaFrame.PC3_VS_PC2_VIEWPOINT_CMD) {
                    ProjectionControlJ3D pctl = (ProjectionControlJ3D)this.display3D.getProjectionControl();
                    pctl.setOrthoView(0);
                } else if (cmd == PcaFrame.TOGGLE_CENTRAL_AXES_LINES_CMD) {
                    boolean display_axes_lines = ((AbstractButton)ae.getSource()).isSelected();
                    if (!display_axes_lines) {
                        this.display3D.removeReference((ThingReference)this.axesLinesDataRef);
                    } else {
                        this.display3D.addReference(this.axesLinesDataRef, this.axesLinesConstantMaps);
                    }
                } else if (cmd == PcaFrame.REAR_GRID_CMD) {
                    this.gridLinesDataRef.setData((Data)this.createGridLines(GridStyle.REAR_GRID));
                } else if (cmd == PcaFrame.CENTRAL_GRID_CMD) {
                    this.gridLinesDataRef.setData((Data)this.createGridLines(GridStyle.CENTRAL_GRID));
                } else if (cmd == PcaFrame.NO_GRID_CMD) {
                    this.gridLinesDataRef.setData(null);
                } else if (cmd == PcaFrame.TOGGLE_REVERSE_PC1_CMD) {
                    double[] min_max = this.pcScalarMaps.get(0).getRange();
                    this.pcScalarMaps.get(0).setRange(min_max[1], min_max[0]);
                } else if (cmd == PcaFrame.TOGGLE_REVERSE_PC2_CMD) {
                    double[] min_max = this.pcScalarMaps.get(1).getRange();
                    this.pcScalarMaps.get(1).setRange(min_max[1], min_max[0]);
                } else if (cmd == PcaFrame.TOGGLE_REVERSE_PC3_CMD) {
                    double[] min_max = this.pcScalarMaps.get(2).getRange();
                    this.pcScalarMaps.get(2).setRange(min_max[1], min_max[0]);
                } else if (cmd == PcaFrame.CHOOSE_OBS_COLOR_CMD) {
                    if (PcaFrame.this.selectedObsIxs.size() > 0) {
                        JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, PcaFrame.this.colorChooser, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.selectedColor = ((PCAPanel3D)PCAPanel3D.this).PcaFrame.this.colorChooser.getColor();
                            }
                        }, null);
                        dialog.setVisible(true);
                        if (PcaFrame.this.selectedColor != null) {
                            this.setObsColor(PcaFrame.this.selectedObsIxs, PcaFrame.this.selectedColor);
                            PcaFrame.this.jPanel_2D.setObsColor(PcaFrame.this.selectedObsIxs, PcaFrame.this.selectedColor);
                        }
                    }
                } else if (cmd == PcaFrame.CHOOSE_OBS_SHAPE_CMD) {
                    ShapeChoice shape_choice;
                    if (PcaFrame.this.selectedObsIxs.size() > 0 && (shape_choice = (ShapeChoice)JOptionPane.showInputDialog(this, "New shape:", "Choose Shape", 1, null, this.availableShapes.toArray(), this.availableShapes.get(0))) != null) {
                        for (Integer obs_ix : PcaFrame.this.selectedObsIxs) {
                            this.userShapesByObsIx.put(obs_ix, shape_choice.getGeometryArray());
                        }
                        this.setShapeMap(this.userShapesByObsIx);
                    }
                } else if (cmd == PcaFrame.CLEAR_SELECTIONS_CMD) {
                    PcaFrame.this.clearSelection();
                } else if (cmd == PcaFrame.SHOW_SPOT_LABEL_CMD) {
                    for (int id : PcaFrame.this.selectedObsIxs) {
                        PcaFrame.this.jPanel_2D.m_point[id].setLabelState(true);
                    }
                    this.setShapeMap(this.userShapesByObsIx);
                } else if (cmd == PcaFrame.SELECT_ALL_CMD) {
                    int num_obs = this.obsIxToScores.getDomainSet().getLength();
                    PcaFrame.this.selectedObsIxs.clear();
                    int obs_ix = 0;
                    while (obs_ix < num_obs) {
                        PcaFrame.this.selectedObsIxs.add(obs_ix);
                        ++obs_ix;
                    }
                    PcaFrame.this.setSelection();
                } else if (cmd == "Save As High Resolution Image (tiff)") {
                    JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
                    int returnVal = chooser.showSaveDialog(PcaFrame.this.jPanelgrid);
                    if (returnVal == 0) {
                        String fileName = chooser.getSelectedFile().getPath();
                        AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
                        String ext = ClUtils.getExtension(fileName);
                        if (ext == null || ext == "") {
                            fileName = String.valueOf(fileName) + ".tif";
                        }
                        try {
                            HighResImage.saveTiff(HighResImage.pca3DScreenCapture(PcaFrame.this, PcaFrame.this.jPanel_3D), 300, new File(fileName));
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(PcaFrame.this.jPanelgrid, "The image size is too big. Please resize down further.");
                        }
                    }
                } else if (cmd == PcaFrame.SAVE_3D_IMG_CMD) {
                    JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
                    FileFilter filter = FileFilters.getImageFileFilter();
                    chooser.addChoosableFileFilter(filter);
                    chooser.setAcceptAllFileFilterUsed(false);
                    int returnVal = chooser.showSaveDialog(PcaFrame.this.jPanelgrid);
                    chooser.setVisible(false);
                    if (returnVal == 0) {
                        String fileName = chooser.getSelectedFile().getName();
                        AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
                        try {
                            String ext = ClUtils.getExtension(fileName);
                            if (ext == null) {
                                fileName = String.valueOf(fileName) + ".png";
                            }
                            File file = new File(String.valueOf(AppFrame.last_user_path.getAbsolutePath()) + File.separatorChar + fileName);
                            BufferedImage img = HighResImage.pca3DScreenCapture(PcaFrame.this, PcaFrame.this.jPanel_3D);
                            ext = ClUtils.getExtension(file);
                            ImageIO.write((RenderedImage)img, ext, file);
                            JOptionPane.showMessageDialog(this, "The image has been saved.", "Image Saved", 1);
                        }
                        catch (IOException ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setObsColor(List<Integer> selObsIxs, Color new_color) {
            for (Integer obs_ix : selObsIxs) {
                this.userColorsByObsIx.put(obs_ix, new_color);
            }
            try {
                this.setColorMap(this.obsGrpsMbrNames, this.userColorsByObsIx);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }

        protected double[] rangeFromMinMax(double[] scores_min_max) {
            double[] range = new double[]{scores_min_max[0] - 0.05 * Math.abs(scores_min_max[0]), scores_min_max[1] + 0.05 * Math.abs(scores_min_max[1])};
            return range;
        }
    }

    class PcaPanel2D
    extends JPanel
    implements ActionListener {
        static final String BACKGROUNDCOLOR = "Backgroud Color...";
        static final String SAVEIMAGE = "Save to File...";
        static final String SYMBOL = "Plot Details...";
        Color m_bgColor = null;
        Color[] m_color = null;
        boolean[] m_bLabel = null;
        int[] m_symbol = null;
        int[] m_size = null;
        Font m_font = null;
        DataPoint[] m_point = null;
        float[] m_x = new float[2];
        float[] m_y = new float[2];
        boolean m_bOK = false;
        int m_xComponent = 1;
        int m_yComponent = 2;
        Vector m_mousePoint = new Vector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItemSymbol = new JMenuItem("Plot Details...");
        JMenuItem jMenuItemBgColor = new JMenuItem("Backgroud Color...");
        JMenuItem jSave = new JMenuItem("Save as image...");

        private void hexagonPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x[3] = x0;
            y[0] = y0 - size;
            y[3] = y0 + size;
            int deltx = (int)((double)size * Math.sin(1.0471975511965976));
            int delty = (int)((double)size * Math.cos(1.0471975511965976));
            x[1] = x[2] = x0 + deltx;
            x[4] = x[5] = x0 - deltx;
            y[1] = y[5] = y0 - delty;
            y[2] = y[4] = y0 + delty;
        }

        private void pentagonPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x0;
            y[0] = y0 - size;
            int deltx = (int)((double)size * Math.sin(0.6283185307179586));
            int delty = (int)((double)size * Math.cos(0.6283185307179586));
            x[2] = x0 + deltx;
            x[3] = x0 - deltx;
            y[2] = y[3] = y0 + delty;
            deltx = (int)((double)size * Math.cos(0.3141592653589793));
            delty = (int)((double)size * Math.sin(0.3141592653589793));
            x[1] = x0 + deltx;
            x[4] = x0 - deltx;
            y[1] = y[4] = y0 - delty;
        }

        private void starPoints(int x0, int y0, int size, int[] x, int[] y) {
            x[0] = x0;
            y[0] = y0 - size;
            x[5] = x0;
            y[5] = y0 + size / 2;
            int deltX = (int)((double)size * Math.sin(0.6283185307179586) / 2.0);
            int deltY = (int)((double)size * Math.cos(0.6283185307179586) / 2.0);
            x[1] = x0 + deltX;
            y[1] = y0 - deltY;
            x[9] = x0 - deltX;
            y[9] = y[1];
            deltX = (int)((double)size * Math.cos(0.3141592653589793));
            deltY = (int)((double)size * Math.sin(0.3141592653589793));
            x[2] = x0 + deltX;
            y[2] = y0 - deltY;
            x[8] = x0 - deltX;
            y[8] = y0 - deltY;
            deltX = (int)((double)size * Math.sin(0.6283185307179586));
            deltY = (int)((double)size * Math.cos(0.6283185307179586));
            x[4] = x0 + deltX;
            y[4] = y0 + deltY;
            x[6] = x0 - deltX;
            y[6] = y0 + deltY;
            deltX = (int)((double)size * Math.sin(1.2566370614359172) / 2.0);
            deltY = (int)((double)size * Math.cos(1.2566370614359172) / 2.0);
            x[3] = x0 + deltX;
            y[3] = y0 + deltY;
            x[7] = x0 - deltX;
            y[7] = y0 + deltY;
        }

        public PcaPanel2D() {
            this.setBackground(Color.white);
            this.jbInit();
            this.setToolTipText("");
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }

        public void setShowLabel(boolean showLabel) {
            int i = 0;
            while (i < this.m_point.length) {
                this.m_point[i].setLabelState(showLabel);
                ++i;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(BACKGROUNDCOLOR)) {
                JDialog dialog = JColorChooser.createDialog(this, "Select Symbol's Color", true, PcaFrame.this.colorChooser, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((PcaPanel2D)PcaPanel2D.this).PcaFrame.this.selectedColor = ((PcaPanel2D)PcaPanel2D.this).PcaFrame.this.colorChooser.getColor();
                    }
                }, null);
                dialog.setVisible(true);
                if (PcaFrame.this.selectedColor != null) {
                    this.m_bgColor = PcaFrame.this.selectedColor;
                    this.repaint();
                }
            } else if (cmd.equals(SYMBOL)) {
                DlgSymbol dlg = new DlgSymbol(PcaFrame.this.m_pcaFrame);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = PcaFrame.this.m_appFrame.getSize();
                Point loc = PcaFrame.this.m_appFrame.getLocation();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
            } else if (cmd.equals("Save As High Resolution Image (tiff)")) {
                BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                this.paintComponent(img.createGraphics());
                HighResImage.SaveHighResImage(this, img);
            } else if (cmd.equals("Save to File...")) {
                JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
                FileFilter filter = FileFilters.getImageFileFilter();
                chooser.addChoosableFileFilter(filter);
                chooser.setAcceptAllFileFilterUsed(false);
                int returnVal = chooser.showSaveDialog(this);
                if (returnVal == 0) {
                    String fileName = chooser.getSelectedFile().getName();
                    AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
                    try {
                        String ext = ClUtils.getExtension(fileName);
                        if (ext == null) {
                            fileName = String.valueOf(fileName) + ".png";
                        }
                        File file = new File(String.valueOf(AppFrame.last_user_path.getAbsolutePath()) + File.separatorChar + fileName);
                        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                        this.paintComponent(img.createGraphics());
                        ext = ClUtils.getExtension(file);
                        ImageIO.write((RenderedImage)img, ext, file);
                        JOptionPane.showMessageDialog(this, "The image has been saved.", "Image Saved", 1);
                    }
                    catch (IOException ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            }
        }

        public int[] getSelectedIndex() {
            int[] ret = null;
            int count = 0;
            int i = 0;
            while (i < this.m_point.length) {
                if (this.m_point[i].isSelected()) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                return null;
            }
            ret = new int[count];
            count = 0;
            i = 0;
            while (i < this.m_point.length) {
                if (this.m_point[i].isSelected()) {
                    ret[count++] = i;
                }
                ++i;
            }
            return ret;
        }

        public void resetCoord(float[] x, float[] y, String[] label, int x_comp, int y_comp) {
            int i;
            this.m_bOK = false;
            this.m_xComponent = x_comp;
            this.m_yComponent = y_comp;
            this.m_x = this.translateData(x);
            this.m_y = this.translateData(y);
            this.scaleData(x, this.m_x[1] - this.m_x[0]);
            this.scaleData(y, this.m_y[1] - this.m_y[0]);
            if (this.m_point == null) {
                this.m_point = new DataPoint[x.length];
            }
            int i2 = 0;
            while (i2 < x.length) {
                this.m_point[i2] = new DataPoint(x[i2], y[i2], i2);
                ++i2;
            }
            int[] selected = null;
            selected = PcaFrame.this.jTable_SampleInfo != null ? PcaFrame.this.jTable_SampleInfo.getSelectedRows() : PcaFrame.this.jTable_U.getSelectedRows();
            if (selected != null) {
                i = 0;
                while (i < selected.length) {
                    this.m_point[selected[i]].setSelectState(true);
                    ++i;
                }
            }
            if (this.m_color == null) {
                this.m_color = new Color[x.length];
            }
            if (this.m_bLabel == null) {
                this.m_bLabel = new boolean[x.length];
            }
            if (this.m_size == null) {
                this.m_size = new int[x.length];
                i = 0;
                while (i < x.length) {
                    this.m_size[i] = DlgSymbol.DEFAULTSIZE;
                    ++i;
                }
            }
            if (this.m_symbol == null) {
                this.m_symbol = new int[x.length];
                i = 0;
                while (i < x.length) {
                    this.m_symbol[i] = 0;
                    ++i;
                }
            }
            this.m_bOK = true;
            this.repaint();
        }

        private void scaleData(float[] data, float dis) {
            int i = 0;
            while (i < data.length) {
                data[i] = data[i] / dis + 0.5f;
                ++i;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_bOK) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.0f));
                if (this.m_font != null) {
                    g2.setFont(this.m_font);
                }
                if (this.m_bgColor != null) {
                    this.setBackground(this.m_bgColor);
                }
                this.drawPoint(g2);
            }
        }

        private void drawPoint(Graphics2D g2) {
            if (this.m_point.length > 2000) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setStroke(new BasicStroke(2.0f));
            int i = 0;
            while (i < this.m_point.length) {
                this.m_point[i].draw(w, h, g2);
                ++i;
            }
            g2.setStroke(new BasicStroke(1.0f));
            if (this.m_point.length > 0) {
                int x = (int)((float)w * 0.1f);
                int y = (int)((float)h * 0.1f);
                g2.setColor(Color.black);
                String str = new String("Score Plot");
                FontRenderContext frc = g2.getFontRenderContext();
                Font oldFont = g2.getFont();
                g2.setFont(new Font(oldFont.getName(), 1, (int)((double)oldFont.getSize() * 1.4)));
                TextLayout layout = new TextLayout(str, g2.getFont(), frc);
                Rectangle2D rect = layout.getBounds();
                g2.drawString(str, (int)((double)w - rect.getWidth()) / 2, y - y / 10);
                g2.setFont(oldFont);
                g2.drawRect(x, y, (int)((float)w * 0.8f), (int)((float)h * 0.8f));
                int delt = (int)((float)w * 0.8f / 3.0f);
                g2.drawLine(x + delt, h - y - 1, x + delt, h - y - 5);
                g2.drawLine(x + 2 * delt, h - y - 1, x + 2 * delt, h - y - 5);
                delt = (int)((float)h * 0.8f / 3.0f);
                g2.drawLine(x, y + delt, x + 4, y + delt);
                g2.drawLine(x, y + 2 * delt, x + 4, y + 2 * delt);
                DecimalFormat format = new DecimalFormat("0.###");
                double[] percent_eigen = PcaFrame.this.getPercentEigen();
                str = "PC " + this.m_xComponent + "(" + format.format(percent_eigen[this.m_xComponent - 1]) + ")";
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)w * 0.5f) - rect.getWidth() / 2.0), (int)((double)(h - y) + rect.getHeight()) + 1);
                str = format.format(this.m_x[1]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)w * 0.9f) - rect.getWidth()), (int)((double)(h - y) + rect.getHeight()) + 2);
                str = format.format(this.m_x[0]);
                g2.drawString(str, x, (int)((double)(h - y) + rect.getHeight()) + 2);
                str = "PC " + this.m_yComponent + "(" + format.format(percent_eigen[this.m_yComponent - 1]) + ")";
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                y = (int)((double)(0.5f * (float)h) + rect.getWidth() / 2.0);
                g2.translate(--x, y);
                g2.rotate(-1.5707963267948966);
                g2.drawString(str, 0, -2);
                str = format.format(this.m_y[0]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)(-y) + 0.1f * (float)h) + rect.getWidth() - 6.0), -2);
                str = format.format(this.m_y[1]);
                layout = new TextLayout(str, g2.getFont(), frc);
                rect = layout.getBounds();
                g2.drawString(str, (int)((double)((float)y - 0.1f * (float)h) - rect.getWidth()), -2);
                g2.rotate(1.5707963267948966);
                g2.translate(-x, -y);
                if (this.m_point.length > 2000) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                }
            }
        }

        private float[] translateData(float[] data) {
            float[] ret = new float[2];
            ret[1] = -3.4028235E38f;
            ret[0] = Float.MAX_VALUE;
            int i = 0;
            while (i < data.length) {
                if (data[i] > ret[1]) {
                    ret[1] = data[i];
                }
                if (data[i] < ret[0]) {
                    ret[0] = data[i];
                }
                ++i;
            }
            float tmp = (ret[1] + ret[0]) / 2.0f;
            int i2 = 0;
            while (i2 < data.length) {
                int n = i2++;
                data[n] = data[n] - tmp;
            }
            return ret;
        }

        public void setObsColor(List<Integer> selObsIxs, Color new_color) {
            for (Integer obsIxs : selObsIxs) {
                this.m_point[obsIxs].setColor(new_color);
            }
            PcaFrame.this.clearSelection();
            this.repaint();
        }

        private void jbInit() {
            this.addMouseListener(new PcaPanel2D_this_mouseAdapter(this));
            this.addMouseMotionListener(new PcaPanel2D_this_mouseMotionAdapter(this));
            this.jPopupMenu.add(this.jMenuItemSymbol);
            this.jMenuItemSymbol.addActionListener(this);
            this.jPopupMenu.add(this.jMenuItemBgColor);
            this.jMenuItemBgColor.addActionListener(this);
            this.jPopupMenu.add(this.jSave);
            JMenuItem jSaveHighResImage = new JMenuItem("Save As High Resolution Image (tiff)");
            this.jPopupMenu.add(jSaveHighResImage);
            jSaveHighResImage.addActionListener(this);
            this.jSave.setActionCommand("Save to File...");
            this.jSave.addActionListener(this);
        }

        void this_mousePressed(MouseEvent e) {
            this.m_mousePoint.clear();
            if (e.getButton() == 1) {
                PcaFrame.this.clearSelection();
                this.m_mousePoint.add(e.getPoint());
            }
            this.setCursor(new Cursor(1));
            this.revalidate();
        }

        void this_mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
                this.jMenuItemSymbol.setVisible(PcaFrame.this.jPanel_2D.getSelectedIndex() != null);
                this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_mousePoint.size() > 1) {
                GeneralPath path = new GeneralPath();
                int nNum = this.m_mousePoint.size();
                path.moveTo(((Point)this.m_mousePoint.get((int)0)).x, ((Point)this.m_mousePoint.get((int)0)).y);
                int i = 1;
                while (i < nNum) {
                    path.lineTo(((Point)this.m_mousePoint.get((int)i)).x, ((Point)this.m_mousePoint.get((int)i)).y);
                    ++i;
                }
                path.closePath();
                int w = this.getWidth();
                int h = this.getHeight();
                PcaFrame.this.selectedObsIxs.clear();
                int i2 = 0;
                while (i2 < this.m_point.length) {
                    int y1;
                    int x1 = (int)(this.m_point[i2].getX() * (float)w * 0.8f + (float)w * 0.1f);
                    if (path.contains(x1, y1 = (int)((float)h - (this.m_point[i2].getY() * (float)h * 0.8f + (float)h * 0.1f)))) {
                        PcaFrame.this.selectedObsIxs.add(i2);
                    }
                    ++i2;
                }
                PcaFrame.this.setSelection();
                if (PcaFrame.this.jTable_SampleInfo != null) {
                    PcaFrame.this.jTabPanel.setSelectedIndex(4);
                } else {
                    PcaFrame.this.jTabPanel.setSelectedIndex(1);
                }
                int row = PcaFrame.this.jTable_U.getSelectedRow();
                if (row > -1) {
                    if (PcaFrame.this.jTable_SampleInfo != null) {
                        PcaFrame.this.jTable_SampleInfo.scrollRectToVisible(PcaFrame.this.jTable_SampleInfo.getCellRect(PcaFrame.this.sorter_sampleInfo.convertRowIndexToView(row), 0, false));
                    } else {
                        PcaFrame.this.jTable_U.scrollRectToVisible(PcaFrame.this.jTable_U.getCellRect(row, 0, false));
                    }
                }
            }
            this.m_mousePoint.clear();
            this.repaint();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void this_mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                this.m_mousePoint.add(e.getPoint());
                int nNum = this.m_mousePoint.size();
                if (nNum > 1) {
                    Graphics2D g2 = (Graphics2D)this.getGraphics();
                    if (g2 == null) {
                        return;
                    }
                    Point p1 = (Point)this.m_mousePoint.get(nNum - 2);
                    g2.drawLine(p1.x, p1.y, e.getX(), e.getY());
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            int w = this.getWidth();
            int h = this.getHeight();
            int i = this.m_point.length - 1;
            while (i >= 0) {
                int x1 = (int)(this.m_point[i].m_x * (float)w * 0.8f + (float)w * 0.1f);
                int y1 = (int)((float)h - (this.m_point[i].m_y * (float)h * 0.8f + (float)h * 0.1f));
                if (e.getX() > x1 - this.m_point[i].getSize() / 2 && e.getX() < x1 + this.m_point[i].getSize() / 2 && e.getY() > y1 - this.m_point[i].getSize() / 2 && e.getY() < y1 + this.m_point[i].getSize() / 2) {
                    String ret = "<html>" + PcaFrame.this.getPCAResults().getObservationLabels()[i] + "<br>";
                    ret = String.valueOf(ret) + "X-Score = " + PcaFrame.this.getPCAResults().getScoresMatrix().get(i, this.m_xComponent - 1) + "<br>";
                    ret = String.valueOf(ret) + "Y-Score = " + PcaFrame.this.getPCAResults().getScoresMatrix().get(i, this.m_yComponent - 1) + "</html>";
                    return ret;
                }
                --i;
            }
            return null;
        }

        class DataPoint {
            static final float coef1 = 0.57735f;
            static final float coef2 = 0.28867513f;
            static final int HOLLOWOVAL = 0;
            static final int FILLEDOVAL = 1;
            static final int HOLLOWRECT = 2;
            static final int FILLEDRECT = 3;
            static final int HOLLOWTRIANGLE = 4;
            static final int FILLEDTRIANGLE = 5;
            static final int INVERSEHOLLOWTRIANGLE = 6;
            static final int INVERSEFILLEDTRIANGLE = 7;
            static final int LEFTHOLLOWTRIANGLE = 8;
            static final int LEFTFILLEDTRIANGLE = 9;
            static final int RIGHTHOLLOWTRIANGLE = 10;
            static final int RIGHTFILLEDTRIANGLE = 11;
            static final int CHECK = 12;
            static final int RICE = 13;
            static final int STAR = 14;
            static final int FILLEDSTAR = 15;
            static final int TIAN = 16;
            static final int PENTAGON = 17;
            static final int FILLEDPENTAGON = 18;
            static final int HEXAGON = 19;
            static final int FILLEDHEXAGON = 20;
            static final int TIANX = 21;
            static final int DIAMOND = 22;
            static final int FILLEDDIAMOND = 23;
            static final int CROSS = 24;
            float m_x;
            float m_y;
            boolean m_bSelected;
            int m_rowNumber = -1;

            public DataPoint(float x, float y, int rowNum) {
                this.m_x = x;
                this.m_y = y;
                this.m_rowNumber = rowNum;
                this.m_bSelected = false;
            }

            public void setColor(Color color) {
                PcaPanel2D.this.m_color[this.m_rowNumber] = color;
            }

            public Color getColor() {
                return PcaPanel2D.this.m_color[this.m_rowNumber];
            }

            public void setSelectState(boolean state) {
                this.m_bSelected = state;
            }

            public boolean isSelected() {
                return this.m_bSelected;
            }

            public void setLabelState(boolean state) {
                PcaPanel2D.this.m_bLabel[this.m_rowNumber] = state;
            }

            public boolean isLabeled() {
                return PcaPanel2D.this.m_bLabel[this.m_rowNumber];
            }

            public void setSymbol(int symbol) {
                PcaPanel2D.this.m_symbol[this.m_rowNumber] = symbol;
            }

            public int getSymbol() {
                return PcaPanel2D.this.m_symbol[this.m_rowNumber];
            }

            public void setSize(int size) {
                PcaPanel2D.this.m_size[this.m_rowNumber] = size;
            }

            public int getSize() {
                return PcaPanel2D.this.m_size[this.m_rowNumber];
            }

            public float getX() {
                return this.m_x;
            }

            public float getY() {
                return this.m_y;
            }

            private int getRowNum() {
                return this.m_rowNumber;
            }

            public void draw(int w, int h, Graphics2D g2) {
                int x1 = (int)(this.m_x * (float)w * 0.8f + (float)w * 0.1f);
                int y1 = (int)((float)h - (this.m_y * (float)h * 0.8f + (float)h * 0.1f));
                if (this.m_bSelected) {
                    g2.setColor(((PcaPanel2D)PcaPanel2D.this).PcaFrame.this.selectionColor2D);
                } else if (PcaPanel2D.this.m_color[this.m_rowNumber] != null) {
                    g2.setColor(PcaPanel2D.this.m_color[this.m_rowNumber]);
                } else {
                    g2.setColor(((PcaPanel2D)PcaPanel2D.this).PcaFrame.this.defaultColor);
                }
                switch (this.getSymbol()) {
                    case 0: {
                        int shift = this.getSize() / 2;
                        g2.drawOval(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 1: {
                        int shift = this.getSize() / 2;
                        g2.fillOval(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 2: {
                        int shift = this.getSize() / 2;
                        g2.drawRect(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 3: {
                        int shift = this.getSize() / 2;
                        g2.fillRect(x1 - shift, y1 - shift, this.getSize(), this.getSize());
                        break;
                    }
                    case 4: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 - (float)this.getSize() * 0.57735f), (int)((float)y1 + (float)this.getSize() * 0.28867513f), (int)((float)y1 + (float)this.getSize() * 0.28867513f)};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 5: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 - (float)this.getSize() * 0.57735f), (int)((float)y1 + (float)this.getSize() * 0.28867513f), (int)((float)y1 + (float)this.getSize() * 0.28867513f)};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 6: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 + (float)this.getSize() * 0.57735f), (int)((float)y1 - (float)this.getSize() * 0.28867513f), (int)((float)y1 - (float)this.getSize() * 0.28867513f)};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 7: {
                        int[] x = new int[]{x1, x1 - this.getSize() / 2, x1 + this.getSize() / 2};
                        int[] y = new int[]{(int)((float)y1 + (float)this.getSize() * 0.57735f), (int)((float)y1 - (float)this.getSize() * 0.28867513f), (int)((float)y1 - (float)this.getSize() * 0.28867513f)};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 8: {
                        int[] x = new int[]{(int)((float)x1 - (float)this.getSize() * 0.57735f), (int)((float)x1 + (float)this.getSize() * 0.28867513f), (int)((float)x1 + (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 9: {
                        int[] x = new int[]{(int)((float)x1 - (float)this.getSize() * 0.57735f), (int)((float)x1 + (float)this.getSize() * 0.28867513f), (int)((float)x1 + (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 10: {
                        int[] x = new int[]{(int)((float)x1 + (float)this.getSize() * 0.57735f), (int)((float)x1 - (float)this.getSize() * 0.28867513f), (int)((float)x1 - (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.drawPolygon(x, y, 3);
                        break;
                    }
                    case 11: {
                        int[] x = new int[]{(int)((float)x1 + (float)this.getSize() * 0.57735f), (int)((float)x1 - (float)this.getSize() * 0.28867513f), (int)((float)x1 - (float)this.getSize() * 0.28867513f)};
                        int[] y = new int[]{y1, y1 - this.getSize() / 2, y1 + this.getSize() / 2};
                        g2.fillPolygon(x, y, 3);
                        break;
                    }
                    case 12: {
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 13: {
                        g2.drawLine(x1 - this.getSize() / 2, y1, x1 + this.getSize() / 2, y1);
                        g2.drawLine(x1, y1 - this.getSize() / 2, x1, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 14: {
                        int[] x = new int[10];
                        int[] y = new int[10];
                        PcaPanel2D.this.starPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, x.length);
                        break;
                    }
                    case 15: {
                        int[] x = new int[10];
                        int[] y = new int[10];
                        PcaPanel2D.this.starPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, x.length);
                        break;
                    }
                    case 16: {
                        g2.drawRect(x1 - this.getSize() / 2, y1 - this.getSize() / 2, this.getSize(), this.getSize());
                        g2.drawLine(x1 - this.getSize() / 2, y1, x1 + this.getSize() / 2, y1);
                        g2.drawLine(x1, y1 + this.getSize() / 2, x1, y1 - this.getSize() / 2);
                        break;
                    }
                    case 17: {
                        int[] x = new int[5];
                        int[] y = new int[5];
                        PcaPanel2D.this.pentagonPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, 5);
                        break;
                    }
                    case 18: {
                        int[] x = new int[5];
                        int[] y = new int[5];
                        PcaPanel2D.this.pentagonPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, 5);
                        break;
                    }
                    case 19: {
                        int[] x = new int[6];
                        int[] y = new int[6];
                        PcaPanel2D.this.hexagonPoints(x1, y1, this.getSize(), x, y);
                        g2.drawPolygon(x, y, 6);
                        break;
                    }
                    case 20: {
                        int[] x = new int[6];
                        int[] y = new int[6];
                        PcaPanel2D.this.hexagonPoints(x1, y1, this.getSize(), x, y);
                        g2.fillPolygon(x, y, 6);
                        break;
                    }
                    case 21: {
                        g2.drawRect(x1 - this.getSize() / 2, y1 - this.getSize() / 2, this.getSize(), this.getSize());
                        g2.drawLine(x1 - this.getSize() / 2, y1 - this.getSize() / 2, x1 + this.getSize() / 2, y1 + this.getSize() / 2);
                        g2.drawLine(x1 - this.getSize() / 2, y1 + this.getSize() / 2, x1 + this.getSize() / 2, y1 - this.getSize() / 2);
                        break;
                    }
                    case 22: {
                        int[] x = new int[]{x1, x1 + this.getSize(), x1, x1 - this.getSize()};
                        int[] y = new int[]{y1 - this.getSize(), y1, y1 + this.getSize(), y1};
                        g2.drawPolygon(x, y, 4);
                        break;
                    }
                    case 23: {
                        int[] x = new int[]{x1, x1 + this.getSize(), x1, x1 - this.getSize()};
                        int[] y = new int[]{y1 - this.getSize(), y1, y1 + this.getSize(), y1};
                        g2.fillPolygon(x, y, 4);
                        break;
                    }
                    case 24: {
                        int shift = this.getSize() / 2;
                        g2.drawLine(x1 - shift, y1, x1 + shift, y1);
                        g2.drawLine(x1, y1 - shift, x1, y1 + shift);
                    }
                }
                if (PcaPanel2D.this.m_bLabel[this.m_rowNumber]) {
                    String tmp = PcaFrame.this.getPCAResults().getObservationLabels()[this.getRowNum()];
                    if (tmp.length() > 12) {
                        tmp = tmp.substring(0, 12);
                    }
                    g2.drawString(tmp, x1 + 1, y1 - 1);
                }
            }
        }

        class PcaPanel2D_this_mouseAdapter
        extends MouseAdapter {
            PcaPanel2D adaptee;

            PcaPanel2D_this_mouseAdapter(PcaPanel2D adaptee) {
                this.adaptee = adaptee;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.adaptee.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.adaptee.this_mouseReleased(e);
            }
        }

        class PcaPanel2D_this_mouseMotionAdapter
        extends MouseMotionAdapter {
            PcaPanel2D adaptee;

            PcaPanel2D_this_mouseMotionAdapter(PcaPanel2D adaptee) {
                this.adaptee = adaptee;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.adaptee.this_mouseDragged(e);
            }
        }
    }
}

