/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.ParsedExpressionValue;
import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCADlg_jComboBox_RowLabel_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCADlg_jList_Column_listSelectionAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAEngine;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAResults;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;

class PCADlg
extends JDialog
implements ActionListener {
    TableFrame m_tableFrame = null;
    AppFrame m_appFrame = null;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel4 = new JPanel(new BorderLayout());
    JLabel jLabel1 = new JLabel();
    DefaultListModel listModel = new DefaultListModel();
    JList jList_Column = new JList(this.listModel);
    BorderLayout borderLayout2 = new BorderLayout();
    JCheckBox jCheckBox_Header = new JCheckBox("Header In First Row");
    JPanel jPanel2 = new JPanel();
    JLabel jLabel2 = new JLabel();
    JComboBox jComboBox_RowLabel = new JComboBox();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JButton jButton_Cancel = new JButton();
    JButton jButton_OK = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JRadioButton jCovariance = new JRadioButton("Centered");
    JRadioButton jCorrelation = new JRadioButton("Auto scaled");
    ButtonGroup pcaMethod = new ButtonGroup();
    int m_nRowLabel = 1;
    boolean m_bHeader = true;
    static boolean m_bWorking = false;
    static int m_count = 0;
    static Thread m_thread = null;

    public PCADlg(Frame frame, TableFrame tableFrame) {
        super(frame, "Principal Component Analysis", true);
        this.m_tableFrame = tableFrame;
        this.m_appFrame = (AppFrame)frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            this.jButton_OK_actionPerformed();
        }
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jLabel1.setText("Columns:");
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel2.setText("Row Label:");
        this.jPanel2.setLayout(this.borderLayout3);
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(this);
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(this);
        this.jScrollPane1.setPreferredSize(new Dimension(100, 120));
        this.jList_Column.addListSelectionListener(new PCADlg_jList_Column_listSelectionAdapter(this));
        this.jComboBox_RowLabel.addItemListener(new PCADlg_jComboBox_RowLabel_itemAdapter(this));
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jLabel1, "North");
        this.panel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList_Column, null);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jCheckBox_Header, "North");
        this.jPanel4.add((Component)this.jCovariance, "Center");
        this.jPanel4.add((Component)this.jCorrelation, "South");
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jComboBox_RowLabel, "South");
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jButton_OK, null);
        this.jPanel3.add((Component)this.jButton_Cancel, null);
        this.pcaMethod.add(this.jCovariance);
        this.pcaMethod.add(this.jCorrelation);
        this.jCorrelation.setSelected(AppFrame.m_bAutoscale);
        this.jCovariance.setSelected(!AppFrame.m_bAutoscale);
        int cols = this.m_tableFrame.m_dm.getColumnCount();
        this.listModel.addElement("<All>");
        this.jComboBox_RowLabel.addItem("Row Label");
        int i = 1;
        while (i < cols) {
            String name = this.m_tableFrame.m_dm.getColumnName(i);
            this.listModel.addElement(name);
            this.jComboBox_RowLabel.addItem(name);
            ++i;
        }
        this.m_nRowLabel = 1;
        this.jComboBox_RowLabel.setSelectedIndex(this.m_nRowLabel);
        this.jCheckBox_Header.setSelected(this.m_bHeader);
        AbstractAction upDataStatus = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (m_bWorking) {
                    String str = " Waiting";
                    int i = 0;
                    while (i < m_count) {
                        str = String.valueOf(str) + ".";
                        ++i;
                    }
                    PCADlg.this.m_appFrame.statusBar.setText(str);
                    if (++m_count > 200) {
                        m_count = 0;
                    }
                } else {
                    PCADlg.this.m_appFrame.statusBar.setText(" Ready");
                }
                PCADlg.this.m_appFrame.statusBar.revalidate();
            }
        };
        new Timer(500, upDataStatus).start();
    }

    void jButton_OK_actionPerformed() {
        int rows;
        final int[] indices = this.jList_Column.getSelectedIndices();
        final int cols = indices.length;
        int rows_t = this.m_tableFrame.m_dm.getRowCount();
        this.m_bHeader = this.jCheckBox_Header.isSelected();
        if (this.m_bHeader) {
            --rows_t;
        }
        if (cols * (rows = rows_t) < 2) {
            ClUtils.ErrorMessage("You must select at least 2 datasets and 1 data columns.");
            return;
        }
        this.m_nRowLabel = this.jComboBox_RowLabel.getSelectedIndex();
        this.m_appFrame.jStopThread.setEnabled(true);
        m_count = 0;
        m_bWorking = true;
        m_thread = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        int i;
                        String[] rLabel = new String[rows];
                        double[][] data = new double[rows][cols];
                        if (PCADlg.this.m_bHeader) {
                            i = 0;
                            while (i < rows) {
                                rLabel[i] = (String)PCADlg.this.m_tableFrame.m_dm.getValueAt(i + 1, PCADlg.this.m_nRowLabel);
                                int j = 0;
                                while (j < cols) {
                                    try {
                                        data[i][j] = ParsedExpressionValue.fromString((String)PCADlg.this.m_tableFrame.m_dm.getValueAt(i + 1, indices[j])).getExpressionValue();
                                        if (Double.isInfinite(data[i][j])) {
                                            data[i][j] = Double.NaN;
                                        }
                                    }
                                    catch (Exception ex) {
                                        data[i][j] = Double.NaN;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < rows) {
                                rLabel[i] = (String)PCADlg.this.m_tableFrame.m_dm.getValueAt(i, PCADlg.this.m_nRowLabel);
                                int j = 0;
                                while (j < cols) {
                                    try {
                                        data[i][j] = ParsedExpressionValue.fromString((String)PCADlg.this.m_tableFrame.m_dm.getValueAt(i, indices[j])).getExpressionValue();
                                        if (Double.isInfinite(data[i][j])) {
                                            data[i][j] = Double.NaN;
                                        }
                                    }
                                    catch (Exception ex) {
                                        data[i][j] = Double.NaN;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        final PCAResults pca_results = new PCAEngine().doPCA(data, rLabel, null, PCADlg.this.jCorrelation.isSelected());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PcaFrame fr = AppFrame.isGraph3DTester() ? new PcaFrameEx((this).PCADlg.this.m_appFrame, pca_results) : new PcaFrame((this).PCADlg.this.m_appFrame, pca_results);
                                (this).PCADlg.this.m_appFrame.m_pcaFrameList.add(fr);
                                (this).PCADlg.this.m_appFrame.jButton_PCA.setEnabled(false);
                                (this).PCADlg.this.m_appFrame.jButton_TransposeTable.setEnabled(false);
                            }
                        });
                    }
                    catch (OutOfMemoryError oome) {
                        ClUtils.ErrorMessage("Out of Memory");
                        PCADlg.this.m_appFrame.jStopThread.setEnabled(false);
                        m_bWorking = false;
                        m_thread = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClUtils.ErrorMessage(e.getMessage());
                        PCADlg.this.m_appFrame.jStopThread.setEnabled(false);
                        m_bWorking = false;
                        m_thread = null;
                    }
                }
                finally {
                    PCADlg.this.m_appFrame.jStopThread.setEnabled(false);
                    m_bWorking = false;
                    m_thread = null;
                }
            }
        };
        m_thread.start();
    }

    void jList_Column_valueChanged(ListSelectionEvent e) {
        if (this.jList_Column.getSelectedIndex() == 0) {
            this.jList_Column.clearSelection();
            this.m_nRowLabel = this.jComboBox_RowLabel.getSelectedIndex();
            Vector<Integer> vV = new Vector<Integer>();
            int c = this.m_tableFrame.m_dm.getColumnCount() - 1;
            int i = 0;
            while (i < c) {
                vV.add(new Integer(i + 1));
                ++i;
            }
            i = 0;
            while (i < vV.size()) {
                if (((Integer)vV.get(i)).equals(new Integer(this.m_nRowLabel))) {
                    vV.remove(i);
                }
                ++i;
            }
            int[] in = new int[vV.size()];
            int i2 = 0;
            while (i2 < in.length) {
                in[i2] = (Integer)vV.get(i2);
                ++i2;
            }
            this.jList_Column.setSelectedIndices(in);
        }
    }

    void jComboBox_RowLabel_itemStateChanged(ItemEvent e) {
        this.m_nRowLabel = this.jComboBox_RowLabel.getSelectedIndex();
        if (this.jList_Column.isSelectedIndex(this.m_nRowLabel)) {
            int[] index = this.jList_Column.getSelectedIndices();
            int[] in = new int[index.length - 1];
            int k = 0;
            int i = 0;
            while (i < index.length) {
                if (index[i] != this.m_nRowLabel) {
                    in[k++] = index[i];
                }
                ++i;
            }
            this.jList_Column.setSelectedIndices(in);
        }
    }
}

