/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableHeader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.table.AbstractTableModel;

public class MyTableModel
extends AbstractTableModel {
    Object[][] m_data;
    String[] m_rLabel;
    String[] m_cLabel;

    public MyTableModel(Object[][] data, String[] rLabel, String[] cLabel) {
        this.m_data = data;
        this.m_rLabel = rLabel;
        this.m_cLabel = cLabel;
    }

    @Override
    public int getRowCount() {
        return this.m_rLabel.length;
    }

    @Override
    public int getColumnCount() {
        return this.m_cLabel.length + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return " ";
        }
        return this.m_cLabel[columnIndex - 1];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.m_rLabel[rowIndex];
        }
        return this.m_data[rowIndex][columnIndex - 1];
    }

    @Override
    public void setValueAt(Object obj, int rowIndex, int columnIndex) {
        this.m_data[rowIndex][columnIndex - 1] = obj;
    }

    public Class getColumnClass(int c) {
        if (c > 0) {
            return String.class;
        }
        return TableHeader.class;
    }

    public String saveAsTable() {
        JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
        chooser.addChoosableFileFilter(FileFilters.getDataFileFilter());
        int returnVal = chooser.showSaveDialog(null);
        String fileName = null;
        if (returnVal == 0) {
            fileName = chooser.getSelectedFile().getPath();
            AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
            String ext = ClUtils.getExtension(fileName);
            if (ext == null) {
                fileName = String.valueOf(fileName) + ".txt";
            }
            this.writeTableToFile(fileName);
        }
        return fileName;
    }

    public void writeTableToFile(String fileName) {
        int rows = this.m_data.length;
        int cols = this.m_data[0].length;
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            if (this.m_cLabel != null && !this.m_cLabel[0].equals("C1")) {
                i = 0;
                while (i < this.m_cLabel.length) {
                    out.write("\t" + this.m_cLabel[i]);
                    ++i;
                }
                out.write("\n");
            }
            i = 0;
            while (i < rows) {
                if (this.m_rLabel != null && !this.m_rLabel[0].equals("R1")) {
                    out.write(String.valueOf(this.m_rLabel[i]) + "\t");
                }
                int j = 0;
                while (j < cols - 1) {
                    if (this.m_data[i][j].toString().indexOf("\t") > -1) {
                        out.write("\"" + this.m_data[i][j] + "\"\t");
                    } else {
                        out.write(this.m_data[i][j] + "\t");
                    }
                    ++j;
                }
                out.write(String.valueOf((String)this.m_data[i][cols - 1]) + "\n");
                ++i;
            }
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

