/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.util.math.la.Matrix;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;

public class MatrixTableModel
extends AbstractTableModel {
    Matrix srcMatrix;
    String[] customRowLabels;
    NumberFormat nFmt;
    String colNumPrefix;
    String[] col_labels = null;

    public MatrixTableModel(Matrix m, String[] custom_row_labels, String col_num_prefix) {
        this.srcMatrix = m;
        this.nFmt = NumberFormat.getInstance(Locale.US);
        this.nFmt.setMaximumFractionDigits(3);
        this.customRowLabels = custom_row_labels;
        this.colNumPrefix = col_num_prefix;
        this.col_labels = null;
    }

    public MatrixTableModel(Matrix m, String[] custom_row_labels, String[] col_labels) {
        this.srcMatrix = m;
        this.nFmt = NumberFormat.getInstance(Locale.US);
        this.nFmt.setMaximumFractionDigits(3);
        this.customRowLabels = custom_row_labels;
        this.colNumPrefix = null;
        this.col_labels = col_labels;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.srcMatrix.getColumnDimension();
    }

    @Override
    public int getRowCount() {
        return this.srcMatrix.getRowDimension();
    }

    @Override
    public Object getValueAt(int rix, int cix) {
        if (cix == 0) {
            if (this.customRowLabels != null) {
                return this.customRowLabels[rix];
            }
            return "R" + (rix + 1);
        }
        return this.srcMatrix.get(rix, cix - 1);
    }

    @Override
    public Class<?> getColumnClass(int cix) {
        if (cix == 0) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public String getColumnName(int cix) {
        if (this.col_labels == null) {
            if (cix == 0) {
                return null;
            }
            return this.colNumPrefix != null ? String.valueOf(this.colNumPrefix) + cix : String.valueOf(cix);
        }
        if (cix == 0) {
            return null;
        }
        return this.col_labels[cix - 1];
    }
}

