/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.FontSelectDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.HighResImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class HeatmapPane
extends JScrollPane
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
ActionListener {
    static final String ENLARGE = "Zoom In(+)";
    static final String REDUCE = "Zoom Out(-)";
    static final String NORMALSIZE = "Actual Size";
    static final String CUSTOMSCALE = "Custom Scale...";
    static final String FITTOWINDOW = "Fit to window";
    static final String BLOCKSIZE = "Change Image Block Size...";
    static final String FITTOX = "Fit to Width";
    static final String COLORSCHEME = "Change Color Scheme...";
    static final String FITTOY = "Fit to Height";
    static final String SCALEXUP = "Scale Up by X";
    static final String SCALEXDOWN = "Scale Down by X";
    static final String SCALEYUP = "Scale Up by Y";
    static final String SCALEYDOWN = "Scale Down by Y";
    static final String VACANTCOLOR = "Change Missing Value Color...";
    static final String LABELALIGNMENT = "Change Label Alignment...";
    static final String LABELFONT = "Change Label Font...";
    static final String GENELABEL = "Change gene label...";
    static final String GROUPCOLOR = "Set group color...";
    static final String SAVEHEATMAP = "Save heat map to file...";
    static final Color selectColor = Color.MAGENTA;
    private ViewPanel view = null;
    JPopupMenu jPopupMenu = new JPopupMenu();
    AppFrame m_appFrame;
    private int rows = 0;
    private int cols = 0;
    private int size = 16;
    private int space = 20;
    private int width_rowLabel = 0;
    private int width_colLabel = 0;
    private int height_rowLabel = 0;
    private int height_colLabel = 0;
    private double xscale = 1.0;
    private double yscale = 1.0;
    private Font m_Font;
    private Color[] groupColor = null;
    public boolean[] selected = null;
    private JColorChooser colorChooser = new JColorChooser();
    private Color selectGroupColor = Color.black;
    private Color[] grpColorOfSample = null;
    private Color vacantColor = Color.gray;
    private Color colorMin;
    private Color colorMedianLow;
    private Color colorMedianUp;
    private Color colorMax;
    private double max;
    private double min;
    private double medianLow;
    private double medianUp;
    private boolean alignRight = true;
    private boolean alignTop = false;
    private int widthLegend = 100;
    private int Legandheight = 64;
    boolean m_noChange = false;
    Image m_img = null;

    public void clearSelection() {
        int i = 0;
        while (i < this.selected.length) {
            this.selected[i] = false;
            ++i;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.view.repaint();
        this.m_noChange = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.view.repaint();
        this.m_noChange = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.view.repaint();
        this.m_noChange = false;
    }

    void view_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
    }

    void view_mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
    }

    void view_mouseDragged(MouseEvent e) {
        e.getModifiers();
    }

    void view_mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(VACANTCOLOR)) {
            Color color = JColorChooser.showDialog(this, "Select a color for vacant value", this.vacantColor);
            if (color != null) {
                this.vacantColor = color;
            }
        } else if (cmd.equals("Choose a color")) {
            JDialog dialog = JColorChooser.createDialog(this, "Select a color for group", true, this.colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapPane.this.selectGroupColor = HeatmapPane.this.colorChooser.getColor();
                }
            }, null);
            dialog.setVisible(true);
            if (this.selectGroupColor != null) {
                ((JButton)e.getSource()).setForeground(this.selectGroupColor);
            }
        } else if (cmd.equals(LABELALIGNMENT)) {
            LabelAlignDlg dlg = new LabelAlignDlg(this);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.getSize();
            Point loc = this.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setVisible(true);
        } else if (cmd.equals(BLOCKSIZE)) {
            int ss;
            String oldSize = String.valueOf(this.size);
            String newSize = JOptionPane.showInputDialog(this, "Enter your new block size:", oldSize);
            if (newSize != null && (ss = Integer.parseInt(newSize)) > 0) {
                this.size = ss;
            }
        } else if (cmd.equals(LABELFONT)) {
            FontSelectDlg dlg = new FontSelectDlg(this.m_Font.getFamily(), this.m_Font.getStyle(), this.m_Font.getSize());
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.getSize();
            Point loc = this.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setModal(true);
            dlg.pack();
            dlg.setVisible(true);
            if (dlg.m_fontFamily != null) {
                this.m_Font = new Font(dlg.m_fontFamily, dlg.m_fontStyle, dlg.m_fontSize);
            }
        } else if (cmd.equals(COLORSCHEME)) {
            ColorSchemeDlg dlg = new ColorSchemeDlg(null, this, "", true);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.getSize();
            Point loc = this.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setModal(true);
            dlg.pack();
            dlg.setVisible(true);
        } else if (cmd.equals(CUSTOMSCALE)) {
            Object[] ob = new Object[]{"Enter New Scale:"};
            String newCoef = (String)JOptionPane.showInputDialog(this, ob, "Change Image Scale", 1, null, null, "");
            if (newCoef != null && Float.parseFloat(newCoef) > 0.0f) {
                this.xscale = Double.parseDouble(newCoef);
                this.yscale = Double.parseDouble(newCoef);
            }
        } else if (cmd.equals(ENLARGE)) {
            this.xscale *= (double)1.1f;
            this.yscale *= (double)1.1f;
        } else if (cmd.equals(SCALEXUP)) {
            this.xscale *= (double)1.1f;
        } else if (cmd.equals(SCALEYUP)) {
            this.yscale *= (double)1.1f;
        } else if (cmd.equals(SCALEXDOWN)) {
            this.xscale *= (double)0.9f;
        } else if (cmd.equals(SCALEYDOWN)) {
            this.yscale *= (double)0.9f;
        } else if (cmd.equals(FITTOWINDOW)) {
            Rectangle rect = this.getViewportBorderBounds();
            this.xscale = (rect.getWidth() - (double)(2 * this.space) - (double)this.width_rowLabel - (double)this.widthLegend) / (double)(this.size * this.cols);
            this.yscale = (rect.getHeight() - (double)(2 * this.space) - (double)this.width_colLabel) / (double)(this.size * this.rows);
        } else if (cmd.equals(FITTOX)) {
            Rectangle rect = this.getViewportBorderBounds();
            this.xscale = (rect.getWidth() - (double)(2 * this.space) - (double)this.width_rowLabel - (double)this.widthLegend) / (double)(this.size * this.cols);
        } else if (cmd.equals(FITTOY)) {
            Rectangle rect = this.getViewportBorderBounds();
            this.yscale = (rect.getHeight() - (double)(2 * this.space) - (double)this.width_colLabel) / (double)(this.size * this.rows);
        } else if (cmd.equals(NORMALSIZE)) {
            this.xscale = 1.0;
            this.yscale = 1.0;
        } else if (cmd.equals(REDUCE)) {
            this.xscale *= 0.9;
            this.yscale *= 0.9;
        } else if (cmd.equals(SAVEHEATMAP)) {
            this.saveHeatmap();
        } else if (cmd.equals("Save As High Resolution Image (tiff)")) {
            Dimension size = this.view.getPreferredSize();
            BufferedImage img = new BufferedImage(size.width, size.height, 1);
            Graphics2D g = img.createGraphics();
            g.setBackground(Color.white);
            g.clearRect(0, 0, size.width, size.height);
            HighResImage.SaveHighResImage(this, img);
        }
        this.view.setViewDimension();
        this.revalidate();
        this.repaint();
        this.m_noChange = false;
    }

    private void saveHeatmap() {
        JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
        FileFilter filter2 = FileFilters.getImageFileFilter();
        chooser.addChoosableFileFilter(filter2);
        chooser.setAcceptAllFileFilterUsed(false);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            String fileName = chooser.getSelectedFile().getPath();
            AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
            try {
                File file;
                String ext = ClUtils.getExtension(chooser.getSelectedFile().getName());
                if (chooser.getFileFilter() instanceof FileFilters.ImageFileFilter && (ext == null || ext == "")) {
                    fileName = String.valueOf(fileName) + ".png";
                }
                if (filter2.accept(file = new File(fileName))) {
                    Dimension size = this.view.getPreferredSize();
                    BufferedImage img = new BufferedImage(size.width, size.height, 1);
                    Graphics2D g = img.createGraphics();
                    g.setBackground(Color.white);
                    g.clearRect(0, 0, size.width, size.height);
                    ext = ClUtils.getExtension(file);
                    ImageIO.write((RenderedImage)img, ext, file);
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private float[][] initColorComponents(int numColors, int numColorComp) {
        float[][] ret = new float[numColorComp][numColors];
        Color[] cT = new Color[]{Color.blue, Color.red, Color.green, Color.pink, Color.cyan, Color.lightGray, Color.orange, Color.black, new Color(0.0f, 0.5f, 0.5f), new Color(0.5f, 0.0f, 0.5f), new Color(1.0f, 0.0f, 0.5f), new Color(0.0f, 0.75f, 1.0f), new Color(0.0f, 0.75f, 0.25f), Color.gray, Color.yellow};
        float[] colorComp = null;
        int end = numColors > 15 ? 15 : numColors;
        int i = 0;
        while (i < end) {
            colorComp = cT[i].getRGBColorComponents(null);
            ret[0][i] = colorComp[0];
            ret[1][i] = colorComp[1];
            ret[2][i] = colorComp[2];
            ++i;
        }
        Random rand = new Random(10L);
        int i2 = 10;
        while (i2 < numColors) {
            ret[0][i2] = rand.nextFloat();
            ret[1][i2] = rand.nextFloat();
            ret[2][i2] = rand.nextFloat();
            ++i2;
        }
        return ret;
    }

    public void setSelected(int[] sel) {
        int i = 0;
        while (i < this.selected.length) {
            this.selected[i] = false;
            ++i;
        }
        i = 0;
        while (i < sel.length) {
            if (sel[i] < this.rows) {
                this.selected[sel[i]] = true;
            }
            ++i;
        }
        this.repaint();
    }

    private int[] getLabelExtent(String[] label, int num) {
        int[] ret = new int[2];
        Graphics g = this.m_appFrame.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.m_Font);
        FontRenderContext frc = g2.getFontRenderContext();
        int i = 0;
        while (i < num) {
            if (label[i] != null && label[i].length() > 0) {
                TextLayout layout = new TextLayout(label[i], this.m_Font, frc);
                Rectangle2D rect = layout.getBounds();
                if ((double)ret[0] < rect.getWidth()) {
                    ret[0] = (int)Math.ceil(rect.getWidth());
                }
                if ((double)ret[1] < rect.getHeight()) {
                    ret[1] = (int)Math.ceil(rect.getHeight());
                }
            }
            ++i;
        }
        return ret;
    }

    private int[] getVisibleRange(Rectangle rc) {
        int[] ret = new int[4];
        double x0 = (double)(this.space + this.width_rowLabel) + (double)(rc.x - this.space - this.width_rowLabel) / this.xscale;
        double y0 = (double)(this.space + this.width_colLabel) + (double)(rc.y - this.space - this.width_colLabel) / this.yscale;
        double x1 = (double)(this.space + this.width_rowLabel) + (double)(rc.x + rc.width - this.space - this.width_rowLabel) / this.xscale;
        double y1 = (double)(this.space + this.width_colLabel) + (double)(rc.y + rc.height - this.space - this.width_colLabel) / this.yscale;
        ret[0] = (int)Math.floor((x0 - (double)this.space - (double)this.width_rowLabel) / (double)this.size);
        if (ret[0] < 1) {
            ret[0] = 0;
        }
        if (ret[0] > this.cols - 1) {
            ret[0] = this.cols - 1;
        }
        ret[1] = (int)Math.ceil((x1 - (double)this.space - (double)this.width_rowLabel) / (double)this.size) + 1;
        if (ret[1] < 1) {
            ret[1] = 0;
        }
        if (ret[1] > this.cols - 1) {
            ret[1] = this.cols - 1;
        }
        ret[2] = (int)Math.floor((y0 - (double)this.space - (double)this.width_colLabel) / (double)this.size);
        if (ret[2] < 1) {
            ret[2] = 0;
        }
        if (ret[2] > this.rows - 1) {
            ret[2] = this.rows - 1;
        }
        ret[3] = (int)Math.ceil((y1 - (double)this.space - (double)this.width_colLabel) / (double)this.size) + 1;
        if (ret[3] < 1) {
            ret[3] = 0;
        }
        if (ret[3] > this.rows - 1) {
            ret[3] = this.rows - 1;
        }
        return ret;
    }

    private Color getColorByValue(double value) {
        Color color;
        if (Double.isNaN(value)) {
            return this.vacantColor;
        }
        if (value > this.max) {
            value = this.max;
        }
        if (value < this.min) {
            value = this.min;
        }
        if (this.medianLow != this.medianUp) {
            double mm = (this.medianLow + this.medianUp) / 2.0;
            color = value <= this.medianLow ? this.MapColor(value, this.medianLow, this.min, this.colorMin, this.colorMedianLow) : (value <= this.medianUp ? this.MapColor(value, this.medianUp, this.medianLow, this.colorMedianLow, this.colorMedianUp) : this.MapColor(value, this.max, this.medianUp, this.colorMedianUp, this.colorMax));
        } else {
            color = value <= this.medianLow ? this.MapColor(value, this.medianLow, this.min, this.colorMin, this.colorMedianLow) : this.MapColor(value, this.max, this.medianLow, this.colorMedianLow, this.colorMax);
        }
        return color;
    }

    private Color MapColor(double value, double Up, double Bottom, Color lowColor, Color upColor) {
        value = (value - Bottom) / (Up - Bottom);
        int R1 = lowColor.getRed();
        int R2 = upColor.getRed();
        int G1 = lowColor.getGreen();
        int G2 = upColor.getGreen();
        int B1 = lowColor.getBlue();
        int B2 = upColor.getBlue();
        int r = (int)(value * (double)(R2 - R1) + (double)R1);
        int g = (int)(value * (double)(G2 - G1) + (double)G1);
        int b = (int)(value * (double)(B2 - B1) + (double)B1);
        Color color = new Color(r, g, b);
        return color;
    }

    class ColorSchemeDlg
    extends JDialog
    implements ActionListener {
        JPanel jPanel1;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JLabel jLabel1;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JButton jButton_MaxColor;
        JButton jButton_MedianUpColor;
        JButton jButton_MedianLow;
        JButton jButton_MinColor;
        JTextField jTextField_MedianUp;
        JTextField jTextField_MedianLow;
        JTextField jTextField_Min;
        JTextField jTextField_LegendHeight;
        JButton jButton_Cancle;
        JButton jButton_OK;
        JButton jButton_Apply;
        Border border1;
        JTextField jTextField_Max;
        HeatmapPane heatMapFrame;
        Color m_MaximumColor;
        Color m_MedianUpColor;
        Color m_MedianLowColor;
        Color m_MinimumColor;
        double m_MaxValue;
        double m_MedianUpValue;
        double m_MedianLowValue;
        double m_MinValue;

        public ColorSchemeDlg(Frame frame, HeatmapPane heatMapFrame, String title, boolean modal) {
            super(frame, title, modal);
            this.jPanel1 = new JPanel();
            this.jPanel2 = new JPanel();
            this.jPanel3 = new LegendPanel();
            this.jPanel4 = new JPanel();
            this.jPanel5 = new JPanel();
            this.jPanel6 = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jButton_MaxColor = new JButton();
            this.jButton_MedianUpColor = new JButton();
            this.jButton_MedianLow = new JButton();
            this.jButton_MinColor = new JButton();
            this.jTextField_MedianUp = new JTextField();
            this.jTextField_MedianLow = new JTextField();
            this.jTextField_Min = new JTextField();
            this.jTextField_LegendHeight = new JTextField();
            this.jButton_Cancle = new JButton();
            this.jButton_OK = new JButton();
            this.jButton_Apply = new JButton();
            this.jTextField_Max = new JTextField();
            this.heatMapFrame = null;
            this.m_MaximumColor = Color.red;
            this.m_MedianUpColor = Color.black;
            this.m_MedianLowColor = Color.black;
            this.m_MinimumColor = Color.green;
            this.m_MaxValue = 0.0;
            this.m_MedianUpValue = 0.0;
            this.m_MedianLowValue = 0.0;
            this.m_MinValue = 0.0;
            this.heatMapFrame = heatMapFrame;
            try {
                this.jbInit();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton bt = (JButton)e.getSource();
            if (bt.equals(this.jButton_Apply)) {
                this.updateData();
                this.jPanel3.repaint();
                this.heatMapFrame.view.repaint();
            } else if (bt.equals(this.jButton_OK)) {
                this.updateData();
                this.dispose();
                this.jPanel3.repaint();
            } else if (bt.equals(this.jButton_MaxColor)) {
                Color t = JColorChooser.showDialog(this, "Select a color", this.m_MaximumColor);
                if (t != null) {
                    this.m_MaximumColor = t;
                    bt.setForeground(t);
                }
            } else if (bt.equals(this.jButton_MedianLow)) {
                Color t = JColorChooser.showDialog(this, "Select a color", this.m_MedianLowColor);
                if (t != null) {
                    this.m_MedianLowColor = t;
                    bt.setForeground(t);
                }
            } else if (bt.equals(this.jButton_MedianUpColor)) {
                Color t = JColorChooser.showDialog(this, "Select a color", this.m_MedianUpColor);
                if (t != null) {
                    this.m_MedianUpColor = t;
                    bt.setForeground(t);
                }
            } else if (bt.equals(this.jButton_MinColor)) {
                Color t = JColorChooser.showDialog(this, "Select a color", this.m_MinimumColor);
                if (t != null) {
                    bt.setForeground(t);
                    this.m_MinimumColor = t;
                }
            } else {
                this.dispose();
            }
            this.jPanel3.repaint();
        }

        private void updateData() {
            this.heatMapFrame.max = Double.parseDouble(this.jTextField_Max.getText());
            this.heatMapFrame.min = Double.parseDouble(this.jTextField_Min.getText());
            this.heatMapFrame.medianLow = Double.parseDouble(this.jTextField_MedianLow.getText());
            this.heatMapFrame.medianUp = Double.parseDouble(this.jTextField_MedianUp.getText());
            this.heatMapFrame.Legandheight = Integer.parseInt(this.jTextField_LegendHeight.getText());
            this.heatMapFrame.colorMax = this.m_MaximumColor;
            this.heatMapFrame.colorMin = this.m_MinimumColor;
            this.heatMapFrame.colorMedianLow = this.m_MedianLowColor;
            this.heatMapFrame.colorMedianUp = this.m_MedianUpColor;
        }

        private void jbInit() throws Exception {
            this.border1 = BorderFactory.createEmptyBorder(0, 2, 0, 0);
            this.m_MaximumColor = this.heatMapFrame.colorMax;
            this.m_MinimumColor = this.heatMapFrame.colorMin;
            this.m_MedianUpColor = this.heatMapFrame.colorMedianUp;
            this.m_MedianLowColor = this.heatMapFrame.colorMedianLow;
            this.m_MaxValue = this.heatMapFrame.max;
            this.m_MinValue = this.heatMapFrame.min;
            this.m_MedianLowValue = this.heatMapFrame.medianLow;
            this.m_MedianUpValue = this.heatMapFrame.medianUp;
            this.jLabel1.setText("Legend Height");
            this.jLabel2.setText("Maximum:");
            this.jLabel3.setText("Median Up:");
            this.jLabel4.setText("Median Low:");
            this.jLabel5.setText("Minimum:");
            this.jPanel4.setLayout(new GridLayout(5, 1, 0, 6));
            this.jButton_MaxColor.setText("Color...");
            this.jButton_MaxColor.setForeground(this.m_MaximumColor);
            this.jButton_MaxColor.addActionListener(this);
            this.jButton_MedianUpColor.setText("Color...");
            this.jButton_MedianUpColor.setForeground(this.m_MedianUpColor);
            this.jButton_MedianUpColor.addActionListener(this);
            this.jButton_MedianLow.setText("Color...");
            this.jButton_MedianLow.setForeground(this.m_MedianLowColor);
            this.jButton_MedianLow.addActionListener(this);
            this.jButton_MinColor.setText("Color...");
            this.jButton_MinColor.setForeground(this.m_MinimumColor);
            this.jButton_MinColor.addActionListener(this);
            this.jTextField_Max.setText("jTextField1");
            this.jPanel5.setLayout(new GridLayout(5, 1, 0, 2));
            this.jPanel2.setLayout(new GridLayout(4, 1, 0, 2));
            this.jPanel3.setPreferredSize(new Dimension(20, 40));
            this.jButton_Cancle.setText("Cancel");
            this.jButton_Cancle.addActionListener(this);
            this.jButton_OK.setText("OK");
            this.jButton_OK.addActionListener(this);
            this.jButton_Apply.setText("Apply");
            this.jButton_Apply.addActionListener(this);
            this.jPanel1.setBorder(this.border1);
            this.jTextField_Max.setText(String.format("%.3f", this.m_MaxValue));
            this.jTextField_Min.setText(String.format("%.3f", this.m_MinValue));
            this.jTextField_MedianLow.setText(String.format("%.3f", this.m_MedianLowValue));
            this.jTextField_MedianUp.setText(String.format("%.3f", this.m_MedianUpValue));
            this.jTextField_LegendHeight.setText(Integer.toString(this.heatMapFrame.Legandheight));
            this.setModal(true);
            this.setResizable(true);
            this.jPanel6.add((Component)this.jButton_OK, null);
            this.jPanel6.add((Component)this.jButton_Apply, null);
            this.getContentPane().add((Component)this.jPanel1, "West");
            this.jPanel1.add((Component)this.jPanel4, null);
            this.jPanel4.add((Component)this.jLabel2, null);
            this.jPanel4.add((Component)this.jLabel3, null);
            this.jPanel4.add((Component)this.jLabel4, null);
            this.jPanel4.add((Component)this.jLabel5, null);
            this.jPanel4.add((Component)this.jLabel1, null);
            this.jPanel5.add((Component)this.jTextField_Max, null);
            this.jPanel5.add((Component)this.jTextField_MedianUp, null);
            this.jPanel5.add((Component)this.jTextField_MedianLow, null);
            this.jPanel5.add((Component)this.jTextField_Min, null);
            this.jPanel5.add((Component)this.jTextField_LegendHeight, null);
            this.jPanel1.add((Component)this.jPanel5, null);
            this.jPanel2.add((Component)this.jButton_MaxColor, null);
            this.jPanel2.add((Component)this.jButton_MedianUpColor, null);
            this.jPanel2.add((Component)this.jButton_MedianLow, null);
            this.jPanel2.add((Component)this.jButton_MinColor, null);
            this.getContentPane().add((Component)this.jPanel3, "East");
            this.getContentPane().add((Component)this.jPanel6, "South");
            this.jPanel6.add((Component)this.jButton_Cancle, null);
            this.getContentPane().add((Component)this.jPanel2, "Center");
        }

        class LegendPanel
        extends JPanel {
            LegendPanel() {
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(ColorSchemeDlg.this.m_MaximumColor);
                Graphics2D g2 = (Graphics2D)g;
                int w = (int)this.getSize().getWidth() - 2;
                int h = (int)this.getSize().getHeight();
                int delt = h / 3;
                int xStart = 2;
                int yStart = 2;
                if (!ColorSchemeDlg.this.m_MedianUpColor.equals(ColorSchemeDlg.this.m_MedianLowColor.toString())) {
                    GradientPaint gp = new GradientPaint(xStart, yStart, ColorSchemeDlg.this.m_MaximumColor, xStart, delt + yStart, ColorSchemeDlg.this.m_MedianUpColor);
                    g2.setPaint(gp);
                    g2.fillRect(xStart, yStart, w, delt);
                    gp = new GradientPaint(xStart, delt + yStart, ColorSchemeDlg.this.m_MedianUpColor, xStart, delt + delt + yStart, ColorSchemeDlg.this.m_MedianLowColor);
                    g2.setPaint(gp);
                    g2.fillRect(xStart, delt + yStart, w, delt);
                    gp = new GradientPaint(xStart, delt + delt + yStart, ColorSchemeDlg.this.m_MedianLowColor, xStart, h + yStart, ColorSchemeDlg.this.m_MinimumColor);
                    g2.setPaint(gp);
                    g2.fillRect(xStart, delt + delt + yStart, w, delt);
                } else {
                    delt = h / 2;
                    GradientPaint gp = new GradientPaint(xStart, yStart, ColorSchemeDlg.this.m_MaximumColor, xStart, delt + yStart, ColorSchemeDlg.this.m_MedianUpColor);
                    g2.setPaint(gp);
                    g2.fillRect(xStart, yStart, w, delt);
                    gp = new GradientPaint(xStart, delt + yStart, ColorSchemeDlg.this.m_MedianUpColor, xStart, delt + delt + yStart, ColorSchemeDlg.this.m_MinimumColor);
                    g2.setPaint(gp);
                    g2.fillRect(xStart, delt + yStart, w, delt);
                }
            }
        }
    }

    class Heatmap_view_mouseAdapter
    extends MouseAdapter {
        HeatmapPane adaptee;

        Heatmap_view_mouseAdapter(HeatmapPane adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.adaptee.view_mouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.view_mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.adaptee.view_mousePressed(e);
        }
    }

    class LabelAlignDlg
    extends JDialog
    implements ActionListener {
        static final String BOTTOM = "Bottom";
        static final String LEFT = "Left";
        static final String RIGHT = "Right";
        static final String TOP = "Top";
        JPanel panel1 = new JPanel();
        BorderLayout borderLayout1 = new BorderLayout();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        JRadioButton jRadioButton_Bottom = new JRadioButton();
        JRadioButton jRadioButton_Top = new JRadioButton();
        JRadioButton jRadioButton_Right = new JRadioButton();
        JRadioButton jRadioButton_Left = new JRadioButton();
        JButton jButton_OK = new JButton();
        JButton jButtonCancel = new JButton();
        Border border1;
        TitledBorder titledBorder1;
        Border border2;
        TitledBorder titledBorder2;
        Border border3;
        TitledBorder titledBorder3;
        ButtonGroup buttonGroup1 = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        boolean m_bColAlignment;
        boolean m_bRowAlignment;
        HeatmapPane m_heatmapPane;

        public LabelAlignDlg(HeatmapPane heatmapPane2) {
            this.setTitle("Label alignment");
            this.setModal(true);
            this.m_heatmapPane = heatmapPane2;
            try {
                this.jbInit();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.border1 = BorderFactory.createLineBorder(Color.black, 2);
            this.titledBorder1 = new TitledBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(115, 114, 105), new Color(165, 163, 151)), "Column Label Alignment");
            this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
            this.titledBorder2 = new TitledBorder(this.border2, "Column Label Alignment");
            this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
            this.titledBorder3 = new TitledBorder(this.border3, "Row Label Alignment");
            this.panel1.setLayout(this.borderLayout1);
            this.jPanel1.setLayout(this.borderLayout2);
            this.jRadioButton_Bottom.setText(BOTTOM);
            this.jRadioButton_Bottom.addActionListener(this);
            this.jRadioButton_Top.setText(TOP);
            this.jRadioButton_Top.addActionListener(this);
            this.jRadioButton_Right.setText(RIGHT);
            this.jRadioButton_Right.addActionListener(this);
            this.jRadioButton_Left.setText(LEFT);
            this.jRadioButton_Left.addActionListener(this);
            this.jButton_OK.setText("OK");
            this.jButton_OK.addActionListener(this);
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(this);
            this.jPanel2.setBorder(this.titledBorder2);
            this.jPanel3.setBorder(this.titledBorder3);
            this.getContentPane().add((Component)this.panel1, "Center");
            this.panel1.add((Component)this.jPanel2, "North");
            this.jPanel2.add((Component)this.jRadioButton_Top, null);
            this.jPanel2.add((Component)this.jRadioButton_Bottom, null);
            this.panel1.add((Component)this.jPanel3, "South");
            this.jPanel3.add((Component)this.jRadioButton_Left, null);
            this.jPanel3.add((Component)this.jRadioButton_Right, null);
            this.getContentPane().add((Component)this.jPanel1, "East");
            this.jPanel1.add((Component)this.jPanel5, "North");
            this.jPanel5.add((Component)this.jButton_OK, null);
            this.jPanel1.add((Component)this.jPanel4, "Center");
            this.jPanel4.add((Component)this.jButtonCancel, null);
            this.buttonGroup1.add(this.jRadioButton_Top);
            this.buttonGroup1.add(this.jRadioButton_Bottom);
            this.buttonGroup2.add(this.jRadioButton_Left);
            this.buttonGroup2.add(this.jRadioButton_Right);
            this.m_bColAlignment = this.m_heatmapPane.alignTop;
            this.m_bRowAlignment = this.m_heatmapPane.alignRight;
            this.titledBorder2.setTitleColor(Color.lightGray);
            this.jRadioButton_Top.setSelected(this.m_bColAlignment);
            this.jRadioButton_Bottom.setSelected(!this.m_bColAlignment);
            this.jRadioButton_Left.setSelected(!this.m_bRowAlignment);
            this.jRadioButton_Right.setSelected(this.m_bRowAlignment);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("OK")) {
                this.m_heatmapPane.alignTop = this.m_bColAlignment;
                this.m_heatmapPane.alignRight = this.m_bRowAlignment;
                this.m_heatmapPane.view.repaint();
                this.dispose();
            } else if (cmd.equals("Cancel")) {
                this.dispose();
            } else if (cmd.equals(BOTTOM)) {
                this.m_bColAlignment = false;
            } else if (cmd.equals(LEFT)) {
                this.m_bRowAlignment = false;
            } else if (cmd.equals(TOP)) {
                this.m_bColAlignment = true;
            } else if (cmd.equals(RIGHT)) {
                this.m_bRowAlignment = true;
            }
        }
    }

    class ViewPanel
    extends JPanel {
        private void setViewDimension() {
            int width = (int)Math.ceil((double)(HeatmapPane.this.size * HeatmapPane.this.cols) * HeatmapPane.this.xscale + (double)HeatmapPane.this.width_rowLabel + (double)(2 * HeatmapPane.this.space));
            int height = (int)Math.ceil((double)(HeatmapPane.this.size * HeatmapPane.this.rows) * HeatmapPane.this.yscale + (double)HeatmapPane.this.width_colLabel + (double)(2 * HeatmapPane.this.space));
            this.setPreferredSize(new Dimension(width + HeatmapPane.this.widthLegend, height));
            this.revalidate();
        }

        private void DrawLegend(Graphics2D g2, Point point) {
            String str;
            int width = 15;
            Color[] color = new Color[2];
            int i = 2;
            int bias = 2;
            DecimalFormat format = new DecimalFormat("0.###");
            if (HeatmapPane.this.medianLow != HeatmapPane.this.medianUp) {
                this.LegendColor(color, 0);
                GradientPaint gp1 = new GradientPaint(point.x, point.y, color[0], point.x, point.y + HeatmapPane.this.Legandheight, color[1]);
                this.LegendColor(color, 1);
                GradientPaint gp2 = new GradientPaint(point.x, point.y + HeatmapPane.this.Legandheight, color[0], point.x, point.y + HeatmapPane.this.Legandheight * 2, color[1]);
                this.LegendColor(color, 2);
                GradientPaint gp3 = new GradientPaint(point.x, point.y + HeatmapPane.this.Legandheight * 2, color[0], point.x, point.y + HeatmapPane.this.Legandheight * 3, color[1]);
                g2.setPaint(gp1);
                g2.fillRect(point.x, point.y, width, HeatmapPane.this.Legandheight);
                g2.setPaint(gp2);
                g2.fillRect(point.x, point.y + HeatmapPane.this.Legandheight, width, HeatmapPane.this.Legandheight);
                g2.setPaint(gp3);
                g2.fillRect(point.x, point.y + HeatmapPane.this.Legandheight * 2, width, HeatmapPane.this.Legandheight);
                str = format.format(HeatmapPane.this.min);
                g2.setColor(Color.black);
                g2.drawString(str, point.x + width + bias, point.y);
                str = format.format(HeatmapPane.this.medianLow);
                g2.drawString(str, point.x + width + bias, point.y + HeatmapPane.this.Legandheight);
                str = format.format(HeatmapPane.this.medianUp);
                g2.drawString(str, point.x + width + bias, point.y + HeatmapPane.this.Legandheight * 2);
                i = 3;
            } else {
                this.LegendColor(color, 0);
                GradientPaint gp1 = new GradientPaint(point.x, point.y, color[0], point.x, point.y + HeatmapPane.this.Legandheight, color[1]);
                this.LegendColor(color, 3);
                GradientPaint gp2 = new GradientPaint(point.x, point.y + HeatmapPane.this.Legandheight, color[0], point.x, point.y + HeatmapPane.this.Legandheight * 2, color[1]);
                g2.setPaint(gp1);
                g2.fillRect(point.x, point.y, width, HeatmapPane.this.Legandheight);
                g2.setPaint(gp2);
                g2.fillRect(point.x, point.y + HeatmapPane.this.Legandheight, width, HeatmapPane.this.Legandheight);
                str = format.format(HeatmapPane.this.min);
                g2.setColor(Color.black);
                g2.drawString(str, point.x + width + bias, point.y);
                str = format.format((HeatmapPane.this.medianUp + HeatmapPane.this.medianLow) / 2.0);
                g2.drawString(str, point.x + width + bias, point.y + HeatmapPane.this.Legandheight);
                i = 2;
            }
            str = format.format(HeatmapPane.this.max);
            g2.drawString(str, point.x + width, point.y + i * HeatmapPane.this.Legandheight);
        }

        private void LegendColor(Color[] color, int zone) {
            switch (zone) {
                case 0: {
                    color[0] = HeatmapPane.this.colorMin;
                    color[1] = HeatmapPane.this.colorMedianLow;
                    break;
                }
                case 1: {
                    color[0] = HeatmapPane.this.colorMedianLow;
                    color[1] = HeatmapPane.this.colorMedianUp;
                    break;
                }
                case 2: {
                    color[0] = HeatmapPane.this.colorMedianUp;
                    color[1] = HeatmapPane.this.colorMax;
                    break;
                }
                default: {
                    color[0] = HeatmapPane.this.colorMedianLow;
                    color[1] = HeatmapPane.this.colorMax;
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paintComponent(g);
        }
    }
}

