/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.ColumnHeaderRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class HeaderListener
extends MouseAdapter
implements ActionListener {
    JTableHeader header;
    ColumnHeaderRenderer renderer;
    TableFrame tableFrame = null;
    static final String DELETECOLUMN = "Delete";
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jMenuItemDeleteColumn = new JMenuItem("Delete");

    HeaderListener(JTableHeader header, ColumnHeaderRenderer renderer, TableFrame tFrame) {
        this.header = header;
        this.renderer = renderer;
        this.tableFrame = tFrame;
        this.jPopupMenu.add(this.jMenuItemDeleteColumn);
        this.jMenuItemDeleteColumn.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(DELETECOLUMN)) {
            JTable table = this.header.getTable();
            int[] selected = table.getSelectedColumns();
            if (table != null) {
                if (table.getColumnCount() - selected.length == 1) {
                    this.tableFrame.this_internalFrameClosed();
                    this.tableFrame.dispose();
                }
                if (selected.length > 0) {
                    MyTableModel dm = (MyTableModel)table.getModel();
                    int rows = dm.m_data.length;
                    int cols = dm.m_data[0].length;
                    Object[][] data = new Object[rows][cols - selected.length];
                    String[] cl = new String[dm.m_cLabel.length - selected.length];
                    int k = 0;
                    int i = 0;
                    while (i < cols) {
                        if (!this.isSelected(i + 1, selected)) {
                            cl[k] = "C" + (k + 1);
                            int j = 0;
                            while (j < rows) {
                                data[j][k] = dm.m_data[j][i];
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    this.tableFrame.m_dm = new MyTableModel(data, dm.m_rLabel, cl);
                    table.setModel(this.tableFrame.m_dm);
                    this.renderer.clearPressedColumn();
                    TableColumnModel model = table.getColumnModel();
                    int n = table.getColumnCount();
                    int i2 = 1;
                    while (i2 < n) {
                        model.getColumn(i2).setHeaderRenderer(this.renderer);
                        ++i2;
                    }
                    table.revalidate();
                }
            }
        }
    }

    private boolean isSelected(int column, int[] selected) {
        int i = 0;
        while (i < selected.length) {
            if (column == selected[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int col;
        if (e.getButton() == 1 && (col = this.header.columnAtPoint(e.getPoint())) > 0) {
            MouseListener[] listener;
            if (this.header.getTable().getRowSelectionAllowed()) {
                this.header.getTable().setColumnSelectionAllowed(true);
                this.header.getTable().setRowSelectionAllowed(false);
                this.header.getTable().clearSelection();
            }
            if ((listener = this.header.getTable().getMouseListeners()) != null) {
                int i = 0;
                while (i < listener.length) {
                    listener[i].mousePressed(e);
                    ++i;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.isPopupTrigger() || (e.getModifiers() & 4) != 0) && this.header.getTable().columnAtPoint(e.getPoint()) > 0 && this.header.getTable().getColumnSelectionAllowed() && this.header.getTable().getSelectedColumnCount() > 0) {
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

