/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.BoolPoint;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClassifyDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.Cluster;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterFrame_jPanel_Tree_mouseAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterFrame_jPanel_Tree_mouseMotionAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterFrame_this_internalFrameAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterTreeNode;
import NCTR.app.arraytrack.vs2.analysis.clustering.ColorSchemeDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.FontSelectDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.GenesSelectable;
import NCTR.app.arraytrack.vs2.analysis.clustering.HighResImage;
import NCTR.app.arraytrack.vs2.analysis.clustering.LabelAlignDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;

public class ClusterFrame
extends JInternalFrame
implements GenesSelectable,
ActionListener,
MouseMotionListener {
    static int openFrameCount = 1;
    AppFrame m_appFrame;
    public Cluster m_tree = null;
    private TableFrame m_TableFrame = null;
    Point m_mDown;
    Point m_mMove;
    String m_FileName = "";
    JToolBar jToolBar = new JToolBar();
    JButton jEnlarge;
    JButton jReduce;
    JButton jFont;
    JButton jFitWindow;
    JButton jActualSize;
    JButton jTreeColor;
    JButton jSave;
    JButton jFitX;
    JButton jFitY;
    JButton jScaleXUp;
    JButton jScaleXDown;
    JButton jScaleYUp;
    JButton jScaleYDown;
    JButton jAddToGeneList = new JButton("Signature");
    boolean m_bBeginSignature = false;
    List<Integer> geneList = new ArrayList<Integer>();
    List<Double> avgIntensity = new ArrayList<Double>();
    ClusterTreeNode colTree = null;
    ClusterTreeNode rowTree = null;
    TableFrame pGeneListView = null;
    static final String ENLARGE = "Zoom In(+)";
    static final String REDUCE = "Zoom Out(-)";
    static final String NORMALSIZE = "Actual Size";
    static final String CUSTOMSCALE = "Custom Scale...";
    static final String FITTOWINDOW = "Fit to window";
    static final String FITTOX = "Fit to Width";
    static final String FITTOY = "Fit to Height";
    static final String SCALEXUP = "Scale Up by X";
    static final String SCALEXDOWN = "Scale Down by X";
    static final String SCALEYUP = "Scale Up by Y";
    static final String SCALEYDOWN = "Scale Down by Y";
    static final String TREECOLOR = "Change Tree Color...";
    static final String VACANTCOLOR = "Change Missing Value Color...";
    static final String LOGARITHMIC = "Logarithmic Selected Tree's Distance";
    static final String LABELALIGNMENT = "Change Label Alignment...";
    static final String LABELFONT = "Change Label Font...";
    static final String LINEWIDTH = "Change Line Width...";
    static final String COLORSCHEME = "Change Color Scheme...";
    static final String BLOCKSIZE = "Change Image Block Size...";
    static final String BRANCHDENDROGRAM = "Branch Dendrogram";
    static final String BRANCHSUBTABLE = "Branch and Subtable";
    static final String CLASSASSIGNMENT = "Class Assignment...";
    static final String DRAWDISTANCE = "Distance Scale";
    static final String SAVE = "Save...";
    static final String SAVEAS = "Save As...";
    static final String TREEHEIGHT = "Change Tree Height...";
    Color selectedColor = null;
    final JColorChooser colorChooser = new JColorChooser();
    JScrollPane jScrollPane = null;
    TreePanel jPanel_Tree = null;
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jMenuItem_treeColor;
    JMenuItem jMenuItem_treeHeight;
    JMenuItem jMenuItem_LabelAlignment;
    JMenuItem jMenuItem_LineWidth;
    JMenuItem jMenuItem_ColorScheme;
    JMenuItem jMenuItem_BlockSize;
    JMenuItem jMenuItem_Enlarge;
    JMenuItem jMenuItem_Reduce;
    JMenuItem jMenuItem_FitY;
    JMenuItem jMenuItem_FitX;
    JMenuItem jMenuItem_ScaleYDown;
    JMenuItem jMenuItem_ScaleYUp;
    JMenuItem jMenuItem_ScaleXDown;
    JMenuItem jMenuItem_ScaleXUp;
    JMenuItem jMenuItem_Normal;
    JMenuItem jMenuItem_Custom;
    JMenuItem jMenuItem_BranchDendrogram;
    JMenuItem jMenuItem_BranchSubTable;
    JMenuItem jMenuItem_ClassAssignment;
    JCheckBoxMenuItem jMenuItem_DrawDistance;
    JMenuItem jMenuItem_LogarithmicDistance;
    JMenuItem jMenuSave;
    JMenuItem jMenuSaveAs;
    JMenuItem jMenuChangeFont;
    JMenuItem jMenuVacantColor;

    @Override
    public void mouseDragged(MouseEvent e) {
        this.m_tree.m_noChange = false;
        this.jPanel_Tree.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public String[] getSelectedGenes() {
        return this.m_tree != null ? this.m_tree.getSelectedGenes() : null;
    }

    public void SaveAsData() {
        JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
        FileFilter filter1 = FileFilters.getClusterFileFilter();
        FileFilter filter2 = FileFilters.getImageFileFilter();
        chooser.addChoosableFileFilter(filter2);
        chooser.addChoosableFileFilter(filter1);
        chooser.setAcceptAllFileFilterUsed(false);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            String fileName = chooser.getSelectedFile().getPath();
            AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
            try {
                File file;
                String ext = ClUtils.getExtension(chooser.getSelectedFile().getName());
                if (chooser.getFileFilter() instanceof FileFilters.ClusterFileFilter) {
                    if (ext == null || ext == "") {
                        fileName = String.valueOf(fileName) + ".cls";
                    }
                } else if (chooser.getFileFilter() instanceof FileFilters.ImageFileFilter && (ext == null || ext == "")) {
                    fileName = String.valueOf(fileName) + ".png";
                }
                if (filter2.accept(file = new File(fileName))) {
                    BufferedImage img = this.createBufferedImage();
                    if (img != null) {
                        ext = ClUtils.getExtension(file);
                        ImageIO.write((RenderedImage)img, ext, file);
                    }
                } else if (filter1.accept(file)) {
                    this.m_tree.SaveCluster(fileName);
                    this.m_FileName = fileName;
                    this.setTitle(fileName);
                } else {
                    System.out.println("File extension is not matched");
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private BufferedImage createBufferedImage() {
        BufferedImage img = null;
        try {
            int cx = (int)((double)this.m_tree.m_ImageSize[0] * this.m_tree.m_xcoef);
            int cy = (int)((double)this.m_tree.m_ImageSize[1] * this.m_tree.m_ycoef);
            if (this.m_tree.m_Method == 1) {
                cx = (int)((double)this.m_tree.m_ImageSize[0] + (this.m_tree.m_xcoef - 1.0) * (double)this.m_tree.m_gap * (double)this.m_tree.m_cols);
                cy = (int)((double)this.m_tree.m_ImageSize[1] + (this.m_tree.m_ycoef - 1.0) * (double)this.m_tree.m_gap * (double)this.m_tree.m_rows);
            }
            img = new BufferedImage(cx, cy, 1);
            Rectangle rc = new Rectangle(img.getWidth(), img.getHeight());
            Graphics2D g2 = img.createGraphics();
            g2.setBackground(Color.white);
            g2.clearRect(0, 0, cx, cy);
            Image tmpImg = this.m_tree.m_img;
            this.m_tree.m_noChange = false;
            this.m_tree.DrawInGraph(g2, rc);
            this.m_tree.m_img = tmpImg;
            this.m_tree.m_noChange = true;
        }
        catch (OutOfMemoryError ex) {
            JOptionPane.showMessageDialog(this, "The image size is too big. Please resize down further.");
        }
        return img;
    }

    public void SaveData() {
        String fileName;
        if (this.m_FileName.equals("")) {
            JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
            chooser.addChoosableFileFilter(FileFilters.getClusterFileFilter());
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            fileName = chooser.getSelectedFile().getPath();
            AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
            String ext = ClUtils.getExtension(chooser.getSelectedFile().getName());
            if (ext == null || ext == "") {
                fileName = String.valueOf(fileName) + ".cls";
            }
            this.m_FileName = fileName;
            this.setTitle(fileName);
        } else {
            fileName = this.m_FileName;
        }
        this.m_tree.SaveCluster(fileName);
    }

    public ClusterFrame(AppFrame appFrame, Cluster tree, TableFrame tableframe) {
        super("Cluster", true, true, true, true);
        if (tree == null) {
            return;
        }
        appFrame.desktop.add(this);
        this.setVisible(true);
        this.m_tree = tree;
        this.m_tree.m_bOK = false;
        this.m_tree.m_ClusterFrame = this;
        this.m_appFrame = appFrame;
        this.setFrameIcon(this.m_appFrame.imgCluster);
        this.setSizeLocation();
        this.m_TableFrame = tableframe;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_appFrame.replaceToolBar(this.jToolBar);
        this.m_tree.m_bOK = true;
    }

    private void setSizeLocation() {
        int[] loc = this.m_appFrame.getSubWindowLocaton();
        this.setSize(loc[0], loc[1]);
        this.setLocation(loc[2], loc[3]);
        Dimension ss = this.getMinimumSize();
        if (ss.height != AppFrame.m_yOffset) {
            AppFrame.m_xOffset = AppFrame.m_yOffset = this.getMinimumSize().height;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block88: {
            String cmd = e.getActionCommand();
            Object lib = null;
            Object type = null;
            if (cmd.equals(TREECOLOR)) {
                JDialog dialog = JColorChooser.createDialog(this, "Select a color for tree", true, this.colorChooser, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClusterFrame.this.selectedColor = ClusterFrame.this.colorChooser.getColor();
                    }
                }, null);
                dialog.setVisible(true);
                if (this.selectedColor == null) {
                    return;
                }
                ClusterTreeNode.PostOrderTree(this.m_tree.m_SelectedTree, 2, this.selectedColor);
                ClusterTreeNode.PostOrderTree(this.m_tree.m_SelectedTree, 5, new BoolPoint(false, new Point()));
                this.m_tree.DrawSelInGraph((Graphics2D)this.jPanel_Tree.getGraphics(), this.jPanel_Tree.getVisibleRect());
            } else if (cmd.equals("Signature")) {
                ((JButton)e.getSource()).setText("Import Signature");
                BoolPoint operation = new BoolPoint(false, null);
                if (this.m_tree.m_SelectedTree != null) {
                    ClusterTreeNode.PostOrderTree(this.m_tree.m_SelectedTree, 5, operation);
                    this.m_tree.m_SelectedTree = null;
                }
                this.geneList.clear();
                this.pGeneListView = null;
                this.m_bBeginSignature = true;
            } else if (cmd.equals("Import Signature")) {
                ((JButton)e.getSource()).setText("Signature");
                BoolPoint operation = new BoolPoint(false, null);
                if (this.rowTree != null) {
                    ClusterTreeNode.PostOrderTree(this.rowTree, 5, operation);
                    this.rowTree = null;
                }
                if (this.colTree != null) {
                    ClusterTreeNode.PostOrderTree(this.colTree, 5, operation);
                    this.colTree = null;
                }
                this.m_bBeginSignature = false;
            } else if (cmd.equals(VACANTCOLOR)) {
                Color color = JColorChooser.showDialog(this, "Select a color for vacant value", this.m_tree.m_vacantColor);
                if (color != null) {
                    this.m_tree.m_vacantColor = color;
                    this.jPanel_Tree.repaint();
                }
            } else if (cmd.equals(LABELALIGNMENT)) {
                LabelAlignDlg dlg = new LabelAlignDlg((Frame)this.m_appFrame, this, "Set Label Alignment", true);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = this.getSize();
                Point loc = this.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setVisible(true);
            } else if (cmd.equals(BLOCKSIZE)) {
                String oldSize = Integer.toString(this.m_tree.m_gap);
                String newSize = (String)JOptionPane.showInputDialog(this, "Enter your new block size:", "Change Image Block Size", 1, null, null, oldSize);
                if (Integer.parseInt(newSize) > 0) {
                    ClusterTreeNode.m_gap = this.m_tree.m_gap = Integer.parseInt(newSize);
                    this.m_tree.m_bColorImageOk = false;
                    if (this.m_tree.m_Method == 2) {
                        this.m_tree.SetLeafNo();
                    } else {
                        this.m_tree.DetermineDimesion(this.m_tree.m_colTreeHeight, this.m_tree.m_rowTreeHeight);
                    }
                    this.m_tree.setTreePanelSize();
                    this.jPanel_Tree.repaint();
                }
            } else if (cmd.equals(LABELFONT)) {
                FontSelectDlg dlg = new FontSelectDlg(this.m_tree.m_Font.getFamily(), this.m_tree.m_Font.getStyle(), this.m_tree.m_Font.getSize());
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = this.getSize();
                Point loc = this.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
                if (dlg.m_fontFamily != null) {
                    this.m_tree.m_Font = new Font(dlg.m_fontFamily, dlg.m_fontStyle, dlg.m_fontSize);
                    this.m_tree.m_bColorImageOk = false;
                    if (this.m_tree.m_Method == 2) {
                        this.m_tree.SetLeafNo();
                    } else {
                        this.m_tree.DetermineDimesion(this.m_tree.m_colTreeHeight, this.m_tree.m_rowTreeHeight);
                    }
                    this.m_tree.setTreePanelSize();
                    this.jPanel_Tree.repaint();
                }
            } else if (cmd.equals(BRANCHDENDROGRAM)) {
                this.m_tree.BranchTree(false, true, null, null);
            } else if (cmd.equals(BRANCHSUBTABLE)) {
                this.m_tree.BranchTree(true, true, null, null);
            } else if (cmd.equals(CLASSASSIGNMENT)) {
                ClassifyDlg dlg = new ClassifyDlg((Frame)this.m_appFrame, "Classifying Dendrogram", true, this);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = this.getSize();
                Point loc = this.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
            } else if (cmd.equals(COLORSCHEME)) {
                ColorSchemeDlg dlg = new ColorSchemeDlg(null, this, "", true);
                Dimension dlgSize = dlg.getPreferredSize();
                Dimension frmSize = this.getSize();
                Point loc = this.getLocationOnScreen();
                dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
            } else if (cmd.equals(CUSTOMSCALE)) {
                Object[] objectArray = new Object[]{"Enter New Scale:"};
                Object[] ob = objectArray;
                String newCoef = (String)JOptionPane.showInputDialog(this, ob, "Change Image Scale", 1, null, null, "");
                if (Float.parseFloat(newCoef) > 0.0f) {
                    this.m_tree.m_xcoef = Float.parseFloat(newCoef);
                    this.m_tree.m_ycoef = Float.parseFloat(newCoef);
                }
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(DRAWDISTANCE)) {
                this.m_tree.m_bDrawDistance = !this.m_tree.m_bDrawDistance;
                this.m_tree.DrawDistanceInGraph((Graphics2D)this.jPanel_Tree.getGraphics());
            } else if (cmd.equals(ENLARGE)) {
                this.m_tree.m_xcoef *= (double)1.1f;
                this.m_tree.m_ycoef *= (double)1.1f;
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(SCALEXUP)) {
                this.m_tree.m_xcoef *= (double)1.1f;
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(SCALEYUP)) {
                this.m_tree.m_ycoef *= (double)1.1f;
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(SCALEXDOWN)) {
                this.m_tree.m_xcoef *= (double)0.9f;
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(SCALEYDOWN)) {
                this.m_tree.m_ycoef *= (double)0.9f;
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(FITTOWINDOW)) {
                Rectangle rect = this.jScrollPane.getViewportBorderBounds();
                if (this.m_tree.m_Method == 1) {
                    int width = this.m_tree.m_ExtentOfRowLabel + this.m_tree.m_rowTreeHeight;
                    this.m_tree.m_xcoef = rect.getWidth() > (double)width ? (rect.getWidth() - (double)this.m_tree.m_ImageSize[0]) / (double)(this.m_tree.m_gap * this.m_tree.m_cols) + 1.0 : (double)1.4E-45f;
                    int height = this.m_tree.m_ExtentOfColLabel + this.m_tree.m_colTreeHeight;
                    this.m_tree.m_ycoef = rect.getHeight() > (double)height ? (rect.getHeight() - (double)this.m_tree.m_ImageSize[1]) / (double)(this.m_tree.m_gap * this.m_tree.m_rows) + 1.0 : (double)1.4E-45f;
                } else {
                    this.m_tree.m_xcoef = rect.getWidth() / (double)this.m_tree.m_ImageSize[0];
                    this.m_tree.m_ycoef = rect.getHeight() / (double)this.m_tree.m_ImageSize[1];
                }
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(FITTOX)) {
                Rectangle rect = this.jScrollPane.getViewportBorderBounds();
                if (this.m_tree.m_Method == 1) {
                    int width = this.m_tree.m_ExtentOfRowLabel + this.m_tree.m_rowTreeHeight;
                    this.m_tree.m_xcoef = rect.getWidth() > (double)width ? (rect.getWidth() - (double)this.m_tree.m_ImageSize[0]) / (double)(this.m_tree.m_gap * this.m_tree.m_cols) + 1.0 : (double)1.4E-45f;
                } else {
                    this.m_tree.m_xcoef = rect.getWidth() / (double)this.m_tree.m_ImageSize[0];
                }
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(FITTOY)) {
                Rectangle rect = this.jScrollPane.getViewportBorderBounds();
                this.m_tree.setScaleY(rect.height);
                this.jPanel_Tree.repaint();
                this.setButtonState();
            } else if (cmd.equals(LINEWIDTH)) {
                String oldWidth = Float.toString(this.m_tree.m_SelectedTree.m_penWidth);
                String newWidth = (String)JOptionPane.showInputDialog(this, "Enter Width of Line:", "Change Line Width", 1, null, null, oldWidth);
                if (Float.parseFloat(newWidth) > 0.0f) {
                    Float operation = Float.valueOf(newWidth);
                    ClusterTreeNode.PostOrderTree(this.m_tree.m_SelectedTree, 8, operation);
                    this.m_tree.DrawSelInGraph((Graphics2D)this.jPanel_Tree.getGraphics(), this.jPanel_Tree.getVisibleRect());
                }
            } else if (cmd.equals(NORMALSIZE)) {
                this.m_tree.m_xcoef = 1.0;
                this.m_tree.m_ycoef = 1.0;
                this.setButtonState();
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
            } else if (cmd.equals(REDUCE)) {
                this.m_tree.m_xcoef *= (double)0.9f;
                this.m_tree.m_ycoef *= (double)0.9f;
                this.setButtonState();
                this.m_tree.setTreePanelSize();
                this.jPanel_Tree.repaint();
            } else if (cmd.equals(LOGARITHMIC)) {
                int ret = JOptionPane.showConfirmDialog(this, "Change Logarithmic the State of Selected Tree's Distance?", "Change Logarithmic the State of Distancne", 0, 3);
                if (ret == 0) {
                    if (this.m_tree.m_bRowSelected) {
                        this.m_tree.m_bRLogExp = !this.m_tree.m_bRLogExp;
                    } else if (this.m_tree.m_bColSelected) {
                        this.m_tree.m_bCLogExp = !this.m_tree.m_bCLogExp;
                    } else {
                        System.out.println("No tree selected!!!");
                    }
                    this.m_tree.DetermineDimesion(this.m_tree.m_colTreeHeight, this.m_tree.m_rowTreeHeight);
                    this.jPanel_Tree.repaint();
                }
            } else if (cmd.equals(TREEHEIGHT)) {
                String oldHeight;
                if (this.m_tree.m_ColTree.m_bSelected) {
                    oldHeight = Integer.toString(this.m_tree.m_colTreeHeight);
                } else if (this.m_tree.m_RowTree.m_bSelected) {
                    oldHeight = Integer.toString(this.m_tree.m_rowTreeHeight);
                } else {
                    return;
                }
                String newHeight = (String)JOptionPane.showInputDialog(this, "Please enter new tree height:", "Tree Height", 3, null, null, oldHeight);
                try {
                    int height = Integer.parseInt(newHeight);
                    if (height <= 0) break block88;
                    if (this.m_tree.m_Method == 0) {
                        this.m_tree.m_rowTreeHeight = height;
                        this.m_tree.DetermineDimesion(ClusterTreeNode.m_treeHeight, height);
                        break block88;
                    }
                    if (this.m_tree.m_ColTree.m_bSelected) {
                        this.m_tree.m_colTreeHeight = height;
                        this.m_tree.DetermineDimesion(height, this.m_tree.m_rowTreeHeight);
                    } else {
                        this.m_tree.m_rowTreeHeight = height;
                        this.m_tree.DetermineDimesion(this.m_tree.m_colTreeHeight, height);
                    }
                    this.m_tree.setTreePanelSize();
                    this.jPanel_Tree.repaint();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, "Invalid tree height entered: number was expected.");
                }
            } else if (cmd.equals(SAVE)) {
                this.SaveData();
            } else if (cmd.equals(SAVEAS)) {
                this.SaveAsData();
            } else if (cmd.equals("Save As High Resolution Image (tiff)")) {
                HighResImage.SaveHighResImage(this, this.createBufferedImage());
            }
        }
    }

    private void jbInit() throws Exception {
        this.jMenuItem_treeColor = new JMenuItem(TREECOLOR, this.m_appFrame.imgTreeColor);
        this.jMenuItem_treeColor.addActionListener(this);
        this.jMenuItem_treeHeight = new JMenuItem(TREEHEIGHT);
        this.jMenuItem_treeHeight.addActionListener(this);
        this.jMenuItem_LabelAlignment = new JMenuItem(LABELALIGNMENT);
        this.jMenuItem_LabelAlignment.addActionListener(this);
        this.jMenuItem_LineWidth = new JMenuItem(LINEWIDTH);
        this.jMenuItem_LineWidth.addActionListener(this);
        this.jMenuItem_ColorScheme = new JMenuItem(COLORSCHEME);
        this.jMenuItem_ColorScheme.addActionListener(this);
        this.jMenuItem_BlockSize = new JMenuItem(BLOCKSIZE);
        this.jMenuItem_BlockSize.addActionListener(this);
        this.jMenuItem_Enlarge = new JMenuItem(ENLARGE, this.m_appFrame.imgEnlarge);
        this.jMenuItem_Enlarge.addActionListener(this);
        this.jMenuItem_Reduce = new JMenuItem(REDUCE, this.m_appFrame.imgReduce);
        this.jMenuItem_Reduce.addActionListener(this);
        this.jMenuItem_ScaleYDown = new JMenuItem(SCALEYDOWN, this.m_appFrame.imgScaleYDown);
        this.jMenuItem_ScaleYDown.addActionListener(this);
        this.jMenuItem_ScaleYUp = new JMenuItem(SCALEYUP, this.m_appFrame.imgScaleYUp);
        this.jMenuItem_ScaleYUp.addActionListener(this);
        this.jMenuItem_ScaleXDown = new JMenuItem(SCALEXDOWN, this.m_appFrame.imgScaleXDown);
        this.jMenuItem_ScaleXDown.addActionListener(this);
        this.jMenuItem_ScaleXUp = new JMenuItem(SCALEXUP, this.m_appFrame.imgScaleXUp);
        this.jMenuItem_ScaleXUp.addActionListener(this);
        this.jMenuItem_FitY = new JMenuItem(FITTOY, this.m_appFrame.imgFitY);
        this.jMenuItem_FitY.addActionListener(this);
        this.jMenuItem_FitX = new JMenuItem(FITTOX, this.m_appFrame.imgFitX);
        this.jMenuItem_FitX.addActionListener(this);
        this.jMenuItem_Normal = new JMenuItem(NORMALSIZE, this.m_appFrame.imgActualSize);
        this.jMenuItem_Normal.addActionListener(this);
        this.jMenuItem_Custom = new JMenuItem(CUSTOMSCALE);
        this.jMenuItem_Custom.addActionListener(this);
        this.jMenuItem_BranchDendrogram = new JMenuItem(BRANCHDENDROGRAM);
        this.jMenuItem_BranchDendrogram.addActionListener(this);
        this.jMenuItem_BranchSubTable = new JMenuItem(BRANCHSUBTABLE);
        this.jMenuItem_BranchSubTable.addActionListener(this);
        this.jMenuItem_ClassAssignment = new JMenuItem(CLASSASSIGNMENT);
        this.jMenuItem_ClassAssignment.addActionListener(this);
        this.jMenuItem_DrawDistance = new JCheckBoxMenuItem(DRAWDISTANCE);
        this.jMenuItem_DrawDistance.addActionListener(this);
        this.jMenuItem_LogarithmicDistance = new JMenuItem(LOGARITHMIC);
        this.jMenuItem_LogarithmicDistance.addActionListener(this);
        this.jMenuVacantColor = new JMenuItem(VACANTCOLOR);
        this.jMenuVacantColor.addActionListener(this);
        this.jMenuChangeFont = new JMenuItem(LABELFONT, this.m_appFrame.imgFont);
        this.jMenuChangeFont.addActionListener(this);
        this.jMenuSave = new JMenuItem(SAVE);
        this.jMenuSave.addActionListener(this);
        this.jMenuSaveAs = new JMenuItem(SAVEAS);
        this.jMenuSaveAs.addActionListener(this);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuItem_treeColor);
        this.jPopupMenu.add(this.jMenuItem_LogarithmicDistance);
        this.jPopupMenu.add(this.jMenuItem_treeHeight);
        this.jPopupMenu.add(this.jMenuItem_LabelAlignment);
        this.jPopupMenu.add(this.jMenuChangeFont);
        this.jPopupMenu.add(this.jMenuItem_LineWidth);
        this.jPopupMenu.add(this.jMenuItem_ColorScheme);
        this.jPopupMenu.add(this.jMenuItem_BlockSize);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuItem_ScaleXDown);
        this.jPopupMenu.add(this.jMenuItem_ScaleXUp);
        this.jPopupMenu.add(this.jMenuItem_ScaleYDown);
        this.jPopupMenu.add(this.jMenuItem_ScaleYUp);
        this.jPopupMenu.add(this.jMenuItem_FitY);
        this.jPopupMenu.add(this.jMenuItem_FitX);
        this.jPopupMenu.add(this.jMenuItem_Normal);
        this.jPopupMenu.add(this.jMenuItem_Custom);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuItem_BranchDendrogram);
        this.jPopupMenu.add(this.jMenuItem_BranchSubTable);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuItem_ClassAssignment);
        this.jPopupMenu.add(this.jMenuItem_DrawDistance);
        this.jPopupMenu.addSeparator();
        this.jPopupMenu.add(this.jMenuSave);
        this.jPopupMenu.add(this.jMenuSaveAs);
        JMenuItem jMenuSaveHighResImage = new JMenuItem("Save As High Resolution Image (tiff)");
        jMenuSaveHighResImage.addActionListener(this);
        this.jPopupMenu.add(jMenuSaveHighResImage);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addInternalFrameListener(new ClusterFrame_this_internalFrameAdapter(this));
        this.jAddToGeneList.addActionListener(this);
        this.jEnlarge = new JButton(this.m_appFrame.imgEnlarge);
        this.jEnlarge.addActionListener(this);
        this.jEnlarge.setActionCommand(ENLARGE);
        this.jEnlarge.setToolTipText(ENLARGE);
        this.jReduce = new JButton(this.m_appFrame.imgReduce);
        this.jReduce.addActionListener(this);
        this.jReduce.setActionCommand(REDUCE);
        this.jReduce.setToolTipText(REDUCE);
        this.jFont = new JButton(this.m_appFrame.imgFont);
        this.jFont.addActionListener(this);
        this.jFont.setToolTipText(LABELFONT);
        this.jFont.setActionCommand(LABELFONT);
        this.jFitX = new JButton(this.m_appFrame.imgFitX);
        this.jFitX.addActionListener(this);
        this.jFitX.setActionCommand(FITTOX);
        this.jFitX.setToolTipText(FITTOX);
        this.jFitWindow = new JButton(this.m_appFrame.imgFitWindow);
        this.jFitWindow.addActionListener(this);
        this.jFitWindow.setActionCommand(FITTOWINDOW);
        this.jFitWindow.setToolTipText(FITTOWINDOW);
        this.jFitY = new JButton(this.m_appFrame.imgFitY);
        this.jFitY.addActionListener(this);
        this.jFitY.setActionCommand(FITTOY);
        this.jFitY.setToolTipText(FITTOY);
        this.jScaleXUp = new JButton(this.m_appFrame.imgScaleXUp);
        this.jScaleXUp.addActionListener(this);
        this.jScaleXUp.setActionCommand(SCALEXUP);
        this.jScaleXUp.setToolTipText(SCALEXUP);
        this.jScaleYUp = new JButton(this.m_appFrame.imgScaleYUp);
        this.jScaleYUp.addActionListener(this);
        this.jScaleYUp.setActionCommand(SCALEYUP);
        this.jScaleYUp.setToolTipText(SCALEYUP);
        this.jScaleXDown = new JButton(this.m_appFrame.imgScaleXDown);
        this.jScaleXDown.addActionListener(this);
        this.jScaleXDown.setActionCommand(SCALEXDOWN);
        this.jScaleXDown.setToolTipText(SCALEXDOWN);
        this.jScaleYDown = new JButton(this.m_appFrame.imgScaleYDown);
        this.jScaleYDown.addActionListener(this);
        this.jScaleYDown.setActionCommand(SCALEYDOWN);
        this.jScaleYDown.setToolTipText(SCALEYDOWN);
        this.jActualSize = new JButton(this.m_appFrame.imgActualSize);
        this.jActualSize.addActionListener(this);
        this.jActualSize.setActionCommand(NORMALSIZE);
        this.jActualSize.setToolTipText(NORMALSIZE);
        this.jTreeColor = new JButton(this.m_appFrame.imgTreeColor);
        this.jTreeColor.addActionListener(this);
        this.jTreeColor.setActionCommand(TREECOLOR);
        this.jTreeColor.setToolTipText(TREECOLOR);
        this.jSave = new JButton(this.m_appFrame.imgSave);
        this.jSave.addActionListener(this);
        this.jSave.setActionCommand(SAVE);
        this.jSave.setToolTipText(SAVE);
        this.jToolBar.add(this.jSave);
        this.jToolBar.add(this.jEnlarge);
        this.jToolBar.add(this.jReduce);
        this.jToolBar.add(this.jFitWindow);
        this.jToolBar.add(this.jActualSize);
        this.jToolBar.add(this.jScaleXUp);
        this.jToolBar.add(this.jScaleXDown);
        this.jToolBar.add(this.jFitX);
        this.jToolBar.add(this.jScaleYUp);
        this.jToolBar.add(this.jScaleYDown);
        this.jToolBar.add(this.jFitY);
        this.jToolBar.add(this.jTreeColor);
        this.jToolBar.add(this.jFont);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.getVerticalScrollBar().addMouseMotionListener(this);
        this.jScrollPane.getHorizontalScrollBar().addMouseMotionListener(this);
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.jPanel_Tree = new TreePanel();
        this.m_tree.setTreePanelSize();
        this.jPanel_Tree.addMouseMotionListener(new ClusterFrame_jPanel_Tree_mouseMotionAdapter(this));
        this.jPanel_Tree.setBackground(Color.white);
        this.jPanel_Tree.addMouseListener(new ClusterFrame_jPanel_Tree_mouseAdapter(this));
        this.jScrollPane.getViewport().add((Component)this.jPanel_Tree, null);
    }

    void jPanel_Tree_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.setMenuItemState();
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.m_mDown == null) {
            return;
        }
        if (e.getButton() == 1) {
            this.jPanel_Tree.drawRubberBox(this.m_mDown, this.m_mMove);
            if (this.m_tree.m_ColorImageArea.contains(this.m_mDown)) {
                this.m_tree.GenSubDendrogram(this.m_mDown, this.m_mMove);
            }
        }
    }

    void jPanel_Tree_mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.m_mMove = this.m_mDown = e.getPoint();
    }

    void jPanel_Tree_mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 16) {
            if (this.m_mDown == null) {
                return;
            }
            if (this.m_tree.m_ColorImageArea.contains(this.m_mDown)) {
                this.jPanel_Tree.drawRubberBox(this.m_mDown, this.m_mMove);
                this.m_mMove = e.getPoint();
                this.jPanel_Tree.drawRubberBox(this.m_mDown, this.m_mMove);
            }
        }
    }

    private void addToGeneListView() {
        String[] rLabel = new String[this.geneList.size()];
        String[] cLabel = new String[]{"Gene ID", "Average intensity"};
        Object[][] data = new String[this.geneList.size()][2];
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        int i = 0;
        while (i < this.geneList.size()) {
            rLabel[i] = "R" + (i + 1);
            data[i][0] = this.m_tree.m_RowLabel[this.geneList.get(i)];
            data[i][1] = nf.format(this.avgIntensity.get(i));
            ++i;
        }
        MyTableModel dm = new MyTableModel(data, rLabel, cLabel);
        if (this.pGeneListView == null) {
            this.pGeneListView = new TableFrame(this.m_appFrame, dm);
            int width = 230;
            Dimension size = this.m_appFrame.getSize();
            this.pGeneListView.setSize(width, size.height);
            this.pGeneListView.setLocation(size.width - width - 8, 0);
        } else {
            this.pGeneListView.jTable.setModel(dm);
        }
        this.pGeneListView.jTable.repaint();
        this.pGeneListView.toFront();
        JPopupMenu popup = this.pGeneListView.getPopupMenu();
        JMenuItem save_mi = new JMenuItem("Save Signature");
        popup.add(save_mi);
    }

    void jPanel_Tree_mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.m_tree.m_Method != 2) {
            Point pt = e.getPoint();
            this.m_tree.restorePoint(pt);
            BoolPoint operation = new BoolPoint(false, pt);
            ClusterTreeNode sel = null;
            ClusterTreeNode from = null;
            boolean isRow = true;
            if (this.m_tree.m_rowTreeArea.contains(pt)) {
                this.m_tree.translatePoint(pt, true);
                from = this.m_tree.m_RowTree;
            } else if (this.m_tree.m_colTreeArea.contains(pt)) {
                this.m_tree.translatePoint(pt, false);
                from = this.m_tree.m_ColTree;
                isRow = false;
            }
            sel = ClusterTreeNode.PostOrderTree(from, 4, operation);
            if (sel != this.m_tree.m_SelectedTree) {
                ClusterTreeNode.PostOrderTree(this.m_tree.m_SelectedTree, 5, operation);
                operation.m_bHoriz = true;
                ClusterTreeNode.PostOrderTree(sel, 5, operation);
                this.m_tree.DrawSelInGraph((Graphics2D)this.jPanel_Tree.getGraphics(), this.jPanel_Tree.getVisibleRect());
                this.m_tree.m_SelectedTree = sel;
                this.m_tree.m_bRowSelected = isRow;
                this.m_tree.m_bColSelected = !isRow;
                this.m_tree.DrawSelInGraph((Graphics2D)this.jPanel_Tree.getGraphics(), this.jPanel_Tree.getVisibleRect());
            }
            this.setButtonState();
        }
    }

    private void setMenuItemState() {
        this.jMenuItem_treeColor.setEnabled(this.m_tree.m_SelectedTree != null);
        this.jMenuItem_LineWidth.setEnabled(this.m_tree.m_SelectedTree != null);
        this.jMenuItem_treeHeight.setEnabled(this.m_tree.m_ColTree != null && this.m_tree.m_ColTree.m_bSelected || this.m_tree.m_RowTree != null && this.m_tree.m_RowTree.m_bSelected);
        this.jMenuItem_Normal.setEnabled(this.m_tree.m_xcoef != 1.0 || this.m_tree.m_ycoef != 1.0);
        this.jMenuItem_BranchDendrogram.setEnabled(this.m_tree.m_SelectedTree != null);
        this.jMenuItem_BranchSubTable.setEnabled(this.m_tree.m_SelectedTree != null);
        this.jMenuItem_ColorScheme.setEnabled(this.m_tree.m_Method != 0);
        this.jMenuItem_BlockSize.setEnabled(this.m_tree.m_Method != 0);
        this.jMenuItem_ClassAssignment.setEnabled(this.m_tree.m_Method != 2);
        this.jMenuItem_DrawDistance.setState(this.m_tree.m_bDrawDistance && this.m_tree.m_Method != 2);
        this.jMenuItem_DrawDistance.setEnabled(this.m_tree.m_Method != 2);
        this.jMenuItem_LogarithmicDistance.setEnabled(this.m_tree.m_ColTree != null && this.m_tree.m_ColTree.m_bSelected || this.m_tree.m_RowTree != null && this.m_tree.m_RowTree.m_bSelected);
    }

    private void setButtonState() {
        this.jTreeColor.setEnabled(this.m_tree.m_SelectedTree != null);
        this.jActualSize.setEnabled(this.m_tree.m_xcoef != 1.0 || this.m_tree.m_ycoef != 1.0);
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        this.m_appFrame.replaceToolBar(this.jToolBar);
        this.setButtonState();
    }

    void this_internalFrameDeactivated(InternalFrameEvent e) {
        this.m_appFrame.replaceToolBar(this.m_appFrame.jToolBar);
    }

    void this_internalFrameClosing(InternalFrameEvent e) {
        this.m_appFrame.replaceToolBar(this.m_appFrame.jToolBar);
    }

    class TreePanel
    extends JPanel {
        Rectangle m_vrc = null;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ClusterFrame.this.m_tree.m_bOK) {
                Rectangle rc = this.getVisibleRect();
                if (!rc.equals(this.m_vrc)) {
                    this.m_vrc = rc;
                    ClusterFrame.this.m_tree.m_noChange = false;
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                ClusterFrame.this.m_tree.DrawInGraph(g2d, rc);
            }
        }

        public void drawRubberBox(Point pt1, Point pt2) {
            if (pt1 == null || pt2 == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            float[] dashPattern = new float[]{1.0f, 1.5f};
            int w = pt2.x - pt1.x;
            int h = pt2.y - pt1.y;
            g2.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, dashPattern, 0.0f));
            g2.setXORMode(Color.gray);
            g2.drawRect(pt1.x, pt1.y, w, h);
        }
    }
}

