/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.Algorithm;
import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.BoolPoint;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterTreeNode;
import NCTR.app.arraytrack.vs2.analysis.clustering.DrawNode;
import NCTR.app.arraytrack.vs2.analysis.clustering.GenesSelectable;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class Cluster
implements Runnable,
GenesSelectable {
    public static final int MAHATTON = 0;
    public static final int EUCILIDEAN = 1;
    public static final int CORELATION = 2;
    public static final int SINGLE = 0;
    public static final int COMPLETE = 1;
    public static final int AVERAGE = 2;
    public static final int CENTROID = 3;
    public static final int MEDIAN = 4;
    public static final int MINIMUMVARIANCE = 5;
    public static final int SINGLECLUSTER = 0;
    public static final int DUALCLUSTER = 1;
    public static final int IMAGECOLOR = 2;
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public float[][] m_Data = null;
    public int m_Method = 0;
    public ClusterTreeNode m_RowTree = null;
    public ClusterTreeNode m_ColTree = null;
    public double m_xcoef = 1.0;
    public double m_ycoef = 1.0;
    public ClusterTreeNode m_SelectedTree = null;
    public boolean m_bRowSelected = false;
    public boolean m_bColSelected = false;
    public boolean m_bDrawDistance = false;
    public Rectangle m_rowTreeArea = new Rectangle();
    public Rectangle m_colTreeArea = new Rectangle();
    public Rectangle m_ColorImageArea = new Rectangle();
    public int m_rowTreeHeight = 100;
    public int m_colTreeHeight = 100;
    public boolean m_bRLogExp = true;
    public boolean m_bCLogExp = true;
    public boolean m_bColLeftAlignment = false;
    public boolean m_bRowLeftAlignment = false;
    public int m_gap = 16;
    public boolean m_bColorImageOk = false;
    public int[] m_ImageSize = new int[2];
    public double m_max;
    public double m_min;
    public double m_medianLow;
    public double m_medianUp;
    public int m_Legandheight = 40;
    public Color m_ColorMin;
    public Color m_ColorMedianLow;
    public Color m_ColorMedianUp;
    public Color m_ColorMax;
    public static AppFrame m_appFrame = null;
    public ClusterFrame m_ClusterFrame = null;
    public Font m_Font;
    public String[] m_RowLabel = null;
    public String[] m_ColLabel = null;
    public boolean m_bOK = false;
    public int m_rows = 0;
    public int m_cols = 0;
    public Color m_vacantColor = Color.gray;
    private static int m_Limit = 1000;
    private int m_headerHeight = -1;
    private int m_Dissimilarity = 5;
    private int m_Metric = 0;
    private boolean m_bNormalize = false;
    private boolean m_bSortValue = false;
    private int m_defaultTreeHeight;
    private boolean m_bHeader;
    private double[] m_rExp;
    private double[] m_cExp;
    private int[] m_colLeafNo;
    private int[] m_rowLeafNo;
    private String m_strHead;
    private TableFrame m_TableFrame;
    private int m_minBit;
    private int m_RGBMax;
    private static Thread m_thread = null;
    static int m_count = 0;
    static boolean m_bWorking = false;
    private static float m_minLimit = 5.0f;
    public int m_ExtentOfRowLabel;
    public int m_ExtentOfColLabel;
    private List<String>[] m_GroupColNames;
    Image m_img;
    boolean m_noChange;
    private boolean m_bFlagData;
    private int m_r;
    private int m_g;
    private int m_b;
    private static int m_treeHeatmapGap = 1;

    public Cluster() {
        ClusterTreeNode.m_treeHeight = 100;
        this.m_defaultTreeHeight = 100;
        this.m_bHeader = false;
        this.m_rExp = new double[]{0.0, 0.0};
        this.m_cExp = new double[]{0.0, 0.0};
        this.m_colLeafNo = null;
        this.m_rowLeafNo = null;
        this.m_strHead = null;
        this.m_TableFrame = null;
        this.m_minBit = 0;
        this.m_RGBMax = 255;
        this.m_ExtentOfRowLabel = 0;
        this.m_ExtentOfColLabel = 0;
        this.m_GroupColNames = null;
        this.m_img = null;
        this.m_noChange = false;
        this.m_bFlagData = false;
        this.m_Font = new Font("Arial", 0, 12);
        AbstractAction upDataStatus = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (m_bWorking) {
                    String str = " Waiting";
                    int i = 0;
                    while (i < m_count) {
                        str = String.valueOf(str) + ".";
                        ++i;
                    }
                    Cluster.m_appFrame.statusBar.setText(str);
                    if (++m_count > 200) {
                        m_count = 0;
                    }
                } else {
                    Cluster.m_appFrame.statusBar.setText(" Ready");
                }
                Cluster.m_appFrame.statusBar.revalidate();
            }
        };
        if (m_appFrame != null) {
            new Timer(500, upDataStatus).start();
        }
    }

    public void setFlaged(boolean isFlagData) {
        this.m_bFlagData = isFlagData;
    }

    public static void stop() {
        if (m_bWorking) {
            m_bWorking = false;
        }
        Cluster.m_appFrame.jStopThread.setEnabled(false);
        Thread tmp = m_thread;
        m_thread = null;
        tmp.stop();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void start() {
        if (!m_bWorking) {
            m_thread = new Thread(this);
            m_thread.start();
        }
    }

    private void DrawDistance(Graphics2D g2, Point p1, Point p2, double min, double max, boolean bLogExp) {
        if (this.m_bDrawDistance) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(Color.white);
        }
        String[] bs = new String[5];
        if (bLogExp) {
            if (min < 1.0) {
                min = Math.log(min + 1.0);
                max = Math.log(max + 1.0);
            } else {
                min = Math.log(min);
                max = Math.log(max);
            }
        }
        DecimalFormat format = new DecimalFormat("0.###");
        int i = 0;
        while (i < bs.length) {
            bs[i] = format.format(min + (max - min) / 4.0 * (double)i);
            ++i;
        }
        float dh = 0.0f;
        if (bs[4] != null && bs[4].length() > 0) {
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout layout = new TextLayout(bs[4], this.m_Font, frc);
            Rectangle2D rect = layout.getBounds();
            dh = (float)rect.getHeight() / 2.0f;
            g2.setColor(Color.black);
        }
        if (p1.x == p2.x && p1.y != p2.y) {
            g2.drawLine(p1.x, p1.y, p1.x + 5, p1.y);
            g2.drawLine(p2.x, p2.y, p2.x + 5, p2.y);
            int dy = p2.y - p1.y;
            g2.drawLine(p1.x, p1.y + dy / 4, p1.x + 5, p1.y + dy / 4);
            g2.drawLine(p1.x, p2.y - dy / 4, p2.x + 5, p2.y - dy / 4);
            g2.drawLine(p1.x, p2.y - dy / 2, p2.x + 5, p2.y - dy / 2);
            g2.drawString(bs[0], (float)(p1.x + 7), (float)p2.y + dh);
            g2.drawString(bs[1], (float)(p1.x + 7), (float)(p2.y - dy / 4) + dh);
            g2.drawString(bs[2], (float)(p1.x + 7), (float)(p2.y - dy / 2) + dh);
            g2.drawString(bs[3], (float)(p1.x + 7), (float)(p1.y + dy / 4) + dh);
            g2.drawString(bs[4], (float)(p1.x + 7), (float)p1.y + dh);
        } else if (p1.x != p2.x && p1.y == p2.y) {
            g2.drawLine(p1.x, p1.y, p1.x, p1.y + 5);
            g2.drawLine(p2.x, p2.y, p2.x, p2.y + 5);
            int dx = p2.x - p1.x;
            g2.drawLine(p1.x + dx / 4, p1.y, p1.x + dx / 4, p1.y + 5);
            g2.drawLine(p2.x - dx / 4, p2.y, p2.x - dx / 4, p2.y + 5);
            g2.drawLine(p2.x - dx / 2, p2.y, p2.x - dx / 2, p2.y + 5);
            g2.translate(p1.x, p1.y);
            double angle = 1.5707963267948966;
            g2.rotate(angle);
            g2.drawString(bs[0], 7.0f, dh);
            g2.drawString(bs[1], 7.0f, (float)(-dx / 4) + dh);
            g2.drawString(bs[2], 7.0f, (float)(-dx / 2) + dh);
            g2.drawString(bs[3], 7.0f, (float)(-dx) * 0.75f + dh);
            g2.drawString(bs[4], 7.0f, (float)(-dx) + dh);
            g2.rotate(-angle);
            g2.translate(-p1.x, -p1.y);
        } else {
            return;
        }
        g2.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    private float[][] DisOfMatrix(float[][] x, int[] c, double[] minMaxExp) {
        int size = x.length - 1;
        int cols = x[0].length;
        int rows = x.length;
        if (rows < 1 || cols < 1) {
            return null;
        }
        minMaxExp[0] = Double.MAX_VALUE;
        float[][] dis = new float[size][];
        int i = 0;
        while (i < size) {
            dis[i] = new float[size - i];
            ++i;
        }
        switch (this.m_Metric) {
            case 0: {
                int j;
                int m;
                i = 0;
                while (i < size) {
                    m = 0;
                    j = i + 1;
                    while (j < rows) {
                        double dt = 0.0;
                        int count = 0;
                        int k = 0;
                        while (k < cols) {
                            if (!Float.isNaN(x[i][k]) && !Float.isNaN(x[j][k])) {
                                dt += (double)Math.abs(x[i][k] - x[j][k]);
                                ++count;
                            }
                            ++k;
                        }
                        dis[i][m++] = (float)(dt /= (double)count);
                        if (minMaxExp[0] > dt) {
                            minMaxExp[0] = dt;
                            c[0] = i;
                            c[1] = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int j;
                int m;
                i = 0;
                while (i < size) {
                    m = 0;
                    j = i + 1;
                    while (j < rows) {
                        double dt = 0.0;
                        double tmp = 0.0;
                        int count = 0;
                        int k = 0;
                        while (k < cols) {
                            if (!Float.isNaN(x[i][k]) && !Float.isNaN(x[j][k])) {
                                tmp = x[i][k] - x[j][k];
                                dt += tmp * tmp;
                                ++count;
                            }
                            ++k;
                        }
                        dt = this.m_Dissimilarity == 5 ? dt / 2.0 / (double)count : Math.sqrt(dt / (double)count);
                        dis[i][m++] = (float)dt;
                        if (minMaxExp[0] > dt) {
                            minMaxExp[0] = dt;
                            c[0] = i;
                            c[1] = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int j;
                double[] avg = new double[rows];
                int i2 = 0;
                while (i2 < rows) {
                    avg[i2] = 0.0;
                    int count = 0;
                    j = 0;
                    while (j < cols) {
                        if (!Double.isNaN(x[i2][j])) {
                            int n = i2;
                            avg[n] = avg[n] + (double)x[i2][j];
                            ++count;
                        }
                        ++j;
                    }
                    int n = i2++;
                    avg[n] = avg[n] / (double)count;
                }
                i2 = 0;
                while (i2 < size) {
                    int m = 0;
                    j = i2 + 1;
                    while (j < rows) {
                        double si = 0.0;
                        double sj = 0.0;
                        double sij = 0.0;
                        double ti = 0.0;
                        double tj = 0.0;
                        double dt = 0.0;
                        int k = 0;
                        while (k < cols) {
                            if (!Float.isNaN(x[i2][k]) && !Float.isNaN(x[j][k])) {
                                ti = (double)x[i2][k] - avg[i2];
                                tj = (double)x[j][k] - avg[j];
                                si += ti * ti;
                                sj += tj * tj;
                                sij += ti * tj;
                            }
                            ++k;
                        }
                        dt = si == 0.0 || sj == 0.0 ? 0.0 : 1.0 - sij / Math.sqrt(si * sj);
                        dis[i2][m++] = (float)dt;
                        if (minMaxExp[0] > dt) {
                            minMaxExp[0] = dt;
                            c[0] = i2;
                            c[1] = j;
                        }
                        ++j;
                    }
                    ++i2;
                }
                break;
            }
        }
        i = 0;
        while (i < dis.length) {
            int j = 0;
            while (j < dis[i].length) {
                if (Float.isNaN(dis[i][j]) || Float.isInfinite(dis[i][j])) {
                    ClUtils.ErrorMessage("Too many null values in data!");
                    Cluster.stop();
                }
                ++j;
            }
            ++i;
        }
        return dis;
    }

    private float[][] RefreshDistance(double[] Exp, int[] c, float[][] dis, int c_1, int c_2, int[] ChildNum, LinkedList UnClustered) {
        int size = dis.length;
        double Dki = 0.0;
        double Dkj = 0.0;
        double Dij = 0.0;
        int m = 0;
        int c_3 = -1;
        int njk = -1;
        int nFirst = 0;
        int nSecond = -1;
        Exp[0] = Double.MAX_VALUE;
        float[][] newdis = new float[size - 1][];
        int i = 0;
        while (i < size - 1) {
            newdis[i] = new float[size - i - 1];
            ++i;
        }
        i = 0;
        while (i <= size) {
            if (i != c[0] && i != c[1]) {
                Dki = i > c[0] ? dis[c[0]][i - c[0] - 1] : dis[i][c[0] - i - 1];
                Dkj = i > c[1] ? dis[c[1]][i - c[1] - 1] : dis[i][c[1] - i - 1];
                switch (this.m_Dissimilarity) {
                    case 0: {
                        newdis[0][m] = (float)Math.min(Dki, Dkj);
                        break;
                    }
                    case 1: {
                        newdis[0][m] = (float)Math.max(Dki, Dkj);
                        break;
                    }
                    case 2: {
                        newdis[0][m] = (float)((Dki * (double)ChildNum[c_1] + Dkj * (double)ChildNum[c_2]) / (double)(ChildNum[c_1] + ChildNum[c_2]));
                        break;
                    }
                    case 3: {
                        Dij = dis[c[0]][c[1] - c[0] - 1];
                        njk = ChildNum[c_1] + ChildNum[c_2];
                        newdis[0][m] = (float)((Dki * (double)ChildNum[c_1] + Dkj * (double)ChildNum[c_2]) / (double)njk - Dij * (double)ChildNum[c_1] * (double)ChildNum[c_2] / (double)njk / (double)njk);
                        break;
                    }
                    case 4: {
                        Dij = dis[c[0]][c[1] - c[0] - 1];
                        newdis[0][m] = (float)(0.5 * Dki + 0.5 * Dkj - 0.25 * Dij);
                        break;
                    }
                    case 5: {
                        Dij = dis[c[0]][c[1] - c[0] - 1];
                        c_3 = (Integer)UnClustered.get(i);
                        newdis[0][m] = (float)(((double)(ChildNum[c_1] + ChildNum[c_3]) * Dki + (double)(ChildNum[c_2] + ChildNum[c_3]) * Dkj - (double)ChildNum[c_3] * Dij) / (double)(ChildNum[c_1] + ChildNum[c_2] + ChildNum[c_3]));
                    }
                }
                int n = m++;
                if ((double)newdis[0][n] < Exp[0]) {
                    Exp[0] = newdis[0][m - 1];
                    nSecond = m;
                }
            }
            ++i;
        }
        int k = 1;
        int i2 = 0;
        while (i2 < size) {
            if (i2 != c[0] && i2 != c[1]) {
                int l = 0;
                int j = i2 + 1;
                while (j <= size) {
                    if (j != c[0] && j != c[1]) {
                        newdis[k][l++] = dis[i2][j - i2 - 1];
                        if (Exp[0] > (double)newdis[k][l - 1]) {
                            Exp[0] = newdis[k][l - 1];
                            nFirst = k;
                            nSecond = l + nFirst;
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i2;
        }
        c[0] = nFirst;
        c[1] = nSecond;
        return newdis;
    }

    private ClusterTreeNode ClusterProcess(float[][] data, float[] value, double[] minMaxExp) {
        int nNumOfS;
        int[] c = new int[2];
        float[][] tmp = this.DisOfMatrix(data, c, minMaxExp);
        float[][] dis = null;
        if (this.m_Dissimilarity == 3 || this.m_Dissimilarity == 4) {
            minMaxExp[0] = 0.0;
        }
        double[] Exp = new double[]{minMaxExp[0]};
        int nCounter = nNumOfS = tmp.length + 1;
        int[] ChildNum = new int[2 * nNumOfS];
        LinkedList<Integer> UnClustered = new LinkedList<Integer>();
        LinkedList<ClusterTreeNode> Tree = new LinkedList<ClusterTreeNode>();
        int i = 0;
        while (i < nNumOfS) {
            Tree.addLast(new ClusterTreeNode(i, value[i]));
            ChildNum[i] = 1;
            UnClustered.addLast(new Integer(i));
            ++i;
        }
        int size = nNumOfS - 1;
        int c_1 = -1;
        int c_2 = -1;
        ClusterTreeNode right = null;
        ClusterTreeNode left = null;
        ClusterTreeNode newNode = null;
        double exp = 0.0;
        while (size > 0) {
            c_1 = (Integer)UnClustered.get(c[0]);
            c_2 = (Integer)UnClustered.get(c[1]);
            ChildNum[nCounter] = ChildNum[c_1] + ChildNum[c_2];
            left = (ClusterTreeNode)Tree.get(c[0]);
            right = (ClusterTreeNode)Tree.get(c[1]);
            float val = 0.0f;
            if (!this.m_bSortValue) {
                if (left.m_nNoOfNode > right.m_nNoOfNode) {
                    ClusterTreeNode T = left;
                    left = right;
                    right = T;
                }
            } else {
                if (left.m_value > right.m_value) {
                    ClusterTreeNode T = left;
                    left = right;
                    right = T;
                }
                val = left.m_value * (float)(left.m_nNumOfLeftLeaf + left.m_nNumOfRightLeaf) + right.m_value * (float)(right.m_nNumOfLeftLeaf + right.m_nNumOfRightLeaf);
                val /= (float)(left.m_nNumOfLeftLeaf + left.m_nNumOfRightLeaf + right.m_nNumOfLeftLeaf + right.m_nNumOfRightLeaf);
            }
            right.m_parent = left.m_parent = (newNode = new ClusterTreeNode(nCounter, val, left, right));
            if (this.m_Dissimilarity == 3 || this.m_Dissimilarity == 4) {
                Exp[0] = exp += 1.0;
            }
            right.m_DisOfCombine = left.m_DisOfCombine = (float)Exp[0];
            Tree.remove(c[1]);
            Tree.remove(c[0]);
            Tree.addFirst(newNode);
            int oldc1 = c[0];
            int oldc2 = c[1];
            if (size > 1) {
                dis = tmp;
                tmp = this.RefreshDistance(Exp, c, dis, c_1, c_2, ChildNum, UnClustered);
            }
            --size;
            UnClustered.remove(oldc2);
            UnClustered.remove(oldc1);
            UnClustered.addFirst(new Integer(nCounter++));
        }
        minMaxExp[1] = Exp[0];
        if (minMaxExp[0] <= 0.0) {
            minMaxExp[0] = 1.0E-5;
        }
        if (minMaxExp[0] >= minMaxExp[1]) {
            minMaxExp[0] = minMaxExp[1] / 10.0;
        }
        return (ClusterTreeNode)Tree.getFirst();
    }

    private float[] ComputeValue(float[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        float[] Ret = new float[rows];
        int i = 0;
        while (i < rows) {
            Ret[i] = 0.0f;
            int count = 0;
            int j = 0;
            while (j < cols) {
                if (!Float.isNaN(data[i][j])) {
                    int n = i;
                    Ret[n] = Ret[n] + data[i][j];
                    ++count;
                }
                ++j;
            }
            int n = i++;
            Ret[n] = Ret[n] / (float)count;
        }
        return Ret;
    }

    @Override
    public String[] getSelectedGenes() {
        Vector<String> set = new Vector<String>();
        if (this.m_SelectedTree != null && (this.m_bColSelected || this.m_bRowSelected)) {
            int i;
            int num = this.m_SelectedTree.m_nNumOfLeftLeaf + this.m_SelectedTree.m_nNumOfRightLeaf;
            int[] leafNo = new int[num];
            ClusterTreeNode.PostOrderTree(this.m_SelectedTree, 6, leafNo);
            if (this.m_bColSelected) {
                i = 0;
                while (i < leafNo.length) {
                    set.add(this.m_ColLabel[leafNo[i]]);
                    ++i;
                }
            } else {
                i = 0;
                while (i < leafNo.length) {
                    set.add(this.m_RowLabel[leafNo[i]]);
                    ++i;
                }
            }
        }
        String[] ret = new String[set.size()];
        int i = 0;
        while (i < set.size()) {
            ret[i] = (String)set.get(i);
            ++i;
        }
        return ret;
    }

    public void SetLeafNo() {
        ClusterTreeNode.m_gap = this.m_gap;
        double[] size1 = this.GetLabelExtent(this.m_RowLabel);
        double[] size2 = this.GetLabelExtent(this.m_ColLabel);
        this.m_ExtentOfColLabel = (int)size2[0];
        this.m_ExtentOfRowLabel = (int)size1[0];
        this.m_rowLeafNo = new int[this.m_rows];
        this.m_colLeafNo = new int[this.m_cols];
        int i = 0;
        while (i < this.m_rows) {
            this.m_rowLeafNo[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.m_cols) {
            this.m_colLeafNo[i] = i;
            ++i;
        }
        this.m_ImageSize[0] = (int)(size1[0] + (double)(this.m_gap * (this.m_cols + 1)) + 90.0);
        this.m_ImageSize[1] = (int)(size2[0] + (double)(this.m_gap * (this.m_rows + 1)));
    }

    public boolean LoadCluster(String fileName, AppFrame frame) {
        BufferedReader in;
        block31: {
            block29: {
                block30: {
                    block28: {
                        int i;
                        StringTokenizer t;
                        String szT;
                        block27: {
                            String line;
                            block26: {
                                block25: {
                                    int i2;
                                    block24: {
                                        block23: {
                                            m_appFrame = frame;
                                            in = new BufferedReader(new FileReader(fileName));
                                            szT = in.readLine();
                                            szT = szT.trim();
                                            if (szT.compareTo("CLS-cls") == 0 || szT.compareTo("CLS-cls-2") == 0 || szT.compareTo("CLS-cls-3") == 0) break block23;
                                            ClUtils.Message("Can't open file");
                                            return false;
                                        }
                                        t = new StringTokenizer(in.readLine(), " ");
                                        if (szT.startsWith("CLS-cls-3")) {
                                            this.m_bFlagData = Cluster.StringToBoolean(t.nextToken());
                                        }
                                        this.m_rows = Integer.parseInt(t.nextToken());
                                        this.m_cols = Integer.parseInt(t.nextToken());
                                        this.m_Method = Integer.parseInt(t.nextToken());
                                        this.m_Metric = Integer.parseInt(t.nextToken());
                                        this.m_Dissimilarity = Integer.parseInt(t.nextToken());
                                        t = new StringTokenizer(in.readLine(), " ");
                                        this.m_defaultTreeHeight = Integer.parseInt(t.nextToken());
                                        this.m_rowTreeHeight = Integer.parseInt(t.nextToken());
                                        this.m_colTreeHeight = Integer.parseInt(t.nextToken());
                                        this.m_Legandheight = Integer.parseInt(t.nextToken());
                                        this.m_gap = Integer.parseInt(t.nextToken());
                                        if (szT.compareTo("CLS-cls-2") == 0 || szT.compareTo("CLS-cls-3") == 0) {
                                            this.m_bNormalize = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bHeader = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRLogExp = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bCLogExp = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColorImageOk = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bSortValue = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColLeftAlignment = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRowLeftAlignment = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRowSelected = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColSelected = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bDrawDistance = Cluster.StringToBoolean(t.nextToken());
                                        } else {
                                            t = new StringTokenizer(in.readLine(), " ");
                                            this.m_bNormalize = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bHeader = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRLogExp = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bCLogExp = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColorImageOk = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bSortValue = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColLeftAlignment = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRowLeftAlignment = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bRowSelected = Cluster.StringToBoolean(t.nextToken());
                                            this.m_bColSelected = Cluster.StringToBoolean(t.nextToken());
                                        }
                                        t = new StringTokenizer(in.readLine(), "\t");
                                        this.m_Font = new Font(t.nextToken(), 0, Integer.parseInt(t.nextToken()));
                                        t = new StringTokenizer(in.readLine(), "=");
                                        t.nextToken();
                                        this.m_strHead = t.nextToken();
                                        t = new StringTokenizer(in.readLine(), " ");
                                        this.m_minBit = Integer.parseInt(t.nextToken());
                                        this.m_RGBMax = Integer.parseInt(t.nextToken());
                                        this.m_ColorMin = Cluster.IntToColor(Integer.parseInt(t.nextToken()));
                                        this.m_ColorMedianLow = Cluster.IntToColor(Integer.parseInt(t.nextToken()));
                                        this.m_ColorMedianUp = Cluster.IntToColor(Integer.parseInt(t.nextToken()));
                                        this.m_ColorMax = Cluster.IntToColor(Integer.parseInt(t.nextToken()));
                                        t = new StringTokenizer(in.readLine(), " ");
                                        this.m_xcoef = Double.parseDouble(t.nextToken());
                                        this.m_ycoef = Double.parseDouble(t.nextToken());
                                        this.m_max = Double.parseDouble(t.nextToken());
                                        this.m_min = Double.parseDouble(t.nextToken());
                                        this.m_medianLow = Double.parseDouble(t.nextToken());
                                        this.m_medianUp = Double.parseDouble(t.nextToken());
                                        t = new StringTokenizer(in.readLine(), " ");
                                        this.m_rExp[0] = Double.parseDouble(t.nextToken());
                                        this.m_rExp[1] = Double.parseDouble(t.nextToken());
                                        this.m_cExp[0] = Double.parseDouble(t.nextToken());
                                        this.m_cExp[1] = Double.parseDouble(t.nextToken());
                                        t = new StringTokenizer(in.readLine(), " ");
                                        this.m_ImageSize[0] = Integer.parseInt(t.nextToken());
                                        this.m_ImageSize[1] = Integer.parseInt(t.nextToken());
                                        int x1 = Integer.parseInt(t.nextToken());
                                        int x2 = Integer.parseInt(t.nextToken());
                                        int y1 = Integer.parseInt(t.nextToken());
                                        int y2 = Integer.parseInt(t.nextToken());
                                        this.m_ColorImageArea.setBounds(x1, y1, x2 - x1, y2 - y1);
                                        t = new StringTokenizer(in.readLine(), " ");
                                        x1 = Integer.parseInt(t.nextToken());
                                        x2 = Integer.parseInt(t.nextToken());
                                        y1 = Integer.parseInt(t.nextToken());
                                        y2 = Integer.parseInt(t.nextToken());
                                        this.m_rowTreeArea.setBounds(x1, y1, x2 - x1, y2 - y1);
                                        x1 = Integer.parseInt(t.nextToken());
                                        x2 = Integer.parseInt(t.nextToken());
                                        y1 = Integer.parseInt(t.nextToken());
                                        y2 = Integer.parseInt(t.nextToken());
                                        this.m_colTreeArea.setBounds(x1, y1, x2 - x1, y2 - y1);
                                        this.m_RowLabel = new String[this.m_rows];
                                        this.m_ColLabel = new String[this.m_cols];
                                        i2 = 0;
                                        while (i2 < this.m_rows) {
                                            this.m_RowLabel[i2] = in.readLine().trim();
                                            ++i2;
                                        }
                                        szT = in.readLine().trim();
                                        if (szT.compareTo("RowLabel End") == 0) break block24;
                                        in.close();
                                        return false;
                                    }
                                    i2 = 0;
                                    while (i2 < this.m_cols) {
                                        this.m_ColLabel[i2] = in.readLine().trim();
                                        ++i2;
                                    }
                                    szT = in.readLine().trim();
                                    if (szT.compareTo("ColLabel End") == 0) break block25;
                                    in.close();
                                    return false;
                                }
                                this.m_rowLeafNo = new int[this.m_rows];
                                this.m_colLeafNo = new int[this.m_cols];
                                line = in.readLine();
                                if (!line.equals("")) {
                                    t = new StringTokenizer(line, " ");
                                    i = 0;
                                    while (i < this.m_rows) {
                                        this.m_rowLeafNo[i] = Integer.parseInt(t.nextToken());
                                        ++i;
                                    }
                                }
                                if ((szT = in.readLine().trim()).compareTo("RowLeafNo End") == 0) break block26;
                                in.close();
                                return false;
                            }
                            line = in.readLine();
                            if (!line.equals("")) {
                                t = new StringTokenizer(line, " ");
                                i = 0;
                                while (i < this.m_cols) {
                                    this.m_colLeafNo[i] = Integer.parseInt(t.nextToken());
                                    ++i;
                                }
                            }
                            if ((szT = in.readLine().trim()).compareTo("ColLeafNo End") == 0) break block27;
                            in.close();
                            return false;
                        }
                        this.m_Data = new float[this.m_rows][this.m_cols];
                        t = new StringTokenizer(in.readLine(), " ");
                        i = 0;
                        while (i < this.m_rows) {
                            int j = 0;
                            while (j < this.m_cols) {
                                this.m_Data[i][j] = Float.parseFloat(t.nextToken());
                                ++j;
                            }
                            ++i;
                        }
                        szT = in.readLine().trim();
                        if (szT.compareTo("Data End") == 0) break block28;
                        in.close();
                        return false;
                    }
                    if (this.m_Method != 1) break block29;
                    this.m_RowTree = this.RestoreClusterTree(in, this.m_rows);
                    if (this.m_RowTree != null) break block30;
                    in.close();
                    return false;
                }
                in.readLine();
                this.m_ColTree = this.RestoreClusterTree(in, this.m_cols);
                if (this.m_ColTree == null) {
                    in.close();
                    return false;
                }
                break block31;
            }
            if (this.m_Method != 0) break block31;
            this.m_RowTree = this.RestoreClusterTree(in, this.m_rows);
            if (this.m_RowTree != null) break block31;
            in.close();
            return false;
        }
        try {
            this.DetermineDimesion(this.m_colTreeHeight, this.m_rowTreeHeight);
            this.m_bOK = true;
            in.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        this.m_bOK = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusterTreeNode RestoreClusterTree(BufferedReader in, int Num) {
        Vector<ClusterTreeNode> treeP = new Vector<ClusterTreeNode>();
        Vector<Long> treeNo = new Vector<Long>();
        Vector<Long> treeNP = new Vector<Long>();
        int N_node = Num * 2 - 1;
        try {
            int i = 0;
            while (i < N_node) {
                String str = in.readLine();
                StringTokenizer t = new StringTokenizer(str, " ");
                int node = Integer.parseInt(t.nextToken());
                int NumL = Integer.parseInt(t.nextToken());
                int NumR = Integer.parseInt(t.nextToken());
                float value = Float.parseFloat(t.nextToken());
                Color color = Cluster.IntToColor(Integer.parseInt(t.nextToken()));
                float penW = Float.parseFloat(t.nextToken());
                float Dis = Float.parseFloat(t.nextToken());
                boolean bSel = Cluster.StringToBoolean(t.nextToken());
                int NodeX = Integer.parseInt(t.nextToken());
                int NodeY = Integer.parseInt(t.nextToken());
                long NN = Long.parseLong(t.nextToken());
                long NP = Long.parseLong(t.nextToken());
                ClusterTreeNode pNew = new ClusterTreeNode(node, value, Dis);
                pNew.m_color = color;
                pNew.m_nNumOfLeftLeaf = NumL;
                pNew.m_nNumOfRightLeaf = NumR;
                pNew.m_penWidth = penW;
                pNew.m_bSelected = bSel;
                pNew.m_NodeCoordinate.x = NodeX;
                pNew.m_NodeCoordinate.y = NodeY;
                treeP.addElement(pNew);
                treeNP.addElement(new Long(NP));
                treeNo.addElement(new Long(NN));
                ++i;
            }
            while (treeP.size() > 1) {
                int Index = -1;
                int i2 = 0;
                while (i2 < treeNo.size()) {
                    if (treeNo.get(i2).equals(treeNP.get(0))) {
                        Index = i2;
                        break;
                    }
                    ++i2;
                }
                if (Index == -1) {
                    ClUtils.ErrorMessage("Error occur in CHA!");
                    return null;
                }
                if (((ClusterTreeNode)treeP.get((int)Index)).m_left != null) {
                    ((ClusterTreeNode)treeP.get((int)Index)).m_right = (ClusterTreeNode)treeP.get(0);
                } else {
                    ((ClusterTreeNode)treeP.get((int)Index)).m_left = (ClusterTreeNode)treeP.get(0);
                }
                ((ClusterTreeNode)treeP.get((int)0)).m_parent = (ClusterTreeNode)treeP.get(Index);
                treeP.remove(0);
                treeNo.remove(0);
                treeNP.remove(0);
            }
            return treeP.get(0);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return (ClusterTreeNode)treeP.get(0);
    }

    public boolean SaveCluster(String fileName) {
        boolean ret = false;
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write("CLS-cls-3\n");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bFlagData)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_rows)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_cols)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_Method)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_Metric)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_Dissimilarity)) + "\n");
            out.write(String.valueOf(Integer.toString(this.m_defaultTreeHeight)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_rowTreeHeight)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_colTreeHeight)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_Legandheight)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_gap)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bNormalize)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bHeader)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bRLogExp)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bCLogExp)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bColorImageOk)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bSortValue)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bColLeftAlignment)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bRowLeftAlignment)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bRowSelected)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bColSelected)) + " ");
            out.write(String.valueOf(Cluster.BooleanToString(this.m_bDrawDistance)) + "\n");
            out.write(String.valueOf(this.m_Font.getFamily()) + "\t" + Integer.toString(this.m_Font.getSize()) + "\n");
            out.write("Head=" + this.m_strHead + "\n");
            out.write(String.valueOf(Integer.toString(this.m_minBit)) + " ");
            out.write(String.valueOf(Integer.toString(this.m_RGBMax)) + " ");
            out.write(String.valueOf(Integer.toString(Cluster.ColorToInt(this.m_ColorMin))) + " ");
            out.write(String.valueOf(Integer.toString(Cluster.ColorToInt(this.m_ColorMedianLow))) + " ");
            out.write(String.valueOf(Integer.toString(Cluster.ColorToInt(this.m_ColorMedianUp))) + " ");
            out.write(String.valueOf(Integer.toString(Cluster.ColorToInt(this.m_ColorMax))) + "\n");
            out.write(String.valueOf(Double.toString(this.m_xcoef)) + " ");
            out.write(String.valueOf(Double.toString(this.m_ycoef)) + " ");
            out.write(String.valueOf(Double.toString(this.m_max)) + " ");
            out.write(String.valueOf(Double.toString(this.m_min)) + " ");
            out.write(String.valueOf(Double.toString(this.m_medianLow)) + " ");
            out.write(String.valueOf(Double.toString(this.m_medianUp)) + "\n");
            out.write(String.valueOf(Double.toString(this.m_rExp[0])) + " ");
            out.write(String.valueOf(Double.toString(this.m_rExp[1])) + " ");
            out.write(String.valueOf(Double.toString(this.m_cExp[0])) + " ");
            out.write(String.valueOf(Double.toString(this.m_cExp[1])) + "\n");
            out.write(String.valueOf(Integer.toString(this.m_ImageSize[0])) + " ");
            out.write(String.valueOf(Integer.toString(this.m_ImageSize[1])) + " ");
            out.write(String.valueOf(Integer.toString((int)this.m_ColorImageArea.getX())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_ColorImageArea.getX() + this.m_ColorImageArea.getWidth()))) + " ");
            out.write(String.valueOf(Integer.toString((int)this.m_ColorImageArea.getY())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_ColorImageArea.getY() + this.m_ColorImageArea.getHeight()))) + "\n");
            out.write(String.valueOf(Integer.toString((int)this.m_rowTreeArea.getX())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_rowTreeArea.getX() + this.m_rowTreeArea.getWidth()))) + " ");
            out.write(String.valueOf(Integer.toString((int)this.m_rowTreeArea.getY())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_rowTreeArea.getY() + this.m_rowTreeArea.getHeight()))) + " ");
            out.write(String.valueOf(Integer.toString((int)this.m_colTreeArea.getX())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_colTreeArea.getX() + this.m_colTreeArea.getWidth()))) + " ");
            out.write(String.valueOf(Integer.toString((int)this.m_colTreeArea.getY())) + " ");
            out.write(String.valueOf(Integer.toString((int)(this.m_colTreeArea.getY() + this.m_colTreeArea.getHeight()))) + "\n");
            if (this.m_RowLabel != null) {
                i = 0;
                while (i < this.m_RowLabel.length) {
                    out.write(String.valueOf(this.m_RowLabel[i]) + "\n");
                    ++i;
                }
            }
            out.write("RowLabel End\n");
            if (this.m_ColLabel != null) {
                i = 0;
                while (i < this.m_ColLabel.length) {
                    out.write(String.valueOf(this.m_ColLabel[i]) + "\n");
                    ++i;
                }
            }
            out.write("ColLabel End\n");
            if (this.m_rowLeafNo != null) {
                i = 0;
                while (i < this.m_rowLeafNo.length) {
                    out.write(String.valueOf(Integer.toString(this.m_rowLeafNo[i])) + " ");
                    ++i;
                }
            }
            out.write("\nRowLeafNo End\n");
            if (this.m_colLeafNo != null) {
                i = 0;
                while (i < this.m_colLeafNo.length) {
                    out.write(String.valueOf(Integer.toString(this.m_colLeafNo[i])) + " ");
                    ++i;
                }
            }
            out.write("\nColLeafNo End\n");
            i = 0;
            while (i < this.m_rows) {
                int j = 0;
                while (j < this.m_cols) {
                    out.write(String.valueOf(Float.toString(this.m_Data[i][j])) + " ");
                    ++j;
                }
                ++i;
            }
            out.write("\nData End\n");
            if (this.m_Method == 1) {
                ClusterTreeNode.PostOrderTree(this.m_RowTree, 1, out);
                out.write("\n");
                ClusterTreeNode.PostOrderTree(this.m_ColTree, 1, out);
            } else if (this.m_Method == 0) {
                ClusterTreeNode.PostOrderTree(this.m_RowTree, 1, out);
            }
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return ret;
    }

    static String BooleanToString(boolean value) {
        if (value) {
            return new String("1");
        }
        return new String("0");
    }

    static boolean StringToBoolean(String value) {
        return value.trim().equals("1");
    }

    static int ColorToInt(Color color) {
        int ret = 0;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        ret = (b << 8 | g) << 8 | r;
        return ret;
    }

    static Color IntToColor(int value) {
        Color ret = null;
        int blueMask = 0xFF0000;
        int greenMask = 65280;
        int redMask = 255;
        int g = (value & greenMask) >> 8;
        int b = (value & blueMask) >> 16;
        int r = value & redMask;
        ret = new Color(r, g, b);
        return ret;
    }

    public boolean ClusteringAnalysis(float[][] data, String[] rowLabel, String[] colLabel, int method, int metric, int dissimilarity, boolean bSortValue, boolean bNormalize, double[] limit, Color[] color, TableFrame tframe, AppFrame f, List<String>[] grp_col_names) {
        this.m_Data = data;
        try {
            this.fillNullData(this.m_Data);
        }
        catch (Exception ex) {
            ClUtils.ErrorMessage(ex.getMessage());
            return false;
        }
        this.m_rows = data.length;
        this.m_cols = data[0].length;
        this.m_bSortValue = bSortValue;
        this.m_bNormalize = bNormalize;
        this.m_Metric = metric;
        this.m_Dissimilarity = dissimilarity;
        this.m_RowLabel = rowLabel;
        this.m_ColLabel = colLabel;
        this.m_TableFrame = tframe;
        m_appFrame = f;
        this.m_Method = method;
        this.m_min = limit[0];
        this.m_max = limit[1];
        this.m_medianLow = limit[2];
        this.m_medianUp = limit[2];
        this.m_ColorMin = color[0];
        this.m_ColorMedianLow = color[1];
        this.m_ColorMedianUp = color[2];
        this.m_ColorMax = color[3];
        this.m_bOK = false;
        this.m_bColSelected = false;
        this.m_bRowSelected = false;
        this.m_GroupColNames = grp_col_names;
        String[] strMetric = new String[]{"Manhattan", "Euclidean", "1-r"};
        String[] strDissimilarity = new String[]{"Single", "Complete", "Average", "Centroid", "Median", ""};
        this.m_strHead = strMetric[this.m_Metric];
        if (this.m_Dissimilarity == 5) {
            this.m_strHead = "Ward's (Minimum variance)";
        }
        this.m_strHead = String.valueOf(this.m_strHead) + " + " + strDissimilarity[this.m_Dissimilarity];
        this.m_strHead = this.m_bNormalize ? String.valueOf(this.m_strHead) + " (Normalized data)" : String.valueOf(this.m_strHead) + " (Nonnormalized data)";
        return true;
    }

    public void restorePoint(Point pt) {
        if (this.m_Method == 0) {
            pt.x = (int)((double)pt.x / this.m_xcoef);
            pt.y = (int)((double)pt.y / this.m_ycoef);
            return;
        }
        pt.x = (double)pt.x > (double)(this.m_gap * this.m_cols) * this.m_xcoef ? (int)((double)pt.x - (double)(this.m_gap * this.m_cols) * (this.m_xcoef - 1.0)) : (int)((double)pt.x / this.m_xcoef);
        int height = 0;
        height = (double)this.m_gap * this.m_xcoef > (double)m_minLimit ? this.m_headerHeight + this.m_colTreeHeight + this.m_ExtentOfColLabel : this.m_headerHeight + this.m_colTreeHeight;
        if (pt.y > height) {
            pt.y = (int)((double)(pt.y - height) / this.m_ycoef + (double)height);
        }
    }

    private Rectangle2D getExtentOfText(String text) {
        Graphics g = m_appFrame.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.m_Font);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout layout = new TextLayout(text, this.m_Font, frc);
        Rectangle2D rect = layout.getBounds();
        return rect;
    }

    public void translatePoint(Point pt, boolean isRowTree) {
        if (isRowTree) {
            if (this.m_Method == 1) {
                int w = this.m_gap * this.m_cols + this.m_ExtentOfRowLabel;
                int h = this.m_headerHeight + this.m_colTreeHeight + this.m_ExtentOfColLabel;
                if ((double)this.m_gap * this.m_xcoef < (double)m_minLimit) {
                    h -= this.m_ExtentOfColLabel;
                }
                if ((double)this.m_gap * this.m_ycoef < (double)m_minLimit) {
                    w -= this.m_ExtentOfRowLabel;
                }
                pt.x -= w;
                pt.y -= h;
            } else {
                pt.x -= this.m_ExtentOfRowLabel;
                pt.y -= this.m_headerHeight;
            }
        } else {
            int tmp = pt.y;
            pt.y = pt.x;
            pt.x = this.m_headerHeight + this.m_colTreeHeight - tmp;
        }
    }

    private Rectangle getAreaOfTree(Rectangle view, Rectangle treeArea, boolean bRowTree) {
        Point pt1 = new Point(view.x, view.y);
        Point pt2 = new Point(view.x + view.width, view.y + view.height);
        this.restorePoint(pt1);
        this.restorePoint(pt2);
        Rectangle tv = new Rectangle(pt1.x, pt1.y, pt2.x - pt1.x, pt2.y - pt1.y);
        Rectangle ret = tv.intersection(treeArea);
        if (bRowTree) {
            if (this.m_Method == 0) {
                ret.x -= this.m_ExtentOfRowLabel;
                ret.y -= this.m_headerHeight;
            } else {
                ret.x -= this.m_cols * this.m_gap;
                if ((double)this.m_gap * this.m_ycoef >= (double)m_minLimit) {
                    ret.x -= this.m_ExtentOfRowLabel;
                }
                ret.y -= this.m_headerHeight + this.m_colTreeHeight;
                if ((double)this.m_gap * this.m_xcoef >= (double)m_minLimit) {
                    ret.y -= this.m_ExtentOfColLabel;
                }
            }
        } else {
            ret = new Rectangle(this.m_headerHeight + this.m_colTreeHeight - ret.y - ret.height, ret.x, ret.height, ret.width);
        }
        return ret;
    }

    public void DrawSelInGraph(Graphics2D g2, Rectangle view) {
        if (this.m_bColSelected) {
            this.drawColTree(g2, view, this.m_SelectedTree);
        } else if (this.m_bRowSelected) {
            this.drawRowTree(g2, view, this.m_SelectedTree);
        }
    }

    public void setTreePanelSize() {
        int cx = (int)((double)this.m_ImageSize[0] * this.m_xcoef);
        int cy = (int)((double)this.m_ImageSize[1] * this.m_ycoef);
        if (this.m_Method == 1) {
            cx = (int)((double)this.m_ImageSize[0] + (this.m_xcoef - 1.0) * (double)this.m_gap * (double)this.m_cols);
            cy = (int)((double)this.m_ImageSize[1] + (this.m_ycoef - 1.0) * (double)this.m_gap * (double)this.m_rows);
        }
        Dimension size = this.m_ClusterFrame.jPanel_Tree.getPreferredSize();
        if (size.width != cx || size.height != cy) {
            this.m_ClusterFrame.jPanel_Tree.setPreferredSize(new Dimension(cx, cy));
            this.m_ClusterFrame.jPanel_Tree.revalidate();
        }
        this.m_noChange = false;
    }

    public void drawColTree(Graphics2D g2, Rectangle view, ClusterTreeNode colTree) {
        g2.scale(this.m_xcoef, 1.0);
        Rectangle vw = this.getAreaOfTree(view, this.m_colTreeArea, false);
        ClusterTreeNode.m_Font = this.m_Font;
        g2.setFont(this.m_Font);
        if (vw != null) {
            ClusterTreeNode.m_treeHeight = this.m_colTreeHeight;
            ClusterTreeNode.m_bLeftAlignment = this.m_bColLeftAlignment;
            Point point = new Point(0, this.m_colTreeHeight + this.m_headerHeight);
            ClusterTreeNode.m_bLabel = true;
            if (this.m_xcoef * (double)this.m_gap < (double)m_minLimit) {
                ClusterTreeNode.m_bLabel = false;
            }
            ClusterTreeNode.m_ExtentOfLabel = this.m_ExtentOfColLabel;
            DrawNode operation = new DrawNode(g2, true, point, vw, this.m_ColLabel);
            ClusterTreeNode.PostOrderTree(colTree, 3, operation);
        }
        g2.scale(1.0 / this.m_xcoef, 1.0);
    }

    public void drawRowTree(Graphics2D g2, Rectangle view, ClusterTreeNode rowTree) {
        g2.scale(1.0, this.m_ycoef);
        Rectangle vw = this.getAreaOfTree(view, this.m_rowTreeArea, true);
        ClusterTreeNode.m_Font = this.m_Font;
        g2.setFont(this.m_Font);
        if (vw != null) {
            ClusterTreeNode.m_treeHeight = this.m_rowTreeHeight;
            ClusterTreeNode.m_bLeftAlignment = this.m_bRowLeftAlignment;
            ClusterTreeNode.m_bLabel = true;
            int y = (int)((double)(this.m_colTreeHeight + this.m_headerHeight + this.m_ExtentOfColLabel + m_treeHeatmapGap) / this.m_ycoef);
            int x = (int)((double)(this.m_cols * this.m_gap) * this.m_xcoef + (double)this.m_ExtentOfRowLabel) + m_treeHeatmapGap;
            if (this.m_ycoef * (double)this.m_gap < (double)m_minLimit) {
                ClusterTreeNode.m_bLabel = false;
                x = (int)((double)(this.m_cols * this.m_gap) * this.m_xcoef) + m_treeHeatmapGap;
            }
            if (this.m_xcoef * (double)this.m_gap < (double)m_minLimit) {
                y = (int)((double)(this.m_colTreeHeight + this.m_headerHeight + m_treeHeatmapGap) / this.m_ycoef);
            }
            Point point = new Point(x, y);
            DrawNode operation = new DrawNode(g2, false, point, vw, this.m_RowLabel);
            ClusterTreeNode.m_ExtentOfLabel = this.m_ExtentOfRowLabel;
            ClusterTreeNode.PostOrderTree(rowTree, 3, operation);
        }
        g2.scale(1.0, 1.0 / this.m_ycoef);
    }

    public void DrawInGraph(Graphics2D g2, Rectangle view) {
        ClusterTreeNode.m_gap = this.m_gap;
        ClusterTreeNode.m_Font = this.m_Font;
        g2.setFont(this.m_Font);
        Rectangle2D rect = new Rectangle();
        if (this.m_strHead != null && this.m_strHead.length() > 0) {
            rect = this.getExtentOfText(this.m_strHead);
            if (this.m_headerHeight < 0) {
                this.m_headerHeight = (int)rect.getHeight() * 2;
            }
        }
        switch (this.m_Method) {
            case 0: {
                g2.scale(this.m_xcoef, this.m_ycoef);
                Rectangle vw = this.getAreaOfTree(view, this.m_rowTreeArea, true);
                if (vw != null) {
                    ClusterTreeNode.m_bLeftAlignment = this.m_bRowLeftAlignment;
                    Point point = new Point(this.m_ExtentOfRowLabel, this.m_headerHeight);
                    DrawNode operation = new DrawNode(g2, false, point, vw, this.m_RowLabel);
                    ClusterTreeNode.m_ExtentOfLabel = this.m_ExtentOfRowLabel;
                    ClusterTreeNode.PostOrderTree(this.m_RowTree, 3, operation);
                }
                if (this.m_bDrawDistance) {
                    Point pt1 = new Point(this.m_ExtentOfRowLabel + ClusterTreeNode.m_leafHeight, this.m_headerHeight + this.m_gap * this.m_rows);
                    Point pt2 = new Point(pt1.x + this.m_rowTreeHeight, this.m_headerHeight + this.m_gap * this.m_rows);
                    this.DrawDistance(g2, pt1, pt2, this.m_rExp[0], this.m_rExp[1], this.m_bRLogExp);
                }
                g2.scale(1.0 / this.m_xcoef, 1.0 / this.m_ycoef);
                break;
            }
            case 1: {
                this.drawColTree(g2, view, this.m_ColTree);
                this.drawRowTree(g2, view, this.m_RowTree);
                this.DrawColorImage(g2, view);
                this.DrawLegend(g2);
                if (!this.m_bDrawDistance) break;
                this.DrawDistanceInGraph(g2);
                break;
            }
            case 2: {
                Point point = new Point(this.m_ExtentOfRowLabel, this.m_ExtentOfColLabel);
                this.DrawColorImage(g2, view);
                this.DrawColorImageLabel(g2, point, view);
                point.setLocation((double)(this.m_cols * this.m_gap + this.m_ExtentOfRowLabel) * this.m_xcoef + 10.0, 20.0);
                this.DrawLegend(g2);
            }
        }
        g2.setColor(Color.black);
        if (this.m_ImageSize[0] / 2 > (int)(rect.getWidth() / 2.0)) {
            g2.drawString(this.m_strHead, (int)(((double)(this.m_ImageSize[0] / 2) - rect.getWidth() / 2.0) * this.m_xcoef), (int)rect.getHeight());
        } else {
            g2.drawString(this.m_strHead, 0, (int)rect.getHeight());
        }
    }

    public void setScaleY(int wh) {
        if (this.m_Method == 1) {
            int height = this.m_headerHeight + this.m_ExtentOfColLabel + this.m_colTreeHeight;
            if (this.m_xcoef * (double)this.m_gap < (double)m_minLimit) {
                height -= this.m_ExtentOfColLabel;
            }
            this.m_ycoef = wh > height ? (double)(1.0f * (float)(wh - height - this.m_gap) / (float)(this.m_gap * this.m_rows)) : (double)1.4E-45f;
        } else {
            this.m_ycoef = 1.0f * (float)wh / (float)this.m_ImageSize[1];
        }
        this.setTreePanelSize();
    }

    public void DrawDistanceInGraph(Graphics2D g2) {
        Point pt1 = new Point((int)((double)(this.m_gap * this.m_cols) * this.m_xcoef + (double)this.m_ExtentOfRowLabel + (double)ClusterTreeNode.m_leafHeight), (int)((double)(this.m_gap * this.m_rows) * this.m_ycoef + (double)this.m_headerHeight + (double)this.m_colTreeHeight + (double)this.m_ExtentOfColLabel));
        if ((double)this.m_gap * this.m_xcoef < (double)m_minLimit) {
            pt1.translate(0, -this.m_ExtentOfColLabel);
        }
        if ((double)this.m_gap * this.m_ycoef < (double)m_minLimit) {
            pt1.translate(-this.m_ExtentOfRowLabel, 0);
        }
        Point pt2 = new Point(pt1.x + this.m_rowTreeHeight, pt1.y);
        this.DrawDistance(g2, pt1, pt2, this.m_rExp[0], this.m_rExp[1], this.m_bRLogExp);
        pt1.setLocation((int)((double)(this.m_gap * this.m_cols) * this.m_xcoef), this.m_headerHeight);
        pt2.setLocation(pt1.x, this.m_headerHeight + this.m_colTreeHeight);
        this.DrawDistance(g2, pt1, pt2, this.m_cExp[0], this.m_cExp[1], this.m_bCLogExp);
    }

    private void DrawColorImageLabel(Graphics2D g2, Point point, Rectangle view) {
        int i;
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setFont(this.m_Font);
        g2.setColor(Color.black);
        int Rs = (int)((double)(view.y - point.y) / this.m_ycoef / (double)this.m_gap) - 1;
        int Re = (int)((double)(view.y + view.height - point.y) / this.m_ycoef / (double)this.m_gap) + 1;
        int Cs = (int)((double)(view.x - point.x) / this.m_xcoef / (double)this.m_gap) - 1;
        int Ce = (int)((double)(view.x + view.width - point.x) / this.m_xcoef / (double)this.m_gap) + 1;
        if (Rs < 0) {
            Rs = 0;
        }
        if (Re > this.m_rows) {
            Re = this.m_rows;
        }
        if (Cs < 0) {
            Cs = 0;
        }
        if (Ce > this.m_cols) {
            Ce = this.m_cols;
        }
        g2.scale(this.m_xcoef, 1.0);
        if ((double)this.m_gap * this.m_xcoef > (double)m_minLimit) {
            i = Cs;
            while (i < Ce) {
                double x = (double)this.m_ExtentOfRowLabel / this.m_xcoef + (double)(i * this.m_gap) + (double)(this.m_gap / 2);
                double y = this.m_ExtentOfColLabel;
                if (this.m_ColLabel[i] != null && this.m_ColLabel[i].length() > 0) {
                    TextLayout layout = new TextLayout(this.m_ColLabel[i], this.m_Font, frc);
                    Rectangle2D rect = layout.getBounds();
                    x += rect.getHeight() / 2.0;
                    if (!this.m_bColLeftAlignment) {
                        y = rect.getWidth();
                    }
                    g2.translate(x, y);
                    g2.rotate(-1.5707963267948966);
                    g2.drawString(this.m_ColLabel[i], 0, 0);
                    g2.rotate(1.5707963267948966);
                    g2.translate(-x, -y);
                }
                ++i;
            }
        }
        g2.scale(1.0 / this.m_xcoef, this.m_ycoef);
        if ((double)this.m_gap * this.m_ycoef > (double)m_minLimit) {
            i = Rs;
            while (i < Re) {
                if (this.m_RowLabel[i] != null && this.m_RowLabel[i].length() > 0) {
                    TextLayout layout = new TextLayout(this.m_RowLabel[i], this.m_Font, frc);
                    Rectangle2D rect = layout.getBounds();
                    int x = 0;
                    int y = (int)((double)this.m_ExtentOfColLabel / this.m_ycoef) + i * this.m_gap + this.m_gap / 2;
                    if (!this.m_bRowLeftAlignment) {
                        x = (int)((double)this.m_ExtentOfRowLabel - rect.getWidth() - 1.0);
                    }
                    g2.drawString(this.m_RowLabel[i], x, (int)((double)y + rect.getHeight() / 2.0));
                }
                ++i;
            }
        }
        g2.scale(1.0, 1.0 / this.m_ycoef);
    }

    private void DrawLegend(Graphics2D g2) {
        String str;
        Point point = new Point((int)((double)((this.m_cols + 1) * this.m_gap) * this.m_xcoef) + this.m_ExtentOfRowLabel + this.m_headerHeight, this.m_headerHeight * 2);
        if (this.m_Method == 2) {
            point.setLocation((double)this.m_ExtentOfRowLabel + (double)(this.m_cols * this.m_gap) * this.m_xcoef + 10.0, 20.0);
        }
        int width = 15;
        Color[] color = new Color[2];
        int i = 2;
        int bias = 2;
        DecimalFormat format = new DecimalFormat("0.###");
        if (this.m_bFlagData) {
            int len = 30;
            g2.setColor(Color.green);
            g2.fillRect(point.x, point.y, width, len);
            g2.setColor(Color.black);
            g2.fillRect(point.x, point.y + len, width, len);
            g2.setColor(Color.red);
            g2.fillRect(point.x, point.y + len + len, width, len);
            g2.setColor(Color.black);
            g2.drawString("Absent", point.x + width + bias, point.y + 6);
            g2.drawString("Margin", point.x + width + bias, (int)((double)point.y + (double)len * 1.5 + 6.0));
            g2.drawString("Present", point.x + width, point.y + 3 * len + 6);
            return;
        }
        if (this.m_medianLow != this.m_medianUp) {
            this.LegendColor(color, 0);
            GradientPaint gp1 = new GradientPaint(point.x, point.y, color[0], point.x, point.y + this.m_Legandheight, color[1]);
            this.LegendColor(color, 1);
            GradientPaint gp2 = new GradientPaint(point.x, point.y + this.m_Legandheight, color[0], point.x, point.y + this.m_Legandheight * 2, color[1]);
            this.LegendColor(color, 2);
            GradientPaint gp3 = new GradientPaint(point.x, point.y + this.m_Legandheight * 2, color[0], point.x, point.y + this.m_Legandheight * 3, color[1]);
            g2.setPaint(gp1);
            g2.fillRect(point.x, point.y, width, this.m_Legandheight);
            g2.setPaint(gp2);
            g2.fillRect(point.x, point.y + this.m_Legandheight, width, this.m_Legandheight);
            g2.setPaint(gp3);
            g2.fillRect(point.x, point.y + this.m_Legandheight * 2, width, this.m_Legandheight);
            str = format.format(this.m_min);
            g2.setColor(Color.black);
            g2.drawString(str, point.x + width + bias, point.y);
            str = format.format(this.m_medianLow);
            g2.drawString(str, point.x + width + bias, point.y + this.m_Legandheight);
            str = format.format(this.m_medianUp);
            g2.drawString(str, point.x + width + bias, point.y + this.m_Legandheight * 2);
            i = 3;
        } else {
            this.LegendColor(color, 0);
            GradientPaint gp1 = new GradientPaint(point.x, point.y, color[0], point.x, point.y + this.m_Legandheight, color[1]);
            this.LegendColor(color, 3);
            GradientPaint gp2 = new GradientPaint(point.x, point.y + this.m_Legandheight, color[0], point.x, point.y + this.m_Legandheight * 2, color[1]);
            g2.setPaint(gp1);
            g2.fillRect(point.x, point.y, width, this.m_Legandheight);
            g2.setPaint(gp2);
            g2.fillRect(point.x, point.y + this.m_Legandheight, width, this.m_Legandheight);
            str = format.format(this.m_min);
            g2.setColor(Color.black);
            g2.drawString(str, point.x + width + bias, point.y);
            str = format.format((this.m_medianUp + this.m_medianLow) / 2.0);
            g2.drawString(str, point.x + width + bias, point.y + this.m_Legandheight);
            i = 2;
        }
        str = format.format(this.m_max);
        g2.drawString(str, point.x + width, point.y + i * this.m_Legandheight);
    }

    private void LegendColor(Color[] color, int rgb, boolean bAscend) {
        Color[] red = new Color[]{new Color(this.m_minBit, 0, 0), new Color(this.m_RGBMax, 0, 0)};
        Color[] green = new Color[]{new Color(0, this.m_minBit, 0), new Color(0, this.m_RGBMax, 0)};
        Color[] blue = new Color[]{new Color(0, 0, this.m_minBit), new Color(0, 0, this.m_RGBMax)};
        if (!bAscend) {
            red[0] = new Color(this.m_RGBMax, 0, 0);
            red[1] = new Color(this.m_minBit, 0, 0);
            green[0] = new Color(0, this.m_RGBMax, 0);
            green[1] = new Color(0, this.m_minBit, 0);
            blue[0] = new Color(0, 0, this.m_RGBMax);
            blue[1] = new Color(0, 0, this.m_minBit);
        }
        switch (rgb) {
            case 0: {
                color[0] = red[0];
                color[1] = red[1];
                break;
            }
            case 1: {
                color[0] = green[0];
                color[1] = green[1];
                break;
            }
            case 2: {
                color[0] = blue[0];
                color[1] = blue[1];
            }
        }
    }

    private void LegendColor(Color[] color, int zone) {
        switch (zone) {
            case 0: {
                color[0] = this.m_ColorMin;
                color[1] = this.m_ColorMedianLow;
                break;
            }
            case 1: {
                color[0] = this.m_ColorMedianLow;
                color[1] = this.m_ColorMedianUp;
                break;
            }
            case 2: {
                color[0] = this.m_ColorMedianUp;
                color[1] = this.m_ColorMax;
                break;
            }
            default: {
                color[0] = this.m_ColorMedianLow;
                color[1] = this.m_ColorMax;
            }
        }
    }

    private void createImageFromAvgData(double xr, double yr, int Cs, int Ce, int Rs, int Re) {
        int dw = (int)((double)(Ce - Cs) * xr);
        int dh = (int)((double)(Re - Rs) * yr);
        int sw = Ce - Cs;
        int sh = Re - Rs;
        int[] iArray = new int[dw * dh];
        int color = 0;
        int y2 = 0;
        int x2 = 0;
        int maxR = this.m_rows - Rs;
        int maxC = this.m_cols - Cs;
        if (xr >= 1.0 && yr >= 1.0) {
            int st0 = 0;
            int st1 = 0;
            int i = 0;
            while (i < sh) {
                int y1 = y2;
                y2 = Math.round((float)(yr * (double)(i + 1)));
                if (y2 > dh) {
                    y2 = dh;
                }
                x2 = 0;
                st0 = dw * (y1 - 1);
                int j = 0;
                while (j < sw) {
                    color = 256;
                    int x1 = x2;
                    x2 = Math.round((float)(xr * (double)(j + 1)));
                    if (x2 > dw) {
                        x2 = dw;
                    }
                    st1 = st0;
                    this.GetValueColor(this.m_Data[this.m_rowLeafNo[Rs + i]][this.m_colLeafNo[Cs + j]]);
                    color = 0xFF000000 | this.m_r << 16 | this.m_g << 8 << this.m_b;
                    int m = y1;
                    while (m < y2) {
                        st1 += dw;
                        int n = x1;
                        while (n < x2) {
                            iArray[st1 + n] = color;
                            ++n;
                        }
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (xr >= 1.0 && yr < 1.0) {
            yr = 1.0 / yr;
            int col = 0;
            int i = 0;
            while (i < dh) {
                int y1 = y2;
                y2 = Math.round((float)(yr * (double)(i + 1)));
                x2 = 0;
                if (y2 > maxR) {
                    y2 = maxR;
                }
                int j = 0;
                while (j < sw) {
                    float value = 0.0f;
                    int m = y1;
                    while (m < y2) {
                        value += this.m_Data[this.m_rowLeafNo[Rs + m]][this.m_colLeafNo[Cs + j]];
                        ++m;
                    }
                    value /= (float)(y2 - y1);
                    int x1 = x2;
                    x2 = Math.round((float)(xr * (double)(j + 1)));
                    if (x2 > dw) {
                        x2 = dw;
                    }
                    this.GetValueColor(value);
                    color = 0xFF000000 | this.m_r << 16 | this.m_g << 8 << this.m_b;
                    int n = x1;
                    while (n < x2) {
                        iArray[col++] = color;
                        ++n;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (xr < 1.0 && yr >= 1.0) {
            xr = 1.0 / xr;
            int st = 0;
            int i = 0;
            while (i < sh) {
                int y1 = y2;
                y2 = Math.round((float)(yr * (double)(i + 1)));
                if (y2 > dh) {
                    y2 = dh;
                }
                x2 = 0;
                int j = 0;
                while (j < dw) {
                    float value = 0.0f;
                    int x1 = x2;
                    x2 = Math.round((float)(xr * (double)(j + 1)));
                    if (x2 > maxC) {
                        x2 = maxC;
                    }
                    int m = x1;
                    while (m < x2) {
                        value += this.m_Data[this.m_rowLeafNo[Rs + i]][this.m_colLeafNo[Cs + m]];
                        ++m;
                    }
                    this.GetValueColor(value /= (float)(x2 - x1));
                    iArray[st + j] = 0xFF000000 | this.m_r << 16 | this.m_g << 8 << this.m_b;
                    ++j;
                }
                j = y1 + 1;
                while (j < y2) {
                    System.arraycopy(iArray, st, iArray, st + dw * (j - y1), dw);
                    ++j;
                }
                st += dw * (y2 - y1);
                ++i;
            }
        } else {
            xr = 1.0 / xr;
            yr = 1.0 / yr;
            int col = 0;
            int i = 0;
            while (i < dh) {
                int y1 = y2;
                y2 = Math.round((float)(yr * (double)(i + 1)));
                x2 = 0;
                if (y2 > maxR) {
                    y2 = maxR;
                }
                int j = 0;
                while (j < dw) {
                    float value = 0.0f;
                    int x1 = x2;
                    x2 = Math.round((float)(xr * (double)(j + 1)));
                    if (x2 > this.m_cols - Cs) {
                        x2 = this.m_cols - Cs;
                    }
                    int m = x1;
                    while (m < x2) {
                        int n = y1;
                        while (n < y2) {
                            value += this.m_Data[this.m_rowLeafNo[Rs + n]][this.m_colLeafNo[Cs + m]];
                            ++n;
                        }
                        ++m;
                    }
                    this.GetValueColor(value /= (float)((x2 - x1) * (y2 - y1)));
                    iArray[col++] = 0xFF000000 | this.m_r << 16 | this.m_g << 8 << this.m_b;
                    ++j;
                }
                ++i;
            }
        }
        this.m_img = m_appFrame.createImage(new MemoryImageSource(dw, dh, iArray, 0, dw));
    }

    private void DrawColorImage(Graphics2D g2, Rectangle view) {
        double yr;
        int h;
        double xr;
        int w;
        int Ce;
        int Cs;
        int Re;
        int Rs;
        int x0 = 0;
        int y0 = 0;
        if (this.m_Method == 2) {
            x0 = (int)((double)this.m_ExtentOfRowLabel / this.m_xcoef);
            y0 = (int)((double)this.m_ExtentOfColLabel / this.m_ycoef);
        } else {
            y0 = (int)((double)(this.m_colTreeHeight + this.m_headerHeight + this.m_ExtentOfColLabel + m_treeHeatmapGap) / this.m_ycoef);
            if (this.m_xcoef * (double)this.m_gap < (double)m_minLimit) {
                y0 = (int)((double)(this.m_colTreeHeight + this.m_headerHeight + m_treeHeatmapGap) / this.m_ycoef);
            }
        }
        Point point = new Point(x0, y0);
        this.m_ColorImageArea.setRect(point.x, point.y, this.m_cols * this.m_gap, this.m_rows * this.m_gap);
        if (this.m_Method == 2) {
            Rs = (int)((double)(view.y - this.m_ExtentOfColLabel) / this.m_ycoef / (double)this.m_gap) - 1;
            Re = (int)((double)(view.y + view.height - this.m_ExtentOfColLabel) / this.m_ycoef / (double)this.m_gap) + 1;
            Cs = (int)((double)(view.x - this.m_ExtentOfRowLabel) / this.m_xcoef / (double)this.m_gap) - 1;
            Ce = (int)((double)(view.x + view.width - this.m_ExtentOfRowLabel) / this.m_xcoef / (double)this.m_gap) + 1;
        } else {
            Point pt1 = new Point(view.x, view.y);
            Point pt2 = new Point(view.x + view.width, view.y + view.height);
            this.restorePoint(pt1);
            this.restorePoint(pt2);
            Rectangle v1 = new Rectangle(pt1.x, pt1.y, pt2.x - pt1.x, pt2.y - pt1.y);
            int x = (int)((double)point.x * this.m_xcoef);
            int y = (int)((double)point.y * this.m_ycoef);
            Rectangle tv = new Rectangle(x, y, this.m_gap * this.m_cols, this.m_gap * this.m_rows);
            Rectangle im = tv.intersection(v1);
            if (im == null) {
                return;
            }
            Rs = (int)Math.floor((im.y - y) / this.m_gap) - 1;
            Re = (int)Math.ceil((im.y + im.height - y) / this.m_gap) + 1;
            Cs = (int)Math.floor((im.x - x) / this.m_gap) - 1;
            Ce = (int)Math.ceil((im.x + im.width - x) / this.m_gap) + 1;
        }
        if (Rs < 0) {
            Rs = 0;
        }
        if (Re > this.m_rows) {
            Re = this.m_rows;
        }
        if (Cs < 0) {
            Cs = 0;
        }
        if (Ce > this.m_cols) {
            Ce = this.m_cols;
        }
        if ((w = (int)((double)(Ce - Cs) * (xr = (double)this.m_gap * this.m_xcoef))) * (h = (int)((double)(Re - Rs) * (yr = (double)this.m_gap * this.m_ycoef))) <= 0) {
            return;
        }
        if (!this.m_noChange) {
            if (this.m_Method == 2 || yr >= 0.0 && xr >= 0.0) {
                int y = 0;
                g2.scale(this.m_xcoef, this.m_ycoef);
                int i = Rs;
                while (i < Re) {
                    y = point.y + i * this.m_gap;
                    int j = Cs;
                    while (j < Ce) {
                        this.GetValueColor(this.m_Data[this.m_rowLeafNo[i]][this.m_colLeafNo[j]]);
                        g2.setColor(new Color(this.m_r, this.m_g, this.m_b));
                        g2.fillRect(point.x + j * this.m_gap, y, this.m_gap, this.m_gap);
                        ++j;
                    }
                    ++i;
                }
                g2.scale(1.0 / this.m_xcoef, 1.0 / this.m_ycoef);
                this.m_bColorImageOk = true;
                return;
            }
            this.createImageFromAvgData(xr, yr, Cs, Ce, Rs, Re);
        }
        int x = (int)((double)Cs * xr);
        int y = (int)((double)(point.y + Rs * this.m_gap) * this.m_ycoef);
        g2.drawImage(this.m_img, x, y + 1, x + w, y + h + 2, 0, 0, w, h, null);
        this.m_noChange = true;
        this.m_bColorImageOk = true;
    }

    private void GetValueColor(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.m_b = 0;
            this.m_g = 0;
            this.m_r = 0;
            return;
        }
        if (value > this.m_max) {
            value = this.m_max;
        }
        if (value < this.m_min) {
            value = this.m_min;
        }
        if (this.m_medianLow != this.m_medianUp) {
            if (value <= this.m_medianLow) {
                this.MapColor(value, this.m_medianLow, this.m_min, this.m_ColorMin, this.m_ColorMedianLow);
            } else if (value <= this.m_medianUp) {
                this.MapColor(value, this.m_medianUp, this.m_medianLow, this.m_ColorMedianLow, this.m_ColorMedianUp);
            } else {
                this.MapColor(value, this.m_max, this.m_medianUp, this.m_ColorMedianUp, this.m_ColorMax);
            }
        } else if (value <= this.m_medianLow) {
            this.MapColor(value, this.m_medianLow, this.m_min, this.m_ColorMin, this.m_ColorMedianLow);
        } else {
            this.MapColor(value, this.m_max, this.m_medianLow, this.m_ColorMedianLow, this.m_ColorMax);
        }
    }

    private void MapColor(double value, double Up, double Bottom, Color lowColor, Color upColor) {
        value = (value - Bottom) / (Up - Bottom);
        int R1 = lowColor.getRed();
        int R2 = upColor.getRed();
        int G1 = lowColor.getGreen();
        int G2 = upColor.getGreen();
        int B1 = lowColor.getBlue();
        int B2 = upColor.getBlue();
        this.m_r = (int)(value * (double)(R2 - R1) + (double)R1);
        this.m_g = (int)(value * (double)(G2 - G1) + (double)G1);
        this.m_b = (int)(value * (double)(B2 - B1) + (double)B1);
    }

    private void SingleCluster() {
        float[] val = this.ComputeValue(this.m_Data);
        this.m_RowTree = this.m_Data.length > m_Limit ? this.genTreeFromTop(this.m_Data, val, this.m_rExp) : this.ClusterProcess(this.m_Data, val, this.m_rExp);
        this.m_rowTreeHeight = this.m_defaultTreeHeight;
        this.DetermineDimesion(this.m_defaultTreeHeight, this.m_defaultTreeHeight);
    }

    public Cluster(int value) {
        ClusterTreeNode.m_treeHeight = 100;
        this.m_defaultTreeHeight = 100;
        this.m_bHeader = false;
        this.m_rExp = new double[]{0.0, 0.0};
        this.m_cExp = new double[]{0.0, 0.0};
        this.m_colLeafNo = null;
        this.m_rowLeafNo = null;
        this.m_strHead = null;
        this.m_TableFrame = null;
        this.m_minBit = 0;
        this.m_RGBMax = 255;
        this.m_ExtentOfRowLabel = 0;
        this.m_ExtentOfColLabel = 0;
        this.m_GroupColNames = null;
        this.m_img = null;
        this.m_noChange = false;
        this.m_bFlagData = false;
    }

    public int[] getSampleOrder(float[][] data) {
        float[] val = this.ComputeValue(data);
        this.m_RowTree = this.ClusterProcess(data, val, this.m_rExp);
        this.m_bSortValue = true;
        int[] leafNo = new int[data.length];
        ClusterTreeNode.PostOrderTree(this.m_RowTree, 6, leafNo);
        return leafNo;
    }

    private void DualCluster() {
        float[][] data = this.m_Data;
        float[] val = this.ComputeValue(data);
        this.m_RowTree = data.length > m_Limit ? this.genTreeFromTop(data, val, this.m_rExp) : this.ClusterProcess(data, val, this.m_rExp);
        float[][] dataT = new float[this.m_Data[0].length][this.m_Data.length];
        int i = 0;
        while (i < this.m_Data[0].length) {
            int j = 0;
            while (j < this.m_Data.length) {
                dataT[i][j] = this.m_Data[j][i];
                ++j;
            }
            ++i;
        }
        val = this.ComputeValue(dataT);
        data = dataT;
        this.m_ColTree = data.length > m_Limit ? this.genTreeFromTop(data, val, this.m_cExp) : this.ClusterProcess(data, val, this.m_cExp);
        if (this.m_GroupColNames != null && this.m_ColTree != null) {
            float[][] colorCmp = this.initColorComponents(this.m_GroupColNames.length, 3);
            HashMap<Integer, Color> colorMap = new HashMap<Integer, Color>();
            int i2 = 0;
            while (i2 < this.m_GroupColNames.length) {
                Color color = new Color(colorCmp[0][i2], colorCmp[1][i2], colorCmp[2][i2]);
                int j = 0;
                while (j < this.m_GroupColNames[i2].size()) {
                    String label = this.m_GroupColNames[i2].get(j);
                    int No = -1;
                    int k = 0;
                    while (k < this.m_ColLabel.length) {
                        if (this.m_ColLabel[k].equals(label)) {
                            No = k;
                            break;
                        }
                        ++k;
                    }
                    if (No != -1) {
                        colorMap.put(new Integer(No), color);
                    } else {
                        System.out.println("Name of sample :" + label + " was not found in the colLabel!");
                    }
                    ++j;
                }
                ++i2;
            }
            ClusterTreeNode.PostOrderTree(this.m_ColTree, 12, colorMap);
        }
        this.m_rowTreeHeight = this.m_colTreeHeight = this.m_defaultTreeHeight;
        this.DetermineDimesion(this.m_defaultTreeHeight, this.m_defaultTreeHeight);
    }

    private float[][] initColorComponents(int numColors, int numColorComp) {
        float[][] ret = new float[numColorComp][numColors];
        Color[] cT = new Color[]{Color.blue, Color.red, Color.green, Color.pink, Color.cyan, Color.lightGray, Color.orange, Color.black, new Color(0.0f, 0.5f, 0.5f), new Color(0.5f, 0.0f, 0.5f), new Color(1.0f, 0.0f, 0.5f), new Color(0.0f, 0.75f, 1.0f), new Color(0.0f, 0.75f, 0.25f), Color.gray, Color.yellow};
        float[] colorComp = null;
        int end = numColors > 15 ? 15 : numColors;
        int i = 0;
        while (i < end) {
            colorComp = cT[i].getRGBColorComponents(null);
            ret[0][i] = colorComp[0];
            ret[1][i] = colorComp[1];
            ret[2][i] = colorComp[2];
            ++i;
        }
        Random rand = new Random(10L);
        int i2 = 10;
        while (i2 < numColors) {
            ret[0][i2] = rand.nextFloat();
            ret[1][i2] = rand.nextFloat();
            ret[2][i2] = rand.nextFloat();
            ++i2;
        }
        return ret;
    }

    private double[] GetLabelExtent(String[] label) {
        double[] ret = new double[]{0.0, 0.0};
        Graphics g = m_appFrame.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.m_Font);
        FontRenderContext frc = g2.getFontRenderContext();
        int i = 0;
        while (i < label.length) {
            if (label[i] != null && label[i].length() > 0) {
                TextLayout layout = new TextLayout(label[i], this.m_Font, frc);
                Rectangle2D rect = layout.getBounds();
                if (ret[0] < rect.getWidth()) {
                    ret[0] = rect.getWidth() + 2.0;
                }
                if (ret[1] < rect.getHeight()) {
                    ret[1] = rect.getHeight();
                }
            }
            ++i;
        }
        return ret;
    }

    public void BranchTree(boolean bTable, boolean bSubTree, int[] ColClassNum, int[] RowClassNum) {
        ClusterTreeNode Row2 = null;
        ClusterTreeNode Col = null;
        String[] RLabel = null;
        String[] CLabel = null;
        float[][] Data2 = null;
        double rMax = 0.0;
        double cMax = 0.0;
        double rMin = 0.0;
        double cMin = 0.0;
        if (this.m_SelectedTree != null) {
            int rows = 0;
            int cols = 0;
            if (this.m_Method != 0) {
                if (this.m_bRowSelected) {
                    Row2 = ClusterTreeNode.Copy(this.m_SelectedTree);
                    Col = ClusterTreeNode.Copy(this.m_ColTree);
                } else {
                    Col = ClusterTreeNode.Copy(this.m_SelectedTree);
                    Row2 = ClusterTreeNode.Copy(this.m_RowTree);
                }
                rMax = Row2.m_left != null ? (double)Row2.m_left.m_DisOfCombine : (double)Row2.m_DisOfCombine;
                cMax = Col.m_left != null ? (double)Col.m_left.m_DisOfCombine : (double)Col.m_DisOfCombine;
                ClusterTreeNode.m_minExp = rMax;
                ClusterTreeNode.PostOrderTree(Row2, 9, null);
                rMin = ClusterTreeNode.m_minExp;
                ClusterTreeNode.m_minExp = cMax;
                ClusterTreeNode.PostOrderTree(Col, 9, null);
                cMin = ClusterTreeNode.m_minExp;
                rows = Row2.m_nNumOfLeftLeaf + Row2.m_nNumOfRightLeaf;
                cols = Col.m_nNumOfLeftLeaf + Col.m_nNumOfRightLeaf;
                int[] rLeafNo = new int[rows];
                int[] cLeafNo = new int[cols];
                ClusterTreeNode.PostOrderTree(Row2, 6, rLeafNo);
                ClusterTreeNode.PostOrderTree(Col, 6, cLeafNo);
                ClusterTreeNode.PostOrderTree(Row2, 7, null);
                ClusterTreeNode.PostOrderTree(Col, 7, null);
                BoolPoint operation = new BoolPoint(false, null);
                ClusterTreeNode.PostOrderTree(Row2, 5, operation);
                ClusterTreeNode.PostOrderTree(Col, 5, operation);
                Data2 = new float[rows][cols];
                RLabel = new String[rows];
                CLabel = new String[cols];
                int i = 0;
                while (i < rows) {
                    RLabel[i] = this.m_RowLabel[rLeafNo[i]];
                    int j = 0;
                    while (j < cols) {
                        Data2[i][j] = this.m_Data[rLeafNo[i]][cLeafNo[j]];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < cols) {
                    CLabel[i] = this.m_ColLabel[cLeafNo[i]];
                    ++i;
                }
            } else {
                cols = this.m_cols;
                CLabel = new String[cols];
                int[] cLeafNo = new int[cols];
                int i = 0;
                while (i < cols) {
                    cLeafNo[i] = i;
                    CLabel[i] = this.m_ColLabel[i];
                    ++i;
                }
                Row2 = ClusterTreeNode.Copy(this.m_SelectedTree);
                rows = Row2.m_nNumOfLeftLeaf + Row2.m_nNumOfRightLeaf;
                rMax = Row2.m_left != null ? (double)Row2.m_left.m_DisOfCombine : (double)Row2.m_DisOfCombine;
                ClusterTreeNode.m_minExp = ClusterTreeNode.m_maxExp;
                ClusterTreeNode.PostOrderTree(Row2, 9, null);
                rMin = ClusterTreeNode.m_minExp;
                int[] rLeafNo = new int[rows];
                ClusterTreeNode.PostOrderTree(Row2, 6, rLeafNo);
                ClusterTreeNode.PostOrderTree(Row2, 7, null);
                ClusterTreeNode.PostOrderTree(Row2, 5, new BoolPoint(false, null));
                RLabel = new String[rows];
                Data2 = new float[rows][cols];
                i = 0;
                while (i < rows) {
                    RLabel[i] = this.m_RowLabel[rLeafNo[i]];
                    int j = 0;
                    while (j < cols) {
                        Data2[i][j] = this.m_Data[rLeafNo[i]][cLeafNo[j]];
                        ++j;
                    }
                    ++i;
                }
            }
            if (bTable) {
                TableFrame i = this.GetSubTable(RLabel, CLabel, Data2, ColClassNum, RowClassNum);
            }
            if (!bSubTree) {
                return;
            }
            Cluster newCluster = new Cluster();
            newCluster.m_bHeader = true;
            newCluster.m_ColLabel = CLabel;
            newCluster.m_RowLabel = RLabel;
            newCluster.m_RowTree = Row2;
            newCluster.m_ColTree = Col;
            newCluster.m_Data = Data2;
            newCluster.m_cols = cols;
            newCluster.m_rows = rows;
            newCluster.m_Dissimilarity = this.m_Dissimilarity;
            newCluster.m_Metric = this.m_Metric;
            newCluster.m_max = this.m_max;
            newCluster.m_min = this.m_min;
            newCluster.m_medianLow = this.m_medianLow;
            newCluster.m_medianUp = this.m_medianUp;
            newCluster.m_Method = this.m_Method;
            newCluster.m_bNormalize = this.m_bNormalize;
            newCluster.m_cExp[1] = cMax;
            newCluster.m_cExp[0] = cMin;
            newCluster.m_ColorMin = this.m_ColorMin;
            newCluster.m_ColorMax = this.m_ColorMax;
            newCluster.m_ColorMedianLow = this.m_ColorMedianLow;
            newCluster.m_ColorMedianUp = this.m_ColorMedianUp;
            newCluster.m_rExp[1] = rMax;
            newCluster.m_rExp[0] = rMin;
            newCluster.m_strHead = this.m_strHead;
            newCluster.m_bRLogExp = this.m_bRLogExp;
            newCluster.m_bCLogExp = this.m_bCLogExp;
            newCluster.m_gap = this.m_gap;
            newCluster.m_bRowLeftAlignment = this.m_bRowLeftAlignment;
            newCluster.m_bColLeftAlignment = this.m_bColLeftAlignment;
            newCluster.m_Font = this.m_Font;
            newCluster.m_bDrawDistance = this.m_bDrawDistance;
            newCluster.DetermineDimesion(this.m_defaultTreeHeight, this.m_defaultTreeHeight);
            newCluster.CreateClusterFrame();
            newCluster.m_bFlagData = this.m_bFlagData;
            newCluster.m_bOK = true;
        }
    }

    private TableFrame GetSubTable(String[] RLabel, String[] CLabel, float[][] data, int[] ColClassNum, int[] RowClassNum) {
        TableFrame f = null;
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        if (ColClassNum == null && RowClassNum == null) {
            Object[][] dt = m_appFrame.floatToString(data);
            MyTableModel dm = new MyTableModel(dt, RLabel, CLabel);
            new TableFrame(m_appFrame, dm);
        } else if (ColClassNum != null && RowClassNum != null) {
            int j;
            String[] rLabel = new String[RLabel.length + 1];
            rLabel[0] = "Class";
            int i = 0;
            while (i < RLabel.length) {
                rLabel[i + 1] = RLabel[i];
                ++i;
            }
            String[] cLabel = new String[CLabel.length + 1];
            cLabel[0] = "Class";
            int i2 = 0;
            while (i2 < CLabel.length) {
                cLabel[i2 + 1] = CLabel[i2];
                ++i2;
            }
            Object[][] nData = new String[RLabel.length + 1][CLabel.length + 1];
            int i3 = 1;
            while (i3 < nData.length) {
                int j2 = 1;
                while (j2 < nData[0].length) {
                    nData[i3][j2] = nf.format(data[i3 - 1][j2 - 1]);
                    ++j2;
                }
                ++i3;
            }
            int m = 1;
            int i4 = 0;
            while (i4 < ColClassNum.length) {
                j = 0;
                while (j < ColClassNum[i4]) {
                    nData[0][m++] = Integer.toString(i4 + 1);
                    ++j;
                }
                ++i4;
            }
            m = 1;
            i4 = 0;
            while (i4 < RowClassNum.length) {
                j = 0;
                while (j < RowClassNum[i4]) {
                    nData[m++][0] = Integer.toString(i4 + 1);
                    ++j;
                }
                ++i4;
            }
            MyTableModel dm = new MyTableModel(nData, rLabel, cLabel);
            new TableFrame(m_appFrame, dm);
        } else {
            String[] cLabel = new String[CLabel.length + 1];
            cLabel[0] = "Class";
            int i = 0;
            while (i < CLabel.length) {
                cLabel[i + 1] = CLabel[i];
                ++i;
            }
            Object[][] nData = new String[RLabel.length][CLabel.length + 1];
            int i5 = 0;
            while (i5 < nData.length) {
                int j = 1;
                while (j < nData[0].length) {
                    nData[i5][j] = nf.format(data[i5][j - 1]);
                    ++j;
                }
                ++i5;
            }
            int m = 0;
            int i6 = 0;
            while (i6 < RowClassNum.length) {
                int j = 0;
                while (j < RowClassNum[i6]) {
                    nData[m++][0] = nf.format(i6 + 1);
                    ++j;
                }
                ++i6;
            }
            MyTableModel dm = new MyTableModel(nData, RLabel, cLabel);
            new TableFrame(m_appFrame, dm);
        }
        return f;
    }

    public void ClassifyingTree(ClusterTreeNode root, int[] classNum, int Num) {
        Vector<ClusterTreeNode> array = new Vector<ClusterTreeNode>();
        array.add(root);
        while (array.size() < Num) {
            double maxExp = -2.0;
            int nMax = -1;
            int i = 0;
            while (i < array.size()) {
                if (((ClusterTreeNode)array.get((int)i)).m_left != null && (double)((ClusterTreeNode)array.get((int)i)).m_left.m_DisOfCombine >= maxExp) {
                    maxExp = ((ClusterTreeNode)array.get((int)i)).m_left.m_DisOfCombine;
                    nMax = i;
                }
                ++i;
            }
            if (nMax != -1) {
                ClusterTreeNode Tmp = (ClusterTreeNode)array.get(nMax);
                array.setElementAt(Tmp.m_left, nMax);
                array.insertElementAt(Tmp.m_right, nMax);
                continue;
            }
            System.out.println("Error!");
        }
        int i = 0;
        while (i < Num) {
            int sum = 0;
            sum = ((ClusterTreeNode)array.get((int)i)).m_left != null ? ((ClusterTreeNode)array.get((int)i)).m_nNumOfLeftLeaf + ((ClusterTreeNode)array.get((int)i)).m_nNumOfRightLeaf : 1;
            classNum[Num - i - 1] = sum;
            ++i;
        }
    }

    public void GenSubDendrogram(Point p1, Point p2) {
        p1.setLocation((int)((double)p1.x / this.m_xcoef), (int)((double)p1.y / this.m_ycoef));
        p2.setLocation((int)((double)p2.x / this.m_xcoef), (int)((double)p2.y / this.m_ycoef));
        int col1 = (int)(((double)p1.x - this.m_ColorImageArea.getX()) / (double)this.m_gap);
        int row1 = (int)(((double)p1.y - this.m_ColorImageArea.getY()) / (double)this.m_gap);
        int col2 = (int)(((double)p2.x - this.m_ColorImageArea.getX()) / (double)this.m_gap);
        int row2 = (int)(((double)p2.y - this.m_ColorImageArea.getY()) / (double)this.m_gap);
        if (row1 < 0) {
            row1 = 0;
        }
        if (col1 < 0) {
            col1 = 0;
        }
        if (row2 >= this.m_rows) {
            row2 = this.m_rows - 1;
        }
        if (col2 >= this.m_cols) {
            col2 = this.m_cols - 1;
        }
        int rows = row2 - row1 + 1;
        int cols = col2 - col1 + 1;
        if (rows < 3 || cols < 3) {
            return;
        }
        float[][] pData = new float[rows][cols];
        String[] ColLabel = new String[cols];
        String[] RowLabel = new String[rows];
        int i = row1;
        while (i <= row2) {
            RowLabel[i - row1] = this.m_RowLabel[this.m_rowLeafNo[i]];
            int j = col1;
            while (j <= col2) {
                pData[i - row1][j - col1] = this.m_Data[this.m_rowLeafNo[i]][this.m_colLeafNo[j]];
                ++j;
            }
            ++i;
        }
        i = col1;
        while (i <= col2) {
            ColLabel[i - col1] = this.m_ColLabel[this.m_colLeafNo[i]];
            ++i;
        }
        Cluster newCluster = new Cluster();
        double[] limit = new double[]{this.m_min, this.m_max, this.m_medianLow, this.m_medianUp};
        Color[] color = new Color[]{this.m_ColorMin, this.m_ColorMedianLow, this.m_ColorMedianUp, this.m_ColorMax};
        if (!newCluster.ClusteringAnalysis(pData, RowLabel, ColLabel, this.m_Method, this.m_Metric, this.m_Dissimilarity, this.m_bSortValue, this.m_bNormalize, limit, color, null, m_appFrame, null)) {
            return;
        }
        newCluster.start();
        int[] rNo = new int[rows];
        int[] cNo = new int[cols];
        int i2 = 0;
        while (i2 < rows) {
            rNo[i2] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < cols) {
            cNo[i2] = i2;
            ++i2;
        }
        ClusterTreeNode.PostOrderTree(newCluster.m_RowTree, 6, rNo);
        ClusterTreeNode.PostOrderTree(newCluster.m_ColTree, 6, cNo);
        float[][] pD = new float[rows][cols];
        String[] pC = new String[cols];
        String[] pR = new String[rows];
        int i3 = 0;
        while (i3 < rows) {
            int sss = rNo[i3];
            pR[i3] = RowLabel[rNo[i3]];
            int j = 0;
            while (j < cols) {
                pD[i3][j] = pData[rNo[i3]][cNo[j]];
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < cols) {
            pC[i3] = ColLabel[cNo[i3]];
            ++i3;
        }
        newCluster.m_TableFrame = this.GetSubTable(pR, pC, pD, null, null);
    }

    public void DetermineDimesion(int ColHeight, int RowHeight) {
        double[] size;
        this.m_bColorImageOk = false;
        ClusterTreeNode.m_gap = this.m_gap;
        ClusterTreeNode.m_Font = this.m_Font;
        if (this.m_strHead != null && this.m_strHead.length() > 0) {
            Rectangle2D rect = this.getExtentOfText(this.m_strHead);
            this.m_headerHeight = (int)rect.getHeight() * 2;
        }
        if (this.m_Method == 0) {
            size = this.GetLabelExtent(this.m_RowLabel);
            this.m_ExtentOfRowLabel = (int)size[0];
            ClusterTreeNode.m_maxExp = this.m_rExp[1];
            ClusterTreeNode.m_minExp = this.m_rExp[0];
            ClusterTreeNode.m_treeHeight = RowHeight;
            ClusterTreeNode.m_bLogExp = this.m_bRLogExp;
            ClusterTreeNode.PostOrderTree(this.m_RowTree, 0, null);
            ClusterTreeNode.m_bLogExp = false;
            this.m_ImageSize[0] = this.m_ExtentOfRowLabel + this.m_rowTreeHeight + this.m_headerHeight;
            this.m_ImageSize[1] = this.m_gap * (this.m_rows + 1) + this.m_headerHeight;
            this.m_rowTreeArea.setBounds(this.m_ExtentOfRowLabel, this.m_headerHeight, this.m_rowTreeHeight + this.m_headerHeight, this.m_gap * (this.m_rows + 1));
        } else if (this.m_Method == 1) {
            size = this.GetLabelExtent(this.m_ColLabel);
            this.m_ExtentOfColLabel = (int)size[0];
            ClusterTreeNode.m_maxExp = this.m_cExp[1];
            ClusterTreeNode.m_minExp = this.m_cExp[0];
            ClusterTreeNode.m_treeHeight = ColHeight;
            ClusterTreeNode.m_bLogExp = this.m_bCLogExp;
            ClusterTreeNode.PostOrderTree(this.m_ColTree, 0, null);
            ClusterTreeNode.m_bLogExp = false;
            this.m_colLeafNo = new int[this.m_cols];
            ClusterTreeNode.PostOrderTree(this.m_ColTree, 6, this.m_colLeafNo);
            this.m_colTreeArea.setBounds(0, 0, this.m_gap * (this.m_cols + 1), this.m_headerHeight + this.m_colTreeHeight);
            size = this.GetLabelExtent(this.m_RowLabel);
            this.m_ExtentOfRowLabel = (int)size[0];
            ClusterTreeNode.m_maxExp = this.m_rExp[1];
            ClusterTreeNode.m_minExp = this.m_rExp[0];
            ClusterTreeNode.m_treeHeight = RowHeight;
            ClusterTreeNode.m_bLogExp = this.m_bRLogExp;
            ClusterTreeNode.PostOrderTree(this.m_RowTree, 0, null);
            ClusterTreeNode.m_bLogExp = false;
            this.m_rowLeafNo = new int[this.m_rows];
            ClusterTreeNode.PostOrderTree(this.m_RowTree, 6, this.m_rowLeafNo);
            this.m_rowTreeArea.setBounds(this.m_gap * this.m_cols, this.m_headerHeight + this.m_colTreeHeight, this.m_headerHeight + this.m_rowTreeHeight + this.m_ExtentOfRowLabel, this.m_gap * (this.m_rows + 1) + this.m_ExtentOfColLabel);
            this.m_ImageSize[0] = (this.m_cols + 1) * this.m_gap + this.m_ExtentOfRowLabel + this.m_rowTreeHeight;
            this.m_ImageSize[1] = (this.m_rows + 1) * this.m_gap + this.m_ExtentOfColLabel + this.m_colTreeHeight + this.m_headerHeight;
        }
    }

    private void CreateClusterFrame() {
        this.m_ClusterFrame = new ClusterFrame(m_appFrame, this, this.m_TableFrame);
        this.m_ClusterFrame.jPanel_Tree.revalidate();
    }

    private ClusterTreeNode genTreeFromTop(float[][] data, float[] value, double[] exp) {
        if (data.length < 3) {
            return null;
        }
        int nodeNo = data.length * 2 - 2;
        ClusterTreeNode root = new ClusterTreeNode(nodeNo--, null);
        root.m_set = new int[data.length];
        int i = 0;
        while (i < data.length) {
            root.m_set[i] = i;
            ++i;
        }
        exp[1] = Double.MIN_VALUE;
        exp[0] = Double.MAX_VALUE;
        Stack<ClusterTreeNode> st = new Stack<ClusterTreeNode>();
        st.push(root);
        KMeans km = new KMeans(data);
        ClusterTreeNode node = null;
        while (!st.empty()) {
            node = (ClusterTreeNode)st.pop();
            if (node.m_set.length > 2) {
                double dis = km.doKMeans(node.m_set);
                if (dis >= (double)node.m_DisOfCombine) {
                    dis = (double)node.m_DisOfCombine * 0.8;
                }
                exp[1] = Math.max(dis, exp[1]);
                exp[0] = Math.min(dis, exp[0]);
                int n1 = km.nC1;
                int n2 = km.nC2;
                if (n1 == 0 || n2 == 0) {
                    n1 = node.m_set.length;
                    ClusterTreeNode genNode = node;
                    int i2 = 0;
                    while (i2 < n1) {
                        if (i2 < n1 - 2) {
                            genNode.m_right = new ClusterTreeNode(km.cls[i2], genNode);
                            genNode.m_left = new ClusterTreeNode(nodeNo--, genNode);
                            genNode.m_right.m_DisOfCombine = genNode.m_left.m_DisOfCombine = (float)dis;
                            genNode.m_nNumOfLeftLeaf = n1 - i2 - 1;
                            genNode.m_nNumOfRightLeaf = 1;
                            genNode = genNode.m_left;
                        } else {
                            genNode.m_right = new ClusterTreeNode(km.cls[i2++], genNode);
                            genNode.m_left = new ClusterTreeNode(km.cls[i2++], genNode);
                            genNode.m_right.m_DisOfCombine = genNode.m_left.m_DisOfCombine = (float)dis;
                            genNode.m_nNumOfRightLeaf = 1;
                            genNode.m_nNumOfLeftLeaf = 1;
                        }
                        ++i2;
                    }
                } else {
                    int[] setL = new int[n1];
                    int[] setR = new int[n2];
                    System.arraycopy(km.cls, 0, setL, 0, km.nC1);
                    System.arraycopy(km.cls, km.nC1, setR, 0, km.nC2);
                    if (setR.length == 1) {
                        node.m_right = new ClusterTreeNode(setR[0], node);
                    } else if (setR.length > 1) {
                        node.m_right = new ClusterTreeNode(nodeNo--, node);
                        node.m_right.m_set = setR;
                        st.push(node.m_right);
                    }
                    if (setL.length == 1) {
                        node.m_left = new ClusterTreeNode(setL[0], node);
                    } else if (setL.length > 1) {
                        node.m_left = new ClusterTreeNode(nodeNo--, node);
                        node.m_left.m_set = setL;
                        st.push(node.m_left);
                    }
                    node.m_right.m_DisOfCombine = node.m_left.m_DisOfCombine = (float)dis;
                    node.m_nNumOfLeftLeaf = setL.length;
                    node.m_nNumOfRightLeaf = setR.length;
                }
            } else if (node.m_set.length == 2) {
                node.m_left = new ClusterTreeNode(node.m_set[1], node);
                node.m_right = new ClusterTreeNode(node.m_set[0], node);
                double tmp = Algorithm.disBetweenVector(data[node.m_set[1]], data[node.m_set[0]]);
                if (tmp >= (double)node.m_DisOfCombine) {
                    tmp = (double)node.m_DisOfCombine * 0.8;
                }
                exp[1] = Math.max(tmp, exp[1]);
                exp[0] = Math.min(exp[0], tmp);
                node.m_left.m_DisOfCombine = node.m_right.m_DisOfCombine = (float)tmp;
                node.m_nNumOfRightLeaf = 1;
            }
            node.m_set = null;
        }
        if (this.m_bSortValue) {
            ClusterTreeNode.PostOrderTree(root, 11, value);
            ClusterTreeNode.PostOrderTree(root, 10, null);
        }
        if (exp[0] <= 0.0) {
            exp[0] = 1.0E-5;
        }
        if (exp[0] >= exp[1]) {
            exp[0] = exp[1] / 10.0;
        }
        return root;
    }

    private void fillNullData(float[][] data) throws Exception {
        int row = data.length;
        int col = data[0].length;
        int i = 0;
        while (i < col) {
            float avg = 0.0f;
            int cc = 0;
            int j = 0;
            while (j < row) {
                if (!Float.isNaN(data[j][i]) && !Float.isInfinite(data[j][i])) {
                    avg += data[j][i];
                    ++cc;
                }
                ++j;
            }
            if (cc < row) {
                if (cc == 0) {
                    throw new Exception("Too many null values in data!");
                }
                avg /= (float)cc;
                j = 0;
                while (j < row) {
                    if (Float.isNaN(data[j][i]) || Float.isInfinite(data[j][i])) {
                        data[j][i] = avg;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    class KMeans {
        private float[][] data = null;
        private int nP = 0;
        int nS = 0;
        int[] cls = null;
        private int[] precls = null;
        int nC1;
        int nC2;
        private int prenC1;
        private int prenC2;
        private double[][] centroid = null;
        private double[] dis = null;

        public KMeans(float[][] d) {
            this.data = d;
            this.nP = d[0].length;
            this.centroid = new double[2][this.nP];
        }

        public double doKMeans(int[] set) {
            double pretotD;
            this.nS = set.length;
            this.cls = new int[this.nS];
            this.precls = new int[this.nS];
            this.dis = new double[this.nS];
            double totD = Double.MAX_VALUE;
            System.arraycopy(set, 0, this.cls, 0, this.nS);
            this.nC1 = this.nS / 2;
            this.nC2 = this.nS - this.nC1;
            while (true) {
                this.computeCentroid();
                this.prenC1 = this.nC1;
                this.prenC2 = this.nC2;
                System.arraycopy(this.cls, 0, this.precls, 0, this.nS);
                pretotD = totD;
                totD = this.reassignSample();
                if (this.nC1 == 0 || this.nC2 == 0) {
                    if (totD < 1.0E-6) {
                        return 0.0;
                    }
                    double max = this.dis[0];
                    int index = 0;
                    int i = 1;
                    while (i < this.nS) {
                        if (this.dis[i] > max) {
                            max = this.dis[i];
                            index = i;
                        }
                        ++i;
                    }
                    this.nC1 = this.nS - 1;
                    this.nC2 = 1;
                    int tt = this.cls[index];
                    this.cls[index] = this.cls[this.nS - 1];
                    this.cls[this.nS - 1] = tt;
                    continue;
                }
                if (pretotD <= totD) break;
            }
            System.arraycopy(this.precls, 0, this.cls, 0, this.nS);
            this.nC1 = this.prenC1;
            this.nC2 = this.prenC2;
            totD = pretotD;
            this.computeCentroid();
            return this.disOfCentroid();
        }

        private double disOfCentroid() {
            double sum = 0.0;
            int i = 0;
            while (i < this.nP) {
                double tmp = this.centroid[0][i] - this.centroid[1][i];
                sum += tmp * tmp;
                ++i;
            }
            return sum;
        }

        private double reassignSample() {
            this.nC2 = 0;
            this.nC1 = 0;
            double totD = 0.0;
            int idx = 0;
            int i = 0;
            while (i < this.nS) {
                double d1 = 0.0;
                double d2 = 0.0;
                int j = 0;
                while (j < this.nP) {
                    double tmp1 = this.centroid[0][j] - (double)this.data[this.precls[i]][j];
                    d1 += tmp1 * tmp1;
                    double tmp2 = this.centroid[1][j] - (double)this.data[this.precls[i]][j];
                    d2 += tmp2 * tmp2;
                    ++j;
                }
                if (d2 > d1) {
                    ++this.nC1;
                    this.dis[idx] = d1;
                } else {
                    idx = this.nS - 1 - this.nC2++;
                    this.dis[idx] = d2;
                }
                this.cls[idx] = this.precls[i];
                totD += this.dis[idx];
                ++i;
            }
            return totD;
        }

        private void computeCentroid() {
            int col = 0;
            while (col < this.nP) {
                this.centroid[0][col] = 0.0;
                int m = 0;
                while (m < this.nC1) {
                    double[] dArray = this.centroid[0];
                    int n = col;
                    dArray[n] = dArray[n] + (double)this.data[this.cls[m]][col];
                    ++m;
                }
                double[] dArray = this.centroid[0];
                int n = col;
                dArray[n] = dArray[n] / (double)this.nC1;
                this.centroid[1][col] = 0.0;
                m = 1;
                while (m <= this.nC2) {
                    double[] dArray2 = this.centroid[1];
                    int n2 = col;
                    dArray2[n2] = dArray2[n2] + (double)this.data[this.cls[this.nS - m]][col];
                    ++m;
                }
                double[] dArray3 = this.centroid[1];
                int n3 = col++;
                dArray3[n3] = dArray3[n3] / (double)this.nC2;
            }
        }
    }
}

