/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.ImageIcons;
import NCTR.app.arraytrack.vs2.ParsedExpressionValue;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.Cluster;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.ImageFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCADlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAEngine;
import NCTR.app.arraytrack.vs2.analysis.clustering.PCAResults;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrameEx;
import NCTR.app.arraytrack.vs2.analysis.clustering.PreferenceDlg;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import NCTR.util.FileUtilities;
import NCTR.util.RowColLabeledTabularData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class AppFrame
extends JFrame
implements ActionListener,
PropertyChangeListener {
    JDesktopPane desktop;
    NameOfMethod m_Algorithm = NameOfMethod.HCA_BY_TTEST;
    public static AppFrame m_Frame = null;
    public static AppFrame m_PCAFrame = null;
    public static AppFrame m_KmeansFrame = null;
    protected static File last_user_path = null;
    Vector<PcaFrame> m_pcaFrameList = null;
    int m_wOffset = 0;
    static int m_xOffset = 30;
    static int m_yOffset = 30;
    public static int m_method = 1;
    public static int m_metric = 1;
    public static int m_Dissimilarity = 5;
    public static boolean m_bSortValue = true;
    public static boolean m_bUseFlagData = false;
    public static int m_FilterFlag = 0;
    public static boolean m_bNormalize = false;
    public static boolean m_bAutoscale = false;
    public static String m_Kmeans_Method = "Hartigan-Wong";
    public static int m_Kmeans_IterMax = 30;
    public static int m_Kmeans_numCenters = 5;
    public static int m_Kmeans_nStart = 1;
    static final String STOPCLUSTERING = "Stop Clustering";
    static final String OPENFILE = "Open";
    static final String CLUSTERING = "Hierarchical Cluster Analysis";
    static final String EXIT = "Exit";
    static final String SAVE = "Save";
    static final String SAVEAS = "Save As...";
    static final String TRANSPOSE = "Transpose Table";
    static final String PCA = "Principal Component Analysis";
    static final String KMEANS = "K-Means";
    static final String CEL = "CEL";
    static final String OK = "OK";
    static final String CANCEL = "Cancel";
    JToolBar jToolBar = new JToolBar();
    JButton jOpenFile;
    JButton jStopThread;
    JButton jClustering;
    JButton jSaveFile;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem("Exit");
    ImageIcon imgOpen;
    ImageIcon imgSave;
    ImageIcon imgEnlarge;
    ImageIcon imgReduce;
    ImageIcon imgCluster;
    ImageIcon imgTable;
    ImageIcon imgFont;
    ImageIcon stopIcon;
    ImageIcon imgFitWindow;
    ImageIcon imgActualSize;
    ImageIcon imgTreeColor;
    ImageIcon imgTranspose;
    ImageIcon imgPCA;
    ImageIcon imgKMeans;
    ImageIcon imgFitX;
    ImageIcon imgFitY;
    ImageIcon imgScaleXUp;
    ImageIcon imgScaleXDown;
    ImageIcon imgScaleYUp;
    ImageIcon imgScaleYDown;
    JMenuItem jMenuOpen = new JMenuItem();
    JMenu jMenu_ClusterAnalysis = new JMenu();
    JMenuItem jMenuItem_ClusterAnalysis = new JMenuItem();
    JMenuItem jMenuItem_Kmeans = new JMenuItem();
    JMenuItem jMenuISave = new JMenuItem("Save");
    JLabel statusBar = new JLabel(" Ready");
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuItem jMenuItem_SaveAs = new JMenuItem("Save As...");
    JMenuItem jMenuItem_PCA;
    JMenuItem jMenuItem_ConvertCellFiles = new JMenuItem();
    JButton jButton_CEL = new JButton();
    JButton jButton_PCA;
    JButton jButton_Kmeans;
    JButton jButton_TransposeTable = new JButton();

    public AppFrame(Image icon, NameOfMethod algorithm) {
        this.m_Algorithm = algorithm;
        if (this.m_Algorithm.equals((Object)NameOfMethod.PCA)) {
            this.m_pcaFrameList = new Vector();
        }
        if (icon != null) {
            this.setIconImage(icon);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(3);
    }

    public AppFrame(Image icon) {
        this(icon, NameOfMethod.HCA_BY_TTEST);
    }

    public static boolean checkRStatus(Frame frm) {
        return true;
    }

    public static void setPreference() {
        new PreferenceDlg();
    }

    private void jbInit() throws Exception {
        ClassLoader cl = AppFrame.class.getClassLoader();
        this.imgOpen = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/openFile.png"));
        this.imgSave = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Save.gif"));
        this.imgEnlarge = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Enlarge.gif"));
        this.imgTable = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/base_table.gif"));
        this.imgReduce = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Reduce.gif"));
        this.imgCluster = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Cluster.gif"));
        this.stopIcon = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/stop.gif"));
        this.imgFont = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Font.gif"));
        this.imgFitWindow = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Fit.gif"));
        this.imgActualSize = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ActualSize.gif"));
        this.imgTreeColor = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Color.gif"));
        this.imgTranspose = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Transpose.gif"));
        this.imgPCA = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/PCA.gif"));
        this.imgKMeans = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/Kmeans.gif"));
        this.imgFitX = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleToX.gif"));
        this.imgFitY = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleToY.gif"));
        this.imgScaleXUp = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleXUp.gif"));
        this.imgScaleXDown = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleXDown.gif"));
        this.imgScaleYUp = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleYUp.gif"));
        this.imgScaleYDown = new ImageIcon(cl.getResource("NCTR/app/arraytrack/vs2/analysis/clustering/images/ScaleYDown.gif"));
        this.desktop = new JDesktopPane();
        this.jMenuOpen.setText(OPENFILE);
        this.jMenuOpen.addActionListener(this);
        this.jMenu_ClusterAnalysis.setToolTipText("");
        this.jMenu_ClusterAnalysis.setText("Analysis");
        this.jMenuItem_ClusterAnalysis.setText(CLUSTERING);
        this.jMenuItem_ClusterAnalysis.setIcon(this.imgCluster);
        this.jMenuItem_ClusterAnalysis.addPropertyChangeListener(this);
        this.jMenuItem_ClusterAnalysis.addActionListener(this);
        this.jMenuItem_Kmeans.setText(KMEANS);
        this.jMenuItem_Kmeans.setIcon(this.imgKMeans);
        this.jMenuItem_Kmeans.addPropertyChangeListener(this);
        this.jMenuItem_Kmeans.addActionListener(this);
        this.jMenuISave.setEnabled(true);
        this.jMenuISave.setFocusPainted(false);
        this.jMenuISave.addPropertyChangeListener(this);
        this.jMenuISave.addActionListener(this);
        this.jStopThread = new JButton(this.stopIcon);
        this.jStopThread.setActionCommand(STOPCLUSTERING);
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            this.jStopThread.setToolTipText("Stop Clustering Analysis");
        } else if (this.m_Algorithm.equals((Object)NameOfMethod.KMEANS)) {
            this.jStopThread.setToolTipText("Stop K-Means");
        } else {
            this.jStopThread.setToolTipText("Stop Principal Component Analysis");
        }
        this.jStopThread.addActionListener(this);
        this.jStopThread.setEnabled(Cluster.m_bWorking);
        this.jOpenFile = new JButton(this.imgOpen);
        this.jOpenFile.setActionCommand(OPENFILE);
        this.jOpenFile.setToolTipText("Open File");
        this.jOpenFile.addActionListener(this);
        this.jSaveFile = new JButton(this.imgSave);
        this.jSaveFile.setEnabled(false);
        this.jSaveFile.setActionCommand(SAVE);
        this.jSaveFile.setToolTipText("Save File");
        this.jSaveFile.addActionListener(this);
        this.jClustering = new JButton(this.imgCluster);
        this.jClustering.setActionCommand(CLUSTERING);
        this.jClustering.setEnabled(false);
        this.jClustering.setToolTipText(CLUSTERING);
        this.jClustering.addActionListener(this);
        this.jMenuItem_ConvertCellFiles.setText("CEL Files To Expression Values...");
        this.jMenuItem_ConvertCellFiles.setActionCommand(CEL);
        this.jMenuItem_ConvertCellFiles.addActionListener(this);
        this.jMenuItem_ConvertCellFiles.setVisible(false);
        this.jButton_CEL.setToolTipText("Convert CEL Data to Probe Data");
        this.jButton_CEL.setText(CEL);
        this.jButton_CEL.setActionCommand(CEL);
        this.jButton_CEL.addActionListener(this);
        this.jButton_CEL.setVisible(false);
        this.jButton_PCA = new JButton(this.imgPCA);
        this.jButton_PCA.setActionCommand(PCA);
        this.jButton_PCA.setToolTipText(PCA);
        this.jButton_PCA.addActionListener(this);
        this.jButton_Kmeans = new JButton(this.imgKMeans);
        this.jButton_Kmeans.setActionCommand(KMEANS);
        this.jButton_Kmeans.setToolTipText(KMEANS);
        this.jButton_Kmeans.addActionListener(this);
        this.jButton_TransposeTable.setIcon(this.imgTranspose);
        this.jButton_TransposeTable.setActionCommand(TRANSPOSE);
        this.jButton_TransposeTable.setToolTipText(TRANSPOSE);
        this.jButton_TransposeTable.addActionListener(this);
        this.jToolBar.add(this.jOpenFile);
        this.jToolBar.add(this.jSaveFile);
        this.jToolBar.add(this.jClustering);
        this.jToolBar.add(this.jStopThread);
        this.jToolBar.add((Component)this.jButton_CEL, null);
        this.jToolBar.add((Component)this.jButton_PCA, null);
        this.jToolBar.add((Component)this.jButton_Kmeans, null);
        this.jToolBar.add((Component)this.jButton_TransposeTable, null);
        this.jMenuItem_SaveAs.addPropertyChangeListener(this);
        this.jMenuItem_SaveAs.addActionListener(this);
        this.jMenuItem_PCA = new JMenuItem(this.imgPCA);
        this.jMenuItem_PCA.setText(PCA);
        this.jMenuItem_PCA.addActionListener(this);
        this.jMenuItem_PCA.addPropertyChangeListener(this);
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setJMenuBar(this.jMenuBar1);
        this.desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        this.setSize(new Dimension(400, 300));
        this.jMenuFile.setText("File");
        this.jMenuFileExit.addActionListener(this);
        this.jMenuFile.add(this.jMenuOpen);
        this.jMenuFile.add(this.jMenuItem_ConvertCellFiles);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuISave);
        this.jMenuFile.add(this.jMenuItem_SaveAs);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenu_ClusterAnalysis);
        this.jMenu_ClusterAnalysis.add(this.jMenuItem_ClusterAnalysis);
        this.jMenu_ClusterAnalysis.add(this.jMenuItem_PCA);
        this.jMenu_ClusterAnalysis.add(this.jMenuItem_Kmeans);
        this.jButton_PCA.setEnabled(this.IsTableSelected());
        this.jButton_Kmeans.setEnabled(this.IsTableSelected());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        int cx = (int)(screenSize.getWidth() * 0.75);
        int cy = (int)(0.75 * (double)cx);
        this.setSize(cx, cy);
        this.setLocation((int)((screenSize.getWidth() - (double)this.getWidth()) / 2.0), (int)((screenSize.getHeight() - (double)this.getHeight()) / 2.0));
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            m_Frame = this;
        } else if (this.m_Algorithm.equals((Object)NameOfMethod.PCA)) {
            m_PCAFrame = this;
        } else {
            m_KmeansFrame = this;
        }
        this.setVisible(true);
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            this.setTitle(CLUSTERING);
            this.jButton_PCA.setVisible(false);
            this.jMenuItem_PCA.setVisible(false);
            this.jMenuItem_Kmeans.setVisible(false);
            this.jButton_Kmeans.setVisible(false);
        } else if (this.m_Algorithm.equals((Object)NameOfMethod.KMEANS)) {
            this.setTitle(KMEANS);
            this.jMenuItem_ClusterAnalysis.setVisible(false);
            this.jClustering.setVisible(false);
            this.jButton_PCA.setVisible(false);
            this.jMenuItem_PCA.setVisible(false);
        } else {
            this.setTitle(PCA);
            this.jMenuItem_ClusterAnalysis.setVisible(false);
            this.jClustering.setVisible(false);
            this.jMenuItem_Kmeans.setVisible(false);
            this.jButton_Kmeans.setVisible(false);
        }
        this.jButton_TransposeTable.setEnabled(this.IsTableSelected());
    }

    public static void simplifyLabels(String[] label) {
        Pattern p = Pattern.compile("(\\{[^\\{\\}]+\\})?[^\\[\\]]+(\\[[^\\[\\]]+\\])?");
        int i = 0;
        while (i < label.length) {
            Matcher m = p.matcher(label[i]);
            if (m.find()) {
                int count = m.groupCount();
                String tmp = "";
                int j = 1;
                while (j <= count) {
                    if (m.group(j) != null) {
                        tmp = String.valueOf(tmp) + m.group(j);
                    }
                    ++j;
                }
                if (!tmp.equals("")) {
                    label[i] = tmp;
                }
            }
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.jMenu_ClusterAnalysis)) {
            ((JMenuItem)source).setEnabled(this.IsTableSelected());
        } else if (source.equals(this.jMenuISave) || source.equals(this.jMenuItem_SaveAs)) {
            ((JMenuItem)source).setEnabled(this.getSelectedFrame() != null);
        } else if (source.equals(this.jMenuItem_PCA) || source.equals(this.jMenuItem_ClusterAnalysis) || source.equals(this.jMenuItem_Kmeans)) {
            ((JMenuItem)source).setEnabled(this.IsTableSelected());
        } else {
            System.out.println("Null Properties");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(STOPCLUSTERING)) {
            if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
                if (Cluster.m_bWorking) {
                    Cluster.stop();
                }
            } else if (!this.m_Algorithm.equals((Object)NameOfMethod.KMEANS) && PCADlg.m_bWorking && PCADlg.m_thread != null) {
                PCADlg.m_thread.stop();
            }
        } else if (cmd.equals(OPENFILE)) {
            this.openFile();
        } else if (cmd.equals(CLUSTERING)) {
            this.jMenuItem_ClusterAnalysis_actionPerformed();
        } else if (cmd.equals(SAVE)) {
            this.jMenuISave_actionPerformed();
        } else if (cmd.equals(EXIT)) {
            this.jMenuFileExit_actionPerformed();
        } else if (cmd.equals(SAVEAS)) {
            this.jMenuItem_SaveAs_actionPerformed();
        } else if (cmd.equals(TRANSPOSE)) {
            this.jButton_TransposeTable_actionPerformed();
        } else if (cmd.equals(PCA)) {
            this.doPCA();
        } else {
            cmd.equals(KMEANS);
        }
    }

    public static void openUrlFileToPCA(URL source) {
        if (m_PCAFrame == null) {
            m_PCAFrame = new AppFrame(ImageIcons.getATIcon().getImage(), NameOfMethod.PCA);
        }
        m_PCAFrame.OpenUrlFile(source);
        m_PCAFrame.setState(0);
        m_PCAFrame.toFront();
    }

    public static void openUrlFileToKMEANS(URL source) {
        if (m_PCAFrame == null) {
            m_PCAFrame = new AppFrame(ImageIcons.getATIcon().getImage(), NameOfMethod.KMEANS);
        }
        m_PCAFrame.OpenUrlFile(source);
        m_PCAFrame.setState(0);
        m_PCAFrame.toFront();
    }

    public static void openUrlFileToHCA(URL source) {
        if (m_Frame == null) {
            m_Frame = new AppFrame(ImageIcons.getATIcon().getImage());
        }
        m_Frame.OpenUrlFile(source);
        m_Frame.setState(0);
        m_Frame.toFront();
    }

    private void OpenUrlFile(URL source) {
        Vector<Vector<String>> list = null;
        String title = "";
        try {
            String aLine = "";
            String file = source.getFile();
            file = file.replace("/", "");
            file.trim();
            if (file.equals("")) {
                ClUtils.Message("No file found!");
                return;
            }
            title = source.toString();
            String ext = ClUtils.getExtension(file);
            int separator = 9;
            if (ext != null && ext.equals("csv")) {
                separator = 44;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(source.openStream()));
            list = new Vector<Vector<String>>();
            while ((aLine = in.readLine()) != null) {
                int ind;
                Vector<String> row = new Vector<String>();
                int index1 = 0;
                int index2 = 0;
                while ((index2 = aLine.indexOf(separator, index1)) != -1) {
                    if (aLine.substring(index1, index2).startsWith("\"")) {
                        if ((ind = aLine.indexOf("\"", ++index1)) == -1 || (index2 = aLine.indexOf(separator, ind)) == -1) break;
                        row.add(aLine.substring(index1, ind - 1));
                        index2 = aLine.indexOf(separator, ind);
                        if (index2 == -1) {
                            break;
                        }
                    } else {
                        row.add(aLine.substring(index1, index2));
                    }
                    index1 = index2 + 1;
                }
                if (aLine.substring(index1).startsWith("\"")) {
                    if ((ind = aLine.indexOf("\"", ++index1)) != -1) {
                        row.add(aLine.substring(index1, ind - 1));
                    }
                } else {
                    row.add(aLine.substring(index1));
                }
                list.add(row);
            }
            in.close();
        }
        catch (Exception e) {
            ClUtils.Message("Error " + e.getMessage());
            return;
        }
        this.dataListtoTable(list, title);
    }

    private void dataListtoTable(Vector<Vector<String>> list, String title) {
        if (list != null) {
            int rows = list.size();
            int cols = 0;
            int i = 0;
            while (i < rows) {
                int tmp = list.get(i).size();
                if (cols < tmp) {
                    cols = tmp;
                }
                ++i;
            }
            Object[][] data = new String[rows][cols];
            String[] rLabel = new String[rows];
            String[] cLabel = new String[cols];
            int i2 = 0;
            while (i2 < cols) {
                cLabel[i2] = "C" + (i2 + 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < rows) {
                rLabel[i2] = "R" + (i2 + 1);
                int j = 0;
                while (j < list.get(i2).size()) {
                    data[i2][j] = list.get(i2).get(j);
                    ++j;
                }
                ++i2;
            }
            MyTableModel dm = new MyTableModel(data, rLabel, cLabel);
            TableFrame table = new TableFrame(this, dm);
            if (title != null) {
                table.m_FileName = title;
                table.setTitle(title);
            }
        }
    }

    private void jMenuFileExit_actionPerformed() {
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            if (Cluster.m_bWorking) {
                Cluster.stop();
            }
        } else if (!this.m_Algorithm.equals((Object)NameOfMethod.KMEANS) && PCADlg.m_bWorking) {
            PCADlg.m_thread.stop();
        }
        this.m_wOffset = 0;
        this.dispose();
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            m_Frame = null;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed();
        } else if (e.getID() == 205 && this.getSelectedTable() != null) {
            this.jButton_TransposeTable.setEnabled(true);
            if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
                this.jClustering.setEnabled(true);
            } else if (this.m_Algorithm.equals((Object)NameOfMethod.KMEANS)) {
                this.jButton_Kmeans.setEnabled(true);
            } else {
                this.jButton_PCA.setEnabled(true);
            }
        }
    }

    public void openFile() {
        try {
            JFileChooser chooser = new JFileChooser(last_user_path);
            FileFilter filter1 = FileFilters.getImageFileFilter();
            FileFilter filter2 = FileFilters.getClusterFileFilter();
            FileFilter filter3 = FileFilters.getDataFileFilter();
            FileFilter filter4 = FileFilters.getExcelFileFilter();
            if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
                chooser.addChoosableFileFilter(filter2);
                chooser.addChoosableFileFilter(filter1);
                chooser.addChoosableFileFilter(filter4);
                chooser.addChoosableFileFilter(filter3);
            } else if (!this.m_Algorithm.equals((Object)NameOfMethod.KMEANS)) {
                chooser.addChoosableFileFilter(filter4);
                chooser.addChoosableFileFilter(filter3);
            }
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            String fileName = chooser.getSelectedFile().getPath();
            last_user_path = chooser.getSelectedFile().getParentFile();
            String ext = ClUtils.getExtension(fileName);
            if (ext == null) {
                ext = "txt";
            }
            if (ext.equals("cls")) {
                this.LoadClusterFile(fileName);
            } else if (ext.equals("jpg") || ext.equals("png") || ext.equals("jpeg")) {
                ImageFrame imgf = new ImageFrame(this);
                imgf.LoadImage(fileName);
            } else if (ext.equalsIgnoreCase("xls") || ext.equalsIgnoreCase("xlsx")) {
                try {
                    File txtFile = FileUtilities.tempTextFileFromExcelFile(new File(fileName), '\t');
                    this.LoadDataFile(txtFile.getPath(), fileName);
                    txtFile.delete();
                }
                catch (Exception ex) {
                    ClUtils.ErrorMessage("Can't Load Excel File");
                }
            } else {
                this.LoadDataFile(fileName, fileName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClUtils.ErrorMessage(ex.getMessage());
        }
        catch (Error er) {
            ClUtils.ErrorMessage("Out of Memory!");
        }
    }

    public void replaceToolBar(JToolBar newBar) {
        Component[] comp = this.getContentPane().getComponents();
        if (comp != null) {
            int i = 0;
            while (i < comp.length) {
                if (comp[i] instanceof JToolBar) {
                    this.getContentPane().remove(comp[i]);
                }
                ++i;
            }
        }
        this.getContentPane().add((Component)newBar, "North");
        this.repaint();
    }

    private TableFrame LoadHCAData(String fileName, int rowLabelColNum, int[] data_col_nums) {
        System.out.println("LoadHCAData, fileName=" + fileName + ", rowLabelColNum=" + rowLabelColNum + ", data_col_nums=" + data_col_nums);
        TableFrame tf = null;
        Vector<Vector<String>> list = ClUtils.readTxtIntoVector(new File(fileName));
        HashSet<Integer> colNums = new HashSet<Integer>();
        int[] nArray = data_col_nums;
        int n = data_col_nums.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            colNums.add(x - 1);
            ++n2;
        }
        if (list != null) {
            int rows = list.size();
            int cols = list.get(0).size();
            Object[][] data = new String[rows][cols];
            String[] rLabel = new String[rows];
            String[] cLabel = new String[cols];
            int i = 0;
            while (i < cols) {
                cLabel[i] = "C" + (i + 1);
                ++i;
            }
            i = 0;
            while (i < rows) {
                rLabel[i] = "R" + (i + 1);
                ++i;
            }
            i = 0;
            while (i < rows) {
                data[i][0] = list.get(i).get(rowLabelColNum - 1);
                ++i;
            }
            i = 0;
            while (i < cols) {
                int j = 0;
                while (j < rows) {
                    if (list.get(j).size() > i) {
                        if (colNums.contains(i) && j > 0) {
                            String val = "NaN";
                            try {
                                double v1 = ParsedExpressionValue.fromString(list.get(j).get(i)).getExpressionValue();
                                if (!Double.isInfinite(v1) && !Double.isNaN(v1)) {
                                    val = String.valueOf(v1);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            data[j][i] = val;
                        } else {
                            data[j][i] = list.get(j).get(i);
                        }
                    } else {
                        data[j][i] = "";
                    }
                    ++j;
                }
                ++i;
            }
            MyTableModel dm = new MyTableModel(data, rLabel, cLabel);
            tf = new TableFrame(this, dm);
        }
        return tf;
    }

    public static boolean isGraph3DTester() {
        return false;
    }

    public void LoadDataFile(String fileName, int row_label_col_num, int[] data_col_nums) {
        this.LoadDataFile(fileName, row_label_col_num, data_col_nums, null);
    }

    private void removeAbscentFlag(final TableFrame tf, int[] indices) {
        int cols = indices.length;
        int rows = tf.m_dm.getRowCount() - 1;
        int i = 0;
        while (i < cols) {
            String name = tf.m_dm.getValueAt(0, indices[i]).toString();
            System.out.println("flag cols=" + name);
            if (name.endsWith("Flag")) {
                name = name.substring(0, name.length() - 4);
            }
            tf.m_dm.setValueAt(name, 0, indices[i]);
            ++i;
        }
        System.out.println("m_FilterFlag=" + m_FilterFlag);
        if (m_FilterFlag == 0) {
            return;
        }
        float[] data1 = new float[cols];
        int i2 = 0;
        while (i2 < rows) {
            int j = 0;
            while (j < cols) {
                try {
                    data1[j] = Float.parseFloat((String)tf.m_dm.getValueAt(i2 + 1, indices[j]));
                }
                catch (Exception ex) {
                    data1[j] = Float.NaN;
                }
                ++j;
            }
            boolean remove = true;
            int j2 = 0;
            while (j2 < cols) {
                int m = j2 + 1;
                while (m < cols) {
                    if ((double)Math.abs(data1[j2] - data1[m]) > 1.0E-10) {
                        remove = false;
                        break;
                    }
                    ++m;
                }
                ++j2;
            }
            if (remove) {
                switch (m_FilterFlag) {
                    case 1: {
                        if (!((double)Math.abs(data1[0] - 0.0f) < 1.0E-10)) break;
                        tf.jTable.addRowSelectionInterval(i2 + 1, i2 + 1);
                        break;
                    }
                    case 2: {
                        if (!(data1[0] + 30.0f <= 0.0f)) break;
                        System.out.println("absent row=" + (i2 + 1));
                        tf.jTable.addRowSelectionInterval(i2 + 1, i2 + 1);
                        break;
                    }
                    case 3: {
                        tf.jTable.addRowSelectionInterval(i2 + 1, i2 + 1);
                    }
                }
            }
            ++i2;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tf.tableListener.deleteRow();
            }
        });
    }

    public void LoadDataFile(String fileName, int row_label_col_num, int[] data_col_nums, final List<String>[] grp_col_names) {
        System.out.println("LoadDataFile, fileName=" + fileName);
        this.setCursor(new Cursor(3));
        if (this.m_Algorithm == NameOfMethod.HCA_BY_TTEST || this.m_Algorithm == NameOfMethod.HCA_BY_DATASETS) {
            final TableFrame tf = this.LoadHCAData(fileName, row_label_col_num, data_col_nums);
            if (tf != null) {
                System.out.println("AppFrame.m_bUseFlagData=" + m_bUseFlagData);
                if (m_bUseFlagData) {
                    int flag_offset;
                    int len = data_col_nums.length;
                    int numCol = tf.m_dm.getColumnCount();
                    int[] flag_cols = new int[len];
                    int n = flag_offset = NameOfMethod.HCA_BY_TTEST == this.m_Algorithm ? data_col_nums.length : 1;
                    if (NameOfMethod.HCA_BY_TTEST == this.m_Algorithm) {
                        int[] nArray = data_col_nums;
                        int n2 = data_col_nums.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            int id = nArray[n3];
                            if (id + len >= numCol) {
                                --len;
                            }
                            ++n3;
                        }
                    }
                    int i = 0;
                    while (i < len) {
                        flag_cols[i] = data_col_nums[i] + flag_offset;
                        ++i;
                    }
                    data_col_nums = flag_cols;
                    this.removeAbscentFlag(tf, flag_cols);
                }
                final int[] data_col_nums_fnl = data_col_nums;
                final int row_label_col_num_fnl = row_label_col_num;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClusterDlg dlg = new ClusterDlg((Frame)m_Frame, tf);
                        dlg.jList_Columns.setSelectedIndices(data_col_nums_fnl);
                        dlg.jComboBox_RowLable.setSelectedIndex(row_label_col_num_fnl);
                        dlg.jButton_OK_actionPerformed();
                    }
                });
            }
        } else {
            try {
                RowColLabeledTabularData tabular_data_orig = ClUtils.loadTabularData(fileName, row_label_col_num, data_col_nums, true);
                String[] orig_coord_names = tabular_data_orig.getRowLabels();
                RowColLabeledTabularData data = tabular_data_orig.transposed();
                final PCAResults pca_results = new PCAEngine().doPCA(data.getData(), data.getRowLabels(), orig_coord_names, m_bAutoscale);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PcaFrame fr = AppFrame.isGraph3DTester() ? new PcaFrameEx(AppFrame.this, pca_results, grp_col_names) : new PcaFrame(AppFrame.this, pca_results, grp_col_names);
                        AppFrame.this.m_pcaFrameList.add(fr);
                        AppFrame.this.jButton_PCA.setEnabled(false);
                        AppFrame.this.jButton_TransposeTable.setEnabled(false);
                    }
                });
            }
            catch (OutOfMemoryError oome) {
                ClUtils.ErrorMessage("Out of Memory");
            }
            catch (Exception e) {
                e.printStackTrace();
                ClUtils.ErrorMessage(e.getMessage());
            }
        }
        this.setCursor(new Cursor(0));
    }

    public void LoadDataFile(String fileName, String title) {
        try {
            Vector<Vector<String>> list = ClUtils.readTxtIntoVector(new File(fileName));
            this.dataListtoTable(list, title);
        }
        catch (Error ex) {
            ClUtils.ErrorMessage("Out of Memory!");
        }
    }

    private void LoadClusterFile(String fileName) {
        Cluster tree = new Cluster();
        if (tree.LoadCluster(fileName, this)) {
            ClusterFrame t = new ClusterFrame(this, tree, null);
            t.m_FileName = fileName;
            t.setTitle(fileName);
        }
    }

    private Object getSelectedFrame() {
        int c = this.desktop.getComponentCount();
        int i = 0;
        while (i < c) {
            if (this.desktop.getComponent(i) instanceof TableFrame ? ((TableFrame)this.desktop.getComponent(i)).isSelected() : (this.desktop.getComponent(i) instanceof ClusterFrame ? ((ClusterFrame)this.desktop.getComponent(i)).isSelected() : this.desktop.getComponent(i) instanceof ImageFrame && ((ImageFrame)this.desktop.getComponent(i)).isSelected())) {
                return this.desktop.getComponent(i);
            }
            ++i;
        }
        return null;
    }

    public boolean IsTableSelected() {
        return this.getSelectedFrame() instanceof TableFrame;
    }

    public TableFrame getSelectedTable() {
        int c = this.desktop.getComponentCount();
        int i = 0;
        while (i < c) {
            if (this.desktop.getComponent(i) instanceof TableFrame && ((TableFrame)this.desktop.getComponent(i)).isSelected()) {
                return (TableFrame)this.desktop.getComponent(i);
            }
            ++i;
        }
        return null;
    }

    public int[] getSubWindowLocaton() {
        int[] ret = new int[4];
        Dimension size = this.desktop.getSize();
        ret[0] = (int)((double)size.width * 0.75);
        ret[1] = (int)((double)ret[0] * 0.6);
        ret[2] = m_xOffset * this.m_wOffset;
        ret[3] = m_yOffset * this.m_wOffset++;
        if (ret[2] + ret[0] > size.width || ret[3] + ret[1] > size.height) {
            this.m_wOffset = 0;
            ret[2] = 0;
            ret[3] = 0;
        }
        return ret;
    }

    public String[][] floatToString(float[][] data) {
        String[][] ret = new String[data.length][data[0].length];
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                ret[i][j] = nf.format(data[i][j]);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private void jMenuItem_ClusterAnalysis_actionPerformed() {
        if (Cluster.m_bWorking) {
            ClUtils.Message("I'm busy now, try it later");
            return;
        }
        if (this.IsTableSelected()) {
            TableFrame table = (TableFrame)this.getSelectedFrame();
            ClusterDlg dlg = new ClusterDlg((Frame)this, table);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.getSize();
            Point loc = this.getLocation();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setModal(true);
            dlg.pack();
            dlg.setVisible(true);
        }
    }

    private void jMenuISave_actionPerformed() {
        Object ret = this.getSelectedFrame();
        if (ret instanceof TableFrame) {
            ((TableFrame)ret).SaveData();
        } else if (ret instanceof ClusterFrame) {
            ((ClusterFrame)ret).SaveData();
        } else if (ret instanceof ImageFrame) {
            ((ImageFrame)ret).SaveData();
        }
    }

    private void jMenuItem_SaveAs_actionPerformed() {
        Object ret = this.getSelectedFrame();
        if (ret instanceof ClusterFrame) {
            ((ClusterFrame)ret).SaveAsData();
        } else if (ret instanceof TableFrame) {
            ((TableFrame)ret).SaveAsData();
        } else if (ret instanceof ImageFrame) {
            ((ImageFrame)ret).SaveAsData();
        }
    }

    private void jMenuItem_ImportDB_actionPerformed() {
        try {
            String cmd = "HCA";
            if (this.m_Algorithm.equals((Object)NameOfMethod.KMEANS)) {
                cmd = "KMEANS";
            } else if (this.m_Algorithm.equals((Object)NameOfMethod.PCA)) {
                String string = "PCA";
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void jMenuItem_PCA_propertyChange(PropertyChangeEvent e) {
        ((JMenuItem)e.getSource()).setEnabled(this.IsTableSelected());
    }

    private void doPCA() {
        TableFrame tableF = (TableFrame)this.getSelectedFrame();
        if (PCADlg.m_bWorking) {
            ClUtils.Message("I'm busy now, try it later!");
            return;
        }
        if (tableF == null) {
            return;
        }
        PCADlg dlg = new PCADlg((Frame)this, tableF);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    private void jButton_TransposeTable_actionPerformed() {
        TableFrame oldTableFrame = this.getSelectedTable();
        if (oldTableFrame != null) {
            MyTableModel dm = (MyTableModel)oldTableFrame.jTable.getModel();
            try {
                int cols = dm.m_data.length;
                int rows = dm.m_data[0].length;
                Object[][] data = new Object[rows][cols];
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < cols) {
                        data[i][j] = dm.m_data[j][i];
                        ++j;
                    }
                    ++i;
                }
                String[] rl = new String[dm.m_cLabel.length];
                String[] cl = new String[dm.m_rLabel.length];
                int i2 = 0;
                while (i2 < rl.length) {
                    rl[i2] = "R" + (i2 + 1);
                    ++i2;
                }
                i2 = 0;
                while (i2 < cl.length) {
                    cl[i2] = "C" + (i2 + 1);
                    ++i2;
                }
                TableFrame newTable = new TableFrame(this, new MyTableModel(data, rl, cl));
                newTable.setTitle("Transpose of " + oldTableFrame.getTitle());
            }
            catch (Error ex) {
                ClUtils.ErrorMessage("Out of Memory");
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppFrame frame = null;
        if (args.length > 0) {
            if (args[0].trim().equals("HCA")) {
                frame = new AppFrame(null, NameOfMethod.HCA_BY_DATASETS);
            } else if (args[0].trim().equals("PCA")) {
                frame = new AppFrame(null, NameOfMethod.PCA);
            }
        } else {
            frame = new AppFrame(null, NameOfMethod.PCA);
        }
        boolean packFrame = false;
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        int cx = (int)(screenSize.getWidth() * 0.75);
        int cy = (int)(0.75 * (double)cx);
        frame.setSize(cx, cy);
        frame.setLocation((int)((screenSize.getWidth() - (double)frame.getWidth()) / 2.0), (int)((screenSize.getHeight() - (double)frame.getHeight()) / 2.0));
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setVisible(true);
    }

    public static enum NameOfMethod {
        HCA_BY_TTEST,
        HCA_BY_DATASETS,
        PCA,
        KMEANS;

    }
}

