/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public final class Algorithm {
    public static float GetMinInArray(float[][] data) {
        float min = data[0][0];
        int rows = data.length;
        int cols = data[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (data[i][j] < min) {
                    min = data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public static float GetMaxInArray(float[][] data) {
        float max = data[0][0];
        int rows = data.length;
        int cols = data[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (data[i][j] > max) {
                    max = data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static float Median_quickSelect(float[] data) {
        TreeSet<Float> set = new TreeSet<Float>();
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            set.add(new Float(val));
            ++n2;
        }
        int id = set.size() / 2;
        Iterator it = set.iterator();
        int cc = 0;
        while (it.hasNext() && cc < id) {
            ++cc;
            it.next();
        }
        if (set.size() == 2) {
            it = set.iterator();
            float val = ((Float)it.next()).floatValue();
            return (val += ((Float)it.next()).floatValue()) / 2.0f;
        }
        if (set.size() % 2 == 1) {
            return ((Float)it.next()).floatValue();
        }
        float val = ((Float)it.next()).floatValue();
        return (val += ((Float)it.next()).floatValue()) / 2.0f;
    }

    public static float Mean(float[] data) {
        float tmp = 0.0f;
        int i = 0;
        while (i < data.length) {
            tmp += data[i];
            ++i;
        }
        return tmp / (float)data.length;
    }

    public static double Std(double[] data) {
        if (data.length == 1) {
            return 0.0;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < data.length) {
            sum1 += data[i];
            sum2 += data[i] * data[i];
            ++i;
        }
        sum1 = sum1 * sum1 / (double)data.length;
        return Math.sqrt((sum2 - sum1) / (double)(data.length - 1));
    }

    private static void swapElement(float[] data, int index1, int index2) {
        float tmp = data[index1];
        data[index1] = data[index2];
        data[index2] = tmp;
    }

    public static void SortByBub(float[] data) {
        int k = 0;
        int m = data.length - 1;
        while (k < m) {
            int j = m - 1;
            m = 0;
            int i = k;
            while (i <= j) {
                if (data[i] > data[i + 1]) {
                    Algorithm.swapElement(data, i, i + 1);
                    m = i;
                }
                ++i;
            }
            j = k + 1;
            k = 0;
            i = m;
            while (i >= j) {
                if (data[i - 1] > data[i]) {
                    Algorithm.swapElement(data, i, i - 1);
                    k = i;
                }
                --i;
            }
        }
    }

    public static void SortByShell(double[] data) {
        int k = data.length / 2;
        while (k > 0) {
            int j = k;
            while (j <= data.length - 1) {
                double t = data[j];
                int i = j - k;
                while (i >= 0 && data[i] > t) {
                    data[i + k] = data[i];
                    i -= k;
                }
                data[i + k] = t;
                ++j;
            }
            k /= 2;
        }
    }

    public static double Median(double[] data) {
        Algorithm.SortByShell(data);
        if (data.length % 2 == 1) {
            return data[data.length / 2];
        }
        return (data[data.length / 2 - 1] + data[data.length / 2]) / 2.0;
    }

    public static int[] Kmeans(float[][] data, int[] Noset, float[] dis) {
        int j;
        int temp;
        double oldInterDis;
        int cols = data[0].length;
        int rows = Noset.length;
        float eps = 1.0E-6f;
        if (rows < 3) {
            System.out.println("samples must be more than 2");
            return null;
        }
        Vector<Integer> Cluster1 = new Vector<Integer>();
        Vector<Integer> Cluster2 = new Vector<Integer>();
        float[] Centroid1 = new float[cols];
        float[] Centroid2 = new float[cols];
        int c1 = Noset[0];
        int c2 = Noset[1];
        float min = Float.MIN_VALUE;
        int i = 0;
        while (i < rows - 1) {
            int j2 = i + 1;
            while (j2 < rows) {
                float tmp = Algorithm.disBetweenVector(data[Noset[i]], data[Noset[j2]]);
                if (tmp > min) {
                    min = tmp;
                    c1 = Noset[i];
                    c2 = Noset[j2];
                }
                ++j2;
            }
            ++i;
        }
        Cluster1.add(new Integer(c1));
        Cluster2.add(new Integer(c2));
        double newInterDis = Double.MIN_VALUE;
        double oldIntraDis = Double.MIN_VALUE;
        do {
            oldInterDis = newInterDis;
            newInterDis = 0.0;
            Algorithm.computeCentroid(data, Cluster1, Centroid1);
            Algorithm.computeCentroid(data, Cluster2, Centroid2);
            Cluster1.clear();
            Cluster2.clear();
            int i2 = 0;
            while (i2 < rows) {
                float d2;
                float d1 = Algorithm.disBetweenVector(Centroid1, data[Noset[i2]]);
                if (d1 > (d2 = Algorithm.disBetweenVector(Centroid2, data[Noset[i2]]))) {
                    Cluster2.add(new Integer(Noset[i2]));
                    newInterDis += (double)d2;
                } else {
                    Cluster1.add(new Integer(Noset[i2]));
                    newInterDis += (double)d1;
                }
                ++i2;
            }
            oldIntraDis = dis[0];
            dis[0] = Algorithm.disBetweenVector(Centroid1, Centroid2);
        } while ((double)dis[0] - oldIntraDis > (double)1.0E-6f || oldInterDis - newInterDis > (double)1.0E-6f);
        int[] ret = new int[rows + 2];
        ret[ret.length - 2] = Cluster1.size();
        ret[ret.length - 1] = Cluster2.size();
        int k = 0;
        int m = 0;
        while (m < Cluster1.size()) {
            temp = (Integer)Cluster1.get(m);
            j = 0;
            while (j < rows) {
                if (temp == Noset[j]) {
                    ret[k++] = Noset[j];
                    break;
                }
                ++j;
            }
            ++m;
        }
        m = 0;
        while (m < Cluster2.size()) {
            temp = (Integer)Cluster2.get(m);
            j = 0;
            while (j < rows) {
                if (temp == Noset[j]) {
                    ret[k++] = Noset[j];
                    break;
                }
                ++j;
            }
            ++m;
        }
        dis[0] = (float)newInterDis;
        return ret;
    }

    public static int[] Kmeans(float[][] data, float[][] distance, int[] Noset, float[] dis) {
        int j;
        int temp;
        double oldInterDis;
        int cols = data[0].length;
        int rows = Noset.length;
        float eps = 1.0E-6f;
        if (rows < 3) {
            System.out.println("samples must be more than 2");
            return null;
        }
        Vector<Integer> Cluster1 = new Vector<Integer>();
        Vector<Integer> Cluster2 = new Vector<Integer>();
        float[] Centroid1 = new float[cols];
        float[] Centroid2 = new float[cols];
        int c1 = Noset[0];
        int c2 = Noset[1];
        float max = Float.MIN_VALUE;
        int i = 0;
        while (i < rows - 1) {
            int j2 = i + 1;
            while (j2 < rows) {
                if (Noset[i] < Noset[j2]) {
                    if (distance[Noset[i]][Noset[j2] - Noset[i] - 1] > max) {
                        max = distance[Noset[i]][Noset[j2] - Noset[i] - 1];
                        c1 = Noset[i];
                        c2 = Noset[j2];
                    }
                } else if (distance[Noset[j2]][Noset[i] - Noset[j2] - 1] > max) {
                    max = distance[Noset[j2]][Noset[i] - Noset[j2] - 1];
                    c1 = Noset[i];
                    c2 = Noset[j2];
                }
                ++j2;
            }
            ++i;
        }
        Cluster1.add(new Integer(c1));
        Cluster2.add(new Integer(c2));
        double newInterDis = Double.MIN_VALUE;
        double oldIntraDis = Double.MIN_VALUE;
        do {
            oldInterDis = newInterDis;
            newInterDis = 0.0;
            Algorithm.computeCentroid(data, Cluster1, Centroid1);
            Algorithm.computeCentroid(data, Cluster2, Centroid2);
            Cluster1.clear();
            Cluster2.clear();
            int i2 = 0;
            while (i2 < rows) {
                float d2;
                float d1 = Algorithm.disBetweenVector(Centroid1, data[Noset[i2]]);
                if (d1 > (d2 = Algorithm.disBetweenVector(Centroid2, data[Noset[i2]]))) {
                    Cluster2.add(new Integer(Noset[i2]));
                    newInterDis += (double)d2;
                } else {
                    Cluster1.add(new Integer(Noset[i2]));
                    newInterDis += (double)d1;
                }
                ++i2;
            }
            oldIntraDis = dis[0];
            dis[0] = Algorithm.disBetweenVector(Centroid1, Centroid2);
        } while ((double)dis[0] - oldIntraDis > (double)1.0E-6f || oldInterDis - newInterDis > (double)1.0E-6f);
        int[] ret = new int[rows + 2];
        ret[ret.length - 2] = Cluster1.size();
        ret[ret.length - 1] = Cluster2.size();
        int k = 0;
        int m = 0;
        while (m < Cluster1.size()) {
            temp = (Integer)Cluster1.get(m);
            j = 0;
            while (j < rows) {
                if (temp == Noset[j]) {
                    ret[k++] = Noset[j];
                    break;
                }
                ++j;
            }
            ++m;
        }
        m = 0;
        while (m < Cluster2.size()) {
            temp = (Integer)Cluster2.get(m);
            j = 0;
            while (j < rows) {
                if (temp == Noset[j]) {
                    ret[k++] = Noset[j];
                    break;
                }
                ++j;
            }
            ++m;
        }
        dis[0] = (float)newInterDis;
        return ret;
    }

    static void outputCluster(Vector Cluster1, Vector Cluster2) {
        System.out.print("Cluster 1:");
        int i = 0;
        while (i < Cluster1.size()) {
            System.out.print(String.valueOf((Integer)Cluster1.get(i)) + " ");
            ++i;
        }
        System.out.println();
        System.out.print("Cluster 2:");
        i = 0;
        while (i < Cluster2.size()) {
            System.out.print(String.valueOf((Integer)Cluster2.get(i)) + " ");
            ++i;
        }
        System.out.println();
    }

    private static void computeCentroid(float[][] data, Vector mem, float[] centroid) {
        int col = 0;
        while (col < centroid.length) {
            int count = 0;
            double tmp = 0.0;
            int m = 0;
            while (m < mem.size()) {
                int nIndex = (Integer)mem.get(m);
                if (!Float.isNaN(data[nIndex][col]) && !Float.isInfinite(data[nIndex][col])) {
                    tmp += (double)data[nIndex][col];
                    ++count;
                }
                ++m;
            }
            centroid[col] = (float)(tmp / (double)count);
            ++col;
        }
    }

    public static float disBetweenVector(float[] v1, float[] v2) {
        double dis = 0.0;
        int count = 0;
        int i = 0;
        while (i < v1.length) {
            if (!(Float.isNaN(v1[i]) || Float.isNaN(v2[i]) || Float.isInfinite(v1[i]) || Float.isInfinite(v2[i]))) {
                dis += (double)((v1[i] - v2[i]) * (v1[i] - v2[i]));
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            count = 1;
        }
        return (float)(dis / (double)count * (double)v1.length);
    }

    static void CenterizeData(float[][] Data2) {
        int rows = Data2.length;
        int cols = Data2[0].length;
        float[] Avg = new float[cols];
        int i = 0;
        while (i < cols) {
            double tmp = 0.0;
            int count = 0;
            int j = 0;
            while (j < rows) {
                if (!Float.isNaN(Data2[j][i])) {
                    tmp += (double)Data2[j][i];
                    ++count;
                }
                ++j;
            }
            Avg[i] = (float)(tmp / (double)count);
            ++i;
        }
        i = 0;
        while (i < cols) {
            int j = 0;
            while (j < rows) {
                float[] fArray = Data2[j];
                int n = i;
                fArray[n] = fArray[n] - Avg[i];
                ++j;
            }
            ++i;
        }
    }
}

