/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2;

public class ParsedExpressionValue {
    private double exprVal;
    private double embeddedRatioNumerator;
    private double embeddedRatioDenominator;
    private boolean logApplied;
    private double logBase;

    private ParsedExpressionValue(double val, double embedded_numerator, double embedded_denominator, boolean log_applied, double log_base) {
        this.exprVal = val;
        this.embeddedRatioNumerator = embedded_numerator;
        this.embeddedRatioDenominator = embedded_denominator;
        this.logApplied = log_applied;
        this.logBase = log_base;
    }

    public double getExpressionValue() {
        return this.exprVal;
    }

    public double getEmbeddedRatioNumerator() {
        return this.embeddedRatioNumerator;
    }

    public double getEmbeddedRatioDenominator() {
        return this.embeddedRatioDenominator;
    }

    public boolean isLogApplied() {
        return this.logApplied;
    }

    public double getLogBase() {
        return this.logBase;
    }

    public static ParsedExpressionValue fromString(String val_str) throws NumberFormatException {
        if (val_str.startsWith("l") || val_str.indexOf(47) != -1) {
            double log_base;
            String unlogged_str;
            double log_divisor;
            boolean apply_log;
            if (val_str.startsWith("ln(")) {
                apply_log = true;
                log_divisor = 1.0;
                if (!val_str.endsWith(")")) {
                    throw new NumberFormatException("no closing paren on symbolic log value");
                }
                unlogged_str = val_str.substring("ln(".length(), val_str.length() - 1);
                log_base = Math.E;
            } else if (val_str.startsWith("log2(")) {
                apply_log = true;
                log_divisor = Math.log(2.0);
                if (!val_str.endsWith(")")) {
                    throw new NumberFormatException("no closing paren on symbolic log value");
                }
                unlogged_str = val_str.substring("log2(".length(), val_str.length() - 1);
                log_base = 2.0;
            } else if (val_str.startsWith("log10(")) {
                apply_log = true;
                log_divisor = Math.log(10.0);
                if (!val_str.endsWith(")")) {
                    throw new NumberFormatException("no closing paren on symbolic log value");
                }
                unlogged_str = val_str.substring("log10(".length(), val_str.length() - 1);
                log_base = 10.0;
            } else {
                apply_log = false;
                log_divisor = Double.NaN;
                unlogged_str = val_str;
                log_base = Double.NaN;
            }
            int slash_ix = unlogged_str.indexOf(47);
            if (slash_ix == -1) {
                double unlogged_val = Double.parseDouble(unlogged_str);
                return new ParsedExpressionValue(Math.log(unlogged_val) / log_divisor, unlogged_val, Double.NaN, true, log_base);
            }
            if (slash_ix != 0 && slash_ix != unlogged_str.length() - 1) {
                double numerator = Double.parseDouble(unlogged_str.substring(0, slash_ix));
                double denominator = Double.parseDouble(unlogged_str.substring(slash_ix + 1));
                double val = apply_log ? Math.log(numerator / denominator) / log_divisor : numerator / denominator;
                return new ParsedExpressionValue(val, numerator, denominator, apply_log, log_base);
            }
            throw new NumberFormatException("Missing numerator or denominator in symbolic expression value");
        }
        double val = Double.parseDouble(val_str);
        return new ParsedExpressionValue(val, val, Double.NaN, false, Double.NaN);
    }
}

