/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01bNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01bNEWT.setResetXRandRIfX11AfterClass();
        width = 200;
        height = 200;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) throws InterruptedException {
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        int[] nArray = gLWindow.convertToWindowUnits(new int[]{n, n2});
        gLWindow.setTitle(string);
        gLWindow.setPosition(nArray[0], nArray[1]);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener(new GearsES2());
        Assert.assertNotNull(gLWindow);
        long l = System.currentTimeMillis();
        gLWindow.setVisible(true);
        System.err.println("Time for visible/pos: " + (System.currentTimeMillis() - l) + " ms");
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(window, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenModeChangeSingleQ1() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(0).getViewport();
            this.testScreenModeChangeImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY());
        }
        finally {
            screen.removeReference();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenModeChangeSingleQ2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (1): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(1).getViewport();
            this.testScreenModeChangeImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY());
        }
        finally {
            screen.removeReference();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    void testScreenModeChangeImpl(Screen screen, int n, int n2) throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = screen.getDisplay();
        System.err.println("Test.0: Window screen: " + screen);
        System.err.println("Test.0: Window bounds (pre): screenPos " + n + "/" + n2 + " [pixels], windowSize " + width + "x" + height + " [wu] within " + screen.getViewport() + " [pixels]");
        GLWindow gLWindow = TestScreenMode01bNEWT.createWindow(screen, gLCapabilities, "win0", n, n2, width, height);
        Assert.assertNotNull(gLWindow);
        Rectangle rectangle = gLWindow.getBounds();
        Dimension dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        System.err.println("Test.0: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Window size      : " + dimension + " [pixels]");
        Animator animator = new Animator(gLWindow);
        animator.start();
        List<MonitorMode> list = screen.getMonitorModes();
        Assert.assertTrue(list.size() > 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode01bNEWT.destroyWindow(gLWindow);
            return;
        }
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.0: Window monitor: " + monitorDevice);
        List<MonitorMode> list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue(list2.size() > 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode01bNEWT.destroyWindow(gLWindow);
            return;
        }
        Assert.assertTrue(list.containsAll(list2));
        MonitorMode monitorMode = monitorDevice.getCurrentMode();
        Assert.assertNotNull(monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull(monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals(monitorMode, monitorMode2);
        list2 = MonitorModeUtil.filterByFlags(list2, 0);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRotation(list2, 0);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByResolution(list2, new Dimension(801, 601));
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRate(list2, monitorMode2.getRefreshRate());
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp(list2);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        MonitorMode monitorMode3 = list2.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl);
        Assert.assertTrue(monitorDevice.isModeChangedByUs());
        Assert.assertEquals(monitorMode3, monitorMode);
        Assert.assertNotSame(monitorMode2, monitorMode);
        Assert.assertEquals(monitorMode, monitorDevice.queryCurrentMode());
        Assert.assertTrue(bl);
        rectangle = gLWindow.getBounds();
        dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        System.err.println("Test.1: Screen           : " + screen);
        System.err.println("Test.1: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.1: Screen viewport  : " + screen.getViewport() + " [pixels]");
        System.err.println("Test.1: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Window main-mon  : " + gLWindow.getMainMonitor());
        Thread.sleep(duration);
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("[1] set orig: " + monitorMode2);
        boolean bl2 = monitorDevice.setCurrentMode(monitorMode2);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[1] has orig?: " + monitorMode + ", changeOK " + bl2);
        Assert.assertFalse(monitorDevice.isModeChangedByUs());
        Assert.assertEquals(monitorMode2, monitorMode);
        Assert.assertTrue(bl2);
        rectangle = gLWindow.getBounds();
        dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        System.err.println("Test.2: Screen           : " + screen);
        System.err.println("Test.2: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.2: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.2: Screen viewport  : " + screen.getViewport() + " [pixels]");
        System.err.println("Test.2: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.2: Window main-mon  : " + gLWindow.getMainMonitor());
        Thread.sleep(duration);
        animator.stop();
        TestScreenMode01bNEWT.destroyWindow(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        String string = TestScreenMode01bNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 2000L;
        duration = 6000L;
    }
}

