/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01aNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;
    static int mm_width;
    static int mm_height;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01aNEWT.setResetXRandRIfX11AfterClass();
        width = 100;
        height = 100;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static Window createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) {
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener(new GearsES2());
        Assert.assertNotNull(gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void testScreenModeChange01() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        Window window = TestScreenMode01aNEWT.createWindow(screen, gLCapabilities, "win0", 0, 0, width, height);
        Assert.assertNotNull(window);
        MonitorDevice monitorDevice = screen.getMonitorDevices().get(0);
        Rectangle rectangle = window.getBounds();
        Dimension dimension = new Dimension(window.getSurfaceWidth(), window.getSurfaceHeight());
        System.err.println("Test.0: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.0: Screen viewport  : " + screen.getViewport() + " [pixels], " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        List<MonitorMode> list = screen.getMonitorModes();
        Assert.assertTrue(list.size() > 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode01aNEWT.destroyWindow(window);
            return;
        }
        List<MonitorMode> list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue(list2.size() > 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode01aNEWT.destroyWindow(window);
            return;
        }
        Assert.assertTrue(list.containsAll(list2));
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull(monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull(monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals(monitorMode, monitorMode2);
        list2 = MonitorModeUtil.filterByFlags(list2, 0);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRotation(list2, 0);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByResolution(list2, new Dimension(mm_width + 1, mm_height + 1));
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRate(list2, monitorMode2.getRefreshRate());
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp(list2);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        MonitorMode monitorMode3 = list2.get(0);
        System.err.println("[1] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        MonitorMode monitorMode4 = monitorDevice.getCurrentMode();
        MonitorMode monitorMode5 = monitorDevice.queryCurrentMode();
        boolean bl2 = monitorMode5.equals(monitorMode4);
        System.err.println("[1] changeOK             : " + bl);
        System.err.println("[1] has current cached   : " + monitorMode4);
        System.err.println("[1] has current queried  : " + monitorMode5 + ", equal " + bl2);
        rectangle = window.getBounds();
        dimension = new Dimension(window.getSurfaceWidth(), window.getSurfaceHeight());
        System.err.println("Test.1: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.1: Screen viewport  : " + screen.getViewport() + " [pixels], " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        Assert.assertTrue(monitorDevice.isModeChangedByUs());
        Assert.assertEquals(monitorMode3, monitorMode4);
        Assert.assertNotSame(monitorMode2, monitorMode4);
        Assert.assertEquals(monitorMode4, monitorDevice.queryCurrentMode());
        Assert.assertTrue(bl);
        Thread.sleep(duration);
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, window.isNativeValid());
        Assert.assertEquals(true, window.isVisible());
        TestScreenMode01aNEWT.destroyWindow(window);
        Assert.assertEquals(false, window.isVisible());
        Assert.assertEquals(false, window.isNativeValid());
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, display.isNativeValid());
        Thread.sleep(waitTimeShort);
        this.validateScreenModeReset(monitorMode2, 0);
    }

    void validateScreenModeReset(MonitorMode monitorMode, int n) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertEquals(false, screen.isNativeValid());
        screen.addReference();
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        MonitorDevice monitorDevice = screen.getMonitorDevices().get(0);
        Assert.assertEquals(monitorMode, monitorDevice.getCurrentMode());
        screen.removeReference();
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertEquals(false, screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-mwidth")) {
                mm_width = MiscUtils.atoi(stringArray[++i], mm_width);
                continue;
            }
            if (!stringArray[i].equals("-mheight")) continue;
            mm_height = MiscUtils.atoi(stringArray[++i], mm_height);
        }
        System.err.println("Desired mode w/ resolution " + mm_width + "x" + mm_height);
        String string = TestScreenMode01aNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 2000L;
        duration = 4000L;
        mm_width = 800;
        mm_height = 600;
    }
}

