/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindows01NEWT
extends UITestCase {
    static int width;
    static int height;

    @BeforeClass
    public static void initClass() {
        NativeWindowFactory.initSingleton();
        width = 256;
        height = 256;
    }

    static Window createWindow(Capabilities capabilities, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws InterruptedException {
        boolean bl3 = n >= 0 && n2 >= 0;
        Assert.assertNotNull(capabilities);
        capabilities.setOnscreen(bl);
        Window window = NewtFactory.createWindow(capabilities);
        Assert.assertNotNull(window);
        Screen screen = window.getScreen();
        Display display = screen.getDisplay();
        window.setUndecorated(bl && bl2);
        if (bl3) {
            window.setPosition(n, n2);
        }
        window.setSize(n3, n4);
        Assert.assertEquals(false, window.isNativeValid());
        Assert.assertEquals(false, window.isVisible());
        window.setVisible(true);
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, window.isVisible());
        Assert.assertEquals(true, window.isNativeValid());
        Assert.assertEquals(n3, window.getWidth());
        Assert.assertEquals(n4, window.getHeight());
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        Assert.assertNotNull(capabilitiesImmutable);
        Assert.assertTrue(capabilitiesImmutable.getGreenBits() >= 5);
        Assert.assertTrue(capabilitiesImmutable.getBlueBits() >= 5);
        Assert.assertTrue(capabilitiesImmutable.getRedBits() >= 5);
        Assert.assertEquals(capabilitiesImmutable.isOnscreen(), bl);
        return window;
    }

    static void destroyWindow(Window window, boolean bl) {
        if (null == window) {
            return;
        }
        Screen screen = window.getScreen();
        Display display = screen.getDisplay();
        window.destroy();
        if (bl) {
            Assert.assertEquals(false, screen.isNativeValid());
            Assert.assertEquals(false, display.isNativeValid());
        } else {
            Assert.assertEquals(true, screen.isNativeValid());
            Assert.assertEquals(true, display.isNativeValid());
        }
        Assert.assertEquals(false, window.isNativeValid());
        Assert.assertEquals(false, window.isVisible());
    }

    @Test
    public void testWindowDecorSimpleWMPos() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull(capabilities);
        Window window = TestWindows01NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        TestWindows01NEWT.destroyWindow(window, true);
    }

    @Test
    public void testWindowDecorSimpleUserPos() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull(capabilities);
        Window window = TestWindows01NEWT.createWindow(capabilities, 100, 100, width, height, true, false);
        TestWindows01NEWT.destroyWindow(window, true);
    }

    @Test
    public void testWindowNativeRecreate01Simple() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull(capabilities);
        Window window = TestWindows01NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        TestWindows01NEWT.destroyWindow(window, true);
        window.setVisible(true);
        Assert.assertEquals(true, window.isNativeValid());
        Assert.assertEquals(true, window.isVisible());
        Assert.assertEquals(width, window.getWidth());
        Assert.assertEquals(height, window.getHeight());
        TestWindows01NEWT.destroyWindow(window, true);
    }

    @Test
    public void testWindowDecorDestroyWinTwiceA() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull(capabilities);
        Window window = TestWindows01NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        TestWindows01NEWT.destroyWindow(window, true);
        TestWindows01NEWT.destroyWindow(window, true);
    }

    @Test
    public void testWindowDecorTwoWin() throws InterruptedException {
        Capabilities capabilities = new Capabilities();
        Assert.assertNotNull(capabilities);
        Window window = TestWindows01NEWT.createWindow(capabilities, -1, -1, width, height, true, false);
        Window window2 = TestWindows01NEWT.createWindow(capabilities, 100, 100, width, height, true, false);
        TestWindows01NEWT.destroyWindow(window2, false);
        TestWindows01NEWT.destroyWindow(window, true);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestWindows01NEWT.class.getName();
        JUnitCore.main(string);
    }
}

