/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindowClosingProtocol03NewtAWT
extends UITestCase {
    @Test
    public void testCloseJFrameNewtCanvasAWT() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame("testCloseJFrameNewtCanvasAWT");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        AWTRobotUtil.WindowClosingListener windowClosingListener2 = AWTRobotUtil.addClosingListener(gLWindow);
        gLWindow.addGLEventListener(new GearsES2());
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().add(newtCanvasAWT);
                jFrame.pack();
                jFrame.setSize(512, 512);
                jFrame.validate();
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals(true, jFrame.isDisplayable());
        Assert.assertEquals(true, jFrame.isVisible());
        Assert.assertEquals(true, newtCanvasAWT.isValid());
        Assert.assertEquals(true, newtCanvasAWT.isDisplayable());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(1L, jFrame.getDefaultCloseOperation());
        WindowClosingProtocol.WindowClosingMode windowClosingMode = newtCanvasAWT.getDefaultCloseOperation();
        Assert.assertEquals((Object)WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE, (Object)windowClosingMode);
        Thread.sleep(300L);
        Assert.assertEquals(true, AWTRobotUtil.closeWindow(jFrame, false, windowClosingListener));
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, false));
        Assert.assertEquals(true, jFrame.isDisplayable());
        Assert.assertEquals(false, jFrame.isVisible());
        Assert.assertEquals(true, newtCanvasAWT.isValid());
        Assert.assertEquals(true, newtCanvasAWT.isDisplayable());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, windowClosingListener.isWindowClosing());
        Assert.assertEquals(false, windowClosingListener.isWindowClosed());
        Assert.assertEquals(true, windowClosingListener2.isWindowClosing());
        Assert.assertEquals(false, windowClosingListener2.isWindowClosed());
        windowClosingListener.reset();
        windowClosingListener2.reset();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals(true, jFrame.isDisplayable());
        Assert.assertEquals(true, jFrame.isVisible());
        jFrame.setDefaultCloseOperation(2);
        Assert.assertEquals(2L, jFrame.getDefaultCloseOperation());
        windowClosingMode = newtCanvasAWT.getDefaultCloseOperation();
        Assert.assertEquals((Object)WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE, (Object)windowClosingMode);
        Thread.sleep(300L);
        Assert.assertEquals(true, AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertEquals(false, jFrame.isDisplayable());
        Assert.assertEquals(false, jFrame.isVisible());
        Assert.assertEquals(false, newtCanvasAWT.isValid());
        Assert.assertEquals(false, newtCanvasAWT.isDisplayable());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(true, windowClosingListener.isWindowClosing());
        Assert.assertEquals(true, windowClosingListener.isWindowClosed());
        Assert.assertEquals(true, windowClosingListener2.isWindowClosing());
        Assert.assertEquals(true, windowClosingListener2.isWindowClosed());
    }

    public static void main(String[] stringArray) {
        String string = TestWindowClosingProtocol03NewtAWT.class.getName();
        JUnitCore.main(string);
    }
}

