/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRemoteWindow01NEWT
extends UITestCase {
    static int width;
    static int height;
    static String remoteDisplay;

    @BeforeClass
    public static void initClass() {
        NativeWindowFactory.initSingleton();
        width = 640;
        height = 480;
    }

    static Window createWindow(Screen screen, Capabilities capabilities, int n, int n2, boolean bl, boolean bl2) {
        Assert.assertNotNull(capabilities);
        capabilities.setOnscreen(bl);
        Window window = NewtFactory.createWindow(screen, (CapabilitiesImmutable)capabilities);
        Assert.assertNotNull(window);
        window.setUndecorated(bl && bl2);
        window.setSize(n, n2);
        Assert.assertEquals(false, window.isNativeValid());
        Assert.assertEquals(false, window.isVisible());
        window.setVisible(true);
        Assert.assertEquals(true, window.isVisible());
        Assert.assertEquals(true, window.isNativeValid());
        CapabilitiesImmutable capabilitiesImmutable = window.getGraphicsConfiguration().getChosenCapabilities();
        Assert.assertNotNull(capabilitiesImmutable);
        Assert.assertTrue(capabilitiesImmutable.getGreenBits() > 5);
        Assert.assertTrue(capabilitiesImmutable.getBlueBits() > 5);
        Assert.assertTrue(capabilitiesImmutable.getRedBits() > 5);
        Assert.assertEquals(capabilitiesImmutable.isOnscreen(), bl);
        return window;
    }

    static void destroyWindow(Display display, Screen screen, Window window) {
        if (null != window) {
            window.destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
    }

    @Test
    public void testRemoteWindow01() throws InterruptedException {
        Window window;
        Screen screen;
        Display display;
        Capabilities capabilities = new Capabilities();
        Display display2 = NewtFactory.createDisplay(null);
        Screen screen2 = NewtFactory.createScreen(display2, 0);
        Window window2 = TestRemoteWindow01NEWT.createWindow(screen2, capabilities, width, height, true, false);
        window2.setVisible(true);
        Assert.assertEquals(true, window2.isNativeValid());
        Assert.assertEquals(true, window2.isVisible());
        try {
            display = NewtFactory.createDisplay(remoteDisplay);
            display.createNative();
            screen = NewtFactory.createScreen(display, 0);
            window = TestRemoteWindow01NEWT.createWindow(screen, capabilities, width, height, true, false);
            window.setVisible(true);
        }
        catch (NativeWindowException nativeWindowException) {
            System.err.println(nativeWindowException);
            Assume.assumeNoException(nativeWindowException);
            TestRemoteWindow01NEWT.destroyWindow(display2, screen2, window2);
            return;
        }
        Assert.assertEquals(true, window.isNativeValid());
        Assert.assertEquals(true, window.isVisible());
        Thread.sleep(500L);
        TestRemoteWindow01NEWT.destroyWindow(display2, screen2, window2);
        TestRemoteWindow01NEWT.destroyWindow(display, screen, window);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-display")) continue;
            remoteDisplay = stringArray[++i];
        }
        System.out.println("display: " + remoteDisplay);
        String string = TestRemoteWindow01NEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        remoteDisplay = "localhost:0.0";
    }
}

