/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindows02NEWTAnimated
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        GLWindow gLWindow;
        Object object;
        Assert.assertNotNull(gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        if (null != screen) {
            object = NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull(object);
            gLWindow = GLWindow.create((Window)object);
        } else {
            gLWindow = GLWindow.create(gLCapabilities);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        Assert.assertNotNull(gLWindow);
        gLWindow.setUndecorated(bl && bl2);
        object = new GearsES2(bl3 ? 1 : 0);
        TestGLWindows02NEWTAnimated.setDemoFields((GLEventListener)object, gLWindow);
        gLWindow.addGLEventListener((GLEventListener)object);
        gLWindow.addWindowListener(new TraceWindowAdapter());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        gLWindow.setSize(n, n2);
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLWindow.getChosenGLCapabilities();
        Assert.assertNotNull(gLCapabilitiesImmutable);
        Assert.assertTrue(gLCapabilitiesImmutable.getGreenBits() >= 5);
        Assert.assertTrue(gLCapabilitiesImmutable.getBlueBits() >= 5);
        Assert.assertTrue(gLCapabilitiesImmutable.getRedBits() >= 5);
        Assert.assertEquals(gLCapabilitiesImmutable.isOnscreen(), bl);
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    @Test
    public void testWindowDecor01Simple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(null, gLCapabilities, width, height, true, false, true);
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        Assert.assertTrue(animator.start());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.isStarted());
        animator.remove(gLWindow);
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertTrue(animator.stop());
    }

    @Test
    public void testWindowDecor02DestroyWinTwiceA() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(null, gLCapabilities, width, height, true, false, true);
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(1, null);
        Assert.assertTrue(animator.start());
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        animator.add(gLWindow);
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isPaused());
        animator.remove(gLWindow);
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertTrue(animator.stop());
    }

    @Test
    public void testWindowDecor03TwoWinOneDisplay() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(0, 0);
        GLWindow gLWindow2 = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width - 10, height - 10, true, false, true);
        Assert.assertNotNull(gLWindow2);
        RectangleImmutable rectangleImmutable = screen.getViewportInWindowUnits();
        gLWindow2.setPosition(rectangleImmutable.getWidth() - width, 0);
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(1, null);
        Assert.assertEquals(false, animator.isStarted());
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertTrue(animator.start());
        Assert.assertEquals(true, animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        animator.add(gLWindow);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        animator.add(gLWindow2);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        gLWindow.destroy();
        animator.remove(gLWindow);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest + durationPerTest / 10L) {
            Thread.sleep(100L);
        }
        gLWindow2.destroy();
        animator.remove(gLWindow2);
        Assert.assertEquals(true, animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertTrue(animator.stop());
    }

    @Test
    public void testWindowDecor03TwoWinTwoDisplays() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null, false);
        Assert.assertNotNull(display);
        Display display2 = NewtFactory.createDisplay(null, false);
        Assert.assertNotNull(display2);
        Assert.assertNotSame(display, display2);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        GLWindow gLWindow = TestGLWindows02NEWTAnimated.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(0, 0);
        Screen screen2 = NewtFactory.createScreen(display2, 0);
        Assert.assertNotNull(screen2);
        GLWindow gLWindow2 = TestGLWindows02NEWTAnimated.createWindow(screen2, gLCapabilities, width - 10, height - 10, true, false, true);
        Assert.assertNotNull(gLWindow2);
        RectangleImmutable rectangleImmutable = screen2.getViewportInWindowUnits();
        gLWindow2.setPosition(rectangleImmutable.getWidth() - width, 0);
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(1, null);
        Assert.assertEquals(false, animator.isStarted());
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertTrue(animator.start());
        Assert.assertEquals(true, animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        animator.add(gLWindow);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        animator.add(gLWindow2);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow);
        animator.remove(gLWindow);
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest + durationPerTest / 10L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(true, animator.pause());
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertEquals(true, animator.resume());
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        TestGLWindows02NEWTAnimated.destroyWindow(gLWindow2);
        animator.remove(gLWindow2);
        Assert.assertEquals(true, animator.isStarted());
        Thread.sleep(250L);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.isPaused());
        Assert.assertTrue(animator.stop());
        Assert.assertEquals(false, animator.isStarted());
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindows02NEWTAnimated.atoi(stringArray[++i]);
        }
        String string = TestGLWindows02NEWTAnimated.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
    }
}

