/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTexture02AWT
extends UITestCase {
    static long durationPerTest = 500L;
    static GLProfile glp;
    static GLCapabilities caps;

    @BeforeClass
    public static void initClass() {
        if (!GLProfile.isAvailable("GL2ES2")) {
            UITestCase.setTestSupported(false);
            return;
        }
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull(glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull(caps);
    }

    @Test
    public void test1() throws InterruptedException {
        final AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(caps.getGLProfile(), false);
        final Frame frame = new Frame("GL -> AWT");
        final ImageIcon imageIcon = new ImageIcon();
        final JLabel jLabel = new JLabel(imageIcon);
        frame.add(jLabel);
        GLCanvas gLCanvas = new GLCanvas(caps);
        final Frame frame2 = new Frame("GearsES2");
        Assert.assertNotNull(frame2);
        frame2.add(gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                BufferedImage bufferedImage = aWTGLReadBufferUtil.readPixelsToBufferedImage(gLAutoDrawable.getGL(), true);
                imageIcon.setImage(bufferedImage);
                jLabel.repaint();
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                frame.setSize(frame2.getWidth(), frame2.getHeight());
                frame.setLocation(frame2.getX() + frame2.getWidth() + 32, frame.getY());
                frame.validate();
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame2.setSize(256, 256);
                    frame2.setLocation(0, 0);
                    frame2.setVisible(true);
                    frame.setSize(frame2.getWidth(), frame2.getHeight());
                    frame.setLocation(frame2.getX() + frame2.getWidth() + 32, frame.getY());
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        FPSAnimator fPSAnimator = new FPSAnimator(gLCanvas, 15);
        fPSAnimator.start();
        Thread.sleep(durationPerTest);
        fPSAnimator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.dispose();
                    frame2.setVisible(false);
                    frame2.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        String string = TestTexture02AWT.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }
}

