/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledRendering1GL2NEWT
extends UITestCase {
    static long duration = 500L;

    private static DrawableContext createDrawableAndCurrentCtx(GLCapabilities gLCapabilities, int n, int n2) {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createOffscreenDrawable(null, gLCapabilities, null, n, n2);
        gLDrawable.setRealized(true);
        GLContext gLContext = null;
        gLContext = gLDrawable.createContext(null);
        Assert.assertTrue("Context could not be made current", 0 < gLContext.makeCurrent());
        return new DrawableContext(gLDrawable, gLContext);
    }

    private static void destroyDrawableContext(DrawableContext drawableContext) {
        if (null != drawableContext.glc) {
            drawableContext.glc.destroy();
            drawableContext.glc = null;
        }
        if (null != drawableContext.d) {
            drawableContext.d.setRealized(false);
            drawableContext.d = null;
        }
    }

    @Test
    public void test01() throws IOException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        DrawableContext drawableContext = TestTiledRendering1GL2NEWT.createDrawableAndCurrentCtx(gLCapabilities, 256, 256);
        GL2 gL2 = drawableContext.glc.getGL().getGL2();
        int n = drawableContext.d.getSurfaceWidth() * 6;
        int n2 = drawableContext.d.getSurfaceHeight() * 4;
        String string = this.getSnapshotFilename(0, "-tile", drawableContext.d.getChosenGLCapabilities(), n, n2, false, "png", null);
        File file = new File(string);
        TileRenderer tileRenderer = new TileRenderer();
        tileRenderer.setTileSize(drawableContext.d.getSurfaceWidth(), drawableContext.d.getSurfaceHeight(), 0);
        tileRenderer.setImageSize(n, n2);
        GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        boolean[] blArray = new boolean[]{false};
        PixelFormat.Composition composition = gLPixelBufferProvider.getHostPixelComp(gL2.getGLProfile(), 3);
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = gLPixelBufferProvider.getAttributes(gL2, 3, true);
        GLPixelBuffer gLPixelBuffer = gLPixelBufferProvider.allocate(gL2, composition, gLPixelAttributes, true, n, n2, 1, 0);
        tileRenderer.setImageBuffer(gLPixelBuffer);
        blArray[0] = false;
        Gears gears = new Gears();
        gears.setVerbose(false);
        gears.init(gL2);
        gears.addTileRendererNotify(tileRenderer);
        while (!tileRenderer.eot()) {
            tileRenderer.beginTile(gL2);
            gears.reshape(gL2, tileRenderer.getParam(3), tileRenderer.getParam(4), tileRenderer.getParam(5), tileRenderer.getParam(6), tileRenderer.getParam(1), tileRenderer.getParam(2));
            gears.display(gL2);
            tileRenderer.endTile(gL2);
        }
        gears.removeTileRendererNotify(tileRenderer);
        TestTiledRendering1GL2NEWT.destroyDrawableContext(drawableContext);
        GLPixelBuffer gLPixelBuffer2 = tileRenderer.getImageBuffer();
        TextureData textureData = new TextureData(gLCapabilities.getGLProfile(), 0, n, n2, 0, gLPixelBuffer2.pixelAttributes, false, false, blArray[0], gLPixelBuffer2.buffer, null);
        TextureIO.write(textureData, file);
    }

    @Test
    public void test02_EOT_01() throws IOException {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        DrawableContext drawableContext = TestTiledRendering1GL2NEWT.createDrawableAndCurrentCtx(gLCapabilities, 256, 256);
        GL2 gL2 = drawableContext.glc.getGL().getGL2();
        int n = drawableContext.d.getSurfaceWidth() * 6;
        int n2 = drawableContext.d.getSurfaceHeight() * 4;
        TileRenderer tileRenderer = new TileRenderer();
        tileRenderer.setTileSize(drawableContext.d.getSurfaceWidth(), drawableContext.d.getSurfaceHeight(), 0);
        IllegalStateException illegalStateException = null;
        try {
            tileRenderer.beginTile(gL2);
        }
        catch (IllegalStateException illegalStateException2) {
            illegalStateException = illegalStateException2;
            System.err.println("Expected " + illegalStateException.getClass().getSimpleName() + ": " + illegalStateException.getMessage());
        }
        Assert.assertNotNull("TileRenderer.beginTile: Image-size exception missing", illegalStateException);
        tileRenderer.setImageSize(n, n2);
        tileRenderer.clipImageSize(0, 0);
        try {
            tileRenderer.beginTile(gL2);
        }
        catch (IllegalStateException illegalStateException3) {
            illegalStateException = illegalStateException3;
            System.err.println("Expected " + illegalStateException.getClass().getSimpleName() + ": " + illegalStateException.getMessage());
        }
        Assert.assertNotNull("TileRenderer.beginTile: EOT (1) exception missing", illegalStateException);
        tileRenderer.clipImageSize(n, n2);
        Gears gears = new Gears();
        gears.setVerbose(false);
        gears.init(gL2);
        gears.addTileRendererNotify(tileRenderer);
        int n3 = 0;
        while (!tileRenderer.eot()) {
            tileRenderer.beginTile(gL2);
            gears.reshape(gL2, tileRenderer.getParam(3), tileRenderer.getParam(4), tileRenderer.getParam(5), tileRenderer.getParam(6), tileRenderer.getParam(1), tileRenderer.getParam(2));
            gears.display(gL2);
            tileRenderer.endTile(gL2);
            ++n3;
        }
        try {
            tileRenderer.beginTile(gL2);
        }
        catch (IllegalStateException illegalStateException4) {
            illegalStateException = illegalStateException4;
            System.err.println("Expected " + illegalStateException.getClass().getSimpleName() + ": " + illegalStateException.getMessage());
        }
        Assert.assertNotNull("TileRenderer.beginTile: EOT (2) exception missing", illegalStateException);
        gears.removeTileRendererNotify(tileRenderer);
        Assert.assertTrue("TileRenderer not rendered more than one tile but " + n3, n3 > 1);
        TestTiledRendering1GL2NEWT.destroyDrawableContext(drawableContext);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestTiledRendering1GL2NEWT.class.getName());
    }

    static class DrawableContext {
        GLDrawable d;
        GLContext glc;

        DrawableContext(GLDrawable gLDrawable, GLContext gLContext) {
            this.d = gLDrawable;
            this.glc = gLContext;
        }
    }
}

