/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.RandomTileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRandomTiledRendering2GL2NEWT
extends UITestCase {
    static long duration = 500L;

    @Test
    public void test01_aa0() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(0);
    }

    @Test
    public void test02_aa8() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(8);
    }

    void doTest(int n) throws IOException, InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setDoubleBuffered(true);
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, 64, 64);
        final Gears gears = new Gears();
        gLOffscreenAutoDrawable.addGLEventListener(gears);
        String string = this.getSnapshotFilename(0, "-tile", gLOffscreenAutoDrawable.getChosenGLCapabilities(), 1536, 1024, false, "png", null);
        File file = new File(string);
        final RandomTileRenderer randomTileRenderer = new RandomTileRenderer();
        randomTileRenderer.attachAutoDrawable(gLOffscreenAutoDrawable);
        randomTileRenderer.setImageSize(1536, 1024);
        final GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        final boolean[] blArray = new boolean[]{false};
        GLEventListener gLEventListener = new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                PixelFormat.Composition composition = gLPixelBufferProvider.getHostPixelComp(gL.getGLProfile(), 3);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = gLPixelBufferProvider.getAttributes(gL, 3, true);
                GLPixelBuffer gLPixelBuffer = gLPixelBufferProvider.allocate(gL, composition, gLPixelAttributes, true, 1536, 1024, 1, 0);
                randomTileRenderer.setImageBuffer(gLPixelBuffer);
                blArray[0] = !gLAutoDrawable.isGLOriented();
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        };
        randomTileRenderer.setGLEventListener(gLEventListener, null);
        int n2 = 0;
        int n3 = 0;
        while (n2 + 64 <= 1536 && n3 + 64 <= 1024) {
            randomTileRenderer.display(n2, n3, 64, 64);
            if ((n2 += 96) + 64 <= 1536) continue;
            n2 = 0;
            n3 += 96;
        }
        randomTileRenderer.detachAutoDrawable();
        gLOffscreenAutoDrawable.invoke(true, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                gears.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
                return false;
            }
        });
        gLOffscreenAutoDrawable.destroy();
        GLPixelBuffer gLPixelBuffer = randomTileRenderer.getImageBuffer();
        gLPixelBuffer.clear();
        System.err.println("XXX2: " + gLPixelBuffer);
        TextureData textureData = new TextureData(gLCapabilities.getGLProfile(), 0, 1536, 1024, 0, gLPixelBuffer.pixelAttributes, false, false, blArray[0], gLPixelBuffer.buffer, null);
        System.err.println("XXX3: " + textureData.getPixelFormat() + ", " + textureData.getPixelAttributes());
        TextureIO.write(textureData, file);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestRandomTiledRendering2GL2NEWT.class.getName());
    }
}

