/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.VectorUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestQuaternion01NOUI {
    static final boolean DEBUG = false;
    static final Quaternion QUAT_IDENT = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    static final float[] ZERO = new float[]{0.0f, 0.0f, 0.0f};
    static final float[] ONE = new float[]{1.0f, 1.0f, 1.0f};
    static final float[] NEG_ONE = new float[]{-1.0f, -1.0f, -1.0f};
    static final float[] UNIT_X = new float[]{1.0f, 0.0f, 0.0f};
    static final float[] UNIT_Y = new float[]{0.0f, 1.0f, 0.0f};
    static final float[] UNIT_Z = new float[]{0.0f, 0.0f, 1.0f};
    static final float[] NEG_UNIT_X = new float[]{-1.0f, 0.0f, 0.0f};
    static final float[] NEG_UNIT_Y = new float[]{0.0f, -1.0f, 0.0f};
    static final float[] NEG_UNIT_Z = new float[]{0.0f, 0.0f, -1.0f};
    static final float[] NEG_ONE_v4 = new float[]{-1.0f, -1.0f, -1.0f, 0.0f};
    static final float[] ONE_v4 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    static final float MACH_EPSILON = FloatUtil.getMachineEpsilon();

    @Test
    public void test01Normalize() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).normalize();
        Assert.assertEquals(0.0f, Math.abs(1.0f - quaternion2.magnitude()), MACH_EPSILON);
    }

    @Test
    public void test02RotateZeroVector() {
        Quaternion quaternion = new Quaternion();
        float[] fArray = quaternion.rotateVector(new float[3], 0, ZERO, 0);
        Assert.assertArrayEquals(ZERO, fArray, 1.1920929E-7f);
    }

    @Test
    public void test03InvertAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion).invert();
        Assert.assertEquals(quaternion, quaternion2.invert());
        quaternion = new Quaternion(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2 = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f).conjugate();
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test04Dot() {
        Quaternion quaternion = new Quaternion(7.0f, 2.0f, 5.0f, -1.0f);
        Assert.assertTrue(35.0f == quaternion.dot(3.0f, 1.0f, 2.0f, -2.0f));
        Assert.assertTrue(-11.0f == quaternion.dot(new Quaternion(-1.0f, 1.0f, -1.0f, 1.0f)));
    }

    @Test
    public void test10AngleAxis() {
        float[] fArray = new float[3];
        Quaternion quaternion = new Quaternion().setFromAngleAxis(1.5707964f, new float[]{2.0f, 0.0f, 0.0f}, fArray);
        Quaternion quaternion2 = new Quaternion().setFromAngleNormalAxis(1.5707964f, new float[]{1.0f, 0.0f, 0.0f});
        Assert.assertEquals(quaternion2, quaternion);
        Assert.assertEquals(0.0f, 1.0f - quaternion2.magnitude(), 1.1920929E-7f);
        Assert.assertTrue(1.0f - quaternion.magnitude() <= 1.1920929E-7f);
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        quaternion.rotateVector(fArray2, 0, ONE, 0);
        quaternion2.rotateVector(fArray3, 0, ONE, 0);
        Assert.assertArrayEquals(fArray2, fArray3, 1.1920929E-7f);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray2, fArray3)), 1.1920929E-7f);
        quaternion.rotateVector(fArray2, 0, UNIT_Z, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Y, fArray2)), 1.1920929E-7f);
        quaternion2.setFromAngleAxis(1.5707964f, ZERO, fArray);
        Assert.assertEquals(QUAT_IDENT, quaternion2);
        float f = quaternion.toAngleAxis(fArray2);
        quaternion2.setFromAngleAxis(f, fArray2, fArray);
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        f = quaternion.toAngleAxis(fArray2);
        Assert.assertTrue(0.0f == f);
        Assert.assertArrayEquals(UNIT_X, fArray2, 1.1920929E-7f);
    }

    @Test
    public void test11FromVectorToVector() {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        Quaternion quaternion = new Quaternion();
        quaternion.setFromVectors(UNIT_Z, UNIT_X, fArray, fArray2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromNormalVectors(UNIT_Z, UNIT_X, fArray);
        Assert.assertEquals(quaternion, quaternion2);
        quaternion2.setFromAngleAxis(1.5707964f, UNIT_Y, fArray);
        Assert.assertEquals(quaternion2, quaternion);
        quaternion.setFromVectors(UNIT_Z, NEG_UNIT_Z, fArray, fArray2);
        quaternion.rotateVector(fArray3, 0, UNIT_Z, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Z, fArray3)), 1.0E-6f);
        quaternion.setFromVectors(UNIT_X, NEG_UNIT_X, fArray, fArray2);
        quaternion.rotateVector(fArray3, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray3)), 1.0E-6f);
        quaternion.setFromVectors(UNIT_Y, NEG_UNIT_Y, fArray, fArray2);
        quaternion.rotateVector(fArray3, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Y, fArray3)), 1.0E-6f);
        quaternion.setFromVectors(ONE, NEG_ONE, fArray, fArray2);
        quaternion.rotateVector(fArray3, 0, ONE, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_ONE, fArray3)), 1.0E-6f);
        quaternion.setFromVectors(ZERO, ZERO, fArray, fArray2);
        Assert.assertEquals(QUAT_IDENT, quaternion);
    }

    @Test
    public void test12FromAndToEulerAngles() {
        Quaternion quaternion = new Quaternion();
        float[] fArray = new float[]{0.0f, 1.5707964f, 0.0f};
        quaternion.setFromEuler(fArray);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        float[] fArray2 = quaternion.toEuler(new float[3]);
        Assert.assertArrayEquals(fArray, fArray2, 1.1920929E-7f);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromEuler(fArray2);
        Assert.assertEquals(quaternion, quaternion2);
        float[] fArray3 = new float[]{0.0f, 0.0f, -1.5707964f};
        quaternion.setFromEuler(fArray3);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        float[] fArray4 = quaternion.toEuler(new float[3]);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion2.setFromEuler(fArray4);
        Assert.assertEquals(quaternion, quaternion2);
        float[] fArray5 = new float[]{1.5707964f, 0.0f, 0.0f};
        quaternion.setFromEuler(fArray5);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        float[] fArray6 = quaternion.toEuler(new float[3]);
        Assert.assertArrayEquals(fArray5, fArray6, 1.1920929E-7f);
        quaternion2.setFromEuler(fArray6);
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test13FromEulerAnglesAndRotateVector() {
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(0.0f, 1.5707964f, 0.0f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        float[] fArray = quaternion.rotateVector(new float[3], 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Z, fArray)), 1.1920929E-7f);
        quaternion.setFromEuler(0.0f, 0.0f, -1.5707964f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Y, fArray)), 1.1920929E-7f);
        quaternion.setFromEuler(1.5707964f, 0.0f, 0.0f);
        Assert.assertEquals(1.0f, quaternion.magnitude(), 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_Z, fArray)), 1.1920929E-7f);
    }

    @Test
    public void test14Matrix() {
        float[] fArray = new float[3];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        Quaternion quaternion = new Quaternion();
        FloatUtil.makeIdentity(fArray3);
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        float f = 1.5707964f;
        fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_Z, fArray)), 1.0E-6f);
        quaternion.setFromMatrix(fArray3, 0);
        quaternion.rotateVector(fArray, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_Z, fArray)), 1.0E-6f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, NEG_ONE, 0);
        FloatUtil.multMatrixVec(fArray4, NEG_ONE_v4, fArray2);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
        f = (float)Math.PI;
        fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        quaternion.setFromEuler(f, 0.0f, 0.0f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Y, fArray)), 1.0E-6f);
        quaternion.setFromMatrix(fArray3, 0);
        quaternion.rotateVector(fArray, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_Y, fArray)), 1.0E-6f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, ONE, 0);
        FloatUtil.multMatrixVec(fArray4, ONE_v4, fArray2);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
        f = (float)Math.PI;
        fArray3 = new float[]{FloatUtil.cos(f), 0.0f, -FloatUtil.sin(f), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, FloatUtil.sin(f), 0.0f, FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        quaternion.setFromEuler(0.0f, f, 0.0f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray)), 1.0E-6f);
        quaternion.setFromMatrix(fArray3, 0);
        quaternion.rotateVector(fArray, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray)), 1.0E-6f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, NEG_ONE, 0);
        FloatUtil.multMatrixVec(fArray4, NEG_ONE_v4, fArray2);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
        f = (float)Math.PI;
        fArray3 = new float[]{FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        quaternion.setFromEuler(0.0f, 0.0f, f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray)), 1.0E-6f);
        quaternion.setFromMatrix(fArray3, 0);
        quaternion.rotateVector(fArray, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray)), 1.0E-6f);
        quaternion.toMatrix(fArray4, 0);
        Assert.assertArrayEquals(fArray3, fArray4, 1.1920929E-7f);
        quaternion.rotateVector(fArray, 0, ONE, 0);
        FloatUtil.multMatrixVec(fArray4, ONE_v4, fArray2);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
        f = 0.7853982f;
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        fArray3 = new float[]{FloatUtil.cos(f), FloatUtil.sin(f), 0.0f, 0.0f, -FloatUtil.sin(f), FloatUtil.cos(f), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        quaternion.setFromMatrix(fArray3, 0);
        FloatUtil.copyMatrixColumn(fArray3, 0, 0, fArray5, 0);
        quaternion.copyMatrixColumn(0, fArray6, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray5, fArray6)), 1.1920929E-7f);
        FloatUtil.copyMatrixColumn(fArray3, 0, 1, fArray5, 0);
        quaternion.copyMatrixColumn(1, fArray6, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray5, fArray6)), 1.1920929E-7f);
        FloatUtil.copyMatrixColumn(fArray3, 0, 2, fArray5, 0);
        quaternion.copyMatrixColumn(2, fArray6, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray5, fArray6)), 1.1920929E-7f);
        quaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
        Assert.assertArrayEquals(UNIT_X, quaternion.copyMatrixColumn(0, fArray6, 0), 1.1920929E-7f);
    }

    @Test
    public void test15aAxesAndMatrix() {
        float[] fArray = new float[]{0.0f, 1.5707964f, 0.0f};
        float[] fArray2 = new float[16];
        FloatUtil.makeRotationEuler(fArray2, 0, fArray[0], fArray[1], fArray[2]);
        float[] fArray3 = new float[16];
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(fArray);
        quaternion.toMatrix(fArray3, 0);
        Assert.assertArrayEquals(fArray2, fArray3, 1.1920929E-7f);
        float[] fArray4 = new float[3];
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMatrix(fArray2, 0);
        quaternion2.toEuler(fArray4);
        Assert.assertArrayEquals(fArray, fArray4, 1.1920929E-7f);
        Assert.assertEquals(quaternion2, quaternion);
        float[] fArray5 = new float[3];
        quaternion2.toEuler(fArray5);
        quaternion.setFromEuler(fArray5);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test15bAxesAndMatrix() {
        float[] fArray = new float[]{1.5707964f, 0.0f, 0.0f};
        float[] fArray2 = new float[16];
        FloatUtil.makeRotationEuler(fArray2, 0, fArray[0], fArray[1], fArray[2]);
        float[] fArray3 = new float[16];
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(fArray);
        quaternion.toMatrix(fArray3, 0);
        Assert.assertArrayEquals(fArray2, fArray3, 1.1920929E-7f);
        float[] fArray4 = new float[3];
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMatrix(fArray2, 0);
        quaternion2.toEuler(fArray4);
        Assert.assertArrayEquals(fArray, fArray4, 1.1920929E-7f);
        Assert.assertEquals(quaternion2, quaternion);
        float[] fArray5 = new float[3];
        quaternion2.toEuler(fArray5);
        quaternion.setFromEuler(fArray5);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test15cAxesAndMatrix() {
        float[] fArray = new float[]{0.7853982f, 1.5707964f, 0.0f};
        float[] fArray2 = new float[16];
        FloatUtil.makeRotationEuler(fArray2, 0, fArray[0], fArray[1], fArray[2]);
        float[] fArray3 = new float[16];
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(fArray);
        quaternion.toMatrix(fArray3, 0);
        Assert.assertArrayEquals(fArray2, fArray3, 1.1920929E-7f);
        float[] fArray4 = new float[3];
        Quaternion quaternion2 = new Quaternion();
        quaternion2.setFromMatrix(fArray2, 0);
        quaternion2.toEuler(fArray4);
        Assert.assertArrayEquals(fArray, fArray4, 1.1920929E-7f);
        Assert.assertEquals(quaternion2, quaternion);
        float[] fArray5 = new float[3];
        quaternion2.toEuler(fArray5);
        quaternion.setFromEuler(fArray5);
        Assert.assertEquals(quaternion2, quaternion);
    }

    @Test
    public void test20AddSubtract() {
        Quaternion quaternion = new Quaternion(1.0f, 2.0f, 3.0f, 4.0f);
        Quaternion quaternion2 = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion3 = new Quaternion(1.0f, 1.0f, 1.0f, 1.0f);
        Quaternion quaternion4 = new Quaternion();
        quaternion4.set(quaternion2);
        quaternion4.add(quaternion3);
        Assert.assertEquals(quaternion, quaternion4);
        quaternion2.set(0.0f, 1.0f, 2.0f, 3.0f);
        quaternion3.set(1.0f, 1.0f, 1.0f, 1.0f);
        quaternion4.set(quaternion2);
        quaternion4.subtract(quaternion3);
        Assert.assertEquals(new Quaternion(-1.0f, 0.0f, 1.0f, 2.0f), quaternion4);
    }

    @Test
    public void test21Multiply() {
        Quaternion quaternion = new Quaternion(0.5f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.set(quaternion);
        quaternion2.scale(2.0f);
        Assert.assertEquals(new Quaternion(1.0f, 2.0f, 4.0f, 6.0f), quaternion2);
        quaternion2.set(quaternion);
        quaternion2.scale(4.0f);
        Assert.assertEquals(new Quaternion(2.0f, 4.0f, 8.0f, 12.0f), quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.mult(quaternion);
        float[] fArray = new float[3];
        quaternion2.rotateVector(fArray, 0, UNIT_Z, 0);
        Assert.assertTrue(Math.abs(VectorUtil.distVec3(UNIT_X, fArray)) <= 1.0E-6f);
        quaternion2.setFromAngleNormalAxis(1.5707964f, UNIT_Y);
        quaternion.mult(quaternion);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(fArray, 0, UNIT_Z, 0);
        Assert.assertTrue(Math.abs(VectorUtil.distVec3(NEG_UNIT_Z, fArray)) <= 1.0E-6f);
        quaternion2.setFromEuler(0.0f, 1.5707964f, 0.0f);
        quaternion.mult(quaternion2);
        quaternion.rotateVector(fArray, 0, UNIT_Z, 0);
        Assert.assertTrue(Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray)) <= 1.0E-6f);
    }

    @Test
    public void test22InvertMultNormalAndConj() {
        Quaternion quaternion = new Quaternion(0.0f, 1.0f, 2.0f, 3.0f);
        Quaternion quaternion2 = new Quaternion(quaternion);
        Quaternion quaternion3 = new Quaternion(quaternion);
        quaternion2.invert();
        quaternion3.mult(quaternion2);
        Assert.assertEquals(QUAT_IDENT, quaternion3);
        quaternion2.invert();
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.setFromAngleNormalAxis(0.7853982f, UNIT_Y);
        quaternion2.set(quaternion);
        quaternion2.invert();
        quaternion3.set(quaternion);
        quaternion3.mult(quaternion2);
        Assert.assertEquals(QUAT_IDENT, quaternion3);
        quaternion2.invert();
        Assert.assertEquals(quaternion, quaternion2);
        quaternion.set(-1.0f, -2.0f, -3.0f, 4.0f);
        quaternion2.set(1.0f, 2.0f, 3.0f, 4.0f);
        quaternion3.set(quaternion2);
        quaternion3.conjugate();
        Assert.assertEquals(quaternion, quaternion3);
    }

    @Test
    public void test23RotationOrder() {
        Object object = new Quaternion().setFromEuler((float)(-Math.PI), 0.0f, 0.0f);
        Object object2 = new Quaternion().rotateByAngleX((float)(-Math.PI));
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler(1.5707964f, 0.0f, 0.0f);
        object2 = new Quaternion().rotateByAngleX(1.5707964f);
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler(1.5707964f, 0.7853982f, 0.0f);
        object2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleX(1.5707964f);
        Assert.assertEquals(object, object2);
        object = new Quaternion().setFromEuler((float)Math.PI, 0.7853982f, 1.5707964f);
        object2 = new Quaternion().rotateByAngleY(0.7853982f).rotateByAngleZ(1.5707964f).rotateByAngleX((float)Math.PI);
        Assert.assertEquals(object, object2);
        object = new float[3];
        object2 = new float[3];
        Quaternion quaternion = new Quaternion();
        quaternion.setFromEuler(1.5707964f, 0.7853982f, (float)Math.PI);
        object2 = new float[]{1.0f, 1.0f, 1.0f};
        quaternion.rotateVector((float[])object2, 0, (float[])object2, 0);
        object = new float[]{1.0f, 1.0f, 1.0f};
        Quaternion quaternion2 = new Quaternion();
        quaternion2.rotateByAngleY(0.7853982f).rotateByAngleZ((float)Math.PI).rotateByAngleX(1.5707964f);
        quaternion.rotateVector((float[])object, 0, (float[])object, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3((float[])object, (float[])object2), 1.1920929E-7f);
        object = new float[]{1.0f, 1.0f, 1.0f};
        object2 = new float[]{1.0f, 1.0f, 1.0f};
        quaternion2.setIdentity().rotateByAngleX(0.7853982f).rotateVector((float[])object, 0, (float[])object, 0);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 1.0f, 0.0f, 0.0f).rotateVector((float[])object2, 0, (float[])object2, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3((float[])object, (float[])object2), 1.1920929E-7f);
        object = new float[]{1.0f, 1.0f, 1.0f};
        object2 = new float[]{1.0f, 1.0f, 1.0f};
        quaternion2.setIdentity().rotateByAngleY(0.7853982f).rotateVector((float[])object, 0, (float[])object, 0);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 1.0f, 0.0f).rotateVector((float[])object2, 0, (float[])object2, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3((float[])object, (float[])object2), 1.1920929E-7f);
        object = new float[]{1.0f, 1.0f, 1.0f};
        object2 = new float[]{1.0f, 1.0f, 1.0f};
        quaternion2.setIdentity().rotateByAngleZ(0.7853982f).rotateVector((float[])object, 0, (float[])object, 0);
        quaternion2.setIdentity().rotateByAngleNormalAxis(0.7853982f, 0.0f, 0.0f, 1.0f).rotateVector((float[])object2, 0, (float[])object2, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3((float[])object, (float[])object2), 1.1920929E-7f);
        quaternion.set(quaternion2);
        quaternion2.rotateByAngleNormalAxis(0.0f, 0.0f, 0.0f, 0.0f);
        Assert.assertEquals(quaternion, quaternion2);
    }

    @Test
    public void test24Axes() {
        Quaternion quaternion = new Quaternion().rotateByAngleX(0.7853982f).rotateByAngleY(1.5707964f);
        float[] fArray = new float[16];
        quaternion.toMatrix(fArray, 0);
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        FloatUtil.copyMatrixColumn(fArray, 0, 0, fArray2, 0);
        FloatUtil.copyMatrixColumn(fArray, 0, 1, fArray3, 0);
        FloatUtil.copyMatrixColumn(fArray, 0, 2, fArray4, 0);
        Quaternion quaternion2 = new Quaternion().setFromAxes(fArray2, fArray3, fArray4);
        Assert.assertEquals(quaternion, quaternion2);
        Quaternion quaternion3 = new Quaternion().setFromMatrix(fArray, 0);
        Assert.assertEquals(quaternion3, quaternion2);
        quaternion2.toAxes(fArray2, fArray3, fArray4, fArray);
        quaternion3.setFromAxes(fArray2, fArray3, fArray4);
        Assert.assertEquals(quaternion, quaternion3);
        Assert.assertEquals(quaternion2, quaternion3);
    }

    @Test
    public void test25Slerp() {
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion().rotateByAngleY(1.5707964f);
        float[] fArray = new float[]{FloatUtil.sin(0.7853982f), 0.0f, FloatUtil.sin(0.7853982f)};
        float[] fArray2 = new float[3];
        Quaternion quaternion3 = new Quaternion();
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(fArray2, 0, UNIT_Z, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 1.0f);
        quaternion3.rotateVector(fArray2, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(NEG_UNIT_X, fArray2)), 1.0E-6f);
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(fArray2, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_Y, fArray2)), 1.0E-6f);
        quaternion2.setIdentity().rotateByAngleZ((float)Math.PI);
        quaternion3.setSlerp(quaternion, quaternion2, 0.0f);
        quaternion3.rotateVector(fArray2, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_X, fArray2)), 1.0E-6f);
        quaternion2.setIdentity();
        quaternion3.setSlerp(quaternion, quaternion2, 0.25f);
        quaternion3.rotateVector(fArray2, 0, UNIT_X, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(UNIT_X, fArray2)), 1.0E-6f);
        fArray = new float[]{0.0f, -FloatUtil.sin(0.7853982f), FloatUtil.sin(0.7853982f)};
        quaternion.setIdentity().rotateByAngleX((float)(-Math.PI));
        quaternion2.setIdentity().rotateByAngleX(1.5707964f);
        quaternion3.setSlerp(quaternion, quaternion2, 0.5f);
        quaternion3.rotateVector(fArray2, 0, UNIT_Y, 0);
        Assert.assertEquals(0.0f, Math.abs(VectorUtil.distVec3(fArray, fArray2)), 1.0E-6f);
    }

    @Test
    public void test26LookAt() {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        VectorUtil.copyVec3(fArray, 0, NEG_UNIT_X, 0);
        Quaternion quaternion = new Quaternion().setLookAt(fArray, UNIT_Y, fArray2, fArray3, fArray4);
        Assert.assertEquals(0.0f, VectorUtil.distVec3(fArray, quaternion.rotateVector(fArray5, 0, UNIT_Z, 0)), 1.0E-6f);
        VectorUtil.normalizeVec3(VectorUtil.copyVec3(fArray, 0, ONE, 0));
        quaternion.setLookAt(fArray, UNIT_Y, fArray2, fArray3, fArray4);
        quaternion.rotateVector(fArray5, 0, UNIT_Z, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3(fArray, fArray5), 1.0E-6f);
        VectorUtil.normalizeVec3(VectorUtil.copyVec3(fArray, 0, new float[]{-1.0f, 2.0f, -1.0f}, 0));
        quaternion.setLookAt(fArray, UNIT_Y, fArray2, fArray3, fArray4);
        quaternion.rotateVector(fArray5, 0, UNIT_Z, 0);
        Assert.assertEquals(0.0f, VectorUtil.distVec3(fArray, fArray5), 1.0E-6f);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestQuaternion01NOUI.class.getName());
    }
}

