/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.opengl.math.Binary16;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public final class TestBinary16NOUI
extends UITestCase {
    static int stepping = 1;
    static boolean verbose = false;

    @Test
    public void testExponentIdentity() {
        System.out.println("-- Exponent identities");
        for (int i = -15; i <= 16; ++i) {
            char c = Binary16.packSetExponentUnbiasedUnchecked(i);
            int n = Binary16.unpackGetExponentUnbiased(c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals(i, n);
        }
    }

    @Test
    public void testInfinite() {
        Assert.assertTrue(Binary16.isInfinite(Binary16.POSITIVE_INFINITY));
        Assert.assertTrue(Binary16.isInfinite(Binary16.NEGATIVE_INFINITY));
        Assert.assertFalse(Binary16.isInfinite(Binary16.exampleNaN()));
        for (int i = 0; i <= 65535; i += stepping) {
            Assert.assertFalse(Binary16.isInfinite(Binary16.packDouble(i)));
        }
    }

    @Test
    public void testInfinityExponent() {
        Assert.assertEquals(16L, Binary16.unpackGetExponentUnbiased(Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeExponent() {
        Assert.assertEquals(16L, Binary16.unpackGetExponentUnbiased(Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeSign() {
        Assert.assertEquals(1L, Binary16.unpackGetSign(Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeSignificand() {
        Assert.assertEquals(0L, Binary16.unpackGetSignificand(Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinitySign() {
        Assert.assertEquals(0L, Binary16.unpackGetSign(Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testInfinitySignificand() {
        Assert.assertEquals(0L, Binary16.unpackGetSignificand(Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testNaN() {
        int n = Binary16.packSetExponentUnbiasedUnchecked(16) | Binary16.packSetSignificandUnchecked(1);
        char c = (char)n;
        Assert.assertEquals(16L, Binary16.unpackGetExponentUnbiased(c));
        Assert.assertEquals(1L, Binary16.unpackGetSignificand(c));
        Assert.assertEquals(16L, Binary16.unpackGetExponentUnbiased(Binary16.exampleNaN()));
        Assert.assertEquals(1L, Binary16.unpackGetSignificand(Binary16.exampleNaN()));
        Assert.assertTrue(Binary16.isNaN(c));
        Assert.assertTrue(Binary16.isNaN(Binary16.exampleNaN()));
    }

    @Test
    public void testPackDoubleNaN() {
        char c = Binary16.packDouble(Double.NaN);
        Assert.assertTrue(Binary16.isNaN(c));
    }

    @Test
    public void testPackDoubleNegativeInfinity() {
        Assert.assertTrue(Binary16.NEGATIVE_INFINITY == Binary16.packDouble(Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testPackDoubleNegativeZero() {
        Assert.assertTrue(Binary16.NEGATIVE_ZERO == Binary16.packDouble(-0.0));
    }

    @Test
    public void testPackDoublePositiveInfinity() {
        Assert.assertTrue(Binary16.POSITIVE_INFINITY == Binary16.packDouble(Double.POSITIVE_INFINITY));
    }

    @Test
    public void testPackDoublePositiveZero() {
        Assert.assertTrue(Binary16.POSITIVE_ZERO == Binary16.packDouble(0.0));
    }

    @Test
    public void testPackDoubleUnpackFloat() {
        for (int i = 0; i <= 65536; i += stepping) {
            double d = i;
            char c = Binary16.packDouble(d);
            float f = Binary16.unpackFloat(c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString(c), d, Float.valueOf(f)));
            }
            if (i <= 2048) {
                Assert.assertEquals(d, (double)f, 0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue(f % 2.0f == 0.0f);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue(f % 4.0f == 0.0f);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue(f % 8.0f == 0.0f);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue(f % 16.0f == 0.0f);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue(f % 32.0f == 0.0f);
            }
            if (i != 65536) continue;
            Assert.assertTrue(Double.isInfinite(f));
        }
    }

    @Test
    public void testPackFloatDoubleEquivalent() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            double d = i;
            char c = Binary16.packFloat(f);
            char c2 = Binary16.packDouble(d);
            if (verbose) {
                System.out.println("i: " + i);
                System.out.println(String.format("pack_f: 0x%04x 0b%s", c, Binary16.toRawBinaryString(c)));
                System.out.println(String.format("pack_d: 0x%04x 0b%s", c2, Binary16.toRawBinaryString(c2)));
            }
            Assert.assertEquals(c, c2);
        }
    }

    @Test
    public void testPackFloatNaN() {
        char c = Binary16.packFloat(Float.NaN);
        Assert.assertTrue(Binary16.isNaN(c));
    }

    @Test
    public void testPackFloatNegativeInfinity() {
        Assert.assertTrue(Binary16.NEGATIVE_INFINITY == Binary16.packFloat(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testPackFloatNegativeZero() {
        Assert.assertTrue(Binary16.NEGATIVE_ZERO == Binary16.packFloat(-0.0f));
    }

    @Test
    public void testPackFloatPositiveInfinity() {
        Assert.assertTrue(Binary16.POSITIVE_INFINITY == Binary16.packFloat(Float.POSITIVE_INFINITY));
    }

    @Test
    public void testPackFloatPositiveZero() {
        Assert.assertTrue(Binary16.POSITIVE_ZERO == Binary16.packFloat(0.0f));
    }

    @Test
    public void testPackFloatUnpackDouble() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            char c = Binary16.packFloat(f);
            double d = Binary16.unpackDouble(c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString(c), Float.valueOf(f), d));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)f, d, 0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue(d % 2.0 == 0.0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue(d % 4.0 == 0.0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue(d % 8.0 == 0.0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue(d % 16.0 == 0.0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue(d % 32.0 == 0.0);
            }
            if (i != 65536) continue;
            Assert.assertTrue(Double.isInfinite(d));
        }
    }

    @Test
    public void testPackUnpackDouble() {
        for (int i = 0; i <= 65536; i += stepping) {
            double d = i;
            char c = Binary16.packDouble(d);
            double d2 = Binary16.unpackDouble(c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString(c), d, d2));
            }
            if (i <= 2048) {
                Assert.assertEquals(d, d2, 0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue(d2 % 2.0 == 0.0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue(d2 % 4.0 == 0.0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue(d2 % 8.0 == 0.0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue(d2 % 16.0 == 0.0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue(d2 % 32.0 == 0.0);
            }
            if (i != 65536) continue;
            Assert.assertTrue(Double.isInfinite(d2));
        }
    }

    @Test
    public void testPackUnpackFloat() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            char c = Binary16.packFloat(f);
            float f2 = Binary16.unpackFloat(c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString(c), Float.valueOf(f), Float.valueOf(f2)));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)f, (double)f2, 0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue(f2 % 2.0f == 0.0f);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue(f2 % 4.0f == 0.0f);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue(f2 % 8.0f == 0.0f);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue(f2 % 16.0f == 0.0f);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue(f2 % 32.0f == 0.0f);
            }
            if (i != 65536) continue;
            Assert.assertTrue(Float.isInfinite(f2));
        }
    }

    @Test
    public void testSignIdentity() {
        System.out.println("-- Sign identities");
        for (int i = 0; i <= 1; ++i) {
            char c = Binary16.packSetSignUnchecked(i);
            int n = Binary16.unpackGetSign(c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals(i, n);
        }
    }

    @Test
    public void testSignificandIdentity() {
        System.out.println("-- Significand identities");
        for (int i = 0; i <= 1023; ++i) {
            char c = Binary16.packSetSignificandUnchecked(i);
            int n = Binary16.unpackGetSignificand(c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals(i, n);
        }
    }

    @Test
    public void testUnpackDoubleNaN() {
        double d = Binary16.unpackDouble(Binary16.exampleNaN());
        Assert.assertTrue(Double.isNaN(d));
    }

    @Test
    public void testUnpackDoubleNegativeInfinity() {
        Assert.assertTrue(Double.NEGATIVE_INFINITY == Binary16.unpackDouble(Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testUnpackDoubleNegativeZero() {
        Assert.assertTrue(-0.0 == Binary16.unpackDouble(Binary16.NEGATIVE_ZERO));
    }

    @Test
    public void testUnpackDoubleOne() {
        double d = Binary16.unpackDouble('\u3c00');
        System.out.println(String.format("0x%04x -> %f", 15360, d));
        Assert.assertEquals(d, 1.0, 0.0);
    }

    @Test
    public void testUnpackDoubleOneNegative() {
        double d = Binary16.unpackDouble('\ubc00');
        System.out.println(String.format("0x%04x -> %f", 48128, d));
        Assert.assertEquals(d, -1.0, 0.0);
    }

    @Test
    public void testUnpackDoublePositiveInfinity() {
        Assert.assertTrue(Double.POSITIVE_INFINITY == Binary16.unpackDouble(Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testUnpackDoublePositiveZero() {
        Assert.assertTrue(0.0 == Binary16.unpackDouble(Binary16.POSITIVE_ZERO));
    }

    @Test
    public void testUnpackDoubleTwo() {
        double d = Binary16.unpackDouble('\u4000');
        System.out.println(String.format("%04x -> %f", 16384, d));
        Assert.assertEquals(d, 2.0, 0.0);
    }

    @Test
    public void testUnpackDoubleTwoNegative() {
        double d = Binary16.unpackDouble('\uc000');
        System.out.println(String.format("%04x -> %f", 49152, d));
        Assert.assertEquals(d, -2.0, 0.0);
    }

    @Test
    public void testUnpackFloatNaN() {
        float f = Binary16.unpackFloat(Binary16.exampleNaN());
        Assert.assertTrue(Float.isNaN(f));
    }

    @Test
    public void testUnpackFloatNegativeInfinity() {
        Assert.assertTrue(Float.NEGATIVE_INFINITY == Binary16.unpackFloat(Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testUnpackFloatNegativeZero() {
        Assert.assertTrue(-0.0 == (double)Binary16.unpackFloat(Binary16.NEGATIVE_ZERO));
    }

    @Test
    public void testUnpackFloatOne() {
        float f = Binary16.unpackFloat('\u3c00');
        System.out.println(String.format("0x%04x -> %f", 15360, Float.valueOf(f)));
        Assert.assertEquals((double)f, 1.0, 0.0);
    }

    @Test
    public void testUnpackFloatOneNegative() {
        float f = Binary16.unpackFloat('\ubc00');
        System.out.println(String.format("0x%04x -> %f", 48128, Float.valueOf(f)));
        Assert.assertEquals((double)f, -1.0, 0.0);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-stepping")) {
                stepping = MiscUtils.atoi(stringArray[++i], stepping);
                continue;
            }
            if (!stringArray[i].equals("-verbose")) continue;
            verbose = true;
        }
        JUnitCore.main(TestBinary16NOUI.class.getName());
    }
}

