/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTransformFeedbackVaryingsBug407NEWT
extends UITestCase {
    private static final boolean debugGL = true;
    private static final String VERTEX_SHADER_TEXT = "#version 150                           \n                                       \nout vec4 Position;                     \n                                       \nvoid main() {                          \n  Position = vec4(1.0, 1.0, 1.0, 1.0); \n}                                      \n";
    static final String glps = "GL3";

    private MyShader attachShader(GL3 gL3, String string, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        int n2 = gL3.glCreateProgram();
        int n3 = gL3.glCreateShader(n);
        String[] stringArray = new String[]{string};
        int[] nArray = new int[]{stringArray[0].length()};
        gL3.glShaderSource(n3, stringArray.length, stringArray, nArray, 0);
        gL3.glCompileShader(n3);
        if (!ShaderUtil.isShaderStatusValid((GL)gL3, n3, 35713, printStream)) {
            System.out.println("getShader:postCompile: " + byteArrayOutputStream.toString());
            Assert.assertTrue(false);
        }
        printStream.flush();
        byteArrayOutputStream.reset();
        gL3.glAttachShader(n2, n3);
        Assert.assertEquals(0L, gL3.glGetError());
        return new MyShader(n2, n3);
    }

    private void releaseShader(GL3 gL3, MyShader myShader) {
        if (null != myShader) {
            gL3.glDetachShader(myShader.shaderProgram, myShader.vertShader);
            gL3.glDeleteShader(myShader.vertShader);
            gL3.glDeleteProgram(myShader.shaderProgram);
        }
        Assert.assertEquals(0L, gL3.glGetError());
    }

    private NEWTGLContext.WindowContext prepareTest() throws GLException, InterruptedException {
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(new GLCapabilities(GLProfile.getMaxProgrammable(true)), 480, 480, true);
        if (!windowContext.context.getGL().isGL3()) {
            System.err.println("GL3 not available");
            this.cleanupTest(windowContext);
            return null;
        }
        Assert.assertEquals(0L, windowContext.context.getGL().glGetError());
        return windowContext;
    }

    private void cleanupTest(NEWTGLContext.WindowContext windowContext) {
        if (null != windowContext) {
            NEWTGLContext.destroyWindow(windowContext);
        }
    }

    @Test(timeout=60000L)
    public void testGlTransformFeedbackVaryings_WhenVarNameOK() throws GLException, InterruptedException {
        NEWTGLContext.WindowContext windowContext = this.prepareTest();
        if (null == windowContext) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        GL3 gL3 = windowContext.context.getGL().getGL3();
        Assert.assertEquals(0L, gL3.glGetError());
        MyShader myShader = this.attachShader(gL3, VERTEX_SHADER_TEXT, 35633);
        String[] stringArray = new String[]{"Position"};
        gL3.glTransformFeedbackVaryings(myShader.shaderProgram, 1, stringArray, 35981);
        gL3.glLinkProgram(myShader.shaderProgram);
        Assert.assertEquals(0L, gL3.glGetError());
        boolean bl = false;
        if (!ShaderUtil.isProgramLinkStatusValid(gL3, myShader.shaderProgram, printStream)) {
            System.out.println("Error (unexpected link error) - testGlTransformFeedbackVaryings_WhenVarNameOK:postLink: " + byteArrayOutputStream.toString());
            bl = true;
        }
        printStream.flush();
        byteArrayOutputStream.reset();
        Assert.assertEquals(0L, gL3.glGetError());
        this.releaseShader(gL3, myShader);
        this.cleanupTest(windowContext);
        Assert.assertFalse(bl);
    }

    @Test(timeout=60000L)
    public void testGlTransformFeedbackVaryings_WhenVarNameWrong() throws GLException, InterruptedException {
        NEWTGLContext.WindowContext windowContext = this.prepareTest();
        if (null == windowContext) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        GL3 gL3 = windowContext.context.getGL().getGL3();
        Assert.assertEquals(0L, gL3.glGetError());
        MyShader myShader = this.attachShader(gL3, VERTEX_SHADER_TEXT, 35633);
        String[] stringArray = new String[]{"PPPosition"};
        gL3.glTransformFeedbackVaryings(myShader.shaderProgram, 1, stringArray, 35981);
        gL3.glLinkProgram(myShader.shaderProgram);
        boolean bl = false;
        if (!ShaderUtil.isProgramLinkStatusValid(gL3, myShader.shaderProgram, printStream)) {
            System.out.println("GOOD (expected link error) - testGlTransformFeedbackVaryings_WhenVarNameWrong:postLink: " + byteArrayOutputStream.toString());
        } else {
            System.out.println("Error (unexpected link success) - testGlTransformFeedbackVaryings_WhenVarNameWrong link worked, but it should not");
            bl = true;
        }
        printStream.flush();
        byteArrayOutputStream.reset();
        Assert.assertEquals(0L, gL3.glGetError());
        this.releaseShader(gL3, myShader);
        this.cleanupTest(windowContext);
        Assert.assertFalse(bl);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestTransformFeedbackVaryingsBug407NEWT.class.getName();
        JUnitCore.main(string);
    }

    static class MyShader {
        int shaderProgram;
        int vertShader;

        MyShader(int n, int n2) {
            this.shaderProgram = n;
            this.vertShader = n2;
        }
    }
}

