/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsAWTAnalyzeBug455
extends UITestCase {
    static long duration = 500L;
    static boolean waitForKey = false;
    static boolean altSwap = true;
    static GLProfile glp;
    static int width;
    static int height;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull(glp);
            width = 512;
            height = 512;
        } else {
            TestGearsAWTAnalyzeBug455.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull(frame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.setAutoSwapBufferMode(!altSwap);
        frame.add(gLCanvas);
        gLCanvas.addGLEventListener(new Gears(0));
        gLCanvas.addGLEventListener(new Swapper());
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(gLCanvas);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(512, 512);
                frame.setVisible(true);
            }
        });
        Animator animator = new Animator(gLCanvas);
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull(frame);
        Assert.assertNotNull(gLCanvas);
        Assert.assertNotNull(animator);
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(gLCanvas);
                frame.dispose();
            }
        });
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setDoubleBuffered(true);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-autoswap")) continue;
            altSwap = false;
        }
        System.err.println("altSwap " + altSwap);
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main(TestGearsAWTAnalyzeBug455.class.getName());
    }

    static class Swapper
    implements GLEventListener {
        Swapper() {
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            System.err.println("auto-swap: " + gLAutoDrawable.getAutoSwapBufferMode());
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!gLAutoDrawable.getAutoSwapBufferMode()) {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                gL2.glReadBuffer(1029);
                gL2.glDrawBuffer(1028);
                gL2.glCopyPixels(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), 6144);
                gL2.glDrawBuffer(1029);
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

