/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.TraceMouseAdapter;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.opengl.util.NEWTDemoListener;
import com.jogamp.newt.util.EDTUtil;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.GLClearOnInitReshape;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LineSquareXDemoES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import jogamp.newt.DefaultEDTUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NEWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static float[] reqSurfacePixelScale;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean undecorated;
    static boolean alwaysOnTop;
    static boolean alwaysOnBottom;
    static boolean resizable;
    static boolean sticky;
    static boolean max_vert;
    static boolean max_horz;
    static boolean fullscreen;
    static int swapInterval;
    static boolean waitForKey;
    static boolean mouseVisible;
    static boolean mouseConfined;
    static boolean setPointerIcon;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceES3;
    static boolean forceGL3;
    static boolean forceGL2;
    static int demoType;
    static boolean traceMouse;
    static boolean manualTest;
    static boolean exclusiveContext;
    static boolean useAnimator;
    static boolean useMappedBuffers;
    static SysExit sysExit;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(final GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException {
        long l;
        Animator animator;
        GLEventListener gLEventListener;
        GLEventListener gLEventListener2;
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        final Screen screen = NewtFactory.createScreen(display, screenIdx);
        final GLWindow gLWindow = GLWindow.create(screen, gLCapabilitiesImmutable);
        Assert.assertNotNull(gLWindow);
        gLWindow.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLWindow.getRequestedSurfaceScale(new float[2]);
        gLWindow.setSize(wsize.getWidth(), wsize.getHeight());
        if (null != wpos) {
            gLWindow.setPosition(wpos.getX(), wpos.getY());
        }
        gLWindow.setUndecorated(bl);
        gLWindow.setAlwaysOnTop(alwaysOnTop);
        gLWindow.setAlwaysOnBottom(alwaysOnBottom);
        gLWindow.setResizable(resizable);
        gLWindow.setSticky(sticky);
        gLWindow.setMaximized(max_horz, max_vert);
        gLWindow.setFullscreen(fullscreen);
        gLWindow.setPointerVisible(mouseVisible);
        gLWindow.confinePointer(mouseConfined);
        if (2 == demoType) {
            gLEventListener2 = new LineSquareXDemoES2(false);
            gLEventListener = gLEventListener2;
        } else if (1 == demoType) {
            gLEventListener2 = new GearsES2(swapInterval);
            ((GearsES2)gLEventListener2).setUseMappedBuffers(useMappedBuffers);
            ((GearsES2)gLEventListener2).setValidateBuffers(true);
            gLEventListener = gLEventListener2;
        } else {
            gLEventListener = 0 == demoType ? new GLClearOnInitReshape() : null;
        }
        if (null != gLEventListener) {
            gLWindow.addGLEventListener(gLEventListener);
        }
        gLEventListener2 = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(gLEventListener2);
        if (waitForKey) {
            gLWindow.addGLEventListener(new GLEventListener(){

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (waitForKey && gLAnimatorControl.getTotalFPSFrames() == 180) {
                        JunitTracer.waitForKey("3s mark");
                        gLAnimatorControl.resetFPSCounter();
                        waitForKey = false;
                    }
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        Animator animator2 = animator = useAnimator ? new Animator() : null;
        if (useAnimator) {
            animator.setModeBits(false, 1);
            animator.setExclusiveContext(exclusiveContext);
        }
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getBounds() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                NEWTDemoListener.setTitle(gLWindow);
            }

            @Override
            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getBounds() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
                NEWTDemoListener.setTitle(gLWindow);
            }
        });
        final GLWindow[] gLWindowArray = new GLWindow[]{null};
        final NEWTDemoListener nEWTDemoListener = new NEWTDemoListener(gLWindow);
        nEWTDemoListener.quitAdapterEnable(true);
        gLWindow.addKeyListener(nEWTDemoListener);
        if (traceMouse) {
            gLWindow.addMouseListener(new TraceMouseAdapter());
        }
        gLWindow.addMouseListener(nEWTDemoListener);
        gLWindow.addWindowListener(nEWTDemoListener);
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'n') {
                    if (null != gLWindowArray[0] && gLWindowArray[0].isNativeValid()) {
                        gLWindowArray[0].destroy();
                        gLWindowArray[0] = null;
                    } else {
                        Animator animator;
                        gLWindowArray[0] = GLWindow.create(screen, gLCapabilitiesImmutable);
                        gLWindowArray[0].setTitle("GLWindow2");
                        gLWindowArray[0].setPosition(gLWindow.getX() + gLWindow.getWidth() + 64, gLWindow.getY());
                        gLWindowArray[0].setSize(gLWindow.getWidth(), gLWindow.getHeight());
                        gLWindowArray[0].addGLEventListener(new LineSquareXDemoES2(false));
                        Animator animator2 = animator = useAnimator ? new Animator(gLWindowArray[0]) : null;
                        if (null != animator) {
                            animator.start();
                        }
                        gLWindowArray[0].setVisible(true);
                    }
                }
            }
        });
        if (useAnimator) {
            animator.add(gLWindow);
            animator.start();
            Assert.assertTrue(animator.isStarted());
            Assert.assertTrue(animator.isAnimating());
            Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
        }
        if (SysExit.displayError == sysExit || SysExit.displayExit == sysExit || SysExit.displayEDTError == sysExit) {
            gLWindow.addGLEventListener(new GLEventListener(){

                @Override
                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                @Override
                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (null != gLAnimatorControl && gLAnimatorControl.isAnimating()) {
                        long l = gLAnimatorControl.getTotalFPSDuration();
                        if (l >= duration / 2L || l >= 3000L) {
                            if (SysExit.displayError == sysExit) {
                                throw new Error("test error send from GLEventListener.display - " + Thread.currentThread());
                            }
                            if (SysExit.displayExit == sysExit) {
                                System.err.println("exit(0) send from GLEventListener");
                                System.exit(0);
                            } else if (SysExit.displayEDTError == sysExit) {
                                Object object = gLAutoDrawable.getUpstreamWidget();
                                System.err.println("EDT invokeAndWaitError: upstream type " + object.getClass().getName());
                                if (object instanceof Window) {
                                    EDTUtil eDTUtil = ((Window)object).getScreen().getDisplay().getEDTUtil();
                                    System.err.println("EDT invokeAndWaitError: edt type " + eDTUtil.getClass().getName());
                                    if (eDTUtil instanceof DefaultEDTUtil) {
                                        nEWTDemoListener.doQuit();
                                        ((DefaultEDTUtil)eDTUtil).invokeAndWaitError(new Runnable(){

                                            @Override
                                            public void run() {
                                                throw new RuntimeException("XXX Should never ever be seen! - " + Thread.currentThread());
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    } else {
                        System.exit(0);
                    }
                }

                @Override
                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        gLWindow.setVisible(true);
        if (useAnimator) {
            animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        }
        System.err.println("Window Current State   : " + gLWindow.getStateMaskString());
        System.err.println("Window Supported States: " + gLWindow.getSupportedStateMaskString());
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        float[] fArray2 = gLWindow.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + fArray2[0] + "x" + fArray2[1] + " (has)");
        NEWTDemoListener.setTitle(gLWindow);
        ((UITestCase.SnapshotGLEventListener)gLEventListener2).setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            gLWindow.setSize(rwsize.getWidth(), rwsize.getHeight());
            System.err.println("window resize pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        }
        ((UITestCase.SnapshotGLEventListener)gLEventListener2).setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!nEWTDemoListener.shouldQuit() && l2 - l < duration) {
            long l3;
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            if (SysExit.testError != sysExit && SysExit.testExit != sysExit && SysExit.testEDTError != sysExit || (l3 = l2 - l) < duration / 2L && l3 < 3000L) continue;
            if (SysExit.testError == sysExit) {
                throw new Error("test error send from test thread");
            }
            if (SysExit.testExit == sysExit) {
                System.err.println("exit(0) send from test thread");
                System.exit(0);
                continue;
            }
            if (SysExit.testEDTError != sysExit) continue;
            EDTUtil eDTUtil = gLWindow.getScreen().getDisplay().getEDTUtil();
            System.err.println("EDT invokeAndWaitError: edt type " + eDTUtil.getClass().getName());
            if (!(eDTUtil instanceof DefaultEDTUtil)) continue;
            nEWTDemoListener.doQuit();
            ((DefaultEDTUtil)eDTUtil).invokeAndWaitError(new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException("XXX Should never ever be seen!");
                }
            });
        }
        if (useAnimator) {
            Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
            animator.stop();
            Assert.assertFalse(animator.isAnimating());
            Assert.assertFalse(animator.isStarted());
        }
        Assert.assertEquals(null, gLWindow.getExclusiveContextThread());
        gLWindow.destroy();
        if (null != gLWindowArray[0] && gLWindowArray[0].isNativeValid()) {
            gLWindowArray[0].destroy();
            gLWindowArray[0] = null;
        }
        if (NativeWindowFactory.isAWTAvailable()) {
            Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, false));
        }
    }

    @Test
    public void test01_GL2ES2() throws InterruptedException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES3 ? GLProfile.get("GLES3") : (forceES2 ? GLProfile.get("GLES2") : (forceGL2 ? GLProfile.get("GL2") : GLProfile.getGL2ES2())));
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL(gLCapabilities, undecorated);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02_GLES2() throws InterruptedException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, undecorated);
    }

    @Test
    public void test03_GL3() throws InterruptedException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, undecorated);
    }

    @Test
    public void test99_PixelScale1_DefaultNorm() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        TestGearsES2NEWT.reqSurfacePixelScale[0] = 1.0f;
        TestGearsES2NEWT.reqSurfacePixelScale[1] = 1.0f;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        this.runTestGL(gLCapabilities, undecorated);
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-undecorated")) {
                undecorated = true;
                continue;
            }
            if (stringArray[i].equals("-atop")) {
                alwaysOnTop = true;
                continue;
            }
            if (stringArray[i].equals("-abottom")) {
                alwaysOnBottom = true;
                continue;
            }
            if (stringArray[i].equals("-noresize")) {
                resizable = false;
                continue;
            }
            if (stringArray[i].equals("-sticky")) {
                sticky = true;
                continue;
            }
            if (stringArray[i].equals("-maxv")) {
                max_vert = true;
                continue;
            }
            if (stringArray[i].equals("-maxh")) {
                max_horz = true;
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                forceES3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl2")) {
                forceGL2 = true;
                continue;
            }
            if (stringArray[i].equals("-mappedBuffers")) {
                useMappedBuffers = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (stringArray[i].equals("-mouseInvisible")) {
                mouseVisible = false;
                continue;
            }
            if (stringArray[i].equals("-mouseConfine")) {
                mouseConfined = true;
                continue;
            }
            if (stringArray[i].equals("-pointerIcon")) {
                setPointerIcon = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-pixelScale")) {
                float f;
                TestGearsES2NEWT.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
                TestGearsES2NEWT.reqSurfacePixelScale[1] = f;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (stringArray[i].equals("-loop-shutdown")) {
                loop_shutdown = true;
                continue;
            }
            if (stringArray[i].equals("-sysExit")) {
                sysExit = SysExit.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-manual")) {
                manualTest = true;
                continue;
            }
            if (stringArray[i].equals("-demo")) {
                demoType = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (!stringArray[i].equals("-traceMouse")) continue;
            traceMouse = true;
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("undecorated " + undecorated);
        System.err.println("atop " + alwaysOnTop);
        System.err.println("abottom " + alwaysOnBottom);
        System.err.println("resizable " + resizable);
        System.err.println("sticky " + sticky);
        System.err.println("max_vert " + max_vert);
        System.err.println("max_horz " + max_horz);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("mouseVisible " + mouseVisible);
        System.err.println("mouseConfined " + mouseConfined);
        System.err.println("pointerIcon " + setPointerIcon);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceES3 " + forceES3);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("forceGL2 " + forceGL2);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("sysExitWithin " + (Object)((Object)sysExit));
        System.err.println("mappedBuffers " + useMappedBuffers);
        System.err.println("demoType " + demoType);
        System.err.println("traceMouse " + traceMouse);
        if (waitForKey) {
            JunitTracer.waitForKey("Start");
        }
        JUnitCore.main(TestGearsES2NEWT.class.getName());
    }

    static {
        rwsize = null;
        reqSurfacePixelScale = new float[]{0.0f, 0.0f};
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        undecorated = false;
        alwaysOnTop = false;
        alwaysOnBottom = false;
        resizable = true;
        sticky = false;
        max_vert = false;
        max_horz = false;
        fullscreen = false;
        swapInterval = 1;
        waitForKey = false;
        mouseVisible = true;
        mouseConfined = false;
        setPointerIcon = false;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceES3 = false;
        forceGL3 = false;
        forceGL2 = false;
        demoType = 1;
        traceMouse = false;
        manualTest = false;
        exclusiveContext = false;
        useAnimator = true;
        useMappedBuffers = false;
        sysExit = SysExit.none;
    }

    static enum SysExit {
        none,
        testExit,
        testError,
        testEDTError,
        displayExit,
        displayError,
        displayEDTError;

    }
}

