/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2AWT
extends UITestCase {
    static long duration = 500L;
    static int width = 640;
    static int height = 480;
    static int xpos = 10;
    static int ypos = 10;
    static FrameLayout frameLayout = FrameLayout.None;
    static ResizeBy resizeBy = ResizeBy.Component;
    static float[] reqSurfacePixelScale = new float[]{0.0f, 0.0f};
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean manualTest = false;
    static boolean shallUseOffscreenFBOLayer = false;
    static boolean shallUseOffscreenPBufferLayer = false;
    static boolean useMSAA = false;
    static boolean useStencil = false;
    static boolean shutdownRemoveGLCanvas = true;
    static boolean shutdownDisposeFrame = true;
    static boolean shutdownSystemExit = false;
    static int swapInterval = 1;
    static boolean exclusiveContext = false;
    static boolean useAnimator = true;
    static Thread awtEDT;
    static Dimension rwsize;

    @BeforeClass
    public static void initClass() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    awtEDT = Thread.currentThread();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull(exception);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    static void setComponentSize(final Frame frame, final Component component, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    component.setMinimumSize(dimension);
                    component.setPreferredSize(dimension);
                    component.setSize(dimension);
                    if (null != frame) {
                        frame.pack();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    static void setFrameSize(final Frame frame, final boolean bl, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension);
                    if (bl) {
                        frame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    static void setSize(ResizeBy resizeBy, Frame frame, boolean bl, Component component, Dimension dimension) {
        switch (resizeBy) {
            case Component: {
                TestGearsES2AWT.setComponentSize(bl ? frame : null, component, dimension);
                break;
            }
            case Frame: {
                TestGearsES2AWT.setFrameSize(frame, bl, dimension);
            }
        }
    }

    private void setTitle(Frame frame, GLCanvas gLCanvas, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        String string = gLCapabilitiesImmutable.isBackgroundOpaque() ? "opaque" : "transl";
        Rectangle rectangle = gLCanvas.getBounds();
        float[] fArray = gLCanvas.getMinimumSurfaceScale(new float[2]);
        float[] fArray2 = gLCanvas.getMaximumSurfaceScale(new float[2]);
        float[] fArray3 = gLCanvas.getRequestedSurfaceScale(new float[2]);
        float[] fArray4 = gLCanvas.getCurrentSurfaceScale(new float[2]);
        frame.setTitle("GLCanvas[" + string + "], swapI " + swapInterval + ", win: [" + rectangle.x + "/" + rectangle.y + " " + rectangle.width + "x" + rectangle.height + "], pix: " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight() + ", scale[min " + fArray[0] + "x" + fArray[1] + ", max " + fArray2[0] + "x" + fArray2[1] + ", req " + fArray3[0] + "x" + fArray3[1] + " -> has " + fArray4[0] + "x" + fArray4[1] + "]");
    }

    protected void runTestGL(final GLCapabilities gLCapabilities, final ResizeBy resizeBy, FrameLayout frameLayout) throws InterruptedException, InvocationTargetException {
        long l;
        Animator animator;
        Object object;
        Object object2;
        final Frame frame = new Frame("GearsES2 AWT Test");
        Assert.assertNotNull(frame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull(gLCanvas);
        TestGearsES2AWT.setSize(resizeBy, frame, false, gLCanvas, new Dimension(width, height));
        gLCanvas.setSurfaceScale(reqSurfacePixelScale);
        float[] fArray = gLCanvas.getRequestedSurfaceScale(new float[2]);
        frame.setLocation(xpos, ypos);
        switch (frameLayout) {
            case None: {
                frame.add(gLCanvas);
                break;
            }
            case TextOnBottom: {
                object2 = new TextArea(2, 20);
                ((TextArea)object2).append("0123456789");
                ((TextArea)object2).append(Platform.getNewline());
                ((TextArea)object2).append("Some Text");
                ((TextArea)object2).append(Platform.getNewline());
                frame.setLayout(new BorderLayout());
                frame.add((Component)object2, "South");
                frame.add((Component)gLCanvas, "Center");
                break;
            }
            case BorderCenterSurrounded: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)gLCanvas, "Center");
                break;
            }
            case DoubleBorderCenterSurrounded: {
                object = new Container();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add((Component)new Button("north"), "North");
                ((Container)object).add((Component)new Button("south"), "South");
                ((Container)object).add((Component)new Button("east"), "East");
                ((Container)object).add((Component)new Button("west"), "West");
                ((Container)object).add((Component)gLCanvas, "Center");
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)object, "Center");
            }
        }
        this.setTitle(frame, gLCanvas, gLCapabilities);
        object2 = new GearsES2(swapInterval);
        gLCanvas.addGLEventListener((GLEventListener)object2);
        object = new UITestCase.SnapshotGLEventListener(this);
        gLCanvas.addGLEventListener((GLEventListener)object);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                TestGearsES2AWT.this.setTitle(frame, gLCanvas, gLCapabilities);
            }
        });
        Animator animator2 = animator = useAnimator ? new Animator(gLCanvas) : null;
        if (useAnimator && exclusiveContext) {
            animator.setExclusiveContext(awtEDT);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(gLCanvas);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(frame);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'x') {
                    float[] fArray = gLCanvas.getCurrentSurfaceScale(new float[2]);
                    float[] fArray2 = fArray[0] == 1.0f ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
                    System.err.println("[set PixelScale pre]: had " + fArray[0] + "x" + fArray[1] + " -> req " + fArray2[0] + "x" + fArray2[1]);
                    gLCanvas.setSurfaceScale(fArray2);
                    float[] fArray3 = gLCanvas.getRequestedSurfaceScale(new float[2]);
                    float[] fArray4 = gLCanvas.getCurrentSurfaceScale(new float[2]);
                    System.err.println("[set PixelScale post]: " + fArray[0] + "x" + fArray[1] + " (had) -> " + fArray2[0] + "x" + fArray2[1] + " (req) -> " + fArray3[0] + "x" + fArray3[1] + " (val) -> " + fArray4[0] + "x" + fArray4[1] + " (has)");
                    TestGearsES2AWT.this.setTitle(frame, gLCanvas, gLCapabilities);
                }
            }
        };
        new AWTKeyAdapter((KeyListener)keyAdapter, (NativeSurfaceHolder)gLCanvas).addTo(gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (ResizeBy.Frame == resizeBy) {
                    frame.validate();
                } else {
                    frame.pack();
                }
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, true));
        float[] fArray2 = gLCanvas.getCurrentSurfaceScale(new float[2]);
        System.err.println("HiDPI PixelScale: " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " (req) -> " + fArray[0] + "x" + fArray[1] + " (val) -> " + fArray2[0] + "x" + fArray2[1] + " (has)");
        this.setTitle(frame, gLCanvas, gLCapabilities);
        if (useAnimator) {
            animator.start();
            Assert.assertTrue(animator.isStarted());
            Assert.assertTrue(animator.isAnimating());
            Assert.assertEquals(exclusiveContext ? awtEDT : null, gLCanvas.getExclusiveContextThread());
            animator.setUpdateFPSFrames(60, System.err);
        }
        System.err.println("canvas pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            TestGearsES2AWT.setSize(resizeBy, frame, true, gLCanvas, rwsize);
            System.err.println("window resize pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight());
        }
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull(frame);
        Assert.assertNotNull(gLCanvas);
        if (useAnimator) {
            Assert.assertNotNull(animator);
            Assert.assertEquals(exclusiveContext ? awtEDT : null, gLCanvas.getExclusiveContextThread());
            animator.stop();
            Assert.assertFalse(animator.isAnimating());
            Assert.assertFalse(animator.isStarted());
            Assert.assertEquals(null, gLCanvas.getExclusiveContextThread());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (shutdownRemoveGLCanvas) {
                    frame.remove(gLCanvas);
                }
                if (shutdownDisposeFrame) {
                    frame.dispose();
                }
                if (shutdownSystemExit) {
                    System.exit(0);
                }
            }
        });
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (useMSAA) {
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setSampleBuffers(true);
        }
        if (useStencil) {
            gLCapabilities.setStencilBits(1);
        }
        if (shallUseOffscreenFBOLayer) {
            gLCapabilities.setOnscreen(false);
        }
        if (shallUseOffscreenPBufferLayer) {
            gLCapabilities.setPBuffer(true);
        }
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    @Test
    public void test02_GLES2() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    @Test
    public void test03_GL3() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    @Test
    public void test99_PixelScale1_DefaultNorm() throws InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        TestGearsES2AWT.reqSurfacePixelScale[0] = 1.0f;
        TestGearsES2AWT.reqSurfacePixelScale[1] = 1.0f;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                xpos = MiscUtils.atoi(stringArray[++i], xpos);
                continue;
            }
            if (stringArray[i].equals("-y")) {
                ypos = MiscUtils.atoi(stringArray[++i], ypos);
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-pixelScale")) {
                float f;
                TestGearsES2AWT.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
                TestGearsES2AWT.reqSurfacePixelScale[1] = f;
                continue;
            }
            if (stringArray[i].equals("-layout")) {
                frameLayout = FrameLayout.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-resizeBy")) {
                resizeBy = ResizeBy.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                shallUseOffscreenFBOLayer = true;
                continue;
            }
            if (stringArray[i].equals("-layeredPBuffer")) {
                shallUseOffscreenPBufferLayer = true;
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                continue;
            }
            if (stringArray[i].equals("-stencil")) {
                useStencil = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepGLCanvas")) {
                shutdownRemoveGLCanvas = false;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepFrame")) {
                shutdownDisposeFrame = false;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepAll")) {
                shutdownRemoveGLCanvas = false;
                shutdownDisposeFrame = false;
                continue;
            }
            if (stringArray[i].equals("-shutdownSystemExit")) {
                shutdownSystemExit = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manualTest = true;
        }
        if (0 < n && 0 < n2) {
            rwsize = new Dimension(n, n2);
        }
        System.err.println("resize " + rwsize);
        System.err.println("frameLayout " + (Object)((Object)frameLayout));
        System.err.println("resizeBy " + (Object)((Object)resizeBy));
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useMSAA " + useMSAA);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("shallUseOffscreenFBOLayer     " + shallUseOffscreenFBOLayer);
        System.err.println("shallUseOffscreenPBufferLayer " + shallUseOffscreenPBufferLayer);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main(TestGearsES2AWT.class.getName());
    }

    static {
        rwsize = null;
    }

    public static enum ResizeBy {
        Component,
        Frame;

    }

    public static enum FrameLayout {
        None,
        TextOnBottom,
        BorderCenterSurrounded,
        DoubleBorderCenterSurrounded;

    }
}

