/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.av;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.graph.TextRendererGLELBase;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureSequenceCubeES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class MovieCube
implements GLEventListener {
    public static final float zoom_def = -2.77f;
    private static boolean waitForKey = false;
    private final float zoom0;
    private final float rotx;
    private final float roty;
    private TextureSequenceCubeES2 cube = null;
    private GLMediaPlayer mPlayer = null;
    private int swapInterval = 1;
    private boolean swapIntervalSet = true;
    private long lastPerfPos = 0L;
    private volatile boolean resetGLState = false;
    public static final Uri defURI;
    final int[] textSampleCount = new int[]{4};
    private InfoTextRendererGLELBase textRendererGLEL = null;
    final boolean showText;
    private boolean displayOSD = true;
    private final KeyListener keyAction = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = -2 != MovieCube.this.mPlayer.getVID() ? MovieCube.this.mPlayer.getVideoPTS() : MovieCube.this.mPlayer.getAudioPTS();
            int n2 = 0;
            switch (keyEvent.getKeySymbol()) {
                case 86: {
                    switch (MovieCube.this.swapInterval) {
                        case 0: {
                            MovieCube.this.swapInterval = -1;
                            break;
                        }
                        case -1: {
                            MovieCube.this.swapInterval = 1;
                            break;
                        }
                        case 1: {
                            MovieCube.this.swapInterval = 0;
                            break;
                        }
                        default: {
                            MovieCube.this.swapInterval = 1;
                        }
                    }
                    MovieCube.this.swapIntervalSet = true;
                    break;
                }
                case 79: {
                    MovieCube.this.displayOSD = !MovieCube.this.displayOSD;
                    break;
                }
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: 
                case 27: {
                    MovieCube.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieCube.this.mPlayer.getState()) {
                        MovieCube.this.mPlayer.play();
                        break;
                    }
                    MovieCube.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieCube.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieCube.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieCube.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieCube.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieCube.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieCube.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieCube.this.mPlayer.setAudioVolume(f);
                }
            }
            if (0 != n2) {
                MovieCube.this.mPlayer.seek(n2);
            }
        }
    };

    public MovieCube() throws IOException, URISyntaxException {
        this(-2.77f, 0.0f, 0.0f, true);
        this.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            @Override
            public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
            }

            @Override
            public void attributesChanged(GLMediaPlayer gLMediaPlayer, int n, long l) {
                System.err.println("MovieCube AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
                System.err.println("MovieCube State: " + gLMediaPlayer);
                if (0 != (0x40000 & n)) {
                    MovieCube.this.resetGLState();
                }
                if (0 != (0x10 & n)) {
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            MovieCube.this.mPlayer.seek(0);
                            MovieCube.this.mPlayer.play();
                        }
                    }.start();
                }
            }
        });
        this.initStream(defURI, -1, -1, 4);
        Throwable throwable = null;
        while (null == throwable && GLMediaPlayer.State.Initialized != this.mPlayer.getState()) {
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throwable = this.mPlayer.getStreamException();
        }
        if (null != throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public MovieCube(float f, float f2, float f3, boolean bl) throws IOException {
        this.zoom0 = f;
        this.rotx = f2;
        this.roty = f3;
        this.showText = bl;
        this.mPlayer = GLMediaPlayerFactory.createDefault();
    }

    public void initStream(Uri uri, int n, int n2, int n3) {
        this.mPlayer.initStream(uri, n, n2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public void setSwapInterval(int n) {
        this.swapInterval = n;
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        if (GLMediaPlayer.State.Uninitialized == this.mPlayer.getState()) {
            throw new IllegalStateException("mPlayer in uninitialized state: " + this.mPlayer);
        }
        if (-2 == this.mPlayer.getVID()) {
            // empty if block
        }
        this.resetGLState = false;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo(gL2ES2, null));
        this.cube = new TextureSequenceCubeES2(this.mPlayer, false, this.zoom0, this.rotx, this.roty);
        if (waitForKey) {
            JunitTracer.waitForKey("Init>");
        }
        if (GLMediaPlayer.State.Initialized == this.mPlayer.getState()) {
            try {
                this.mPlayer.initGL(gL2ES2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (null != this.mPlayer) {
                    this.mPlayer.destroy(gL2ES2);
                    this.mPlayer = null;
                }
                throw new GLException(exception);
            }
        }
        this.cube.init(gLAutoDrawable);
        this.mPlayer.play();
        System.out.println("play.0 " + this.mPlayer);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addKeyListener(this.keyAction);
            bl = true;
        } else {
            bl = false;
        }
        System.err.println("MC.init: kl-added " + bl + ", " + gLAutoDrawable.getClass().getName());
        if (this.showText) {
            int n = gLAutoDrawable.getChosenGLCapabilities().getSampleBuffers() ? 0 : 2;
            boolean bl2 = gL2ES2.isGLES();
            this.textRendererGLEL = new InfoTextRendererGLELBase(n, bl2);
            gLAutoDrawable.addGLEventListener(this.textRendererGLEL);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null == this.mPlayer) {
            return;
        }
        this.cube.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " MovieCube.dispose ... ");
        if (null != this.textRendererGLEL) {
            gLAutoDrawable.disposeGLEventListener(this.textRendererGLEL, true);
            this.textRendererGLEL = null;
        }
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object;
        if (null == this.mPlayer) {
            return;
        }
        Object object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            object = (Window)object2;
            object.removeKeyListener(this.keyAction);
        }
        object = gLAutoDrawable.getGL().getGL2ES2();
        if (bl) {
            this.mPlayer.destroy((GL)object);
            this.mPlayer = null;
        }
        this.cube.dispose(gLAutoDrawable);
        this.cube = null;
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        long l;
        if (this.swapIntervalSet) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            int n = this.swapInterval;
            gL2ES2.setSwapInterval(n);
            gLAutoDrawable.getAnimator().resetFPSCounter();
            this.swapInterval = gL2ES2.getSwapInterval();
            System.err.println("Swap Interval: " + n + " -> " + this.swapInterval);
            this.swapIntervalSet = false;
        }
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            System.err.println(this.mPlayer.getPerfString());
            this.lastPerfPos = l;
        }
        this.cube.display(gLAutoDrawable);
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException, URISyntaxException {
        int n = 1;
        int n2 = 800;
        int n3 = 600;
        int n4 = 4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = -1;
        int n6 = -1;
        String string = null;
        String string2 = null;
        boolean bl5 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vid")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-aid")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-osize")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-textureCount")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-file")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-gldef")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        final boolean bl6 = bl5;
        Uri uri = null != string ? Uri.cast(string) : (null != string2 ? Uri.valueOf(new File(string2)) : defURI);
        System.err.println("url_s " + string);
        System.err.println("file_s " + string2);
        System.err.println("stream " + uri);
        System.err.println("vid " + n5 + ", aid " + n6);
        System.err.println("textureCount " + n4);
        System.err.println("forceES2   " + bl);
        System.err.println("forceES3   " + bl2);
        System.err.println("forceGL3   " + bl3);
        System.err.println("forceGLDef " + bl4);
        System.err.println("swapInterval " + n);
        final MovieCube movieCube = new MovieCube(-2.77f, 0.0f, 0.0f, true);
        movieCube.setSwapInterval(n);
        GLProfile gLProfile = bl4 ? GLProfile.getDefault() : (bl3 ? GLProfile.get("GL3") : (bl2 ? GLProfile.get("GLES3") : (bl ? GLProfile.get("GLES2") : GLProfile.getGL2ES2())));
        System.err.println("GLProfile: " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLWindow gLWindow = GLWindow.create(gLCapabilities);
        final Animator animator = new Animator(gLWindow);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyed(WindowEvent windowEvent) {
                animator.stop();
            }
        });
        gLWindow.setSize(n2, n3);
        gLWindow.setVisible(true);
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        animator.start();
        movieCube.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            @Override
            public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
            }

            @Override
            public void attributesChanged(GLMediaPlayer gLMediaPlayer, int n, long l) {
                System.err.println("MovieCube AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
                System.err.println("MovieCube State: " + gLMediaPlayer);
                if (0 != (0x40000 & n)) {
                    if (bl6) {
                        gLWindow.setSurfaceSize(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                    }
                    movieCube.resetGLState();
                }
                if (0 != (1 & n)) {
                    gLWindow.addGLEventListener(movieCube);
                    animator.setUpdateFPSFrames(60, null);
                    animator.resetFPSCounter();
                }
                if (0 != (4 & n)) {
                    animator.resetFPSCounter();
                }
                if (0 != (0x30 & n)) {
                    GLMediaPlayer.StreamException streamException = movieCube.mPlayer.getStreamException();
                    if (null != streamException) {
                        streamException.printStackTrace();
                    }
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            gLWindow.destroy();
                        }
                    }.start();
                }
            }
        });
        movieCube.initStream(uri, n5, n6, n4);
    }

    static {
        Uri uri = null;
        try {
            uri = Uri.cast("http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uri;
    }

    private final class InfoTextRendererGLELBase
    extends TextRendererGLELBase {
        private static final float z_diff = 0.001f;
        private final Font font;
        private final float fontSize1 = 12.0f;
        private final float fontSize2 = 10.0f;
        private final GLRegion regionFPS;
        private float pixelSize1;
        private float pixelSize2;
        private float underlineSize;

        InfoTextRendererGLELBase(int n, boolean bl) {
            super(n, MovieCube.this.textSampleCount);
            this.font = InfoTextRendererGLELBase.getFont(0, 0, 0);
            this.fontSize1 = 12.0f;
            this.fontSize2 = 10.0f;
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            if (bl) {
                this.regionFPS = null;
            } else {
                this.regionFPS = GLRegion.create(this.renderModes, null);
                System.err.println("RegionFPS " + Region.getRenderModeString(this.renderModes) + ", sampleCount " + MovieCube.this.textSampleCount[0] + ", class " + this.regionFPS.getClass().getName());
            }
            this.staticRGBAColor[0] = 0.1f;
            this.staticRGBAColor[1] = 0.1f;
            this.staticRGBAColor[2] = 0.1f;
            this.staticRGBAColor[3] = 1.0f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            this.setSharedPMVMatrix(((MovieCube)MovieCube.this).cube.pmvMatrix);
            super.init(gLAutoDrawable);
            this.pixelSize1 = this.font.getPixelSize(12.0f, this.dpiH);
            this.pixelSize2 = this.font.getPixelSize(10.0f, this.dpiH);
            this.pixelScale = 1.0f / (this.pixelSize1 * 20.0f);
            Font.Metrics metrics = this.font.getMetrics();
            float f = metrics.getLineGap(this.pixelSize1);
            float f2 = metrics.getDescent(this.pixelSize1);
            this.underlineSize = f2 - f;
            System.err.println("XXX: dpiH " + this.dpiH + ", fontSize " + 12.0f + ", pixelSize " + this.pixelSize1 + ", pixelScale " + this.pixelScale + ", fLG " + f + ", fDesc " + f2 + ", underlineSize " + this.underlineSize);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            if (null != this.regionFPS) {
                this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            }
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            boolean bl = -2 != MovieCube.this.mPlayer.getVID();
            float f3 = (float)(bl ? MovieCube.this.mPlayer.getVideoPTS() : MovieCube.this.mPlayer.getAudioPTS()) / 1000.0f;
            float f4 = (float)MovieCube.this.mPlayer.getWidth() / (float)MovieCube.this.mPlayer.getHeight();
            float f5 = 1.0f / f4;
            float f6 = 1.0f - f5;
            float f7 = f6 - this.pixelScale * this.underlineSize;
            float f8 = 2.0f - f6;
            GL gL = gLAutoDrawable.getGL();
            String string = null != this.regionFPS ? "3.1" : "3.0";
            String string2 = String.format("%0" + string + "f/%0" + string + "f s, %s (%01.2fx, vol %01.2f), a %01.2f, fps %02.1f -> %02.1f / %02.1f, v-sync %d", Float.valueOf(f3), Float.valueOf((float)MovieCube.this.mPlayer.getDuration() / 1000.0f), MovieCube.this.mPlayer.getState().toString().toLowerCase(), Float.valueOf(MovieCube.this.mPlayer.getPlaySpeed()), Float.valueOf(MovieCube.this.mPlayer.getAudioVolume()), Float.valueOf(f4), Float.valueOf(MovieCube.this.mPlayer.getFramerate()), Float.valueOf(f), Float.valueOf(f2), MovieCube.this.swapInterval);
            String string3 = String.format("audio: id %d, kbps %d, codec %s", MovieCube.this.mPlayer.getAID(), MovieCube.this.mPlayer.getAudioBitrate() / 1000, MovieCube.this.mPlayer.getAudioCodec());
            String string4 = String.format("video: id %d, kbps %d, codec %s", MovieCube.this.mPlayer.getVID(), MovieCube.this.mPlayer.getVideoBitrate() / 1000, MovieCube.this.mPlayer.getVideoCodec());
            String string5 = ((MovieCube)MovieCube.this).mPlayer.getUri().path.decode();
            if (MovieCube.this.displayOSD && null != this.renderer) {
                gL.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
                if (null != this.regionFPS) {
                    this.renderString(gLAutoDrawable, this.font, this.pixelSize1, string2, 1, -1, -0.999f, f7, 1.001f, this.regionFPS);
                } else {
                    this.renderString(gLAutoDrawable, this.font, this.pixelSize1, string2, 1, -1, -0.999f, f7, 1.001f, true);
                }
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, string3, 1, 0, -0.999f, f8, 1.001f, true);
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, string4, 1, 1, -0.999f, f8, 1.001f, true);
                this.renderString(gLAutoDrawable, this.font, this.pixelSize2, string5, 1, 2, -0.999f, f8, 1.001f, true);
            }
        }
    }
}

