/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.av;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.opengl.util.av.AudioSink;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.File;

public class CrossFadePlayer {
    static GLMediaPlayer[] player;
    static volatile boolean stop;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            System.out.println("No files! \npass as many media files you want\nto the CrossFadePlayer arguments \nand i will try CrossFade-play them all in parallel!");
        }
        GLMediaPlayer.GLMediaEventListener gLMediaEventListener = new GLMediaPlayer.GLMediaEventListener(){

            @Override
            public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
            }

            @Override
            public void attributesChanged(final GLMediaPlayer gLMediaPlayer, int n, long l) {
                GLMediaPlayer.StreamException streamException;
                System.out.println("\n***\nEvent mask changed: " + n);
                System.out.println("Timestamp: " + l);
                System.out.println("State of player: " + gLMediaPlayer.getState().toString() + "\n");
                if ((n & 1) != 0) {
                    System.out.println("Duration: " + gLMediaPlayer.getDuration() + "ms");
                    System.out.println("Volume: " + gLMediaPlayer.getAudioVolume());
                    System.out.println("player.initGL()...");
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            try {
                                gLMediaPlayer.initGL(null);
                                if (GLMediaPlayer.State.Paused == gLMediaPlayer.getState()) {
                                    gLMediaPlayer.play();
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }.start();
                } else if ((n & 8) != 0) {
                    System.out.println("player.paused()...");
                } else if ((n & 4) != 0) {
                    System.out.println("playing...");
                    System.out.println(gLMediaPlayer.toString());
                    System.out.println(gLMediaPlayer.getAudioSink().toString());
                } else if (0 != (0x10 & n)) {
                    streamException = gLMediaPlayer.getStreamException();
                    if (null != streamException) {
                        System.err.println("Player State: EOS + Exception");
                        stop = true;
                    } else {
                        System.err.println("Player State: EOS");
                        new InterruptSource.Thread(){

                            @Override
                            public void run() {
                                System.out.println("mp.setPlaySpeed(1f) returned: " + gLMediaPlayer.setPlaySpeed(1.0f));
                                gLMediaPlayer.seek(0);
                                gLMediaPlayer.play();
                            }
                        }.start();
                    }
                }
                if (0 != (0x30 & n)) {
                    streamException = gLMediaPlayer.getStreamException();
                    if (null != streamException) {
                        streamException.printStackTrace();
                    }
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            System.out.println("terminating...");
                            stop = true;
                        }
                    }.start();
                }
            }
        };
        player = new GLMediaPlayer[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            block17: {
                CrossFadePlayer.player[n] = GLMediaPlayerFactory.createDefault();
                if (player[n] != null) {
                    System.out.println("Created CrossFade player: " + n + " " + player[n].getClass().getName());
                    player[n].addEventListener(gLMediaEventListener);
                    try {
                        object = string;
                        if (((String)object).equals("")) {
                            System.out.println("No file selected: arg " + n + " = " + (String)object);
                            CrossFadePlayer.player[n] = null;
                            break block17;
                        }
                        File file = new File((String)object);
                        if (!file.exists()) {
                            System.out.println("File do not exist");
                            break block17;
                        }
                        Uri uri = Uri.valueOf(file);
                        System.out.println("State of player " + n + ": " + player[n].getState().toString());
                        System.out.println("...initializing stream " + n + "...");
                        player[n].initStream(uri, -2, -1, 4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    System.out.println("Failed to create player " + n + "!");
                }
            }
            ++n;
        }
        long l = Platform.currentTimeMillis();
        double d = Math.PI * 2 / (double)stringArray.length;
        object = null;
        while (null == object && !stop) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            float f = 1000.0f;
            for (GLMediaPlayer gLMediaPlayer : player) {
                if (gLMediaPlayer == null || !((float)gLMediaPlayer.getDuration() > f)) continue;
                f = gLMediaPlayer.getDuration();
            }
            float f2 = (float)(Platform.currentTimeMillis() - l) / f;
            n = 0;
            for (GLMediaPlayer gLMediaPlayer : player) {
                if (gLMediaPlayer != null) {
                    AudioSink audioSink = gLMediaPlayer.getAudioSink();
                    if (audioSink != null) {
                        float f3 = (float)(0.5 + 0.5 * Math.cos((double)(40.0f * f2) + d * (double)n));
                        float f4 = Platform.currentTimeMillis() - l;
                        audioSink.setVolume(f3);
                    }
                    if (null != (object = gLMediaPlayer.getStreamException())) {
                        ((Throwable)object).printStackTrace();
                        throw new RuntimeException((Throwable)object);
                    }
                }
                ++n;
            }
        }
        for (GLMediaPlayer gLMediaPlayer : player) {
            if (gLMediaPlayer == null) continue;
            gLMediaPlayer.destroy(null);
        }
        System.out.println("...main exit...");
    }

    static {
        stop = false;
    }
}

