/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es1.newt;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES1NEWT
extends UITestCase {
    static int width;
    static int height;
    static boolean forceES2;
    static boolean forceFFPEmu;
    static int swapInterval;
    static long duration;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Gears NEWT Test");
        GearsES1 gearsES1 = new GearsES1(swapInterval);
        gearsES1.setForceFFPEmu(bl, bl, false, false);
        gLWindow.addGLEventListener(gearsES1);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator = new Animator(gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        final GLWindow gLWindow2 = gLWindow;
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            gLWindow2.setFullscreen(!gLWindow2.isFullscreen());
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            gLWindow2.setUndecorated(!gLWindow2.isUndecorated());
                        }
                    }.start();
                }
            }
        });
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test00() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES1());
        this.runTestGL(gLCapabilities, forceFFPEmu);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (!stringArray[i].equals("-ffpemu")) continue;
            forceFFPEmu = true;
        }
        JUnitCore.main(TestGearsES1NEWT.class.getName());
    }

    static {
        forceES2 = false;
        forceFFPEmu = false;
        swapInterval = 1;
        duration = 500L;
    }
}

