/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos02AWT
extends UITestCase {
    static long duration = 1600L;
    static int width = 640;
    static int height = 480;

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos02AWT.getGLP());
        final JFrame jFrame = new JFrame("TestBug816OSXCALayerPos02AWT");
        Assert.assertNotNull(jFrame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        Animator animator = new Animator();
        animator.add(gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(jFrame);
        JSplitPane jSplitPane = new JSplitPane(0, true, new JScrollPane(), gLCanvas);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(1, true, new JScrollPane(), jSplitPane);
        jSplitPane2.setResizeWeight(0.5);
        JRootPane jRootPane = new JRootPane();
        jRootPane.setContentPane(jSplitPane2);
        jFrame.add(jRootPane);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize(width, height);
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, true));
        animator.start();
        Assert.assertTrue(animator.isStarted());
        Assert.assertTrue(animator.isAnimating());
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull(jFrame);
        Assert.assertNotNull(gLCanvas);
        Assert.assertNotNull(animator);
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
            }
        });
        Assert.assertEquals(false, jFrame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.remove(gLCanvas);
                jFrame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore(true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestBug816OSXCALayerPos02AWT.class.getName());
    }
}

