/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShutdownCompleteAWT
extends UITestCase {
    static long duration = 300L;
    static boolean initOnly = false;
    static boolean waitForKey = false;

    protected void runTestGL() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull(frame);
        final GLCanvas gLCanvas = new GLCanvas(new GLCapabilities(GLProfile.getGL2ES2()));
        Assert.assertNotNull(gLCanvas);
        frame.add(gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        Animator animator = new Animator(gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(256, 256);
                frame.setVisible(true);
            }
        });
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(true, gLCanvas.isVisible());
        Assert.assertEquals(true, gLCanvas.isDisplayable());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(true, gLCanvas.isRealized());
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(gLCanvas);
                frame.dispose();
            }
        });
    }

    @AfterClass
    public static void afterAll() {
        if (waitForKey) {
            UITestCase.waitForKey("Exit");
        }
    }

    protected void oneLife(boolean bl) throws InterruptedException, InvocationTargetException {
        long l = Platform.currentTimeMicros();
        GLProfile.initSingleton();
        long l2 = Platform.currentTimeMicros();
        if (!initOnly) {
            this.runTestGL();
        }
        long l3 = Platform.currentTimeMicros();
        if (bl) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, false).toString());
        }
        long l4 = Platform.currentTimeMicros();
        GLProfile.shutdown();
        long l5 = Platform.currentTimeMicros();
        System.err.println("Total:                          " + (double)(l5 - l) / 1000.0 + "ms");
        System.err.println("  GLProfile.initSingleton():    " + (double)(l2 - l) / 1000.0 + "ms");
        System.err.println("  Demo Code:                    " + (double)(l3 - l2) / 1000.0 + "ms");
        System.err.println("  GLInfo:                       " + (double)(l4 - l3) / 1000.0 + "ms");
        System.err.println("  GLProfile.shutdown():         " + (double)(l5 - l4) / 1000.0 + "ms");
    }

    @Test
    public void test01OneLife() throws InterruptedException, InvocationTargetException {
        this.oneLife(false);
    }

    @Test
    public void test02AnotherLifeWithGLInfo() throws InterruptedException, InvocationTargetException {
        this.oneLife(true);
    }

    @Test
    public void test03AnotherLife() throws InterruptedException, InvocationTargetException {
        this.oneLife(true);
    }

    @Test
    public void test03TwoLifes() throws InterruptedException, InvocationTargetException {
        this.oneLife(false);
        this.oneLife(false);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-initOnly")) continue;
            initOnly = true;
        }
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        String string = TestShutdownCompleteAWT.class.getName();
        JUnitCore.main(string);
    }
}

