/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.DumpGLInfo;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestSharedExternalContextAWT {
    static final int LATCH_COUNT = 5;

    private void doTest(boolean bl) throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final CountDownLatch countDownLatch2 = new CountDownLatch(1);
        CountDownLatch countDownLatch3 = new CountDownLatch(5);
        final MyGLEventListener myGLEventListener = new MyGLEventListener(bl, countDownLatch3);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.err.println("Master Thread Start: " + Thread.currentThread().getName());
                GLProfile gLProfile = GLProfile.getDefault();
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLOffscreenAutoDrawable gLOffscreenAutoDrawable = GLDrawableFactory.getDesktopFactory().createOffscreenAutoDrawable(GLProfile.getDefaultDevice(), gLCapabilities, null, 512, 512);
                gLOffscreenAutoDrawable.addGLEventListener(new DumpGLInfo(Platform.getNewline() + Platform.getNewline() + "Master GLContext", false, false, false));
                gLOffscreenAutoDrawable.addGLEventListener(myGLEventListener);
                gLOffscreenAutoDrawable.display();
                countDownLatch2.countDown();
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                System.err.println("Master Thread End: " + Thread.currentThread().getName());
            }
        };
        InterruptSource.Thread thread = new InterruptSource.Thread(null, runnable);
        thread.setDaemon(true);
        thread.start();
        countDownLatch2.await(3L, TimeUnit.SECONDS);
        countDownLatch3.await(3L, TimeUnit.SECONDS);
        countDownLatch.countDown();
        Exception exception = myGLEventListener.fException;
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void test01OnEDT() throws Exception {
        this.doTest(true);
    }

    @Test
    public void test02OnExecutorThread() throws Exception {
        this.doTest(false);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestSharedExternalContextAWT.class.getName());
    }

    private static class MyGLEventListener
    implements GLEventListener {
        GLOffscreenAutoDrawable fOffscreenDrawable;
        final boolean fUseEDT;
        final CountDownLatch fLatch;
        final RecursiveLock masterLock = LockFactory.createRecursiveLock();
        private Exception fException = null;

        public MyGLEventListener(boolean bl, CountDownLatch countDownLatch) {
            this.fUseEDT = bl;
            this.fLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            block6: {
                this.masterLock.lock();
                try {
                    GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                    gL2.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
                    gL2.glClear(16384);
                    System.err.println();
                    System.err.println();
                    System.err.println("Master (orig) Ct: " + gLAutoDrawable.getContext());
                    final GLContext gLContext = GLDrawableFactory.getDesktopFactory().createExternalGLContext();
                    System.err.println();
                    System.err.println();
                    System.err.println("External Context: " + gLContext);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            MyGLEventListener.this.fOffscreenDrawable = GLDrawableFactory.getDesktopFactory().createOffscreenAutoDrawable(GLProfile.getDefaultDevice(), new GLCapabilities(GLProfile.getDefault()), null, 512, 512);
                            MyGLEventListener.this.fOffscreenDrawable.setSharedContext(gLContext);
                            MyGLEventListener.this.fOffscreenDrawable.addGLEventListener(new DumpGLInfo(Platform.getNewline() + Platform.getNewline() + "Slave GLContext", false, false, false));
                            try {
                                System.err.println();
                                System.err.println();
                                System.err.println("Current: " + GLContext.getCurrent());
                                MyGLEventListener.this.fOffscreenDrawable.display();
                            }
                            catch (GLException gLException) {
                                MyGLEventListener.this.fException = gLException;
                                throw gLException;
                            }
                        }
                    };
                    if (this.fUseEDT) {
                        try {
                            EventQueue.invokeLater(runnable);
                        }
                        catch (Exception exception) {
                            this.fException = exception;
                        }
                        Timer timer = new Timer(200, new ActionListener(){
                            int i = 0;

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (++this.i > 5) {
                                    return;
                                }
                                System.err.println("Update on EDT");
                                MyGLEventListener.this.fOffscreenDrawable.display();
                                MyGLEventListener.this.fLatch.countDown();
                            }
                        });
                        timer.start();
                        break block6;
                    }
                    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                    scheduledExecutorService.submit(runnable);
                    scheduledExecutorService.scheduleAtFixedRate(new Runnable(){
                        int i = 0;

                        @Override
                        public void run() {
                            if (++this.i > 5) {
                                return;
                            }
                            System.err.println("Update on Executor thread");
                            MyGLEventListener.this.fOffscreenDrawable.display();
                            MyGLEventListener.this.fLatch.countDown();
                        }
                    }, 0L, 200L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.masterLock.unlock();
                }
            }
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            this.masterLock.lock();
            this.masterLock.unlock();
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            this.masterLock.lock();
            this.masterLock.unlock();
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.masterLock.lock();
            this.masterLock.unlock();
        }
    }
}

