/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextWithJTabbedPaneAWT
extends UITestCase {
    static long durationPerTest = 2000L;
    static boolean manual = false;

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame();
        jFrame.setTitle("Shared GLContext AWT GLCanvas JTabbedPane");
        final DemoInstance demoInstance = new DemoInstance(jFrame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.err.println("XXX SetVisible XXX");
                jFrame.setVisible(true);
            }
        });
        if (manual) {
            for (long i = durationPerTest; i > 0L; i -= 100L) {
                Thread.sleep(100L);
            }
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    demoInstance.tabbedPanel.setSelectedIndex(0);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    demoInstance.tabbedPanel.setSelectedIndex(1);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    demoInstance.tabbedPanel.setSelectedIndex(0);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    demoInstance.tabbedPanel.setSelectedIndex(1);
                }
            });
            Thread.sleep(durationPerTest / 4L);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.err.println("XXX SetVisible XXX");
                jFrame.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        JUnitCore.main(TestSharedContextWithJTabbedPaneAWT.class.getName());
    }

    static class DemoInstance {
        int[] bufferId;
        public JTabbedPane tabbedPanel;

        protected static GLCapabilities getCaps() {
            GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getMaxFixedFunc(true));
            gLCapabilities.setAlphaBits(8);
            gLCapabilities.setRedBits(8);
            gLCapabilities.setGreenBits(8);
            gLCapabilities.setBlueBits(8);
            gLCapabilities.setDepthBits(24);
            gLCapabilities.setDoubleBuffered(true);
            return gLCapabilities;
        }

        protected void makeVBO(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            this.bufferId = new int[1];
            gL2.glGenBuffers(1, this.bufferId, 0);
            gL2.glBindBuffer(34962, this.bufferId[0]);
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(6);
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
            floatBuffer.put(1.0f).put(1.0f).put(0.0f);
            gL2.glBufferData(34962, floatBuffer.capacity() * 4, floatBuffer.rewind(), 35044);
        }

        public DemoInstance(JFrame jFrame) {
            try {
                GLProfile.initSingleton();
                System.err.println("XXX START DEMO XXX");
                this.tabbedPanel = new JTabbedPane();
                jFrame.add((Component)this.tabbedPanel, "Center");
                SharedGLPanel sharedGLPanel = new SharedGLPanel(null, 600, 600);
                SharedGLPanel sharedGLPanel2 = new SharedGLPanel(sharedGLPanel.canvas, sharedGLPanel.getWidth(), sharedGLPanel.getHeight());
                this.tabbedPanel.add((Component)sharedGLPanel, "Window A");
                this.tabbedPanel.add((Component)sharedGLPanel2, "Window B");
                jFrame.add((Component)this.tabbedPanel, "Center");
                jFrame.setTitle("Multi-Window Tabbed Pane");
                jFrame.setDefaultCloseOperation(3);
                jFrame.pack();
                jFrame.setResizable(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        class SharedGLPanel
        extends JPanel
        implements GLEventListener {
            final GLCanvas canvas;
            final boolean shared;

            public SharedGLPanel(GLCanvas gLCanvas, int n, int n2) {
                GLContext gLContext = gLCanvas != null ? gLCanvas.getContext() : null;
                System.err.println("XXX WWPanel: shareWith " + gLCanvas + ", sharedCtx " + gLContext);
                this.canvas = new GLCanvas(DemoInstance.getCaps());
                if (null != gLCanvas) {
                    this.canvas.setSharedAutoDrawable(gLCanvas);
                    this.shared = true;
                } else {
                    this.shared = false;
                }
                this.canvas.setSize(new Dimension(n, n2));
                this.setLayout(new BorderLayout(5, 5));
                this.add((Component)this.canvas, "Center");
                this.setOpaque(false);
                this.canvas.addGLEventListener(this);
            }

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                if (!this.shared) {
                    Assert.assertNull("Buffer is set, but instance is share master", DemoInstance.this.bufferId);
                    DemoInstance.this.makeVBO(gLAutoDrawable);
                    System.err.println("XXX Create Buffer " + DemoInstance.this.bufferId[0]);
                } else {
                    Assert.assertNotNull("Buffer is not set, but instance is share slave", DemoInstance.this.bufferId);
                    Assert.assertTrue("Context is not shared", gLAutoDrawable.getContext().isShared());
                    System.err.println("XXX Reuse Buffer " + DemoInstance.this.bufferId[0]);
                }
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                if (this.shared) {
                    gL2.glColor3f(1.0f, 1.0f, 1.0f);
                    gL2.glClearColor(0.3f, 0.3f, 0.3f, 1.0f);
                } else {
                    gL2.glColor3f(0.0f, 0.0f, 0.0f);
                    gL2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
                }
                gL2.glShadeModel(7424);
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                gL2.glClear(16640);
                gL2.glEnableClientState(32884);
                gL2.glBindBuffer(34962, DemoInstance.this.bufferId[0]);
                gL2.glVertexPointer(3, 5126, 0, 0L);
                gL2.glDrawArrays(1, 0, 2);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                int n5 = this.getWidth();
                int n6 = this.getHeight();
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                gL2.glViewport(0, 0, n5, n6);
                gL2.glMatrixMode(5889);
                gL2.glLoadIdentity();
                gL2.glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
                gL2.glMatrixMode(5888);
                gL2.glLoadIdentity();
            }
        }
    }
}

