/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2AWT3
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES2")) {
            glp = GLProfile.get("GL2ES2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2AWT3.setTestSupported(false);
        }
    }

    protected GLCanvas createGLCanvas(Frame frame, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLCanvas gLCanvas = new GLCanvas(caps);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.addGLEventListener(gearsES2);
        frame.add(gLCanvas);
        frame.setLocation(n, n2);
        frame.setSize(width, height);
        frame.setTitle("AWT GLCanvas Shared Gears Test: " + n + "/" + n2 + " shared true");
        return gLCanvas;
    }

    @Test
    public void test01SyncedOneAnimatorCleanDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(true);
    }

    @Test
    public void test02SyncedOneAnimatorDirtyDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(false);
    }

    public void syncedOneAnimator(final boolean bl) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLCanvas gLCanvas = this.createGLCanvas(frame, 0, 0, gearsES2);
        animator.add(gLCanvas);
        final Frame frame2 = new Frame();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLCanvas gLCanvas2 = this.createGLCanvas(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable(gLCanvas);
        animator.add(gLCanvas2);
        final Frame frame3 = new Frame();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLCanvas gLCanvas3 = this.createGLCanvas(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLCanvas3.setSharedAutoDrawable(gLCanvas);
        animator.add(gLCanvas3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
                frame.setVisible(true);
                frame3.setVisible(true);
            }
        });
        animator.start();
        Thread.sleep(160L);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas, true));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas2, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas2, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas2, true));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas3, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas3, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas3, true));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. Ma trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame3.dispose();
                    } else {
                        frame.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame2.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame.dispose();
                    } else {
                        frame3.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas2, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas3, false));
    }

    @Test
    public void test11AsyncEachAnimatorCleanDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(true);
    }

    @Test
    public void test12AsyncEachAnimatorDirtyDtorOrder() throws InterruptedException, InvocationTargetException {
        this.asyncEachOneAnimator(false);
    }

    public void asyncEachOneAnimator(final boolean bl) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLCanvas gLCanvas = this.createGLCanvas(frame, 0, 0, gearsES2);
        animator.add(gLCanvas);
        animator.start();
        final Frame frame2 = new Frame();
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLCanvas gLCanvas2 = this.createGLCanvas(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable(gLCanvas);
        animator2.add(gLCanvas2);
        animator2.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
            }
        });
        Thread.sleep(200L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        final Frame frame3 = new Frame();
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLCanvas gLCanvas3 = this.createGLCanvas(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLCanvas3.setSharedAutoDrawable(gLCanvas);
        animator3.add(gLCanvas3);
        animator3.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame3.setVisible(true);
            }
        });
        Thread.sleep(160L);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas, true));
        Assert.assertTrue("Gears1 not initialized", gearsES2.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas2, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas2, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas2, true));
        Assert.assertTrue("Gears2 not initialized", gearsES22.waitForInit(true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas3, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas3, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLCanvas3, true));
        Assert.assertTrue("Gears3 not initialized", gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List<GLContext> list = gLContext.getCreatedShares();
        List<GLContext> list2 = gLContext2.getCreatedShares();
        List<GLContext> list3 = gLContext3.getCreatedShares();
        MiscUtils.dumpSharedGLContext("XXX-C-3.1", gLContext);
        MiscUtils.dumpSharedGLContext("XXX-C-3.2", gLContext2);
        MiscUtils.dumpSharedGLContext("XXX-C-3.3", gLContext3);
        Assert.assertTrue("Ctx1 is not shared", gLContext.isShared());
        Assert.assertTrue("Ctx2 is not shared", gLContext2.isShared());
        Assert.assertTrue("Ctx3 is not shared", gLContext3.isShared());
        Assert.assertEquals("Ctx1 has unexpected number of created shares", 2L, list.size());
        Assert.assertEquals("Ctx2 has unexpected number of created shares", 2L, list2.size());
        Assert.assertEquals("Ctx3 has unexpected number of created shares", 2L, list3.size());
        Assert.assertTrue("Gears1 is shared", !gearsES2.usesSharedGears());
        Assert.assertTrue("Gears2 is not shared", gearsES22.usesSharedGears());
        Assert.assertTrue("Gears3 is not shared", gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        animator2.stop();
        Assert.assertEquals(false, animator2.isAnimating());
        animator3.stop();
        Assert.assertEquals(false, animator3.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. Ma trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame3.dispose();
                    } else {
                        frame.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame2.dispose();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame.dispose();
                    } else {
                        frame3.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas2, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLCanvas3, false));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES2AWT3.class.getName());
    }

    static {
        duration = 1000L;
    }
}

