/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtAWTReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestOffscreenLayer02NewtCanvasAWT
extends UITestCase {
    static boolean singleBuffer = false;
    static boolean useMSAA = false;
    static boolean addComp = true;
    static int swapInterval = 1;
    static boolean shallUseOffscreenPBufferLayer = false;
    static boolean noAnimation = false;
    static Dimension frameSize0;
    static Dimension frameSize1;
    static Dimension preferredGLSize;
    static long durationPerTest;
    static boolean waitForKey;

    @BeforeClass
    public static void initClass() {
        frameSize0 = new Dimension(500, 300);
        frameSize1 = new Dimension(800, 600);
        preferredGLSize = new Dimension(400, 200);
    }

    private void setupFrameAndShow(final Frame frame, Component component) throws InterruptedException, InvocationTargetException {
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add(component, "Center");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("NORTH"), "North");
        frame.add((Component)new Button("SOUTH"), "South");
        frame.add((Component)new Button("EAST"), "East");
        frame.add((Component)new Button("WEST"), "West");
        frame.add((Component)container, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.validate();
                frame.setVisible(true);
            }
        });
    }

    private void end(GLAnimatorControl gLAnimatorControl, final Frame frame, Window window) throws InterruptedException, InvocationTargetException {
        gLAnimatorControl.stop();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        if (null != window) {
            window.destroy();
        }
    }

    @Test
    public void test01_GLDefault() throws InterruptedException, InvocationTargetException {
        this.testOffscreenLayerNewtCanvas_Impl(null);
    }

    @Test
    public void test02_GL3() throws InterruptedException, InvocationTargetException {
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        this.testOffscreenLayerNewtCanvas_Impl(GLProfile.get("GL3"));
    }

    private void testOffscreenLayerNewtCanvas_Impl(GLProfile gLProfile) throws InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        final Frame frame = new Frame("AWT Parent Frame");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (singleBuffer) {
            gLCapabilities.setDoubleBuffered(false);
        }
        if (useMSAA) {
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setSampleBuffers(true);
        }
        if (shallUseOffscreenPBufferLayer) {
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setOnscreen(true);
        }
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        newtCanvasAWT.setShallUseOffscreenLayer(true);
        newtCanvasAWT.setPreferredSize(preferredGLSize);
        newtCanvasAWT.setMinimumSize(preferredGLSize);
        newtCanvasAWT.setSize(preferredGLSize);
        GearsES2 gearsES2 = new GearsES2(swapInterval);
        if (noAnimation) {
            gearsES2.setDoRotation(false);
        }
        TestOffscreenLayer02NewtCanvasAWT.setDemoFields(gearsES2, gLWindow, false);
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.addKeyListener(new NewtAWTReparentingKeyAdapter(frame, newtCanvasAWT, gLWindow));
        frame.setSize(frameSize0);
        this.setupFrameAndShow(frame, newtCanvasAWT);
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Assert.assertEquals(true, newtCanvasAWT.isOffscreenLayerSurfaceEnabled());
        Animator animator = new Animator(gLWindow);
        if (!noAnimation) {
            animator.start();
        }
        animator.setUpdateFPSFrames(60, System.err);
        Thread.sleep(durationPerTest / 2L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(frameSize1);
                frame.pack();
                frame.validate();
            }
        });
        Thread.sleep(durationPerTest / 2L);
        this.end(animator, frame, gLWindow);
        if (waitForKey) {
            JunitTracer.waitForKey("Continue");
        }
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestOffscreenLayer02NewtCanvasAWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-layeredPBuffer")) {
                shallUseOffscreenPBufferLayer = true;
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                continue;
            }
            if (stringArray[i].equals("-single")) {
                singleBuffer = true;
                continue;
            }
            if (stringArray[i].equals("-still")) {
                noAnimation = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            JunitTracer.waitForKey("Start");
        }
        String string = TestOffscreenLayer02NewtCanvasAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 1000L;
        waitForKey = false;
    }
}

