/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.PointsDemo;
import com.jogamp.opengl.test.junit.jogl.demos.es1.PointsDemoES1;
import com.jogamp.opengl.test.junit.jogl.demos.es2.PointsDemoES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLPointsNEWT
extends UITestCase {
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        width = 512;
        height = 512;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL0(GLCapabilities gLCapabilities, PointsDemo pointsDemo) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.addGLEventListener(pointsDemo);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        snapshotGLEventListener.setPostSNDetail(pointsDemo.getClass().getSimpleName());
        gLWindow.addGLEventListener(snapshotGLEventListener);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        pointsDemo.setSmoothPoints(false);
        snapshotGLEventListener.setMakeSnapshot();
        snapshotGLEventListener.setPostSNDetail("flat");
        gLWindow.display();
        pointsDemo.setSmoothPoints(true);
        snapshotGLEventListener.setMakeSnapshot();
        snapshotGLEventListener.setPostSNDetail("smooth");
        gLWindow.display();
        pointsDemo.setPointParams(2.0f, 40.0f, 0.01f, 0.0f, 0.01f, 1.0f);
        snapshotGLEventListener.setMakeSnapshot();
        snapshotGLEventListener.setPostSNDetail("attn0");
        gLWindow.display();
        gLWindow.removeGLEventListener(pointsDemo);
        gLWindow.destroy();
    }

    protected void runTestGL(GLCapabilities gLCapabilities, PointsDemo pointsDemo, boolean bl) throws InterruptedException {
        this.runTestGL0(gLCapabilities, pointsDemo);
    }

    @Test
    public void test01FFP__GL2() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2")) {
            System.err.println("GL2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GL2"));
        this.runTestGL(gLCapabilities, new PointsDemoES1(), false);
    }

    @Test
    public void test02FFP__ES1() throws InterruptedException {
        if (!GLProfile.isAvailable("GLES1")) {
            System.err.println("GLES1 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GLES1"));
        this.runTestGL(gLCapabilities, new PointsDemoES1(), false);
    }

    @Test
    public void test03FFP__ES2() throws InterruptedException {
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GLES2"));
        PointsDemoES1 pointsDemoES1 = new PointsDemoES1();
        pointsDemoES1.setForceFFPEmu(true, false, false, false);
        this.runTestGL(gLCapabilities, pointsDemoES1, false);
    }

    @Test
    public void test04FFP__GL2ES2() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2ES2")) {
            System.err.println("GL2ES2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GL2ES2"));
        PointsDemoES1 pointsDemoES1 = new PointsDemoES1();
        pointsDemoES1.setForceFFPEmu(true, false, false, false);
        this.runTestGL(gLCapabilities, pointsDemoES1, false);
    }

    @Test
    public void test11GLSL_GL2() throws InterruptedException {
        if (!GLProfile.isAvailable("GL2")) {
            System.err.println("GL2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GL2"));
        this.runTestGL(gLCapabilities, new PointsDemoES2(), false);
    }

    @Test
    public void test12GLSL_ES2() throws InterruptedException {
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GLES2"));
        this.runTestGL(gLCapabilities, new PointsDemoES2(), false);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestGLPointsNEWT.class.getName());
    }

    static {
        duration = 1000L;
    }
}

