/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableFactoryGLProfileDeviceNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLProfile getProfile(AbstractGraphicsDevice abstractGraphicsDevice, String string) {
        if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return GLProfile.get(abstractGraphicsDevice, string);
    }

    void doTest(boolean bl, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.err.println("Factory: " + gLDrawableFactory.getClass().getName());
        System.err.println("Requested GL Caps: " + gLCapabilitiesImmutable);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(abstractGraphicsDevice, gLCapabilitiesImmutable, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull(gLOffscreenAutoDrawable);
        Assert.assertTrue(gLOffscreenAutoDrawable.isRealized());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        Assert.assertNotNull(gLCapabilitiesImmutable2);
        gLOffscreenAutoDrawable.display();
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        Assert.assertNotNull(gLCapabilitiesImmutable3);
        System.err.println("Choosen   GL Caps: " + gLCapabilitiesImmutable3);
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        GLEventListenerCounter gLEventListenerCounter = new GLEventListenerCounter();
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListenerCounter);
        gLOffscreenAutoDrawable.display();
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        gLOffscreenAutoDrawable.display();
        this.szStep = 1;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        gLOffscreenAutoDrawable.display();
        Thread.sleep(50L);
        AbstractGraphicsDevice abstractGraphicsDevice2 = gLOffscreenAutoDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
        gLOffscreenAutoDrawable.destroy();
        System.err.println("Fin isEGL " + bl + ", " + abstractGraphicsDevice2);
        System.err.println("Fin " + gLEventListenerCounter);
        Assert.assertTrue("init count: " + gLEventListenerCounter, gLEventListenerCounter.initCount > 0);
        Assert.assertTrue("reshape count: " + gLEventListenerCounter, gLEventListenerCounter.reshapeCount > 0);
        Assert.assertTrue("display count: " + gLEventListenerCounter, gLEventListenerCounter.displayCount > 0);
        Assert.assertTrue("dispose count: " + gLEventListenerCounter, gLEventListenerCounter.disposeCount > 0);
        Assert.assertEquals("EGL/Desktop not matching: isEGL " + bl + ", " + abstractGraphicsDevice2, bl, abstractGraphicsDevice2 instanceof EGLGraphicsDevice);
    }

    @Test
    public void test00AvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getEGLFactory())) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
    }

    @Test
    public void test01ES2OnEGL() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getEGLFactory();
        if (null == gLDrawableFactory) {
            System.err.println("EGL Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GLES2");
        if (null != gLProfile) {
            Assert.assertTrue("Not a GLES2 profile but " + gLProfile, gLProfile.isGLES2());
            Assert.assertTrue("Not a GL2ES2 profile but " + gLProfile, gLProfile.isGL2ES2());
        }
        if (null == gLProfile) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory, abstractGraphicsDevice, gLCapabilities, gearsES2);
    }

    @Test
    public void test02GLOnEGL() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getEGLFactory();
        if (null == gLDrawableFactory) {
            System.err.println("EGL Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GL2GL3");
        if (null != gLProfile) {
            Assert.assertTrue("Not a GL2GL3 profile but " + gLProfile, gLProfile.isGL2GL3());
        }
        if (null == gLProfile || !gLProfile.isGL2ES2()) {
            if (null != gLProfile) {
                System.err.println("Not a GL2ES2 profile but " + gLProfile);
            }
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory, abstractGraphicsDevice, gLCapabilities, gearsES2);
    }

    @Test
    public void test11ES2OnDesktop() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null == gLDrawableFactory) {
            System.err.println("Desktop Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GLES2");
        if (null != gLProfile) {
            Assert.assertTrue("Not a GLES2 profile but " + gLProfile, gLProfile.isGLES2());
            Assert.assertTrue("Not a GL2ES2 profile but " + gLProfile, gLProfile.isGL2ES2());
        }
        if (null == gLProfile) {
            return;
        }
        GLDrawableFactory gLDrawableFactory2 = GLDrawableFactory.getFactory(gLProfile);
        if (null == gLDrawableFactory2) {
            System.err.println("Production Factory n/a");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(true, gLDrawableFactory2, abstractGraphicsDevice, gLCapabilities, gearsES2);
    }

    @Test
    public void test12GLOnDesktop() throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null == gLDrawableFactory) {
            System.err.println("Desktop Factory n/a");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        GLProfile gLProfile = TestGLAutoDrawableFactoryGLProfileDeviceNEWT.getProfile(abstractGraphicsDevice, "GL2GL3");
        if (null != gLProfile) {
            Assert.assertTrue("Not a GL2GL3 profile but " + gLProfile, gLProfile.isGL2GL3());
        }
        if (null == gLProfile || !gLProfile.isGL2ES2()) {
            if (null != gLProfile) {
                System.err.println("Not a GL2ES2 profile but " + gLProfile);
            }
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setOnscreen(false);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        this.doTest(false, gLDrawableFactory, abstractGraphicsDevice, gLCapabilities, gearsES2);
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main(TestGLAutoDrawableFactoryGLProfileDeviceNEWT.class.getName());
    }
}

