/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.FBOMix2DemosES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOAutoDrawableFactoryNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    @Test
    public void test01a_GL2ES2_Demo1_SingleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        this.testGLFBODrawableImpl(gLCapabilities, 1, new GearsES2(0));
    }

    @Test
    public void test01b_GL2ES2_Demo1_SingleBuffer_NoTex() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new GearsES2(0));
    }

    @Test
    public void test01c_GL2ES2_Demo1_SingleBuffer_NoTexNoDepth() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setDepthBits(0);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new GearsES2(0));
    }

    @Test
    public void test02a_GL2ES2_Demo1_DoubleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(true);
        this.testGLFBODrawableImpl(gLCapabilities, 1, new GearsES2(0));
    }

    @Test
    public void test03a_GL2ES2_Demo2MSAA4_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 1, new MultisampleDemoES2(true));
    }

    @Test
    public void test03b_GL2ES2_Demo2MSAA4_NoTex() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new MultisampleDemoES2(true));
    }

    @Test
    public void test03c_GL2ES2_Demo2MSAA4_NoTexNoDepth() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setDepthBits(0);
        this.testGLFBODrawableImpl(gLCapabilities, 0, new MultisampleDemoES2(true));
    }

    @Test
    public void test04_GL2ES2_FBODemoMSAA4_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        FBOMix2DemosES2 fBOMix2DemosES2 = new FBOMix2DemosES2(0);
        fBOMix2DemosES2.setDoRotation(false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, 1, fBOMix2DemosES2);
    }

    @Test
    public void test11_EGLES2_Demo0Normal() throws InterruptedException {
        if (GLProfile.isAvailable("GLES2")) {
            GLProfile gLProfile = GLProfile.get("GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.testGLFBODrawableImpl(gLCapabilities, 1, new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    @Test
    public void test13_EGLES2_Demo0MSAA4() throws InterruptedException {
        if (GLProfile.isAvailable("GLES2")) {
            GLProfile gLProfile = GLProfile.get("GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            this.testGLFBODrawableImpl(gLCapabilities, 1, new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    @Test
    public void test21_GL3_Demo0Normal() throws InterruptedException {
        if (GLProfile.isAvailable("GL3")) {
            GLProfile gLProfile = GLProfile.get("GL3");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.testGLFBODrawableImpl(gLCapabilities, 1, new GearsES2(0));
        } else {
            System.err.println("GL3 n/a");
        }
    }

    void testGLFBODrawableImpl(GLCapabilities gLCapabilities, int n, GLEventListener gLEventListener) throws InterruptedException {
        FBObject fBObject;
        Object object;
        FBObject.RenderAttachment renderAttachment;
        FBObject.RenderAttachment renderAttachment2;
        gLCapabilities.setFBO(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLOffscreenAutoDrawable.FBO fBO = (GLOffscreenAutoDrawable.FBO)gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull(fBO);
        System.out.println("Requested:     " + gLCapabilities);
        System.out.println("Realized GLAD: " + fBO);
        System.out.println("Realized GLAD: " + fBO.getChosenGLCapabilities());
        Assert.assertTrue("FBO drawable is initialized before ctx creation", !fBO.isInitialized());
        fBO.setFBOMode(n);
        fBO.display();
        GLContext gLContext = fBO.getContext();
        Assert.assertNotNull(gLContext);
        Assert.assertTrue(gLContext.isCreated());
        Assert.assertTrue("FBO drawable is not initialized after ctx creation", fBO.isInitialized());
        boolean bl = gLCapabilities.getDepthBits() > 0;
        boolean bl2 = fBO.getRequestedGLCapabilities().getDepthBits() > 0;
        boolean bl3 = fBO.getChosenGLCapabilities().getDepthBits() > 0;
        System.out.println("Depth: exp " + bl + ", req " + bl2 + ", has " + bl3);
        Assert.assertEquals("Depth: expected not passed to requested", bl, bl2);
        Assert.assertEquals("Depth: requested not passed to chosen", bl2, bl3);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = fBO.getChosenGLCapabilities();
        System.out.println("Init GLAD: " + fBO);
        System.out.println("Init GLAD: " + gLCapabilitiesImmutable);
        FBObject fBObject2 = fBO.getFBObject(1028);
        FBObject fBObject3 = fBO.getFBObject(1029);
        System.out.println("Init front FBO: " + fBObject2);
        System.out.println("Init back  FBO: " + fBObject3);
        Assert.assertTrue("FBO drawable is not initialized before ctx creation", fBO.isInitialized());
        Assert.assertTrue("FBO Front is not initialized before ctx creation", fBObject2.isInitialized());
        Assert.assertTrue("FBO Back  is not initialized before ctx creation", fBObject3.isInitialized());
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            Assert.assertNotEquals("FBO are equal: " + fBObject2 + " == " + fBObject3, fBObject2, fBObject3);
            Assert.assertNotSame(fBObject2, fBObject3);
        } else {
            Assert.assertEquals("FBO are not equal: " + fBObject2 + " != " + fBObject3, fBObject2, fBObject3);
            Assert.assertSame(fBObject2, fBObject3);
        }
        FBObject.Colorbuffer colorbuffer = fBO.getColorbuffer(1028);
        FBObject.Colorbuffer colorbuffer2 = 0 == fBO.getNumSamples() ? fBO.getColorbuffer(1029) : null;
        boolean bl4 = 0 != (1 & fBO.getFBOMode());
        System.out.println("Texture: exp " + bl4 + ", hasFront " + colorbuffer.isTextureAttachment());
        Assert.assertEquals("Texture: Front", bl4, colorbuffer.isTextureAttachment());
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals("Texture: Back", bl4, colorbuffer2.isTextureAttachment());
        }
        FBObject.Colorbuffer colorbuffer3 = fBObject2.getColorbuffer(0);
        Assert.assertNotNull(colorbuffer3);
        FBObject.Colorbuffer colorbuffer4 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull(colorbuffer4);
        Assert.assertEquals("Texture: Front", bl4, colorbuffer3.isTextureAttachment());
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals("Texture: Back", bl4, colorbuffer4.isTextureAttachment());
        } else {
            Assert.assertEquals("Texture: MSAA Back is Texture", false, colorbuffer4.isTextureAttachment());
        }
        if (bl3) {
            renderAttachment2 = fBObject2.getDepthAttachment();
            Assert.assertNotNull(renderAttachment2);
            renderAttachment = fBObject3.getDepthAttachment();
            Assert.assertNotNull(renderAttachment);
        } else {
            renderAttachment2 = null;
            renderAttachment = null;
        }
        fBO.display();
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            Assert.assertNotEquals("Color attachments are equal: " + colorbuffer4 + " == " + colorbuffer3, colorbuffer3, colorbuffer4);
            Assert.assertNotSame(colorbuffer4, colorbuffer3);
            if (bl3) {
                Assert.assertNotEquals("Depth attachments are equal: " + renderAttachment + " == " + renderAttachment2, renderAttachment2, renderAttachment);
                Assert.assertNotSame(renderAttachment, renderAttachment2);
            }
        } else {
            Assert.assertEquals(colorbuffer3, colorbuffer4);
            Assert.assertSame(colorbuffer3, colorbuffer4);
            Assert.assertEquals(renderAttachment2, renderAttachment);
            Assert.assertSame(renderAttachment2, renderAttachment);
        }
        Assert.assertEquals(colorbuffer, colorbuffer3);
        Assert.assertSame(colorbuffer, colorbuffer3);
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals(colorbuffer2, colorbuffer4);
            Assert.assertSame(colorbuffer2, colorbuffer4);
        }
        if (gLCapabilitiesImmutable.getNumSamples() > 0) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals("FBO are not equal: " + fBObject2 + " != " + object, fBObject2, object);
            Assert.assertSame(fBObject2, object);
            Assert.assertEquals("FBO are not equal: " + fBObject3 + " != " + fBObject, fBObject3, fBObject);
            Assert.assertSame(fBObject3, fBObject);
        } else if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals("FBO are not equal: " + fBObject3 + " != " + object, fBObject3, object);
            Assert.assertSame(fBObject3, object);
            Assert.assertEquals("FBO are not equal: " + fBObject2 + " != " + fBObject, fBObject2, fBObject);
            Assert.assertSame(fBObject2, fBObject);
        } else {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertEquals("FBO are not equal: " + fBObject2 + " != " + object, fBObject2, object);
            Assert.assertSame(fBObject2, object);
            Assert.assertEquals("FBO are not equal: " + fBObject3 + " != " + object, fBObject3, object);
            Assert.assertSame(fBObject3, object);
            Assert.assertEquals("FBO are not equal: " + fBObject3 + " != " + fBObject, fBObject3, fBObject);
            Assert.assertSame(fBObject3, fBObject);
            Assert.assertEquals("FBO are not equal: " + fBObject2 + " != " + fBObject, fBObject2, fBObject);
            Assert.assertSame(fBObject2, fBObject);
        }
        fBO.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        fBO.addGLEventListener((GLEventListener)object);
        fBO.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 1;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight(), AWTRobotUtil.waitForSize(fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        FBObject fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize1.oldFront: " + fBObject2);
        System.out.println("Resize1.nowFront: " + fBObject);
        System.out.println("Resize1.oldBack : " + fBObject3);
        System.out.println("Resize1.nowBack : " + fBObject4);
        Assert.assertEquals(fBObject2, fBObject);
        Assert.assertSame(fBObject2, fBObject);
        Assert.assertEquals(fBObject3, fBObject4);
        Assert.assertSame(fBObject3, fBObject4);
        FBObject.Colorbuffer colorbuffer5 = fBObject.getColorbuffer(0);
        Assert.assertNotNull(colorbuffer5);
        Assert.assertEquals(colorbuffer3, colorbuffer5);
        Assert.assertSame(colorbuffer3, colorbuffer5);
        FBObject.RenderAttachment renderAttachment3 = fBObject.getDepthAttachment();
        System.err.println("Resize1.oldDepth " + renderAttachment2);
        System.err.println("Resize1.newDepth " + renderAttachment3);
        if (bl3) {
            Assert.assertNotNull(renderAttachment3);
        }
        Assert.assertEquals(renderAttachment2, renderAttachment3);
        Assert.assertSame(renderAttachment2, renderAttachment3);
        renderAttachment3 = fBObject4.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull(renderAttachment3);
        }
        Assert.assertEquals(renderAttachment, renderAttachment3);
        Assert.assertSame(renderAttachment, renderAttachment3);
        colorbuffer5 = fBObject.getColorbuffer(colorbuffer3);
        Assert.assertNotNull(colorbuffer5);
        Assert.assertEquals(colorbuffer3, colorbuffer5);
        Assert.assertSame(colorbuffer3, colorbuffer5);
        this.szStep = 4;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight(), AWTRobotUtil.waitForSize(fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize2.oldFront: " + fBObject2);
        System.out.println("Resize2.nowFront: " + fBObject);
        System.out.println("Resize2.oldBack : " + fBObject3);
        System.out.println("Resize2.nowBack : " + fBObject4);
        if (gLCapabilitiesImmutable.getDoubleBuffered() && 0 == gLCapabilitiesImmutable.getNumSamples()) {
            Assert.assertEquals(fBObject3, fBObject);
            Assert.assertEquals(fBObject2, fBObject4);
        } else {
            Assert.assertEquals(fBObject2, fBObject);
            Assert.assertEquals(fBObject3, fBObject4);
        }
        colorbuffer5 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull(colorbuffer5);
        Assert.assertEquals(colorbuffer4, colorbuffer5);
        Assert.assertSame(colorbuffer4, colorbuffer5);
        renderAttachment3 = fBObject3.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull(renderAttachment3);
        }
        Assert.assertEquals(renderAttachment, renderAttachment3);
        Assert.assertSame(renderAttachment, renderAttachment3);
        renderAttachment3 = fBObject2.getDepthAttachment();
        if (bl3) {
            Assert.assertNotNull(renderAttachment3);
        }
        Assert.assertEquals(renderAttachment2, renderAttachment3);
        Assert.assertSame(renderAttachment2, renderAttachment3);
        colorbuffer5 = fBObject3.getColorbuffer(colorbuffer4);
        Assert.assertNotNull(colorbuffer5);
        Assert.assertEquals(colorbuffer4, colorbuffer5);
        Assert.assertSame(colorbuffer4, colorbuffer5);
        int n2 = gLCapabilitiesImmutable.getNumSamples();
        int n3 = n2 > 0 ? 0 : 4;
        System.out.println("Resize3.sampleCount: " + n2 + " -> " + n3);
        fBO.setNumSamples(fBO.getGL(), n3);
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 3;
        fBO.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getSurfaceWidth() + "x" + fBO.getSurfaceHeight(), AWTRobotUtil.waitForSize(fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.destroy();
        System.out.println("Fin: " + fBO);
    }

    public static void main(String[] stringArray) throws Exception {
        JUnitCore.main(TestFBOAutoDrawableFactoryNEWT.class.getName());
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

