/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GL3bc;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLBuffers;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug692GL3VAONEWT
extends UITestCase {
    static long duration = 500L;

    private void testImpl(GLProfile gLProfile, GL3VAODemo.Mode[] modeArray) throws InterruptedException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setSize(512, 512);
        Animator animator = new Animator(gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        GL3VAODemo gL3VAODemo = new GL3VAODemo(modeArray);
        gLWindow.addGLEventListener(gL3VAODemo);
        gLWindow.setVisible(true);
        animator.start();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01CPUSource() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.CPU_SRC};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test02VBOOnly() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.VBO_ONLY};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test03VBOVAO() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.VBO_VAO};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test12CPUSourceAndVBOOnly() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.CPU_SRC, GL3VAODemo.Mode.VBO_ONLY};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test13CPUSourceAndVBOVAO() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.CPU_SRC, GL3VAODemo.Mode.VBO_VAO};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test23VBOOnlyAndVBOVAO() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.VBO_ONLY, GL3VAODemo.Mode.VBO_VAO};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    @Test
    public void test88AllModes() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable("GL3bc")) {
            System.err.println("GL3bc n/a");
            return;
        }
        GL3VAODemo.Mode[] modeArray = new GL3VAODemo.Mode[]{GL3VAODemo.Mode.CPU_SRC, GL3VAODemo.Mode.VBO_ONLY, GL3VAODemo.Mode.VBO_VAO};
        this.testImpl(GLProfile.get("GL3bc"), modeArray);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atoi(stringArray[++i], (int)duration);
        }
        String string = TestBug692GL3VAONEWT.class.getName();
        JUnitCore.main(string);
    }

    static class GL3VAODemo
    implements GLEventListener {
        private final Mode[] allModes;
        private Mode currentMode;
        private int currentModeIdx;
        private static final float[] vertexColorData = new float[]{0.0f, 0.75f, 0.0f, 1.0f, 0.0f, 0.0f, -0.5f, -0.75f, 0.0f, 0.0f, 1.0f, 0.0f, 0.9f, -0.75f, 0.0f, 0.0f, 0.0f, 1.0f};
        private final FloatBuffer vertexColorDataBuffer = GLBuffers.newDirectFloatBuffer(vertexColorData);
        private final short[] indices = new short[]{0, 1, 2};
        private final ShortBuffer indicesBuffer = GLBuffers.newDirectShortBuffer(this.indices);
        private int ibo = -1;
        private int vbo = -1;
        private int vertID = -1;
        private int fragID = -1;
        private int progID = -1;
        private int vao = -1;

        public GL3VAODemo(Mode[] modeArray) {
            this.allModes = modeArray;
            this.currentMode = this.allModes[0];
            this.currentModeIdx = 0;
        }

        private static int createShader(GL3 gL3, int n, String[] stringArray) {
            int n2 = gL3.glCreateShader(n);
            assert (n2 > 0);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = stringArray[i].length();
            }
            gL3.glShaderSource(n2, stringArray.length, stringArray, nArray, 0);
            gL3.glCompileShader(n2);
            return n2;
        }

        private void initBuffers(GL3 gL3) {
            int[] nArray = new int[2];
            gL3.glGenBuffers(nArray.length, nArray, 0);
            this.vbo = nArray[0];
            assert (this.vbo > 0);
            gL3.glBindBuffer(34962, this.vbo);
            gL3.glBufferData(34962, vertexColorData.length * 4, this.vertexColorDataBuffer, 35044);
            gL3.glBindBuffer(34962, 0);
            this.ibo = nArray[1];
            assert (this.ibo > 0);
            gL3.glBindBuffer(34963, this.ibo);
            gL3.glBufferData(34963, this.indices.length * 2, this.indicesBuffer, 35044);
            gL3.glBindBuffer(34963, 0);
        }

        private void initShaders(GL3 gL3) {
            String[] stringArray = new String[]{"#version 150\n", "in vec4 vPosition;\n", "in vec4 vColor;\n", "out vec4 pColor;\n", "void main() {\n", "    pColor       = vColor;\n", "    gl_Position = vPosition;\n", "}\n"};
            this.vertID = GL3VAODemo.createShader(gL3, 35633, stringArray);
            String[] stringArray2 = new String[]{"#version 150\n", "in vec4 pColor;\n", "void main() {\n", "    gl_FragColor = pColor;\n", "}\n"};
            this.fragID = GL3VAODemo.createShader(gL3, 35632, stringArray2);
            gL3.glReleaseShaderCompiler();
            this.progID = gL3.glCreateProgram();
            assert (this.progID > 0);
            gL3.glAttachShader(this.progID, this.vertID);
            gL3.glAttachShader(this.progID, this.fragID);
            gL3.glLinkProgram(this.progID);
            gL3.glValidateProgram(this.progID);
        }

        private int initVAO(GL3 gL3) {
            int[] nArray = new int[1];
            gL3.glGenVertexArrays(1, nArray, 0);
            int n = nArray[0];
            Assert.assertTrue("Invalid VAO: " + n, n > 0);
            gL3.glUseProgram(this.progID);
            int n2 = gL3.glGetAttribLocation(this.progID, "vPosition");
            int n3 = gL3.glGetAttribLocation(this.progID, "vColor");
            gL3.glUseProgram(0);
            gL3.glBindVertexArray(n);
            gL3.glBindBuffer(34962, this.vbo);
            gL3.glBindBuffer(34963, this.ibo);
            gL3.glEnableVertexAttribArray(n2);
            gL3.glEnableVertexAttribArray(n3);
            gL3.glVertexAttribPointer(n2, 3, 5126, false, 24, 0L);
            gL3.glVertexAttribPointer(n3, 3, 5126, false, 24, 12L);
            gL3.glBindVertexArray(0);
            gL3.glBindBuffer(34962, 0);
            gL3.glBindBuffer(34963, 0);
            return n;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL3 gL3 = gLAutoDrawable.getGL().getGL3();
            gL3.glEnable(2929);
            gL3.glDisable(2884);
            this.initBuffers(gL3);
            this.initShaders(gL3);
            this.vao = this.initVAO(gL3);
            gL3.setSwapInterval(1);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL3 gL3 = gLAutoDrawable.getGL().getGL3();
            gL3.glDeleteBuffers(2, new int[]{this.vbo, this.ibo}, 0);
            gL3.glDetachShader(this.progID, this.fragID);
            gL3.glDetachShader(this.progID, this.vertID);
            gL3.glDeleteProgram(this.progID);
            gL3.glDeleteShader(this.fragID);
            gL3.glDeleteShader(this.vertID);
        }

        private void displayCPUSourcing(GL3bc gL3bc) {
            int n = gL3bc.glGetAttribLocation(this.progID, "vPosition");
            int n2 = gL3bc.glGetAttribLocation(this.progID, "vColor");
            gL3bc.glEnableVertexAttribArray(n);
            gL3bc.glEnableVertexAttribArray(n2);
            gL3bc.glVertexAttribPointer(n, 3, 5126, false, 24, this.vertexColorDataBuffer);
            this.vertexColorDataBuffer.position(3);
            gL3bc.glVertexAttribPointer(n2, 3, 5126, false, 24, this.vertexColorDataBuffer);
            this.vertexColorDataBuffer.position(0);
            gL3bc.glDrawElements(4, 3, 5123, this.indicesBuffer);
            gL3bc.glDisableVertexAttribArray(n);
            gL3bc.glDisableVertexAttribArray(n2);
        }

        private void displayVBOOnly(GL3 gL3) {
            int n = gL3.glGetAttribLocation(this.progID, "vPosition");
            int n2 = gL3.glGetAttribLocation(this.progID, "vColor");
            gL3.glEnableVertexAttribArray(n);
            gL3.glEnableVertexAttribArray(n2);
            gL3.glBindBuffer(34962, this.vbo);
            gL3.glVertexAttribPointer(n, 3, 5126, false, 24, 0L);
            gL3.glVertexAttribPointer(n2, 3, 5126, false, 24, 12L);
            gL3.glBindBuffer(34963, this.ibo);
            gL3.glDrawElements(4, 3, 5123, 0L);
            gL3.glDisableVertexAttribArray(n);
            gL3.glDisableVertexAttribArray(n2);
            gL3.glBindBuffer(34962, 0);
            gL3.glBindBuffer(34963, 0);
        }

        private void displayVBOVAO(GL3 gL3) {
            try {
                gL3.glBindVertexArray(this.vao);
                gL3.glDrawElements(4, 3, 5123, 0L);
                gL3.glBindVertexArray(0);
            }
            catch (GLException gLException) {
                Logger.getLogger(TestBug692GL3VAONEWT.class.getName()).log(Level.SEVERE, null, gLException);
            }
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL3bc gL3bc = gLAutoDrawable.getGL().getGL3bc();
            float f = ((float)this.currentMode.ordinal() + 1.0f) / (float)(Mode.values().length + 2);
            gL3bc.glClearColor(f, f, f, 0.0f);
            gL3bc.glClear(16640);
            gL3bc.glUseProgram(this.progID);
            this.currentModeIdx = (this.currentModeIdx + 1) % this.allModes.length;
            Mode mode = this.allModes[this.currentModeIdx];
            if (mode != this.currentMode) {
                this.currentMode = mode;
                System.out.println("Display mode: " + (Object)((Object)this.currentMode));
            }
            this.currentMode.display(this, gL3bc);
            gL3bc.glUseProgram(0);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public static enum Mode {
            CPU_SRC{

                @Override
                void display(GL3VAODemo gL3VAODemo, GL3bc gL3bc) {
                    gL3VAODemo.displayCPUSourcing(gL3bc);
                }
            }
            ,
            VBO_ONLY{

                @Override
                void display(GL3VAODemo gL3VAODemo, GL3bc gL3bc) {
                    gL3VAODemo.displayVBOOnly(gL3bc);
                }
            }
            ,
            VBO_VAO{

                @Override
                void display(GL3VAODemo gL3VAODemo, GL3bc gL3bc) {
                    gL3VAODemo.displayVBOVAO(gL3bc);
                }
            };


            abstract void display(GL3VAODemo var1, GL3bc var2);
        }
    }
}

