/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.graph.demos.ui.LabelButton;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class UIListenerBase01
implements GLEventListener {
    private final GLReadBufferUtil screenshot;
    private final int renderModes;
    private final RegionRenderer rRenderer;
    private final boolean debug;
    private final boolean trace;
    protected LabelButton button;
    private KeyAction keyAction;
    private MouseAction mouseAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private float xTran = -10.0f;
    private float yTran = 10.0f;
    private float ang = 0.0f;
    private float zoom = -70.0f;
    boolean ignoreInput = false;
    int screenshot_num = 0;

    public UIListenerBase01(int n, RegionRenderer regionRenderer, boolean bl, boolean bl2) {
        this.renderModes = n;
        this.rRenderer = regionRenderer;
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
    }

    public final RegionRenderer getRegionRenderer() {
        return this.rRenderer;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final float getXTran() {
        return this.xTran;
    }

    public final float getYTran() {
        return this.yTran;
    }

    public final float getAngle() {
        return this.ang;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void setMatrix(float f, float f2, float f3, int n) {
        this.xTran = f;
        this.yTran = f2;
        this.ang = f3;
        this.zoom = n;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", null, gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", null, gL2ES2, new Object[]{System.err})).getGL2ES2();
        }
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRegionRenderer().init(gL2ES2, this.renderModes);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(n, n2, n3, n4);
        this.rRenderer.reshapePerspective(45.0f, n3, n4, 0.1f, 7000.0f);
        this.dumpMatrix();
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.screenshot.dispose(gL2ES2);
        this.rRenderer.destroy(gL2ES2);
    }

    public void zoom(int n) {
        this.zoom += (float)n;
        this.dumpMatrix();
    }

    public void move(float f, float f2) {
        this.xTran += f;
        this.yTran += f2;
        this.dumpMatrix();
    }

    public void rotate(float f) {
        this.ang += f;
        this.ang %= 360.0f;
        this.dumpMatrix();
    }

    void dumpMatrix() {
        System.err.println("Matrix: " + this.xTran + "/" + this.yTran + " x" + this.zoom + " @" + this.ang);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener(this.keyAction);
        }
        if (null == this.mouseAction) {
            this.mouseAction = new MouseAction();
            gLWindow.addMouseListener(this.mouseAction);
        }
    }

    public void detachFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        if (null == this.mouseAction) {
            return;
        }
        gLWindow.removeGLEventListener(this);
        gLWindow.removeKeyListener(this.keyAction);
        gLWindow.removeMouseListener(this.mouseAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("-%03dx%03d-Z%04d-T%04d-%s", gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), (int)Math.abs(this.zoom), 0, string3);
        String string4 = string + string2 + stringWriter + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string4));
        }
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (UIListenerBase01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                UIListenerBase01.this.zoom(10);
            } else if (keyEvent.getKeyCode() == 50) {
                UIListenerBase01.this.zoom(-10);
            } else if (keyEvent.getKeyCode() == 150) {
                UIListenerBase01.this.move(0.0f, -1.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                UIListenerBase01.this.move(0.0f, 1.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                UIListenerBase01.this.move(1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                UIListenerBase01.this.move(-1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 52) {
                UIListenerBase01.this.button.setSpacing(UIListenerBase01.this.button.getSpacingX() - 0.01f, UIListenerBase01.this.button.getSpacingY() - 0.005f);
                System.err.println("Button Spacing: " + UIListenerBase01.this.button.getSpacingX());
            } else if (keyEvent.getKeyCode() == 53) {
                UIListenerBase01.this.button.setSpacing(UIListenerBase01.this.button.getSpacingX() + 0.01f, UIListenerBase01.this.button.getSpacingY() + 0.005f);
                System.err.println("Button Spacing: " + UIListenerBase01.this.button.getSpacingX());
            } else if (keyEvent.getKeyCode() == 54) {
                UIListenerBase01.this.button.setCorner(UIListenerBase01.this.button.getCorner() - 0.01f);
                System.err.println("Button Corner: " + UIListenerBase01.this.button.getCorner());
            } else if (keyEvent.getKeyCode() == 55) {
                UIListenerBase01.this.button.setCorner(UIListenerBase01.this.button.getCorner() + 0.01f);
                System.err.println("Button Corner: " + UIListenerBase01.this.button.getCorner());
            } else if (keyEvent.getKeyCode() == 48) {
                UIListenerBase01.this.rotate(1.0f);
            } else if (keyEvent.getKeyCode() == 57) {
                UIListenerBase01.this.rotate(-1.0f);
            } else if (keyEvent.getKeyCode() == 86) {
                if (null != UIListenerBase01.this.autoDrawable) {
                    UIListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        @Override
                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            int n;
                            GL gL = gLAutoDrawable.getGL();
                            int n2 = gL.getSwapInterval();
                            switch (n2) {
                                case 0: {
                                    n = 1;
                                    break;
                                }
                                case 1: {
                                    n = -1;
                                    break;
                                }
                                case -1: {
                                    n = 0;
                                    break;
                                }
                                default: {
                                    n = 1;
                                }
                            }
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            if (gLAutoDrawable instanceof FPSCounter) {
                                ((FPSCounter)((Object)gLAutoDrawable)).resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n2 + " -> " + n + " -> " + gL.getSwapInterval());
                            return true;
                        }
                    });
                }
            } else if (keyEvent.getKeyCode() == 83) {
                UIListenerBase01.this.rotate(-1.0f);
                if (null != UIListenerBase01.this.autoDrawable) {
                    UIListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        @Override
                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            try {
                                String string = Region.getRenderModeString(UIListenerBase01.this.renderModes);
                                UIListenerBase01.this.printScreen(gLAutoDrawable, "./", "demo-" + string, "snap" + UIListenerBase01.this.screenshot_num, false);
                                ++UIListenerBase01.this.screenshot_num;
                            }
                            catch (GLException gLException) {
                                gLException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return true;
                        }
                    });
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class MouseAction
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            UIListenerBase01.this.button.setLabelColor(0.8f, 0.8f, 0.8f);
            UIListenerBase01.this.button.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            UIListenerBase01.this.button.setLabelColor(1.0f, 1.0f, 1.0f);
            UIListenerBase01.this.button.setColor(0.6f, 0.6f, 0.6f, 1.0f);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
        }
    }
}

