/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.ui.Label0;
import com.jogamp.opengl.test.junit.graph.demos.ui.RoundButton;

public class LabelButton
extends RoundButton {
    public static final float DEFAULT_SPACING_X = 0.08f;
    public static final float DEFAULT_SPACING_Y = 0.4f;
    private static final float DEFAULT_2PASS_LABEL_ZOFFSET = -0.05f;
    private final Label0 label;
    private float spacingX = 0.08f;
    private float spacingY = 0.4f;

    public LabelButton(Vertex.Factory<? extends Vertex> factory, int n, Font font, String string, float f, float f2) {
        super(factory, n | 0x200, f, f2);
        this.label = new Label0(font, string, new float[]{1.33f, 1.33f, 1.33f, 1.0f});
        this.setColor(0.75f, 0.75f, 0.75f, 1.0f);
        this.setPressedColorMod(0.9f, 0.9f, 0.9f, 0.7f);
        this.setToggleOffColorMod(0.65f, 0.65f, 0.65f, 1.0f);
        this.setToggleOnColorMod(0.85f, 0.85f, 0.85f, 1.0f);
    }

    @Override
    public void drawShape(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        super.drawShape(gL2ES2, regionRenderer, nArray);
    }

    @Override
    protected void addShapeToRegion(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        OutlineShape outlineShape = new OutlineShape(regionRenderer.getRenderState().getVertexFactory());
        if (this.corner == 0.0f) {
            this.createSharpOutline(outlineShape, -0.05f);
        } else {
            this.createCurvedOutline(outlineShape, -0.05f);
        }
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.shapesSharpness);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        this.box.resize(outlineShape.getBounds());
        float f = this.width * (1.0f - this.spacingX);
        float f2 = this.height * (1.0f - this.spacingY);
        AABBox aABBox = this.label.font.getMetricBounds(this.label.text, 10.0f);
        float f3 = f / aABBox.getWidth();
        float f4 = f2 / aABBox.getHeight();
        float f5 = f3 < f4 ? 10.0f * f3 : 10.0f * f4;
        AABBox aABBox2 = this.label.font.getPointsBounds(null, this.label.text, f5, this.tempT1, this.tempT2);
        float[] fArray = aABBox2.getCenter();
        float[] fArray2 = this.box.getCenter();
        float[] fArray3 = new float[]{fArray2[0] - fArray[0], fArray2[1] - fArray[1], 0.0f};
        AABBox aABBox3 = this.label.addShapeToRegion(f5, this.region, this.tempT1.setToTranslation(fArray3[0], fArray3[1]));
        this.setRotationOrigin(fArray2[0], fArray2[1], fArray2[2]);
    }

    public final float getSpacingX() {
        return this.spacingX;
    }

    public final float getSpacingY() {
        return this.spacingY;
    }

    public final void setSpacing(float f, float f2) {
        this.spacingX = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.spacingY = f2 < 0.0f ? 0.0f : (f2 > 1.0f ? 1.0f : f2);
        this.markShapeDirty();
    }

    public final float[] getLabelColor() {
        return this.label.getColor();
    }

    public final void setLabelColor(float f, float f2, float f3) {
        this.label.setColor(f, f2, f3, 1.0f);
        this.markShapeDirty();
    }

    public final void setLabelText(Font font, String string) {
        this.label.setFont(font);
        this.label.setText(string);
        this.markShapeDirty();
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", " + this.label + ", " + "spacing: " + this.spacingX + "/" + this.spacingY;
    }
}

