/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.GPURendererListenerBase01;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.IOException;

public abstract class GPUTextRendererListenerBase01
extends GPURendererListenerBase01 {
    public final TextRegionUtil textRegionUtil;
    private final GLRegion regionFPS;
    private final GLRegion regionBottom;
    int fontSet = 0;
    Font font;
    int headType = 0;
    boolean drawFPS = true;
    final float fontSizeFName = 8.0f;
    final float fontSizeFPS = 10.0f;
    final int[] sampleCountFPS = new int[]{8};
    float fontSizeHead = 12.0f;
    float fontSizeBottom = 16.0f;
    float dpiH = 96.0f;
    final int fontSizeModulo = 100;
    String fontName;
    AABBox fontNameBox;
    String headtext;
    AABBox headbox;
    static final String text1 = "abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
    static final String text2 = "The quick brown fox jumps over the lazy dog";
    static final String textX = "JOGAMP graph demo using Resolution Independent NURBS\nJOGAMP JOGL - OpenGL ES2 profile\nPress 1/2 to zoom in/out the below text\nPress 3/4 to incr/decs font size (alt: head, w/o bottom)\nPress 6/7 to edit texture size if using VBAA\nPress 0/9 to rotate the below string\nPress v to toggle vsync\nPress i for live input text input (CR ends it, backspace supported)\nPress f to toggle fps. H for different text, space for font type\n";
    static final String textX2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est.\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi.\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem,\n-------Press H to change text---------";
    StringBuilder userString = new StringBuilder();
    boolean userInput = false;
    float nearPlaneX0;
    float nearPlaneY0;
    float nearPlaneZ0;
    float nearPlaneSx;
    float nearPlaneSy;
    float nearPlaneS;
    final boolean bottomTextUseFrustum = true;
    KeyAction keyAction = null;
    float fontHeadScale = 1.0f;

    public GPUTextRendererListenerBase01(RenderState renderState, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        super(RegionRenderer.create(renderState, bl ? RegionRenderer.defaultBlendEnable : null, bl ? RegionRenderer.defaultBlendDisable : null), n, bl2, bl3);
        renderState.setHintMask(2);
        this.textRegionUtil = new TextRegionUtil(n);
        this.regionFPS = GLRegion.create(n, null);
        this.regionBottom = GLRegion.create(n, null);
        try {
            this.font = FontFactory.get(this.fontSet).getDefault();
            this.dumpFontNames();
            this.fontName = this.font.toString();
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.setMatrix(0.0f, 0.0f, 0.0f, 0.0f, n2);
    }

    void dumpFontNames() {
        System.err.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        System.err.println(this.font.getAllNames(null, "\n"));
        System.err.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    void switchHeadBox() {
        this.headType = (this.headType + 1) % 4;
        switch (this.headType) {
            case 0: {
                this.headtext = null;
                break;
            }
            case 1: {
                this.headtext = textX2;
                break;
            }
            case 2: {
                this.headtext = textX;
                break;
            }
            default: {
                this.headtext = text1;
            }
        }
        if (null != this.headtext) {
            this.headbox = this.font.getMetricBounds(this.headtext, this.font.getPixelSize(this.fontSizeHead, this.dpiH));
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            float[] fArray = window.getPixelsPerMM(new float[2]);
            fArray[0] = fArray[0] * 25.4f;
            fArray[1] = fArray[1] * 25.4f;
            this.dpiH = fArray[1];
            System.err.println("Using screen DPI of " + this.dpiH);
        } else {
            System.err.println("Using default DPI of " + this.dpiH);
        }
        this.fontNameBox = this.font.getMetricBounds(this.fontName, this.font.getPixelSize(8.0f, this.dpiH));
        this.switchHeadBox();
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        super.reshape(gLAutoDrawable, n, n2, n3, n4);
        this.nearPlaneX0 = this.nearPlane1Box.getMinX() * 100.0f;
        this.nearPlaneY0 = this.nearPlane1Box.getMinY() * 100.0f;
        this.nearPlaneZ0 = this.nearPlane1Box.getMinZ() * 100.0f;
        float f = this.nearPlane1Box.getWidth() * 100.0f;
        float f2 = this.nearPlane1Box.getHeight() * 100.0f;
        this.nearPlaneSx = f / (float)n3;
        this.nearPlaneS = this.nearPlaneSy = f2 / (float)n4;
        System.err.printf("Scale: [%f x %f] / [%d x %d] = [%f, %f] -> %f%n", Float.valueOf(f), Float.valueOf(f2), n3, n4, Float.valueOf(this.nearPlaneSx), Float.valueOf(this.nearPlaneSy), Float.valueOf(this.nearPlaneS));
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
        this.regionBottom.destroy(gLAutoDrawable.getGL().getGL2ES2());
        super.dispose(gLAutoDrawable);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        float f;
        float f2;
        int n = gLAutoDrawable.getSurfaceWidth();
        int n2 = gLAutoDrawable.getSurfaceHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        RegionRenderer regionRenderer = this.getRenderer();
        RenderState renderState = regionRenderer.getRenderState();
        PMVMatrix pMVMatrix = regionRenderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        renderState.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        float f3 = this.font.getPixelSize(8.0f, this.dpiH);
        float f4 = this.font.getPixelSize(this.fontSizeHead, this.dpiH);
        float f5 = this.font.getPixelSize(this.fontSizeBottom, this.dpiH);
        if (this.drawFPS) {
            float f6;
            float f7;
            f2 = this.font.getPixelSize(10.0f, this.dpiH);
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            if (null != gLAnimatorControl) {
                f = gLAnimatorControl.getLastFPS();
                f7 = gLAnimatorControl.getTotalFPS();
                f6 = (float)gLAnimatorControl.getTotalFPSDuration() / 1000.0f;
            } else {
                f = 0.0f;
                f7 = 0.0f;
                f6 = 0.0f;
            }
            String string = Region.getRenderModeString(this.regionFPS.getRenderModes());
            String string2 = String.format("%03.1f/%03.1f fps, v-sync %d, fontSize [head %.1f, bottom %.1f], %s-samples [%d, this %d], td %4.1f, blend %b, alpha-bits %d", Float.valueOf(f), Float.valueOf(f7), gL2ES2.getSwapInterval(), Float.valueOf(this.fontSizeHead), Float.valueOf(this.fontSizeBottom), string, this.getSampleCount()[0], this.sampleCountFPS[0], Float.valueOf(f6), regionRenderer.getRenderState().isHintMaskSet(1), gLAutoDrawable.getChosenGLCapabilities().getAlphaBits());
            pMVMatrix.glTranslatef(this.nearPlaneX0, this.nearPlaneY0 + this.nearPlaneS * f2 / 2.0f, this.nearPlaneZ0);
            TextRegionUtil.drawString3D(gL2ES2, this.regionFPS, regionRenderer, this.font, this.nearPlaneS * f2, (CharSequence)string2, null, this.sampleCountFPS, this.textRegionUtil.tempT1, this.textRegionUtil.tempT2);
        }
        f2 = (float)n - this.fontNameBox.getWidth() - 2.0f;
        f = (float)n2 - 10.0f;
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(this.nearPlaneX0 + f2 * this.nearPlaneSx, this.nearPlaneY0 + f * this.nearPlaneSy, this.nearPlaneZ0);
        this.textRegionUtil.drawString3D(gL2ES2, regionRenderer, this.font, this.nearPlaneS * f3, this.fontName, null, this.getSampleCount());
        f2 = 10.0f;
        f += -this.fontNameBox.getHeight() - 10.0f;
        if (null != this.headtext) {
            pMVMatrix.glMatrixMode(5888);
            pMVMatrix.glLoadIdentity();
            pMVMatrix.glTranslatef(this.nearPlaneX0 + f2 * this.nearPlaneSx, this.nearPlaneY0 + f * this.nearPlaneSy, this.nearPlaneZ0);
            this.textRegionUtil.drawString3D(gL2ES2, regionRenderer, this.font, this.nearPlaneS * f4, this.headtext, null, this.getSampleCount());
        }
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(this.nearPlaneX0 + f2 * this.nearPlaneSx, this.nearPlaneY0 + (f += -this.headbox.getHeight() - this.font.getLineHeight(f5)) * this.nearPlaneSy, this.nearPlaneZ0);
        pMVMatrix.glTranslatef(this.getXTran(), this.getYTran(), this.getZTran());
        pMVMatrix.glRotatef(this.getAngle(), 0.0f, 1.0f, 0.0f);
        renderState.setColorStatic(0.9f, 0.0f, 0.0f, 1.0f);
        this.regionBottom.setFrustum(pMVMatrix.glGetFrustum());
        if (!this.userInput) {
            TextRegionUtil.drawString3D(gL2ES2, this.regionBottom, regionRenderer, this.font, this.nearPlaneS * f5, (CharSequence)text2, null, this.getSampleCount(), this.textRegionUtil.tempT1, this.textRegionUtil.tempT2);
        } else {
            TextRegionUtil.drawString3D(gL2ES2, this.regionBottom, regionRenderer, this.font, this.nearPlaneS * f5, (CharSequence)this.userString.toString(), null, this.getSampleCount(), this.textRegionUtil.tempT1, this.textRegionUtil.tempT2);
        }
    }

    public void fontBottomIncr(int n) {
        this.fontSizeBottom = Math.abs((this.fontSizeBottom + (float)n) % 100.0f);
        this.dumpMatrix(true);
    }

    public void fontHeadIncr(int n) {
        this.fontSizeHead = Math.abs((this.fontSizeHead + (float)n) % 100.0f);
        if (null != this.headtext) {
            this.headbox = this.font.getMetricBounds(this.headtext, this.font.getPixelSize(this.fontSizeHead, this.dpiH));
        }
    }

    public boolean nextFontSet() {
        try {
            int n = this.fontSet == 0 ? 1 : 0;
            Font font = FontFactory.get(n).getDefault();
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.fontName = this.font.getFullFamilyName(null).toString();
                this.fontNameBox = this.font.getMetricBounds(this.fontName, this.font.getPixelSize(8.0f, this.dpiH));
                this.dumpFontNames();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException.getMessage());
        }
        return false;
    }

    public boolean setFontSet(int n, int n2, int n3) {
        try {
            Font font = FontFactory.get(n).get(n2, n3);
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.fontName = this.font.getFullFamilyName(null).toString();
                this.fontNameBox = this.font.getMetricBounds(this.fontName, this.font.getPixelSize(8.0f, this.dpiH));
                this.dumpFontNames();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException.getMessage());
        }
        return false;
    }

    public boolean isUserInputMode() {
        return this.userInput;
    }

    void dumpMatrix(boolean bl) {
        System.err.println("Matrix: " + this.getXTran() + "/" + this.getYTran() + " x" + this.getZTran() + " @" + this.getAngle() + " fontSize " + this.fontSizeBottom);
        if (bl) {
            System.err.println("bbox: " + this.font.getMetricBounds(text2, this.nearPlaneS * this.font.getPixelSize(this.fontSizeBottom, this.dpiH)));
        }
    }

    @Override
    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener(this.keyAction);
            super.attachInputListenerTo(gLWindow);
        }
    }

    @Override
    public void detachInputListenerFrom(GLWindow gLWindow) {
        super.detachInputListenerFrom(gLWindow);
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener(this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, boolean bl) throws GLException, IOException {
        String string3 = this.font.getFullFamilyName(null).toString();
        this.printScreen(gLAutoDrawable, string, string2, string3.replace(' ', '_'), bl);
    }

    public class KeyAction
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (GPUTextRendererListenerBase01.this.userInput) {
                return;
            }
            short s = keyEvent.getKeySymbol();
            if (s == 51) {
                if (keyEvent.isAltDown()) {
                    GPUTextRendererListenerBase01.this.fontHeadIncr(1);
                } else {
                    GPUTextRendererListenerBase01.this.fontBottomIncr(1);
                }
            } else if (s == 52) {
                if (keyEvent.isAltDown()) {
                    GPUTextRendererListenerBase01.this.fontHeadIncr(-1);
                } else {
                    GPUTextRendererListenerBase01.this.fontBottomIncr(-1);
                }
            } else if (s == 72) {
                GPUTextRendererListenerBase01.this.switchHeadBox();
            } else if (s == 70) {
                GPUTextRendererListenerBase01.this.drawFPS = !GPUTextRendererListenerBase01.this.drawFPS;
            } else if (s == 32) {
                GPUTextRendererListenerBase01.this.nextFontSet();
            } else if (s == 73) {
                GPUTextRendererListenerBase01.this.userInput = true;
                GPUTextRendererListenerBase01.this.setIgnoreInput(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                return;
            }
            if (GPUTextRendererListenerBase01.this.userInput) {
                short s = keyEvent.getKeySymbol();
                if (13 == s) {
                    GPUTextRendererListenerBase01.this.userInput = false;
                    GPUTextRendererListenerBase01.this.setIgnoreInput(false);
                } else if (8 == s && GPUTextRendererListenerBase01.this.userString.length() > 0) {
                    GPUTextRendererListenerBase01.this.userString.deleteCharAt(GPUTextRendererListenerBase01.this.userString.length() - 1);
                } else {
                    char c = keyEvent.getKeyChar();
                    if (GPUTextRendererListenerBase01.this.font.isPrintableChar(c)) {
                        GPUTextRendererListenerBase01.this.userString.append(c);
                    }
                }
            }
        }
    }
}

