/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.manual;

import com.jogamp.common.nio.Buffers;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.eax.EAX;
import com.jogamp.openal.eax.EAXFactory;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.util.WAVData;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class OpenALTest {
    private ALC alc = null;
    private ALCdevice device = null;
    private ALCcontext context = null;
    private AL al = null;
    private int[] sources = null;
    private boolean initialized = false;

    public void init() throws UnsupportedAudioFileException, IOException {
        boolean bl;
        if (this.initialized) {
            return;
        }
        this.alc = ALFactory.getALC();
        this.device = this.alc.alcOpenDevice(null);
        this.context = this.alc.alcCreateContext(this.device, null);
        this.alc.alcMakeContextCurrent(this.context);
        this.al = ALFactory.getAL();
        System.out.println("output devices:");
        String[] stringArray = this.alc.alcGetDeviceSpecifiers();
        if (null != stringArray) {
            for (String object2 : stringArray) {
                System.out.println("    " + object2);
            }
        }
        System.out.println("capture devices:");
        stringArray = this.alc.alcGetCaptureDeviceSpecifiers();
        if (null != stringArray) {
            for (String string : stringArray) {
                System.out.println("    " + string);
            }
        }
        EAX eAX = (bl = this.al.alIsExtensionPresent("EAX2.0")) ? EAXFactory.getEAX() : null;
        System.err.println("EAX present:" + bl + ", EAX retrieved: " + (null != eAX));
        int[] nArray = new int[1];
        this.al.alGenBuffers(1, nArray, 0);
        WAVData wAVData = WAVData.loadFromStream(ResourceLocation.getTestStream2(), ResourceLocation.getTestStream2Size(), 2, 16, 44100, ByteOrder.LITTLE_ENDIAN, true);
        System.out.println("*** size " + wAVData.data.limit());
        this.al.alBufferData(nArray[0], wAVData.format, wAVData.data, wAVData.size, wAVData.freq);
        this.sources = new int[1];
        this.al.alGenSources(1, this.sources, 0);
        this.al.alSourcei(this.sources[0], 4105, nArray[0]);
        int[] nArray2 = new int[1];
        this.al.alGetSourcei(this.sources[0], 4103, nArray2, 0);
        System.err.println("Looping 1: " + (nArray2[0] == 1));
        int[] nArray3 = new int[1];
        this.al.alGetSourcei(this.sources[0], 4103, nArray3, 0);
        System.err.println("Looping 2: " + (nArray3[0] == 1));
        if (bl && null != eAX) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
            intBuffer.put(3);
            eAX.setListenerProperty(11, intBuffer);
        }
        this.initialized = true;
    }

    public void play() {
        if (!this.initialized) {
            return;
        }
        System.out.println("play direct");
        this.al.alSourceRewind(this.sources[0]);
        this.al.alSourcePlay(this.sources[0]);
    }

    public void play3f(float f, float f2, float f3) {
        if (!this.initialized) {
            return;
        }
        System.out.println("play3f " + f + ", " + f2 + ", " + f3);
        this.al.alSourceRewind(this.sources[0]);
        this.al.alSourcePlay(this.sources[0]);
        this.al.alSource3f(this.sources[0], 4100, f, f2, f3);
    }

    public void pause() {
        if (!this.initialized) {
            return;
        }
        this.al.alSourcePause(this.sources[0]);
    }

    public void dispose() {
        if (!this.initialized) {
            return;
        }
        if (null != this.sources) {
            this.al.alSourceStop(this.sources[0]);
            this.al.alDeleteSources(1, this.sources, 0);
            this.sources = null;
        }
        if (null != this.context) {
            this.alc.alcDestroyContext(this.context);
            this.context = null;
        }
        if (null != this.device) {
            this.alc.alcCloseDevice(this.device);
            this.device = null;
        }
        this.initialized = false;
    }

    public static void main(String[] stringArray) throws InterruptedException, UnsupportedAudioFileException, IOException {
        OpenALTest openALTest = new OpenALTest();
        openALTest.init();
        openALTest.play();
        Thread.sleep(5000L);
        openALTest.play3f(2.0f, 2.0f, 2.0f);
        Thread.sleep(5000L);
        openALTest.play3f(3.0f, 3.0f, 3.0f);
        Thread.sleep(5000L);
        openALTest.play3f(0.0f, 0.0f, 0.0f);
        Thread.sleep(5000L);
        openALTest.dispose();
    }
}

