/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.junit;

import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.test.util.UITestCase;
import com.jogamp.openal.util.ALut;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ALutWAVLoaderTest
extends UITestCase {
    @Test
    public void testALutLoadWAVFileStream() throws IOException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        ALut.alutLoadWAVFile(ResourceLocation.getTestStream0(), nArray, byteBufferArray, nArray2, nArray3, nArray4);
        System.out.println("*** ALut.alutLoadWAV Stream0 size " + nArray2[0]);
        Assert.assertTrue("Stream0 size " + ResourceLocation.getTestStream0Size() + " < " + nArray2[0], nArray2[0] <= ResourceLocation.getTestStream0Size());
        ALut.alutLoadWAVFile(ResourceLocation.getTestStream3(), nArray, byteBufferArray, nArray2, nArray3, nArray4);
        System.out.println("*** ALut.alutLoadWAV Stream3 size " + nArray2[0]);
        Assert.assertTrue("Stream3 size " + ResourceLocation.getTestStream3Size() + " < " + nArray2[0], nArray2[0] <= ResourceLocation.getTestStream3Size());
    }

    @Test
    public void testWAVDataLoadStream() throws IOException {
        WAVData wAVData = WAVData.loadFromStream(ResourceLocation.getTestStream0(), ResourceLocation.getTestStream0Size(), 1, 8, 22050, ByteOrder.LITTLE_ENDIAN, true);
        System.out.println("*** WAVData.loadFrom Stream0 size " + wAVData.data.limit());
        Assert.assertEquals(wAVData.data.limit(), ResourceLocation.getTestStream0Size());
        WAVData wAVData2 = WAVData.loadFromStream(ResourceLocation.getTestStream1(), ResourceLocation.getTestStream1Size(), 2, 16, 44100, ByteOrder.BIG_ENDIAN, true);
        System.out.println("*** WAVData.loadFrom Stream1 size " + wAVData2.data.limit());
        Assert.assertEquals(wAVData2.data.limit(), ResourceLocation.getTestStream1Size());
        WAVData wAVData3 = WAVData.loadFromStream(ResourceLocation.getTestStream2(), ResourceLocation.getTestStream2Size(), 2, 16, 44100, ByteOrder.LITTLE_ENDIAN, true);
        System.out.println("*** WAVData.loadFrom Stream2 size " + wAVData3.data.limit());
        Assert.assertEquals(wAVData3.data.limit(), ResourceLocation.getTestStream2Size());
        WAVData wAVData4 = WAVData.loadFromStream(ResourceLocation.getTestStream3(), ResourceLocation.getTestStream3Size(), 2, 16, 44100, ByteOrder.LITTLE_ENDIAN, true);
        System.out.println("*** WAVData.loadFrom Stream3 size " + wAVData4.data.limit());
        Assert.assertEquals(wAVData4.data.limit(), ResourceLocation.getTestStream3Size());
    }

    @Test
    public void testWAVLoaderLoadStream() throws IOException {
        WAVData wAVData = WAVLoader.loadFromStream(ResourceLocation.getTestStream0());
        System.out.println("*** WAVLoader.loadFrom Stream0 size " + wAVData.data.limit());
        Assert.assertTrue("Stream0 size " + ResourceLocation.getTestStream0Size() + " < " + wAVData.data.limit(), wAVData.data.limit() <= ResourceLocation.getTestStream0Size());
        WAVData wAVData2 = WAVLoader.loadFromStream(ResourceLocation.getTestStream3());
        System.out.println("*** WAVLoader.loadFrom Stream3 size " + wAVData2.data.limit());
        Assert.assertTrue("Stream3 size " + ResourceLocation.getTestStream3Size() + " < " + wAVData2.data.limit() + " .. " + wAVData2.data, wAVData2.data.limit() <= ResourceLocation.getTestStream3Size());
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main(ALutWAVLoaderTest.class.getName());
    }
}

