/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.ColorMapWidget;

public class ChosenColorWidget
extends JPanel
implements ActionListener {
    ColorMapWidget wrappedWidget;
    private float[][] original;
    private JComboBox choice;

    public ChosenColorWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(new ColorMapWidget(smap));
    }

    public ChosenColorWidget(ColorMapWidget w) {
        this.wrappedWidget = w;
        this.original = ColorMapWidget.copy_table(this.wrappedWidget.control.getTable());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.wrappedWidget);
        this.add(this.buildChoices());
    }

    private Component buildChoices() {
        this.choice = new JComboBox();
        this.choice.addItem(new ComboItem("Original", this.original));
        this.choice.addActionListener(this);
        boolean usedPanel = false;
        JPanel panel = this.wrappedWidget.getButtonPanel();
        if (panel != null) {
            panel.add(this.choice);
            usedPanel = true;
        }
        return usedPanel ? panel : this.choice;
    }

    public int getNumberOfRows() throws VisADException {
        if (this.original == null) {
            throw new VisADException("Unknown original table size");
        }
        return this.original.length;
    }

    public int getRowLength() throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        return this.original[0].length;
    }

    public void addGreyWedgeItem() throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        int num = this.original.length;
        int len = this.original[0].length;
        float[][] table = new float[num][len];
        float step = 1.0f / ((float)len - 1.0f);
        float total = 0.0f;
        int j = 0;
        while (j < len) {
            float f = total;
            table[2][j] = f;
            table[1][j] = f;
            table[0][j] = f;
            if (num > 3) {
                table[3][j] = 1.0f;
            }
            total += step;
            ++j;
        }
        this.addItem("Grey Wedge", table);
    }

    public void addItem(String name, float[][] table) throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        if (table == null) {
            throw new VisADException("Null table");
        }
        int i = table.length - 1;
        while (i >= 0) {
            if (table[i] == null || table[i].length != this.original[i].length) {
                throw new VisADException("Table row " + i + " should have " + this.original[i].length + " elements");
            }
            --i;
        }
        this.choice.addItem(new ComboItem(name, table));
    }

    public void actionPerformed(ActionEvent evt) {
        block3: {
            if (!evt.getActionCommand().equals("comboBoxChanged")) break block3;
            ComboItem item = (ComboItem)this.choice.getSelectedItem();
            try {
                this.wrappedWidget.setTable(item.table);
            }
            catch (RemoteException re) {
            }
            catch (VisADException ve) {}
        }
    }

    public Dimension getMaximumSize() {
        return this.wrappedWidget.getMaximumSize();
    }

    public void setMaximumSize(Dimension size) {
        this.wrappedWidget.setMaximumSize(size);
    }

    public Dimension getMinimumSize() {
        return this.wrappedWidget.getMinimumSize();
    }

    public void setMinimumSize(Dimension size) {
        this.wrappedWidget.setMinimumSize(size);
    }

    public Dimension getPreferredSize() {
        return this.wrappedWidget.getPreferredSize();
    }

    public void setPreferredSize(Dimension size) {
        this.wrappedWidget.setPreferredSize(size);
    }

    public static void main(String[] args) {
        try {
            RealType vis = RealType.getRealType("vis");
            ScalarMap map = new ScalarMap(vis, Display.RGBA);
            map.setRange(0.0, 1.0);
            DisplayImplJ2D dpy = new DisplayImplJ2D("2d");
            dpy.addMap(map);
            ChosenColorWidget chosen = new ChosenColorWidget(map);
            chosen.addGreyWedgeItem();
            JFrame f = new JFrame("0");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(chosen);
            f.pack();
            f.setVisible(true);
            chosen = new ChosenColorWidget(new ColorMapWidget(map, null));
            int num = chosen.getNumberOfRows();
            int len = chosen.getRowLength();
            float[][] table = new float[num][len];
            float step = 1.0f / ((float)len - 1.0f);
            float total = 1.0f;
            int j = 0;
            while (j < len) {
                float f2 = total;
                table[2][j] = f2;
                table[1][j] = f2;
                table[0][j] = f2;
                if (num > 3) {
                    table[3][j] = 1.0f;
                }
                total -= step;
                ++j;
            }
            chosen.addItem("Reverse Wedge", table);
            f = new JFrame("1");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(chosen);
            f.pack();
            f.setVisible(true);
            f = new JFrame("!Updated");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            ColorMapWidget cmw3 = new ColorMapWidget(map, null, false);
            f.getContentPane().add(new ChosenColorWidget(cmw3));
            f.pack();
            f.setVisible(true);
            f = new JFrame("!Immediate");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            ColorMapWidget cmw = new ColorMapWidget(map, null, true, false);
            f.getContentPane().add(new ChosenColorWidget(cmw));
            f.pack();
            f.setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            map.setRange(-10.0, 10.0);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
    }

    class ComboItem {
        private String name;
        private float[][] table;

        private ComboItem(String name, float[][] table) {
            this.name = name;
            this.table = table;
        }

        public String toString() {
            return this.name;
        }
    }
}

