/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.Delay;
import visad.util.VisADSlider;

public class GoesCollaboration {
    RemoteServerImpl server_server;
    RemoteServer client_server;
    RealType nchan;
    RealType indx;
    RealType nl;
    RealType tbc;
    RealType tbc_d;
    RealType wfn;
    RealType pres;
    RealType temp;
    RealType mixr;
    RealType ozone;
    RealType pressure;
    RealType data_real;
    RealType diff;
    DataReference wfna_ref;
    DataReference tempa_ref;
    DataReference mixra_ref;
    DataReference ozonea_ref;
    DataReference presa_ref;
    DataReference diff_col_ref;
    DataReference diff_ref;
    DataReference zero_line_ref;
    DataReference smr_ref;
    DataReference real_tbc_ref;
    DataReference wfnb_ref;
    DataReference wfna_old_ref;
    DataReference gzen_ref;
    DataReference tskin_ref;
    DataReference in_dx_ref;
    public static int WIDTH = 1200;
    public static int HEIGHT = 1000;

    public static void main(String[] args) throws VisADException, RemoteException {
        GoesCollaboration goes = new GoesCollaboration(args);
        if (goes.client_server != null) {
            goes.setupClient();
        } else if (goes.server_server != null) {
            System.loadLibrary("GoesCollaboration");
            goes.setupServer();
        } else {
            System.loadLibrary("GoesCollaboration");
            goes.setupServer();
        }
    }

    public GoesCollaboration(String[] args) throws VisADException, RemoteException {
        if (args.length > 0) {
            String domain = "//" + args[0] + "/GoesCollaboration";
            try {
                this.client_server = (RemoteServer)Naming.lookup(domain);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            File f1 = new File("data_obs_1.dat");
            File f2 = new File("goesrtcf");
            if (!f1.exists() || !f2.exists()) {
                System.out.println("This program requires the data files \"data_obs_1.dat\"");
                System.out.println("and \"goesrtcf\", available at:");
                System.out.println("   ftp://www.ssec.wisc.edu/pub/visad-2.0/paoloa-files.tar.Z");
                System.exit(1);
            }
            if (!f2.exists()) {
                System.out.println("");
                System.exit(2);
            }
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///GoesCollaboration", this.server_server);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    void setupServer() throws VisADException, RemoteException {
        Linear1DSet linear18 = new Linear1DSet(1.0, 18.0, 18);
        Linear1DSet linear19 = new Linear1DSet(1.0, 19.0, 19);
        Linear1DSet linear40 = new Linear1DSet(1.0, 40.0, 40);
        Linear2DSet linear40x18 = new Linear2DSet(1.0, 40.0, 40, 1.0, 18.0, 18);
        this.nchan = RealType.getRealType("nchan", null, linear18);
        this.indx = RealType.getRealType("indx", null, linear19);
        this.nl = RealType.getRealType("nl", null, linear40);
        this.tbc = RealType.getRealType("tbc");
        this.tbc_d = RealType.getRealType("tbc_d");
        this.wfn = RealType.getRealType("wfn");
        this.pres = RealType.getRealType("pres");
        this.temp = RealType.getRealType("temp");
        this.mixr = RealType.getRealType("mixr");
        this.ozone = RealType.getRealType("ozone");
        this.pressure = RealType.getRealType("pressure");
        this.data_real = RealType.getRealType("data_real");
        this.diff = RealType.getRealType("diff");
        RealTupleType nl_nchan = new RealTupleType(this.nl, this.nchan, null, linear40x18);
        FunctionType obs_data = new FunctionType(this.indx, this.data_real);
        FunctionType wfn_big = new FunctionType(nl_nchan, new RealTupleType(this.wfn, this.tbc));
        FunctionType tbc_array_dif = new FunctionType(this.nchan, this.tbc_d);
        FunctionType wfn_array = new FunctionType(nl_nchan, this.wfn);
        FunctionType temp_array = new FunctionType(this.nl, this.temp);
        FunctionType mixr_array = new FunctionType(this.nl, this.mixr);
        FunctionType ozone_array = new FunctionType(this.nl, this.ozone);
        FunctionType pres_array = new FunctionType(this.nl, this.pressure);
        FlatField wfna = new FlatField(wfn_array);
        this.wfna_ref = new DataReferenceImpl("wfna");
        this.wfna_ref.setData(wfna);
        FlatField tempa = new FlatField(temp_array);
        this.tempa_ref = new DataReferenceImpl("tempa");
        this.tempa_ref.setData(tempa);
        FlatField mixra = new FlatField(mixr_array);
        this.mixra_ref = new DataReferenceImpl("mixra");
        this.mixra_ref.setData(mixra);
        FlatField ozonea = new FlatField(ozone_array);
        this.ozonea_ref = new DataReferenceImpl("ozonea");
        this.ozonea_ref.setData(ozonea);
        FlatField presa = new FlatField(pres_array);
        this.presa_ref = new DataReferenceImpl("presa");
        this.presa_ref.setData(presa);
        FlatField diff_col = new FlatField(wfn_array);
        this.diff_col_ref = new DataReferenceImpl("diff_col");
        this.diff_col_ref.setData(diff_col);
        FlatField diff_DATA = new FlatField(tbc_array_dif);
        this.diff_ref = new DataReferenceImpl("diff");
        this.diff_ref.setData(diff_DATA);
        FlatField zero_line = new FlatField(tbc_array_dif);
        this.zero_line_ref = new DataReferenceImpl("zero_line");
        this.zero_line_ref.setData(zero_line);
        Real smr = new Real(this.tbc_d);
        this.smr_ref = new DataReferenceImpl("smr");
        this.smr_ref.setData(smr);
        FlatField real_tbc = new FlatField(obs_data);
        this.real_tbc_ref = new DataReferenceImpl("real_tbc");
        this.real_tbc_ref.setData(real_tbc);
        FlatField wfnb = new FlatField(wfn_big);
        this.wfnb_ref = new DataReferenceImpl("wfnb");
        this.wfnb_ref.setData(wfnb);
        FlatField wfna_old = new FlatField(wfn_array);
        this.wfna_old_ref = new DataReferenceImpl("wfna_old");
        this.wfna_old_ref.setData(wfna);
        this.gzen_ref = new DataReferenceImpl("gzen");
        this.tskin_ref = new DataReferenceImpl("tskin");
        this.in_dx_ref = new DataReferenceImpl("in_dx");
        DataReferenceImpl save_config_ref = new DataReferenceImpl("save_config");
        DisplayImpl[] displays = new DisplayImpl[4];
        this.setupDisplays(displays);
        if (this.server_server != null) {
            int i = 0;
            while (i < displays.length) {
                this.server_server.addDisplay(new RemoteDisplayImpl(displays[i]));
                ++i;
            }
        }
        this.setupUI(displays, this.in_dx_ref, save_config_ref, this.gzen_ref, this.tskin_ref);
        double[][] zero_line_x = zero_line.getValues();
        int i = 0;
        while (i < zero_line_x[0].length) {
            zero_line_x[0][i] = 0.0;
            ++i;
        }
        zero_line.setSamples(zero_line_x);
        new Delay(1000);
        this.gzen_ref.incTick();
        save_config_ref.incTick();
        new Delay(1000);
        real_tbcCell real_tbc_cell = new real_tbcCell();
        real_tbc_cell.addReference(this.in_dx_ref);
        new Delay(500);
        wfnbCell wfnb_cell = new wfnbCell();
        wfnb_cell.addReference(this.gzen_ref);
        wfnb_cell.addReference(this.tskin_ref);
        wfnb_cell.addReference(this.tempa_ref);
        wfnb_cell.addReference(this.mixra_ref);
        wfnb_cell.addReference(this.ozonea_ref);
        wfnb_cell.addReference(this.presa_ref);
        new Delay(500);
        wfnaCell wfna_cell = new wfnaCell();
        wfna_cell.addReference(this.wfnb_ref);
        wfna_cell.addReference(this.real_tbc_ref);
        new Delay(500);
        wfna_oldCell wfna_old_cell = new wfna_oldCell();
        wfna_old_cell.addReference(save_config_ref);
        new Delay(500);
        diff_colCell diff_col_cell = new diff_colCell();
        diff_col_cell.addReference(this.wfna_ref);
        diff_col_cell.addReference(this.wfna_old_ref);
        new Delay(500);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] refs = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.gzen_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.tskin_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.in_dx_ref), new RemoteDataReferenceImpl(save_config_ref)};
            this.server_server.setDataReferences(refs);
        }
        new Delay(1000);
        this.gzen_ref.incTick();
        save_config_ref.incTick();
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] refs = this.client_server.getDataReferences();
        if (refs == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.gzen_ref = refs[0];
        this.tskin_ref = refs[1];
        this.in_dx_ref = refs[2];
        RemoteDataReference save_config_ref = refs[3];
        DisplayImpl[] displays = new DisplayImpl[]{new DisplayImplJ3D(this.client_server.getDisplay("display1")), new DisplayImplJ3D(this.client_server.getDisplay("display2")), new DisplayImplJ3D(this.client_server.getDisplay("display3")), new DisplayImplJ3D(this.client_server.getDisplay("display4"))};
        this.setupUI(displays, this.in_dx_ref, save_config_ref, this.gzen_ref, this.tskin_ref);
    }

    void setupDisplays(DisplayImpl[] displays) throws VisADException, RemoteException {
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1");
        ScalarMap map1nl = new ScalarMap(this.nl, Display.YAxis);
        map1nl.setRange(40.0, 1.0);
        display1.addMap(map1nl);
        display1.addMap(new ScalarMap(this.nchan, Display.XAxis));
        display1.addMap(new ScalarMap(this.wfn, Display.Green));
        display1.addMap(new ScalarMap(this.wfn, Display.ZAxis));
        display1.addMap(new ConstantMap(0.5, Display.Red));
        display1.addMap(new ConstantMap(0.5, Display.Blue));
        GraphicsModeControl mode1 = display1.getGraphicsModeControl();
        mode1.setScaleEnable(true);
        display1.addReference(this.wfna_ref);
        DisplayImplJ3D display2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap map2nl = new ScalarMap(this.nl, Display.YAxis);
        map2nl.setRange(40.0, 1.0);
        display2.addMap(map2nl);
        ScalarMap map2temp = new ScalarMap(this.temp, Display.XAxis);
        display2.addMap(map2temp);
        map2temp.setScaleColor(new float[]{1.0f, 0.0f, 0.0f});
        ScalarMap map2mixr = new ScalarMap(this.mixr, Display.XAxis);
        display2.addMap(map2mixr);
        map2mixr.setScaleColor(new float[]{0.0f, 1.0f, 0.0f});
        ScalarMap map2ozone = new ScalarMap(this.ozone, Display.XAxis);
        display2.addMap(map2ozone);
        map2ozone.setScaleColor(new float[]{0.0f, 0.0f, 1.0f});
        display2.addMap(new ScalarMap(this.pressure, Display.XAxis));
        GraphicsModeControl mode2 = display2.getGraphicsModeControl();
        mode2.setLineWidth(2.0f);
        mode2.setScaleEnable(true);
        ConstantMap[] tmaps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] mmaps = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] omaps = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
        ConstantMap[] pmaps = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
        display2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.tempa_ref, tmaps);
        display2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.mixra_ref, mmaps);
        display2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.ozonea_ref, omaps);
        display2.addReference(this.presa_ref, pmaps);
        DisplayImplJ3D display3 = new DisplayImplJ3D("display3");
        ScalarMap map3nl = new ScalarMap(this.nl, Display.YAxis);
        map3nl.setRange(40.0, 1.0);
        display3.addMap(map3nl);
        display3.addMap(new ScalarMap(this.nchan, Display.XAxis));
        display3.addMap(new ScalarMap(this.wfn, Display.ZAxis));
        display3.addMap(new ScalarMap(this.wfn, Display.Green));
        display3.addMap(new ConstantMap(0.5, Display.Red));
        display3.addMap(new ConstantMap(0.5, Display.Blue));
        GraphicsModeControl mode3 = display3.getGraphicsModeControl();
        mode3.setScaleEnable(true);
        display3.addReference(this.diff_col_ref);
        DisplayImplJ3D display4 = new DisplayImplJ3D("display4", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        display4.addMap(new ScalarMap(this.nchan, Display.XAxis));
        ScalarMap map4tbc_d = new ScalarMap(this.tbc_d, Display.YAxis);
        map4tbc_d.setRange(-40.0, 40.0);
        display4.addMap(map4tbc_d);
        GraphicsModeControl mode4 = display4.getGraphicsModeControl();
        mode4.setPointSize(5.0f);
        mode4.setLineWidth(2.0f);
        mode4.setScaleEnable(true);
        display4.addReference(this.diff_ref);
        display4.addReference(this.zero_line_ref);
        display4.addReference(this.smr_ref);
        displays[0] = display1;
        displays[1] = display2;
        displays[2] = display3;
        displays[3] = display4;
    }

    void setupUI(DisplayImpl[] displays, DataReference in_dx_ref, DataReference save_config_ref, DataReference gzen_ref, DataReference tskin_ref) throws VisADException, RemoteException {
        JFrame frame = new JFrame("GoesCollaboration");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(WIDTH, HEIGHT);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 0));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.getContentPane().add(big_panel);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.setAlignmentY(0.0f);
        left.setAlignmentX(0.0f);
        big_panel.add(left);
        left.add(new JLabel("Interactive GOES satellite sounding retrieval"));
        left.add(new JLabel("using VisAD  -  see:"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        left.add(new JLabel("  "));
        left.add(new JLabel("for more information about VisAD."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Bill Hibbard, Paolo Antonelli and Bob Aune"));
        left.add(new JLabel("Space Science and Engineering Center"));
        left.add(new JLabel("University of Wisconsin - Madison"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        left.add(new JLabel("Move index slider to retrieve a new model"));
        left.add(new JLabel("atmosphere."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Touch ref. conf. slider to save a new"));
        left.add(new JLabel("reference for weighting function difference."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Move zenith angle and skin T sliders to"));
        left.add(new JLabel("to modify atmosphere conditions."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Rotate scenes with left mouse button."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Redraw temperature, water vapor and ozone with"));
        left.add(new JLabel("right mouse button to modify model atmosphere."));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        JPanel sliders = new JPanel();
        sliders.setName("GoesCollaboration Sliders");
        sliders.setFont(new Font("Dialog", 0, 12));
        sliders.setLayout(new BoxLayout(sliders, 1));
        sliders.setAlignmentY(0.0f);
        sliders.setAlignmentX(0.0f);
        left.add(sliders);
        sliders.add(new VisADSlider("index", 1, 2234, 1, 1.0, in_dx_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("save as ref. conf.?", 0, 1000, 0, 1.0, save_config_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("zenith angle (deg)", 0, 65, 35, 1.0, gzen_ref, RealType.Generic));
        sliders.add(new JLabel("  "));
        sliders.add(new VisADSlider("skin T (K)", 250, 340, 300, 1.0, tskin_ref, RealType.Generic));
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 0));
        display_panel.setAlignmentY(0.0f);
        display_panel.setAlignmentX(0.0f);
        big_panel.add(display_panel);
        JPanel display_left = new JPanel();
        display_left.setLayout(new BoxLayout(display_left, 1));
        display_left.setAlignmentY(0.0f);
        display_left.setAlignmentX(0.0f);
        display_panel.add(display_left);
        JPanel display_right = new JPanel();
        display_right.setLayout(new BoxLayout(display_right, 1));
        display_right.setAlignmentY(0.0f);
        display_right.setAlignmentX(0.0f);
        display_panel.add(display_right);
        JPanel panel1 = (JPanel)displays[0].getComponent();
        JPanel panel2 = (JPanel)displays[1].getComponent();
        JPanel panel3 = (JPanel)displays[2].getComponent();
        JPanel panel4 = (JPanel)displays[3].getComponent();
        CompoundBorder etchedBorder10 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        panel1.setBorder(etchedBorder10);
        panel2.setBorder(etchedBorder10);
        panel3.setBorder(etchedBorder10);
        panel4.setBorder(etchedBorder10);
        JLabel display1_label = new JLabel("weighting function");
        JLabel display1a_label = new JLabel("vertical level (Y) vs channel (X)");
        JLabel display2_label = new JLabel("model atmosphere profile");
        JLabel display2a_label = new JLabel("temperature (red), ozone (blue),");
        JLabel display2b_label = new JLabel("water vapor (green), pressure (white)");
        JLabel display3_label = new JLabel("weighting function difference");
        JLabel display3a_label = new JLabel("vertical level (Y) vs channel (X)");
        JLabel display4_label = new JLabel("brightness temperature errors");
        JLabel display4a_label = new JLabel("with zero reference line and");
        JLabel display4b_label = new JLabel("root mean square error (single point)");
        display_left.add(panel1);
        display_left.add(display1_label);
        display_left.add(display1a_label);
        display_left.add(panel2);
        display_left.add(display2_label);
        display_left.add(display2a_label);
        display_left.add(display2b_label);
        display_right.add(panel3);
        display_right.add(display3_label);
        display_right.add(display3a_label);
        display_right.add(panel4);
        display_right.add(display4_label);
        display_right.add(display4a_label);
        display_right.add(display4b_label);
        frame.setVisible(true);
    }

    private native void re_read_1_c(int var1, float[] var2);

    private native void goesrte_2_c(float var1, float var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8);

    private native void get_profil_c(float var1, int var2, float[] var3, float[] var4, float[] var5, float[] var6);

    class diff_colCell
    extends CellImpl {
        diff_colCell() {
        }

        public void doAction() throws VisADException, RemoteException {
            GoesCollaboration.this.diff_col_ref.setData(GoesCollaboration.this.wfna_ref.getData().subtract(GoesCollaboration.this.wfna_old_ref.getData()));
        }
    }

    class real_tbcCell
    extends CellImpl {
        real_tbcCell() {
        }

        public void doAction() throws VisADException, RemoteException {
            int in_dx = (int)((Real)GoesCollaboration.this.in_dx_ref.getData()).getValue();
            if (in_dx < 1 || in_dx > 2234) {
                return;
            }
            float[][] data_b = new float[1][19];
            GoesCollaboration.this.re_read_1_c(in_dx, data_b[0]);
            ((FlatField)GoesCollaboration.this.real_tbc_ref.getData()).setSamples(data_b);
            float lat = data_b[0][18];
            int month = 6;
            float[][] t_x = new float[1][40];
            float[][] m_x = new float[1][40];
            float[][] o_x = new float[1][40];
            float[][] p_x = new float[1][40];
            GoesCollaboration.this.get_profil_c(lat, month, t_x[0], m_x[0], o_x[0], p_x[0]);
            ((FlatField)GoesCollaboration.this.tempa_ref.getData()).setSamples(t_x);
            ((FlatField)GoesCollaboration.this.mixra_ref.getData()).setSamples(m_x);
            ((FlatField)GoesCollaboration.this.ozonea_ref.getData()).setSamples(o_x);
            ((FlatField)GoesCollaboration.this.presa_ref.getData()).setSamples(p_x);
        }
    }

    class wfnaCell
    extends CellImpl {
        wfnaCell() {
        }

        public void doAction() throws VisADException, RemoteException {
            float[][] t_x = new float[1][];
            float[][] wfn = Set.doubleToFloat(((FlatField)GoesCollaboration.this.wfnb_ref.getData()).getValues());
            t_x[0] = wfn[0];
            ((FlatField)GoesCollaboration.this.wfna_ref.getData()).setSamples(t_x);
            float[][] real_tbc_x = Set.doubleToFloat(((FlatField)GoesCollaboration.this.real_tbc_ref.getData()).getValues());
            float[][] diff_DATA_x = new float[1][18];
            float squ_mod = 0.0f;
            int c = 0;
            while (c < 18) {
                diff_DATA_x[0][c] = wfn[1][0 + 40 * c] - real_tbc_x[0][c];
                squ_mod += diff_DATA_x[0][c] * diff_DATA_x[0][c] / 18.0f;
                ++c;
            }
            ((FlatField)GoesCollaboration.this.diff_ref.getData()).setSamples(diff_DATA_x);
            GoesCollaboration.this.smr_ref.setData(new Real(GoesCollaboration.this.tbc_d, Math.sqrt(squ_mod)));
        }
    }

    class wfna_oldCell
    extends CellImpl {
        wfna_oldCell() {
        }

        public void doAction() throws VisADException, RemoteException {
            GoesCollaboration.this.wfna_old_ref.setData((FlatField)((FlatField)GoesCollaboration.this.wfna_ref.getData()).clone());
        }
    }

    class wfnbCell
    extends CellImpl {
        wfnbCell() {
        }

        public void doAction() throws VisADException, RemoteException {
            float gzen = (float)((Real)GoesCollaboration.this.gzen_ref.getData()).getValue();
            float tskin = (float)((Real)GoesCollaboration.this.tskin_ref.getData()).getValue();
            float[][] t_x = Set.doubleToFloat(((FlatField)GoesCollaboration.this.tempa_ref.getData()).getValues());
            float[][] m_x = Set.doubleToFloat(((FlatField)GoesCollaboration.this.mixra_ref.getData()).getValues());
            float[][] o_x = Set.doubleToFloat(((FlatField)GoesCollaboration.this.ozonea_ref.getData()).getValues());
            float[][] p_x = Set.doubleToFloat(((FlatField)GoesCollaboration.this.presa_ref.getData()).getValues());
            float[][] wfn = new float[2][720];
            GoesCollaboration.this.goesrte_2_c(gzen, tskin, t_x[0], m_x[0], o_x[0], p_x[0], wfn[0], wfn[1]);
            ((FlatField)GoesCollaboration.this.wfnb_ref.getData()).setSamples(wfn);
        }
    }
}

